<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.4.1
*/namespace
Adminer;const
VERSION="5.4.1";error_reporting(24575);set_error_handler(function($Ec,$Gc){return!!preg_match('~^Undefined (array key|offset|index)~',$Gc);},E_WARNING|E_NOTICE);$cd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($cd||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$xj=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($xj)$$X=$xj;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($h=null){return($h?:Db::$instance);}function
adminer(){return
Adminer::$instance;}function
driver(){return
Driver::$instance;}function
connect(){$Hb=adminer()->credentials();$J=Driver::connect($Hb[0],$Hb[1],$Hb[2]);return(is_object($J)?$J:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$Le=substr($v,-1);return
str_replace($Le.$Le,$Le,substr($v,1,-1));}function
q($Q){return
connection()->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($xa,$y,$l=null){return($xa&&array_key_exists($y,$xa)?$xa[$y]:$l);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$eh,$cd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($eh)){foreach($X
as$Ce=>$W){unset($eh[$y][$Ce]);if(is_array($W)){$eh[$y][stripslashes($Ce)]=$W;$eh[]=&$eh[$y][stripslashes($Ce)];}else$eh[$y][stripslashes($Ce)]=($cd?$W:stripslashes($W));}}}}function
bracket_escape($v,$Ea=false){static$gj=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Ea?array_flip($gj):$gj));}function
min_version($Pj,$af="",$h=null){$h=connection($h);$Zh=$h->server_info;if($af&&preg_match('~([\d.]+)-MariaDB~',$Zh,$A)){$Zh=$A[1];$Pj=$af;}return$Pj&&version_compare($Zh,$Pj)>=0;}function
charset(Db$g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
ini_bool($me){$X=ini_get($me);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
ini_bytes($me){$X=ini_get($me);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
sid(){static$J;if($J===null)$J=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
set_password($Oj,$N,$V,$F){$_SESSION["pwds"][$Oj][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["adminer_key"]?decrypt_string($J[0],$_COOKIE["adminer_key"]):false);return$J;}function
get_val($H,$n=0,$vb=null){$vb=connection($vb);$I=$vb->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return($K?$K[$n]:false);}function
get_vals($H,$d=0){$J=array();$I=connection()->query($H);if(is_object($I)){while($K=$I->fetch_row())$J[]=$K[$d];}return$J;}function
get_key_vals($H,$h=null,$ci=true){$h=connection($h);$J=array();$I=$h->query($H);if(is_object($I)){while($K=$I->fetch_row()){if($ci)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($H,$h=null,$m="<p class='error'>"){$vb=connection($h);$J=array();$I=$vb->query($H);if(is_object($I)){while($K=$I->fetch_assoc())$J[]=$K;}elseif(!$I&&!$h&&$m&&(defined('Adminer\PAGE_HEADER')||$m=="-- "))echo$m.error()."\n";return$J;}function
unique_array($K,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$J=array();foreach($w["columns"]as$y){if(!isset($K[$y]))continue
2;$J[$y]=$K[$y];}return$J;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$A))return$A[1].idf_escape(idf_unescape($A[2])).$A[3];return
idf_escape($y);}function
where(array$Z,array$o=array()){$J=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$d=escape_key($y);$n=idx($o,$y,array());$Zc=$n["type"];$J[]=$d.(JUSH=="sql"&&$Zc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="pgsql"&&preg_match('~^json~',$Zc)?"::jsonb = ".q($X)."::jsonb":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Zc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n,q($X))))));if(JUSH=="sql"&&preg_match('~char|text~',$Zc)&&preg_match("~[^ -@]~",$X))$J[]="$d = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$J[]=escape_key($y)." IS NULL";return
implode(" AND ",$J);}function
where_check($X,array$o=array()){parse_str($X,$Ya);remove_slashes(array(&$Ya));return
where($Ya,$o);}function
where_link($t,$d,$Y,$bg="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$bg:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$e,array$o,array$M=array()){$J="";foreach($e
as$y=>$X){if($M&&!in_array(idf_escape($y),$M))continue;$ya=convert_field($o[$y]);if($ya)$J
.=", $ya AS ".idf_escape($y);}return$J;}function
cookie($B,$Y,$Te=2592000){header("Set-Cookie: $B=".urlencode($Y).($Te?"; expires=".gmdate("D, d M Y H:i:s",time()+$Te)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($Db){parse_str($_COOKIE[$Db],$di);return$di;}function
get_setting($y,$Db="adminer_settings",$l=null){return
idx(get_settings($Db),$y,$l);}function
save_settings(array$di,$Db="adminer_settings"){$Y=http_build_query($di+get_settings($Db));cookie($Db,$Y);$_COOKIE[$Db]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($kd=false){$Gj=ini_bool("session.use_cookies");if(!$Gj||$kd){session_write_close();if($Gj&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Oj,$N,$V,$k=null){$Cj=remove_from_uri(implode("|",array_keys(SqlDriver::$drivers))."|username|ext|".($k!==null?"db|":"").($Oj=='mssql'||$Oj=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$Cj,$A);return"$A[1]?".(sid()?SID."&":"").($Oj!="server"||$N!=""?urlencode($Oj)."=".urlencode($N)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($A[2]?"&$A[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($We,$pf=null){if($pf!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($We!==null?$We:$_SERVER["REQUEST_URI"]))][]=$pf;}if($We!==null){if($We=="")$We=".";header("Location: $We");exit;}}function
query_redirect($H,$We,$pf,$nh=true,$Lc=true,$Uc=false,$Ti=""){if($Lc){$si=microtime(true);$Uc=!connection()->query($H);$Ti=format_time($si);}$mi=($H?adminer()->messageQuery($H,$Ti,$Uc):"");if($Uc){adminer()->error
.=error().$mi.script("messagesPrint();")."<br>";return
false;}if($nh)redirect($We,$pf.$mi);return
true;}class
Queries{static$queries=array();static$start=0;}function
queries($H){if(!Queries::$start)Queries::$start=microtime(true);Queries::$queries[]=(preg_match('~;$~',$H)?"DELIMITER ;;\n$H;\nDELIMITER ":$H).";";return
connection()->query($H);}function
apply_queries($H,array$T,$Hc='Adminer\table'){foreach($T
as$R){if(!queries("$H ".$Hc($R)))return
false;}return
true;}function
queries_redirect($We,$pf,$nh){$ih=implode("\n",Queries::$queries);$Ti=format_time(Queries::$start);return
query_redirect($ih,$We,$pf,$nh,false,!$nh,$Ti);}function
format_time($si){return
lang(0,max(0,microtime(true)-$si));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($yg=""){return
substr(preg_replace("~(?<=[?&])($yg".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Tb=false,$Zb=""){$bd=$_FILES[$y];if(!$bd)return
null;foreach($bd
as$y=>$X)$bd[$y]=(array)$X;$J='';foreach($bd["error"]as$y=>$m){if($m)return$m;$B=$bd["name"][$y];$bj=$bd["tmp_name"][$y];$_b=file_get_contents($Tb&&preg_match('~\.gz$~',$B)?"compress.zlib://$bj":$bj);if($Tb){$si=substr($_b,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$si))$_b=iconv("utf-16","utf-8",$_b);elseif($si=="\xEF\xBB\xBF")$_b=substr($_b,3);}$J
.=$_b;if($Zb)$J
.=(preg_match("($Zb\\s*\$)",$_b)?"":$Zb)."\n\n";}return$J;}function
upload_error($m){$kf=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(1).($kf?" ".lang(2,$kf):""):lang(3));}function
repeat_pattern($Kg,$Re){return
str_repeat("$Kg{0,65535}",$Re/65535)."$Kg{0,".($Re%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Vc=false){$J=table_status($R,$Vc);return($J?reset($J):array("Name"=>$R));}function
column_foreign_keys($R){$J=array();foreach(adminer()->foreignKeys($R)as$q){foreach($q["source"]as$X)$J[$X][]=$q;}return$J;}function
fields_from_edit(){$J=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$B=bracket_escape($y,true);$J[$B]=array("field"=>$B,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$J;}function
dump_headers($Sd,$_f=false){$J=adminer()->dumpHeaders($Sd,$_f);$ug=$_POST["output"];if($ug!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($Sd).".$J".($ug!="file"&&preg_match('~^[0-9a-z]+$~',$ug)?".$ug":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$J;}function
dump_csv(array$K){foreach($K
as$y=>$X){if(preg_match('~["\n,;\t]|^0.|\.\d*0$~',$X)||$X==="")$K[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$J=ini_get("upload_tmp_dir");if(!$J){if(function_exists('sys_get_temp_dir'))$J=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return'';$J=dirname($p);unlink($p);}}return$J;}function
file_open_lock($p){if(is_link($p))return;$r=@fopen($p,"c+");if(!$r)return;@chmod($p,0660);if(!flock($r,LOCK_EX)){fclose($r);return;}return$r;}function
file_write_unlock($r,$Nb){rewind($r);fwrite($r,$Nb);ftruncate($r,strlen($Nb));file_unlock($r);}function
file_unlock($r){flock($r,LOCK_UN);fclose($r);}function
first(array$xa){return
reset($xa);}function
password_file($i){$p=get_temp_dir()."/adminer.key";if(!$i&&!file_exists($p))return'';$r=file_open_lock($p);if(!$r)return'';$J=stream_get_contents($r);if(!$J){$J=rand_string();file_write_unlock($r,$J);}else
file_unlock($r);return$J;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$_,array$n,$Si){if(is_array($X)){$J="";foreach($X
as$Ce=>$W)$J
.="<tr>".($X!=array_values($X)?"<th>".h($Ce):"")."<td>".select_value($W,$_,$n,$Si);return"<table>$J</table>";}if(!$_)$_=adminer()->selectLink($X,$n);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$J=adminer()->editVal($X,$n);if($J!==null){if(!is_utf8($J))$J="\0";elseif($Si!=""&&is_shortable($n))$J=shorten_utf8($J,max(0,+$Si));else$J=h($J);}return
adminer()->selectVal($J,$_,$n,$X);}function
is_blob(array$n){return
preg_match('~blob|bytea|raw|file~',$n["type"])&&!in_array($n["type"],idx(driver()->structuredTypes(),lang(6),array()));}function
is_mail($vc){$za='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Kg="$za+(\\.$za+)*@($ic?\\.)+$ic";return
is_string($vc)&&preg_match("(^$Kg(,\\s*$Kg)*\$)i",$vc);}function
is_url($Q){$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($ic?\\.)+$ic(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable(array$n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea|hstore~',$n["type"]);}function
host_port($N){return(preg_match('~^(\[(.+)]|([^:]+)):([^:]+)$~',$N,$A)?array($A[2].$A[3],$A[4]):array($N,''));}function
count_rows($R,array$Z,$we,array$yd){$H=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($we&&(JUSH=="sql"||count($yd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$yd).")$H":"SELECT COUNT(*)".($we?" FROM (SELECT 1$H GROUP BY ".implode(", ",$yd).") x":$H));}function
slow_query($H){$k=adminer()->database();$Ui=adminer()->queryTimeout();$hi=driver()->slowQuery($H,$Ui);$h=null;if(!$hi&&support("kill")){$h=connect();if($h&&($k==""||$h->select_db($k))){$Fe=get_val(connection_id(),0,$h);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$Fe&token=".get_token()."'); }, 1000 * $Ui);");}}ob_flush();flush();$J=@get_key_vals(($hi?:$H),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$lh=rand(1,1e6);return($lh^$_SESSION["token"]).":$lh";}function
verify_token(){list($cj,$lh)=explode(":",$_POST["token"]);return($lh^$_SESSION["token"])==$cj;}function
lzw_decompress($Ka){$ec=256;$La=8;$ib=array();$yh=0;$zh=0;for($t=0;$t<strlen($Ka);$t++){$yh=($yh<<8)+ord($Ka[$t]);$zh+=8;if($zh>=$La){$zh-=$La;$ib[]=$yh>>$zh;$yh&=(1<<$zh)-1;$ec++;if($ec>>$La)$La++;}}$dc=range("\0","\xFF");$J="";$Yj="";foreach($ib
as$t=>$hb){$uc=$dc[$hb];if(!isset($uc))$uc=$Yj.$Yj[0];$J
.=$uc;if($t)$dc[]=$Yj.$uc[0];$Yj=$uc;}return$J;}function
script($ji,$fj="\n"){return"<script".nonce().">$ji</script>$fj";}function
script_src($Dj,$Wb=false){return"<script src='".h($Dj)."'".nonce().($Wb?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($B,$Y=""){return"<input type='hidden' name='".h($B)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($B,$Y,$bb,$He="",$ag="",$fb="",$Je=""){$J="<input type='checkbox' name='$B' value='".h($Y)."'".($bb?" checked":"").($Je?" aria-labelledby='$Je'":"").">".($ag?script("qsl('input').onclick = function () { $ag };",""):"");return($He!=""||$fb?"<label".($fb?" class='$fb'":"").">$J".h($He)."</label>":$J);}function
optionlist($fg,$Rh=null,$Hj=false){$J="";foreach($fg
as$Ce=>$W){$gg=array($Ce=>$W);if(is_array($W)){$J
.='<optgroup label="'.h($Ce).'">';$gg=$W;}foreach($gg
as$y=>$X)$J
.='<option'.($Hj||is_string($y)?' value="'.h($y).'"':'').($Rh!==null&&($Hj||is_string($y)?(string)$y:$X)===$Rh?' selected':'').'>'.h($X);if(is_array($W))$J
.='</optgroup>';}return$J;}function
html_select($B,array$fg,$Y="",$Zf="",$Je=""){static$He=0;$Ie="";if(!$Je&&substr($fg[""],0,1)=="("){$He++;$Je="label-$He";$Ie="<option value='' id='$Je'>".h($fg[""]);unset($fg[""]);}return"<select name='".h($B)."'".($Je?" aria-labelledby='$Je'":"").">".$Ie.optionlist($fg,$Y)."</select>".($Zf?script("qsl('select').onchange = function () { $Zf };",""):"");}function
html_radios($B,array$fg,$Y="",$Vh=""){$J="";foreach($fg
as$y=>$X)$J
.="<label><input type='radio' name='".h($B)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>$Vh";return$J;}function
confirm($pf="",$Sh="qsl('input')"){return
script("$Sh.onclick = () => confirm('".($pf?js_escape($pf):lang(7))."');","");}function
print_fieldset($u,$Qe,$Sj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$Qe</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($Sj?"":" class='hidden'").">\n";}function
bold($Na,$fb=""){return($Na?" class='active $fb'":($fb?" class='$fb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($D,$Kb){return" ".($D==$Kb?$D+1:'<a href="'.h(remove_from_uri("page").($D?"&page=$D".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($D+1)."</a>");}function
hidden_fields(array$eh,array$Wd=array(),$Wg=''){$J=false;foreach($eh
as$y=>$X){if(!in_array($y,$Wd)){if(is_array($X))hidden_fields($X,array(),$y);else{$J=true;echo
input_hidden(($Wg?$Wg."[$y]":$y),$X);}}}return$J;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
file_input($oe){$ff="max_file_uploads";$gf=ini_get($ff);$Aj="upload_max_filesize";$Bj=ini_get($Aj);return(ini_bool("file_uploads")?$oe.script("qsl('input[type=\"file\"]').onchange = partialArg(fileChange, "."$gf, '".lang(8,"$ff = $gf")."', ".ini_bytes("upload_max_filesize").", '".lang(8,"$Aj = $Bj")."')"):lang(9));}function
enum_input($U,$_a,array$n,$Y,$yc=""){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$df);$Wg=($n["type"]=="enum"?"val-":"");$bb=(is_array($Y)?in_array("null",$Y):$Y===null);$J=($n["null"]&&$Wg?"<label><input type='$U'$_a value='null'".($bb?" checked":"")."><i>$yc</i></label>":"");foreach($df[1]as$X){$X=stripcslashes(str_replace("''","'",$X));$bb=(is_array($Y)?in_array($Wg.$X,$Y):$Y===$X);$J
.=" <label><input type='$U'$_a value='".h($Wg.$X)."'".($bb?' checked':'').'>'.h(adminer()->editVal($X,$n)).'</label>';}return$J;}function
input(array$n,$Y,$s,$Da=false){$B=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Y=json_encode($Y,128|64|256);$s="json";}$xh=(JUSH=="mssql"&&$n["auto_increment"]);if($xh&&!$_POST["save"])$s=null;$td=(isset($_GET["select"])||$xh?array("orig"=>lang(10)):array())+adminer()->editFunctions($n);$Dc=driver()->enumLength($n);if($Dc){$n["type"]="enum";$n["length"]=$Dc;}$fc=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$_a=" name='fields[$B]".($n["type"]=="enum"||$n["type"]=="set"?"[]":"")."'$fc".($Da?" autofocus":"");echo
driver()->unconvertFunction($n)." ";$R=$_GET["edit"]?:$_GET["select"];if($n["type"]=="enum")echo
h($td[""])."<td>".adminer()->editInput($R,$n,$_a,$Y);else{$Fd=(in_array($s,$td)||isset($td[$s]));echo(count($td)>1?"<select name='function[$B]'$fc>".optionlist($td,$s===null||$Fd?$s:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($td))).'<td>';$oe=adminer()->editInput($R,$n,$_a,$Y);if($oe!="")echo$oe;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$_a value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$_a value='1'>";elseif($n["type"]=="set")echo
enum_input("checkbox",$_a,$n,(is_string($Y)?explode(",",$Y):$Y));elseif(is_blob($n)&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$B'>";elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$_a cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($Qi=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($Qi&&JUSH!="sqlite")$_a
.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$_a
.=" cols='30' rows='$L'";}echo"<textarea$_a>".h($Y).'</textarea>';}else{$rj=driver()->types();$mf=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$A)?((preg_match("~binary~",$n["type"])?2:1)*$A[1]+($A[3]?1:0)+($A[2]&&!$n["unsigned"]?1:0)):($rj[$n["type"]]?$rj[$n["type"]]+($n["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$mf+=7;echo"<input".((!$Fd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($mf?" data-maxlength='$mf'":"").(preg_match('~char|binary~',$n["type"])&&$mf>20?" size='".($mf>99?60:40)."'":"")."$_a>";}echo
adminer()->editHint($R,$n,$Y);$dd=0;foreach($td
as$y=>$X){if($y===""||!$X)break;$dd++;}if($dd&&count($td)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $dd);");}}function
process_input(array$n){if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($n["field"]);$s=idx($_POST["function"],$v);$Y=idx($_POST["fields"],$v);if($n["type"]=="enum"||driver()->enumLength($n)){$Y=$Y[0];if($Y=="orig")return
false;if($Y=="null")return"NULL";$Y=substr($Y,4);}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")$Y=implode(",",(array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(is_blob($n)&&ini_bool("file_uploads")){$bd=get_file("fields-$v");if(!is_string($bd))return
false;return
driver()->quoteBinary($bd);}return
adminer()->processInput($n,$Y,$s);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$Uh="<ul>\n";foreach(table_status('',true)as$R=>$S){$B=adminer()->tableName($S);if(isset($S["Engine"])&&$B!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$I=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$I||$I->fetch_row()){$ah="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$B</a>";echo"$Uh<li>".($I?$ah:"<p class='error'>$ah: ".error())."\n";$Uh="";}}}echo($Uh?"<p class='message'>".lang(11):"</ul>")."\n";}function
on_help($ob,$fi=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $ob, $fi) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$o,$K,$_j,$m=''){$Di=adminer()->tableName(table_status1($R,true));page_header(($_j?lang(12):lang(13)),$m,array("select"=>array($R,$Di)),$Di);adminer()->editRowPrint($R,$o,$K,$_j);if($K===false){echo"<p class='error'>".lang(14)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$o)echo"<p class='error'>".lang(15)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$Da=!$_POST;foreach($o
as$B=>$n){echo"<tr><th>".adminer()->fieldName($n);$l=idx($_GET["set"],bracket_escape($B));if($l===null){$l=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$l,$uh))$l=$uh[1];if(JUSH=="sql"&&preg_match('~binary~',$n["type"]))$l=bin2hex($l);}$Y=($K!==null?($K[$B]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$n["type"])&&is_array($K[$B])?implode(",",$K[$B]):(is_bool($K[$B])?+$K[$B]:$K[$B])):(!$_j&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$l)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$n);$s=($_POST["save"]?idx($_POST["function"],$B,""):($_j&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$_j&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}if($Da!==false)$Da=($n["auto_increment"]||$s=="now"||$s=="uuid"?null:true);input($n,$Y,$s,$Da);if($Da)$Da=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(16)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($_j?lang(17):lang(18))."' title='Ctrl+Shift+Enter'>\n",($_j?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(19)."…', this); };"):"");}echo($_j?"<input type='submit' name='delete' value='".lang(20)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($Q,$Re=80,$yi=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Re).")($)?)u",$Q,$A))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Re).")($)?)",$Q,$A);return
h($A[1]).$yi.(isset($A[2])?"":"<i>…</i>");}function
icon($Rd,$B,$Qd,$Wi){return"<button type='submit' name='$B' title='".h($Wi)."' class='icon icon-$Rd'><span>$Qd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",'1');if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"PimcQCa	2ód<fa:;NBqR;1Lf9u7&)l;3J/CQXr2Mai0)e:LuÝh-923li7mZw4њ<-̴!U,Févt2S,a҇FVXaNq)-ǜh:n59Y;j-_9krٓ;.tTqo0{y\rHnGSZh;i^uxWΒC@k=b/A0+(l\\x:\rb8\00!\0F\nB͎(3\r\\Ȅa'I|(i\n\r4Og@4C@@!QB	°c¯q,\r1Eh&2PZiGH9G\"v4rDR\npJ-A|/.cDu:,=R]U5mVkLLQ@-\\@9%SrMPDIa\r(YY\\@Xp:plLC O,\r2]7?m06pTaҥC;_˗yȴd>bnnܣ3X8\r[ˀ-)i>V[Yy&L3#X|	X\\ù`C#H22.#Z`<sÒ\0uh־M_\niZeO/CӒ_`31>=k3R/;/d\0ڵm7/AXq.sL :\$Fw8߾~Hj\"Գ7gSFLίQ_O'W]c=51X~7;i\r*\nJS1ZctAV86fdy;Y]zIpc3Y]}@\$.+1'>ZcpdGL#k8PzYAuv]s9_Aq:\nKhB;XbAHq,CI`jS[ˌ1Vr;pB)#鐉;4H/*<3L;lf\ns\$K`}Ք7jx`d%j]4YHbYJ`GG.KfI)2MfָXRC̱V,~g\0g6:[j1H:AlIqu3\"q|8<9s'Q]J|\0`pjfObq\$1J>RH(ǔq\n#r@e(yVJ0Q҈6P[C:G伞4^PZ\\(\n)~9R%Sj{70_s	z|8H	\"@#9DVL\$H5WJ@zaJ ^	)2\nQv]j (ABB056b˰][kAwvkgƴ+k[jmzc}MyDZi\$5eʷ	ACY%.Wb*뮼.q/%}BXZV337ʻawW[LQ޲_2`1Ii,曣Mf&(s-Aİ*DwTNɻjX\$x+;F93JkS;qR{>l;B1AIb)(6r\r\rڇZR^SOy/M#9{kv\"KCJrEo\0\\,|fa͚hI/o4k^p1H^phǡVvox@`g&(;~Ǎz68*5EpӘ3ņgrDL)4g{峩L&>脻Z7\0̊@ffRVh֝Iۈrw)=x^,k2ݓjbl0u\"fp1RIz[]wpN6dIzn.7X{;3-I	7pjÝR#,_-[>3\\WqqJ֘uhFbLKyVľѕVf{K}SޝM̀.M\\ixb1+α?<3~H\$\\2\$ e6tÖ\$sxxCnSkV=z6'æNaָhR噣8gw:_ҒIRKÝ.nkVU+dwj%`#,{醳Y(oվ.c0gDXOk7Klhx;؏ ݃L\$09*9 hNrM.>\0rP9\$g	\0\$\\F*d'L:b429@Hnb-E #ĜrPY t \n5.\$oplX\n@`\r	\r  	 	@@\n  	\0j@Q@1\r@ 	\$p	 V\0``\n\0\n \n@'\n\0`\r	\r\0r	\0`	{	,\"^P0\n4\n0.0p\rp\rppqQ0%1Q8\n \0kȼ\0^\0`@>\no1w,Y	h*=P:іVи.q\r\rp1Q	1 `/17\r^\"y`\n #\0	 p\n\n` r Qb13\n##1\$q\$ѱ%0%q%&&q &'1\rR}16	 @b\r``\r	d	j\n``\n`dcсP,1R\$rIO 	Q	Y32b1&01  f\0\0f\0j\nf`	 \n`@\$n=`\0v nI\$P(d'g6--C7R 	4-1&2t\r\"\n 	H*@	`\n  	l2,z\r~ \rFthmz~\0]GF\\I\\}ItC\nT}IEJ\rx>MpIH~fht.bxYEiKoj\nLtr.~dH2U4G\\A4uPt谐L/P	\"G!RMtO-<#APuIR\$cDƊ-GO`Pv^W@tH;QRę\$gKF<\rR*\$4'[IUmh:+5@/lI2^\0OD\rR'\rTЭ[ĪMCMZ4E B\"`euN,䙬]t\r`@h*\r.V%!MBlPF\"&/@v\\C:mMgni8I2\rpvj+Z mTuefv>fИ`DU[ZTVCT\rUvk^Lb/KSev2ubvOVDIm\$%X?ud!W|,\r+cnUeZʖ-~XBGd\$iMv!t#L3oUIOu?ZweRcw.`ȡi\rb%bH\"\"\"h_\$b@z\0f\"rW*B|\$\$Bנ\"@r(\r` C(0&.`Nk9B\n&#(@䂯d^ @`I-{0\nB{4sG{;zb{ {bׯ){BxKŇ5=cڪy&JPrI/ \0V\r׉=N\\ئ=K}XVxإˋxdՊی*H'δ{X==\08\0[ɫJtOeɋ\rDXŇ}z)y''яI([l(5`f\\`e.lY(=zה!Y%hO+`ٙ\"e ėKߚ#SEIY.HJtG`HJ55~ 6ChXDz\nxyshFKczjZY8(%|yIߑ؃eYXu i]cM;ȧ>ǡQT [~W~c݂zz\r:  \0rYx)!ɡK+z!ӀC+ٮï:ݎZg~z4f	:sӪ+x%=GIf3?+Yq@GyoѴp\r~{W[y:\0\\;eۡYI\"zdkZ|[uu+׹9qnR ˮBׁz|\rᤄk^[1%.pA2<=ء\$;5)m!XXYx5vT\\Q%:>ɛ;e|/yWxנ|gC\\<9z\\#.FV;8NX7\"8&d5P4Gj?\0?\"=HER");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91S!	F!\"-6NbdGg:;Nr)c7\r(Hb81s9k\rc)m8OVAc1c34Of*-P1r416d2ցo#3Bf#	g9Φ،fc\rIb6EC&,bum7aVs#m!hrv\\3\rL:SAdk5naF3e6fSyr!L-K,3L@J˲*J쵣	bc99@H8\\6>`Ŏ;A<T'p&qqE4\rlh<5#pR #I%fBIܲ>ʫ29<Cj27j8jc(n?(a\0@5*3:δ60-AlLP4@ɰ\$H4n311t0͙9WO!rH9Q96F<7\r-xC\n @:\$iضm4Kid{\n6\rxhˋ#^'4V@a<#h0S-c9+pa2cyhBO\$9wiXɔVY9*rHtm	@b|@/l\$z+%p2l.7;&{mXC<l96x9m7R0\\4P)AoxqO#f[;6~P\raTGT0uޟ\n3\\ \\ʎJudCGPZ>d8ҨC?VdLL.(ti>,֜R+9iޞC\$#\"AChVb\n6T2ew\nf6m	!1'c;*eLRn\rG\$2S\$0a'l6&~Ad\$J\$s ȃB4j.RC̔Qj\"7\nXs!6=BȀ}");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zc|^RE8kMsdka)h%\"P0nn/#;g\rd8F<3\$,P);<4`<2\n@w-͗A0LrYhXCa>tL2yto;2Qtfrm:AAN\\\"k5oVɃ=t7r1pAv\\+9{^(if=rut]yޅCgivf+Ø|;]~|\re쿓݂'	\0+Wcow6wd Suj3@0!\n .wm[8x<cM\n9'a1>[dux<\"YcB!iw}5Uk]{IךR=f W~](bea'ubm>)\$P-6R*IGu#ƕUKAXt(`_\"p &UI]YG6P]Ar!b *ЙJoӯv*!~_4B_~RBiK`&J\0N\0\$CK SjZ0pvMJbN`Le/`RO.0P82`	d GxbP-(@ɸ@4H%<&Zp%\0pЄ		/\"J\ns_\rg`!kpX	:v6p\$'RUeZd\$\nLB.dntm>vj)	M\r\0.ʊH\"5*!eZJf(dc(xjg\0\\ Z@|`^r)<()@Ykml3Qyс@ѐfPnTNmRqVmvN֍|ШZȆ(Yp\"4Ǩ&%lP`ĀXx bbdr0Fr5<Cz6he!\rdzK;t\n͠HƋQ\$QEnnn\r#T\$ˈ(ȟѩ|c,-#\rJ{dE\n\$BriT+2PEDBe}&%Rf\n^CZZ RVA,;<\0O1c^\r%\r `n\0y1.\rĂK1M3H\r\"0\0NkXPr{3 }	\nSdڗx.ZRTwS;53 .s4sO3F2S~YFpZs'@ّOqR4\n6q6@Dh67vEl\"^;-(&b**.! \r!#x'G\"͆w\" 2!\"R(vX|\"Dv)@,zmAwT@  \nЫhдIDP\$m>\r&`>4A#*#<w\$T{\$4@dӴRem6-#Dd%EDT\\\$)@WC(t\"M#@TF\r,g\rP8~֣JcĹƂ ʎ\"LZ\r+P4=STA)0\"CDhM\n%Fp|fLNlFtDmH5=H\nļ4\$K6\rbZ\r\"pEQ%wJV0M%l\"hPFAA㌮/G6h6]5\$fSCLiRT?RCHUZYbF/.Z\"\"^y6RG n܌\$\\&O(v^ KUѮam(\r\$_%+KTt.ٖ36\nc:@6 jPAQF/Sk\"<4AgAaU\$'fQO\"k~S;.:k9e]`n-7;+V8W2HUYlBv⯎Ԇ	plm\04B)X\0QqFSq4nFx+pESovGW7owKRW\r4`|cqe7,19uucq\"LCth)\rJ\\W@	|D#S\r%5l!%++^k^ʙ`/7(z*񘋀E{S(W-Xė0V0=a	~fB˕2Qru mCtr(\0Q!K;xNW?b<@`X,`0eƂN'&~tu\"| i B 7R lSu8AdF%(?3@A-oQź@|~K^@xb~D@سTNZC	Wix<\0P|\n\0\n`\"&?st|ïw%mduN^8[t9B\$'\">U~98ÔFf u/)9\0Az\"FWAx\$'jG(\" s%THe,	M7b ǅa ˓ƃ&wYφ3 /\rϖ{\"ݜp{%4b`팤~nE3	93XdՏZ9'@lfQbP*Go`8AB|z	@	bZn_h'ѢF\$f`HdDdH%4\rsAjLR'f9g I,R\\>\nH[\"\rӁL,%FLl8gzL<0ko\$k`KPv@d'V:VM%@6<\rTLENԀS#.[x4a̭LL\n@\0۫tٲ\n^F5` R7lLu(d \rBf/uCf4cҞ B_nL\0 \$aYƦ~Ukve˥˲\0ZaZXأ|Cq/<}سú Z*w\nOz`518cIQ2YsK\n\\\" ðc*B.R1<3+*S[4m쭛:RhITdevIH-Zw\\%n56\nWi\$ōow+r&Jq+}Djd?U%BBe/MNm=τUb\$HRfwb|x d2NiSg@q@>Sv|krx\0{R=F#r8	Zv8*ʳ{2S+;SӨ+yL\$\"_B8\"E%\npp''pwUҪ\"8бI\\ @ʾ LnR#MDqLN\n\\̎\$`~@`\0u~^@l-{5,@bruo[}/y. {6qRp\$+13+O!D)\nu<,=Jd+}d#0ɞc3U3EY\rtj5ҥ7ewׄǡ^q߂9<\$}kRI-+'_Ne?SRhd*X4c}\"@vi>;5>Dn \r)bNuP@YG<6i#PB2A-0d0+gK?nddOci<0\0\\gꡖNTi';imj܈uJ+V~'ol`\",F	{CT aNEۃQp p+?\n>'l* tKάp(YC\n-q̔0\"*ɕ,#7\"%+qB=i.@x7:%GcYI0*Ðkۈ\\Q_{#\r{H[p >7chn.S|&JMǾ8mOh	qJ&aݢ'.bOp\$D@CHB	&ݡ|\$Ԭ-6++ pଡAC\rɓ/0MiZnE͢j*>!Ңu%g0@5}r+3%-mG<T;0DVdg9'lMH F@PuntFB%Mt'G2@2<e;`=LX2X}oc.L+xӎ&DaɫF2\ngLE.\\xSLx;lwD=0_QV,a 5+L+|\$ijZ\nDE,Bt\\'H0R~(\\\":n*(o1wQrEteF\$Sђ]\rLyF\\Bihhd&ᚇh;foB-y`0JlPxao\$Xq,(C*	:/HG\"cCQ\nFԄ#8F:У\0OkD])ϚtT8L𒨔n`|HJ  \"6{?=I<HGc ŤF@,C @j\$L(nEʑPjbnΑW \rLqsPHꉝz\\V\$kҏtr5,l<'\0^S020f -5\"ac\"3Up\"ܘ%\0'Zt\"969_ @Z{0IDZE@Nh`\"`\0ɹ(GHCh If`@ZD\$)K;Z\0/CT>r_R@O`1rTҨIb\0*8h\$_pRĕ\$Ni^ʪP/O).ŹT6\\ٔ@Trą`)T=n\02e+9ʢ\\@>PH1	y#r<aeK/cM@_.\09ˈB0ia\ndea%|S2#nD\$/+Ed_2P\$s,ok#<	Ađr{BA-Q4Ҥ\n\ry!b䱎O@ɬk \"r*݇Y/ȑ a0%.gE~& 89#@M_ 7K䃸J`X)B\$(	:gn*|M6PZHtJtqCx[ڼl=\nU3f\\̔JP	,:}TASYH(\nIٲ!t(2U\"\\X^s	a!\nPr`X3fnbJ&zzQSf t!T?9%(QB}6BkP\0>g&~fhUr, p5HipqɚgVVOgWEJ80Gak@N NMUUxȪSx		K@c1yVlϠC2Q^rP6|I^M,j%d`ܫF\\#%|C7싢GTNiHQOCyB\$%T*>z\rMM Kp J7O۷4%\$p4͂EҪ\"T\0O\0@>	rO]x}^I@ źqn0BbȵI(M/;}RN\nC<bPԵu?=PeCL^'S?}4)S-1\r5SOESFAOR+ޙ+v5&C)ِKSDB߳N|E\rcUYʾV?H)実+sFkLPW-,U:&t{VoJl'We74Xn GF'`Cc%Ilju6vUZ\0*Nԟ#(n-;|4]Xy';Z) s9%R+\$	Q(\"_kX\nM#\"!p~:*\$3O6+\nB{1|HK<[`3#F@ǐ! |؊\0>[nrMM+mO_2Ȇ\0e^	7Z&BJ褓h7QO%rfp΁֞mبÇ4El+ViN SZWt2W[;v\"%\$^-(I\$S@R-&Tzk(	%R8uY\0[9-()E8=^G5#)1Vb\r]Ne;&Y`rIPݱֲ\0@P70H؍Rx\0000C|n=`TT\rEhON'&tcK ܕU5P3\\2\"\0y5V]6>U!@hu(\"E%07B6dHNij';@eMzlSfjKY֍-uhHsmL@\"rjj'l7	(uuEea@+K:ӕ%nzV;[_Vz_E8<Sb6g:c7\n%Q K7ܮBwu50֚yncnKT8ʙsW=+=K\n_[pGC5'D\"M<\":|Mq4fsx	qlͰQPaOYE=6nT떒BthC\0p@nD(aP\"'ZN۬\rLNXg<!w[B))~cxvi¦qa@K7sEQdýk?\"3-\"U||21D>߳]­&\\hTƳ5\0`Tzs -N\"fNLU]n(D(&%\"e\\ONInۿ\0ƕ@V|RMYCTbUHp)Ss qi`Z5vt坉*OO\n(F58!ax@{^P?eh}\\j^2L,6.N	K%uip!?l -5wK\"V\\Is2!\$45v\ngrN};W%D(pWa\0v'6Vƿ0WE4EUl8LDE<kOHDU	`vSL!DTMbnWVCd)Ze蟀:2d8Kބ4-Gb;wQW30\rf\0,`Qhl֍0P0h@\\r8T⛜1`&wX>F?|P*MqZѯ}0k`#իc'[ֱˍ|sIJ\r<OaƼ@WuT:E^!ka\$>5u_KcCQr-ъ'\riC@8SPS_Xgl%	n1r.<w_aɺĳGh4\nWZaBn,\\\0DU\nbbZ'72r¢}Y>/w\\Y`^7JjSS.o%Jg\0GD,>7R036%i\0S^LA\riO<a phv[{\0E^xܼgYzWyGa:(>Ce\0])3yts_a7+BCeTfoP2ECv>wlz*pYqQp\nv[|qҨE[Xi=z(	Mn]7F\rCs4|-} Ŀ(NU?,څq	pq~ F%88靦\$ް[ro!3(gץpJ!qZv?cL76\$mq8l!5C;Q,dsF-OfÈ\$6%UCf\"e(j\rMtFRx;nB\$SSx'G陊M	4ͬ'k~#9eY~뭈;f+jK9pM'X/rt\0\\J%QR\rвO3|寚ϱ4xFs5EԐ;ԒWRJXʶJ\$wzO&ǵzkS\n\nNUP.0bdkP	G6+Bz1ΎhQ>sHvQ٠EpM)\n\\ўPz.s g)a~ȥ!(!Ghr[*բ`~\"!O5G3Ş*qkgB,\$**1c.n	8\$dVSneMiZ7žgA5\n`,2aүmMkʻɯ/-6@?#`)Ԁha)Vc]_=Rz\\VR=ط(-ot\$ܥ\ndSmyfөN\rm(t;Dp2ݶZRl)9M̛,/Yixkя).2@S^ud6!>VB x<Kt06@\nGAP(NbDK\n\"cN\ră.p'2Ldꟲ\\LyA=	Dm3%@8qbSP\"ޢƮ/DzC&O\0007fD^1X/,\nvWx%f)' DdQ@I(ҋ7Y|AQDڠe 8ׇ7k)_ @\"\"%}	(11؍\re?-ɵH&\rL'eۮ0T]C!emNz	UzɈSܜaf7M^CD(_#\"dr5981hfȭa_×tZX\0U{2nn];FR!}>sHiy#?\"Ť>{/?7FY?Aj.U!5`H\$r\0'\n\":.dԂٙƪqRխoh>{1+>tk%-D=9}C@8cmHrWn\0Ď<(RR8YV`pp.Ue_`^쵛n^_R|r΅p7/!M5|\n&FVVzOA~ш|ƛ4NȒՔgyh-\nN\"r\"GcsD'Xo٧O{{Y{E=TeZ{\";HXztw*-Uw-\"<A^OT ]D?:<pq[,)&`{xKII``c0Dy8qCYCFJnk[8:\n^ցT!X*M<5`\06A2oP.aAH#x[▞ 'o@O0^h|P=+)d[X-W!Æ/:\"0k#XǞ<hCGݠ@F(kl&HF0OSzwQ3z|+\r9bT}'ܬwA\rnF!g0lpl1+|hkzi&uD{K\\\$t(;ìHr|BwD3[M!:({Z(|-Hy0^'׽}*NK5KUjM\"w]%{1qz)]Ů[k\0O4UF\0cmZEGtsDQZ)n;7<qhlXxI^V&ͷC`,ɑ%1\"@1|)RkV}S,#!G]ExYT<%Qѿ@mJcBB iGf2cDnէ=JI_'iA&,{c4oV%d2xe#s_UHՉW!  =۷O<(y\0.G'\r57pV(þ:}RRHHy[	 1O\")Ll1+<~	\0s?B@d?n~&LЄ?@:@;yQ>f:\0t+jszK,b^pHX?P\\D?v\"\"& ?t`V?\0JwC1O#Ɛ*	@̿\0Ƈ/#8\"O\"\06Ncä[p@Ch\0{\0	pDOFtH/!h@L;@wI~Cˀ¸)E4+)Eb?]d\$<`o?}8b/Jo#IV,Ac3Xa oxi\"椌CUDkYȊ}\n\r\0,G\0|q .ŊNqpNДjBO\$|Cp}4`\\*4bA+D_X\$@6\n\0\$~ˣ\0Jb݅ UpXiD\"ێlgt' +x<N51e0`B8q\"O- 	C!Қmɵ*f@#6ZЛ9ZRǁ	HZL e99 T n?xX\$0%\0002\ny!e:\$QssAnxKl1'Nz!p.Ṇcp1@)m:@P\01\n(CR5D(P1#	d7+\nBuhaM	a\0>1W\0a4 s-ׂ'jp\nJmQ)");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:A,Iv4ǢꆌP-\nҸ%>(c(P74c8X`X:\r3 KIAHHs\"N8R0HY5GDW(3Ut  P9MVd?4\rCPbؼ2*b3T`nVMsb0]pG%n\\E]8ߋh7E`@PIjVTz\rC+R8\r\0aRؾ70l_2dYAxPZA@yART o^CK~c⊰{}cZ.~!`@C.ޒ.y\nl9wt\\C\$pըp8/媤eyn_H!fwZ%hc5~[H{\$\n\r!4nn6͊cHJ.6|`ӛ;.ް[pWݪ>\\hWZO7PxApUW)!/pi[~X\nR\$8?BEy!cPC5.\nH]=y*\$st`57a\r\05j-g\0ͤ#oA\"p;\nH<m!dÙK>+d=p)pP	#|<)70-(ek9HE9.N䔒J hL>e<ۿC`KxVA aPA9WIy4WjpWdER2ip#)CD?ruxs|ϸAX+?l<H&T#|РQb -\$}Ah:t0PD9!9SmHi\ro}ƪP_Eaxfu{Ӳv<)/#QC*ܪ\0rNirtGNow>MӼ DJCv``Na@](U S5{=9N8z3^<		Xc\n=@s3&ꚠdAj%\ry\\{<#	UgR`^K4l!t{\0W&|-U/7yUCXR6uHVu|IV\nq<鼇*p)&Nq/Rل\nV	83<;}_ph\r ӊpt9#%<2id3Rs\nkOf9pA\n9  IYCc,U2^\00\$NqsJ+d*@1:ukΆ!4;@zZ&d\n3\$ݠC]QBVwp.K\\άԌ\$9i<2Zp:a`US3|T!&P,c=0=Nd뛭6nZyiTTJweSu'nm틸In\r;ݔ*)Ai1yQ\r_8?՞76l1ǽ{cvr{\\.,ۼevkۛe~L^7\n@.s8t}ɘ8C-ѻ-4IdO{sջ8[˵f;}Qs^ݹQ2[(@\nL\n)(Aa\" 	&P@O\n師0(M&}'! 0{6}kʘ@;px6zg|+D+ϤyJL#}~*/}4|Aw<wOX\0~\rڏޏZ*\nϧ\0v0 */hD?O\rnBPFo0\\`0fkrOHphxpq֐PTbOPį8揢POo.0·\0\r	PEK͙\rP)\roTv \rDܯoMA(XhCL&\"h\r,N^qKkb\"	}qy\"R`\0n+\rnqHHL\0V%F: ؎\$\rf鬶јjBmQmG\\蕱nk%\"Vdk@ !2+6% ~Ğ% r.R[ 2?\"̹#\0Ԁw\$U%#!%)\$	\$LmA-W{@ܷ#_&x]\$S'\0\rg@m0`df`G&L\0':xjx*оDL(q,&lNt*\n	 %f(оkZ	%in\".Ļ氮~\0U@d4'r\rn#`2H g6&v'\rrS^\$@Xf>΃k6r7`\\	5V'W5\rdTb@E2`P( B'0/w␑s&r.SVsє9JJx&8v!`z4\$k\0x7pI өA9;\r~4>~'\nPs0PQA+/7`WOG1Fp暴\n|\0PGGtI\"TiGO@FV~G荔2\$%96,7LLSoLhP5ʼУ\0P\r\$=%nUjXUkϋN\0\r)F*h@kB5\$56Lbs|Mo8+8\":G4ONS5#j\"NncJtT%(DUS]Mj\$TK`5o@rYSNR1ER\rEXrNJ7bgTUxM5*0r:3		2i1QkF0YZstec\n:oHFExu#4S#	 	\$t?E(p(R\"|eBX8	4>\r/<\0E,^D.E{5a܆*\rZg|~\r:moc9Jv*B7rT&nlHPV6mDw)m\rCVw\$uSwS`ADLS6qk)Jkl'LhB9h Jimn<\0  <\0[:\0K(~s\0K̒Y'ʈgaO(]v:&!`PxV^wnĹ7\0&g|B\0(*,ľ²d7⛬tzwz\nE\",\0\"fb\$B(h(4ժ5b?΍wq|@Ƙ+؁޶&Ɋ~NⴎחN6<uFxWQ^^;P.#/|Wȃ8k./7K/wQl8~Qψ\\1\\&\"ئWR/)|A5reE@k\0OwK&f\"'Lml@ۄPZ7\r#ox`]b̄NzZ@0NR,x[Pc8zX\r?Ǎ?92x}LF'LPyzð\\ƙǌT ŤiNǀTx%xaucw#l,\"Pb*g#Zud,5\$D3]؛?h~0\nyN7bz\0a5qkpvQ,D[A\\EyKyP#UZk&)E9q\"7![QMd۔uQJ#\$o]jۥgO\nXD6꣢eXZ:E:OUbz]7sDc0`?\\S{ySihzEiij&׫e'kXy f6V-ZWewŊ;G\${SK7	1n>@izzw9{x;\0\nIyk[7{޻8-~w,[lȌ@ϷVԘ+Ӌؿjcؤ\\qǊY'zYݻ˜?aA:Q٭(} \ny#Sy\0[?/]My{ˣ9=PϫOLs\\sWDػ˱|7jN-E˕+`uƼ\rM}~I~iڴ|lv}YL1l>\r9,oY9}Sgg銼:u)ÈCR%~|~w0]|\\yϙy\\ج7йe,mu7(T],wθfU=TRW6<Kֽg;||1\0Qy\"9vb\$5mwΆo\r\0xbkH|ɚ Z\rhWʜ\\Ա.3U\r˽ؘ\r>?2)᩟/=50@ƅH~<нx_/˾3~I+~l~HY{Y^]^ae^h^r+>CbB,2/LR#mRKIK'픕EW1]Fz_]T%4̔\0V=4;\$T 枍{?לּԞ3n\rz X?cp\n?#adX\n:z-^X!`:\0y,DlJ`A)hU+5+~_+<b]<m5~']')ެܺ/Pr4o{_ngHFpBsH1)bb?톼\"[C<U~<0y:G@}脬z޺w)}[ꖞ<8&X\"`BWw{kU.E;=pQɢR)t\0;Լ*JC^ d,+d-~*xpn@A?Qh{䄳'A5P{dX`H+sSkX/E(3=!004\rjłZa>m4?og3xƕJW\$EQ^&\nQEhjqCNƠ,yHβ\$'@\n;\0\\]ϛв(\n6arǩuP/;P#q1\nPB.6`\nFٰ͒W3dbZU֜=xa@=fZ;Bk謀mJNg^prٲ(Ilcp*AOU7\\D<Tf+THϠ`RZq[`of\\\"πx|EfŰP/S\"_8-CF]\"jhF29!Eb[E*Mx\0`9DU_tюq^(j!tX'E_ػMQd^b|,{4\\MXFf-kN`7,BJG5&*1L4	#-`'\nL?\0)|r	X|e\nJ9@ʬȥ6qX\"qE	Pm¢NҖ7}	<I\nA͌juL+F'CZd&RncIl\$\")|74hCvcs}sG0~#feB.rO!<]/d[A\$)JP\0Y%F`&BvMIIP*7֐2&lXo.\0KZBq&<Jp	ei;\r0PBHMLİ=TXc1&y-I6fN|&yRn0r	%VRKRdH AY\n<JĺL'~V \"l!d'`q>Iit3:Lɲ\\s%ͪE@HC\nf\"@ 11 ln͆/X\\DK ^-n|\"\n8@{)P(P(s f y0M@\0&bQX]3	8<#11<.bf*p'<4)1\0)n~cȁTStI11(\0P,d\"=@6\0w\\fzYLn(O}5	W=2Y͖e@Ol܀7INmX\0N:nB\0k|,p>Nxnxh5Θ	Gd'3MS\$H1iN0݀8Mvĝ\0P\\NH\0|9@\0!dHNɥL\nS؞؀*MQu@&7i8򓖜)1\0#Ljr3\\9HKd?hg:	OzvsO|\0F4>ϾpS|<*LBw)<?9@	3+7ϲes\0@Ђy\$\n(#B'Rӫ5CiР4:C о}4D(i<jPQ\0ADf%>L4T@IOXX (&l')}\$eIfN_% 4i\\UhC=Du'@v8dB-%(T%7㖨f\nX\0m@C0I\rɽw<QhS09@I,t')˦\0J7\r\0!ƷW1\0~_\r2\nf܊@QK9\r\rXi{/~2Z_2'*o	Uس\0{e(\$iM4T44}6)mV}A3Q\0l/=@QZ:kN|Q&4JR*iSP5\nt@_)QIMXoޠk19B7=\0ɷ̆l|[aa.Ԩ\n\049Βv@GPO'ZHX'VZ@Tng7>l3cDXZfjY_mX)ʀzG\"P2|\0NjX{\00dTl \nq;߁:bShfy)Q+jSCQyS0Hq`	`FlpT+yrjZKcWmA:y5\0P&zWZ)D	TvDV3VFȭRj֭pv5)'X&@.C@`pTlSw_	#:!/5rrr;F&M@\\C\0\"\$(TX+\$t+r84XfId#&cIPZḻ(lZ6^3|s\\=Er3w+(, c^|:`h[UahtZԶO;qyv\\A^x!j2VդմEd0رְ4HYHz 0+Rjf_kAJj[,U\\jXX=ZDw5uˤ՟n	%'}&p& )qX\0+_9C)Iۊ)R짇`ĵ@/!+UAf\0R=A%r3{\0`%z0\$>Ѹ=h]/64\0i_2Ue;:JNuV|@	GhU=Qh'(T>,n?#tsf=cVvu`U'X)MQpp7פ!aJl0@ZFE=ClJduAJtȪp0WUwƁFa\niݻXJ*o*6k8N[*/uMCUMaJ޲V!U!+Ŭpxh<@B] ;  u_2RL:߈	4.f1@b%\0!{=Mۿ|`x	\nтo!p)_tȾ#pai\\3D.񶕁Y2xFg넞8'(0BJ@bZn	p\"Ee9J0X3b\r; S1[y=(73	Ñ2*l0!VlrZ@<TKmXiF\nU?fT\$i8GS)L\$8BiD!\\B#<4aT+@-7\\x6p?\rN/黰%L+`ht<W>{~(@R06ǞP+{Esö\$*b	&#[X̯&bnSUl,0G~}cUf'dCs<m\r;<*4~ǉoam4]/02cFxwH;Rqﵾ&	kX?AIƠ\">x?,Pbiū)c<\\++^n3ő|N'!+PGN5TBK!1\":2bP,Fy*NÓ<a[&3t閇7\$\\qߔ 2ecInTy2c_	@\nup x+XUq<A.Kʕʎ!2?8fr˗8\r8(p^!!Y=q>\rv-πٗ	1gf,[,e'ZX:2\\Hy<1)[α;D|#H@LS3>;]2Xvj.GEBi+d%,Qr%Ц¶*I5`t-sb8E۾e\0=2/Yq9-eZ1\\^U`&gWJYhK]8W@;p##Bynqĕ\$uY!\$)(rX@/+L8O^ʔp6,Ѱw<%MSS=Z%W\r\nHy/2+e1Eɣ\\Uw	(p\n-ISEZiI@1	`\$448>\0iMӈ4QjYyp#x`m'Zڂ6zaSi&ʒR>z\n{TiP:jZjTtR@:ޭ5hj{\rfr\"x|cx?rkp.r>tqC	k5ha\nU:yxW8k)3!ҋk^t}-x5^B(q@Qd]ƴCr\"kw[&usW:ꕝN@d=+Z9N@m{-%>HR0*7K/<~,jsnP\09.͵Sj\n74ݱ,\$;E-m\0*Ȼv7c;u&vֲ37ءy(tn;JAG4hfR@5)V{[Ymb61pJ6;[.Ŋ[rb9V0\rw݀CwVT&=,hzH)8EsIt<@e+0ynjTƮw~dJσ@)c+h,ث8pL K:QAog1o?IZ.?=~nkF!n%/Et0'̔P<ƵGqP䴓FxAq⃫vn`,cW{9K߇{|+s<4Z+צ6PPL(L=ծjfh>)A혠qpK̆Ҡ~6d0Y#y}tORCS_燜|bHwsO%UwpN򈍜Y]U\"rMt\0jxoWD[[M yT8@9h!̋r`\\/4u{d8Sǡsb\" i;jiǿkj}vi74߽J9=՗540'?(7qg t	_[zӌ\\w_>s_g\0V|\$p-BsX܇.;3gPCDGy1j\0y=M˞;Fm(oD7ykbo=!:.%C%t߿Xm\$6&PbjTu*Tx\nd5Νt^d(S|-q\0(tXYQ!HFk0t4H|oNoN%\\w\"0Bq\$[玙f|q7~EyXqר>| Ob*\nImcEЮe6ev˟LnɩKxx~aǜf)9˟]F!sIiNh~ӔR.GF8/zdCf6-#g|t;4TV)kV/yC907h@).HqEN}K+Yr\nb3@K1 )lA˧=#HiLʄ5oAB>Y@\n1H!+ȣs0GH~^7ـQrI8\0Ì`\nw=0Ay[Q8HOg m#ʮukHB#oufoݐk^!p{}4Iv?x{CY-ICמȒ>0l\r\0|Q15L/j3;Lﴷ^{Un(}bW١+>'{WsC~qM;PRv̢Ɗ:pQG 7a;_z)|:g\0Y*/kė\n>U0xH@-=\"0H^UE+x+#;1kyTh:G&-!qs3^|xW-l!׸FXt]BXY;QL0cIojAQLGG%\$(wҹEhXKaob5sAt/\rݒ`w7<MP*yYh>Pr=zjW01gdliD/}^V\"b>XRnr.0̙9@ ۮȷ;&^2hYXh(b\0؀/\0l:0܂?t%> CG4@@E< h	O0K\0@r[\")AoX4z NR̃`jkP ]Ol2\n*b5Dn2(\$<)Hac:ϋ/8i:n6:0;<1LP\$ أY\$:0jIP\nrL!wN\0>~/`4+\0<^RXU6:\0bN莌*.Npxp_ 8\0XoKb蘖|l\0Ɩ)\0P:<pl\n@ASPPƚ\\ A03\0006 (.pv}9z@N\$ņ?5ㅟi+Av8`y \n;  Vp߀\"jE=x0d\$PV	xXg\\?\0ePaAJ/`pSLЙ	(PYBqОA!.bVs\$	|Pf%gzTAk0l%.l5I+8I+BH*pQ\nG^B	rLPUBqhBnB,b4Y`	|#`.B.B\$6!*s\$#<B%Q*e	NrL\0N1!i+\0Ѥ\"60bCgaN\rPUCq/P\$BNIB,%#-\r+eh&pº/d+PC-BD;DC}<BB:0Ï\rPCPBi1r	'c[\r?P*?³+pA,1Q\0L@qDh.YP`0@6Qb\n\rޕ0\r\$1@=ĺB֔ -tXBC1,+BI%	ֳ(KT\0F@/7X\nD``[ΕpDLDQ\0\0N`3^\n@%	9\0[ 	LMA믤Q2Q8)HWGDb%\np	S(#tDHQq[f]\\'(B@^(CCvV[Ř`(^EZc!7ÑE*Y1mEuY_E\\`Ec,[1e]`E\"䆬86 zq]hŀx@OE\$O6}Qq=!\nŐ<b:QcO'b\nT(|QqFR`&E*1R!L^f``ņc\0^H!yg|F\rbFl<ƐcqeFipFhϖ\0]Qhqbƨ4O #\$=\$gFkFp.<\0k`nƦO(J [qFj1F4\\(3\\TgD-TCA+ \r7Mx	\0Z	R\0005p\r1E\nVI(;R~[>`36rp	%-Ж\0	dCñ(9Ax@2!*`\0002ǲ~8S	PAڏ/ #揩-81nt*\0#O0=0	'\0d	( xG  \$\0H(2\n3fn 7\ñ`7GF@>H.5 >?B><z\$`>0RtY+ FQ΃ l@>\0̅10\$VƴK&\0@0 H>4o\0006q81P=9\n17\0D*<#H\"1|#!K3=~=nmH,#,{I#t~) ֓\r b6I!1gE/r\$)\06̎'0v3g@\\@\0! 3!4HdLf_9r,[xebf HHhpf1~D%,a)0֥%<Nc>& K!K0-;H0&܏ଛ.|#.@3!K\0002\0!07ʿeJ9h\\=dT\\\0QDId\r(II 8DrZ~(;bJ8CU!RH\r 3Iė_AN#321@{@J+#=R}2-~H.!`:T^!K)Jл(\\-\"#L0	tʃ)d/!r]8ы.SKҐ\0H\\wG:)Gʘ5+N	N\rJt0&(\na!Is!!d10D	2:53)WJ%:0˂#Z*H-k״\rR<-|Z2L\0dxKAty2vLA8\0K3+\\{e뼠!ֲ\$gI.O#򝂵)>\$g!P؀6KF#q\nWP2NzS{)|/'(kfQ*JdJ>!02\00Rbr4yJ\r <^H@SdWlT\\TTF;q!MCx!\$9_Ay?z2|I|.2)*cBR+2ԭ`K2\\R˛+B0˙L43d)(G,\"̈Ғ3xS?L3<SAM.t2. !+%8!JH@K%4A3N*d,M4/ſZcO1\r\0\0(M</Q5̭38J75S_=5ܩA-0:)~HRQt͑\0\rsdGsdL.[6@562M̒-/	\0cLΦMe7xq\0003b44`1.j@H46\$W6\0\ri\ny\08h;>Q_<40?RH10G(LfQ5/xXsbL`<8{rSɭ9@B8x6'N\nRQf`8|\n'ԟ6T(2^A*/'0Et*xɇ#dgHRH(BU#`\n\$c\0(#92\r>\n`CrKHP eP7\$8҆6Y6|ThRЄ,4sǊ* K)DsJVԟ5\nMH?/|\0006@.Lh˨>KvL\"!K(\nIOv)I v6Ü3>d!Of/KLv0	T\nؑ,,ܹ6M|Od!'U=C/Jd*ǭF<Ӹ!H;ڂ;љA~^<aSe2֘=O1 9L{9,:9,7-\0`\0` u:1| e1VL#A	Ap\r`7)@,dġ{+5\0b`LhU\nЦe\nSΖ}\0JA!2\0A,u\0006PKQ|3O	PS68\0%@0ɦ\nL5.ə \0',<)@?(P5JgI\rd9\0T̒)BLA\$cb)\rXCO(\$NJqHV `\"M8t\r;03|QC7XLu1}3X:bO4]UMaE?T=%0␂C!TLH`*P8K/\\K6{SY+͐KQ6@6V͑<eIP6CSzO\0Pf>80a\"gI,gmFᙔrId|FR\$ ȋH!2FܦP HR		8a5Ih.QL(@;\rZ3%\0=)@B*H?T\0#I\rJpLJU%eR_I&@:R%&ԪRq+*RY?R\"J*R3JiԬ\",F5&j6.'KE+ԣ&u)TRML)TLD~ԹRESK	ԤK1!L7DcK-34DA/x%T@SVIS^= `\r\n5#0	R2Q8TI#%Swނ|R7Ӝ/E\0~0A/\$ӿ@82L!dtYO|7<a(ʮ64d@\rO;tA?QiIᏐ|&,<w-C\$0ۀ+B1P\"*#\0HEJO5\0\r]O첈^\rxz:^	_(6M'%[-i]F#ғN\0ĕLN4f#i:SX@4%[ʙ =&#eHc\08f  p4\0ag/eD,Aڀ@bE	\$PJj2\0*: .24ࣨ-P@u=)\n=x )\0򔂀=\n`+H()\0#x&=:ki&)H+>UՇChi\0OZ~@+x	\".F?B	BmAC[DmQuFjR/4TuK%TMDcW!B\0EГ`ɏ=&L=cϏB(\n̨[0U\n Oό1EUTu]\rU\\D[\rG`1'XdUT?CHsV3WEcuu!Xu\$,B}e5~UP1.'A:>p èi\nSSE\n1\"T@@#lN1[(ñ:PQUl4D[%lЄ%[XuD5b	kHbDpqW]p@9\0[R8Ŋ(-RN..UpTW%\\*U̦)\\Ⴡ@CtU͟j\"\0<WRc}uuu]v3Qs!]}WX]w.mu<I\\ 5׹rdh^usM+ 9Eu\njWy^UW[_E{҄H>WA~U_:k]xٵ\0b(\\B\$89\\dX4UمaH8W#es^A?+=u\0`ĵ|\0z)upQu)`]xOu@6ew`q9? W@hv#	@m\$X+ <~(f\"jDe1X_=rA=W9\\ 5c=E@l1X̐: ^\0\$=bMsخFVb\$Y	b8WCTs6%Y @(-)Tb/DؑdH؜L`@d	VG=eUvX\neZWF{MMY9eMѲu2GN(-(+b	K_fX#f9dcvnRb%4'-\"\n9\$(JW%fՙ6j@7gvr4d/1g׀[e}Ӈc%cNJ\$aa٬N	Y2dSbQ`\0ŠW\rr,H\rhrQ\"i\nFKK;iP+Viupc3]֚Z`8j\0-Ei+d]\"ىh	VLϼŕf}1j67dM\"XYjW@١A\re%\0jbtY:Zev(ծ6dAZk\riEK6l*<J]hu 6[#lb;bճvdtt7JtAو8A\nlxҖZ&!~Ҙ[OmHմ~<\0mZm,[Gdui-DqZL66[nE ۇej1[l6ޗJ}s/[me#mJvF7n?Jt[R\\6YoLc`5ovmX-6acZsl%C@[Wa [W[Mog\\/\0o \"sbM9dģ58<v#4m,}نV|MlS\\im;ᆞ+YQrEȷ%rj7ۯa}ZMrW\"ܝs3؊(B4q76qCo*+qhsv<oՔW-r7?ܧt\r صt->tH)rJ7\"@w]Ŭ7IYpmҷ7XYt\nG]\rp\rQ\n8\n2ѰTezP\0=vNE#ܽu̗Eiu-Ns^.}Cܕd˂2]1f.gr04x>WvE7.]jU\\k4q!twIF]pwq5w)\0qp\0\"\0_az]^7v][-ܗ<vޖL7c]a7?\$-7;^w5v]=vagv	k\$w;Z!Vql@;V0l\\[v-`X xW_\"n <^uw^ew=ӷ]rup*urZ[]G>é5C̻(0*ɒV0W	(\nՂ[z`)^Zkɱ'#\n\n^()BiW \n\nݦ 7<'@	^:3\0*@\nЏJ&h\n| z\0)_\n=젠_D=h\n5_Z`*\03.(\n'!h'(`«>< -\0{zi /L8`/:IUv@Z]<_{0~=`m{,7E{=+c~l}5W_X&\$Jk1m7O{%8hx`\"'{}7^袍Ѐt@\$z\nVi߱{i&JW|\n	UZw_NW(:_RR3}`&\niAh0\0	|ES_%_2֠7߶8|{8%_Y}pc\0}k_k_s}_~Ώ?`	׻{Lpf8;\0^8\0_E`\"b<wߍ~@	_-Jߣ̀_-:fW_~Mia1~~w=&_?ZouU7|XJaUrbdpZ	ը<wЙ0f#U{~@&_	*Ԁ{zw_3`#\$(0gUPX?Rk`>+\$.8gÆxlIa8[{X8aI\n\rc~aͅWx?\r8&L>!^|ڏt=a`=؍߫ %d	M}x\nW+|- Ux	iaCWa-s߯'f(Z'}צ\"^'b\nxkb=5hdCݏz=6\$C؀&+~%8\0W`'`v&Y\n&0<cͨ<	 !M\0,8bɊ\$ď?EXc\nU&Aha108VF2عeNIbq3>\0V..؀Wɗb#a=BϨ[P*=	*踂`7q+H 	`\$U5k^=Z	b=}Xc.(d_3)_3Cb\nF1O,Qyc.#c	.A`>5LF9:<+uߋ\"V[(=>X%Ҍ=H\nS9axIvE a[ &2dh=PZVU]U#d^\n7FG\"&T&F?\0&Hy)bK9)w;P\n\$d#bˉ&JgvK#=nLX㍓H*ا^ۀ *'Kቍn,`::\0V	)&!|PزVO-ԧ}{b	PEe#OcgP+Zrt(O{rByLN22(&U	\0X぀kMf5]VXUU\\<paH#\0=ZXvW	,R`)f6Ucᄝ0,bըf'`%ᛔe݀^8\0^.\nX__P\0).B@dva9)'NO+~++XA-	j3	MaX]\"f)ـ>y:L\nŅ4VX_p0=-@§zUYb\0ȸx\n&jX&*ɋ_r{R7Ki+q3kw8f9{6]aVlb>jyfy<)(\nkfjԫ@X \0Q~@F8CL0@*\0`^~rxgD6tT|x# >u	e)YϪǝuJky2&eU{M;iUL=u#gX*t+0׾ȁ	 'UY^)5VՓ*X-Ua\"ǆ8`}aוU{gdn-8\0t9<Ldh ,=I0h8\":8	ԣc3h1\0iz86cd81hiֆ'X9|̏_aK)߯Xn9Z05\0ƈx\0<\nX.UWic::	Q&\nZ\r<Yփ9VgR踶bZb*IGkc.rmP\03Y\0\"'2UjIiI9]W`+L>-c<|\0Z煥\0e{󀉎NH=h+&@1dS^hy=fWUa3~XN;B+FOva\"Mwg턆cȀG'Gib)@XCf<\0``ڴ:c<p6<ƊcaX^Yc=-axCRKZ<ƛcf%?n,نg種>h/xH筑VyeYWVZ}l\0-jO8_[0\nY\\Q~#nZ>wy৪Y_[X\r궚ޫ|egUj:Սsˢa\nZ&ȭ\r`.I`{.n冭\nqƖWd.)a`>gX}8򸋀(\n.͛v{T7,3dg~0ؔ	<{<}3\$ϔ)8@R34:䵥]~6U!<@jZ ֺS^ӈB~ 5ɳ,S,(M9p 3X/Zu':Fp\\)|ƣX\r<Y8Xt脕!`6 4.6+ZP۰n<0&bw0>Sr<@6d\nzlOFRlO;H5ڝ*L^x0>g6s/qYe\0@<z=\$Cئ\n`+'S9X8_/ij	h75Y\0&cwa֡EɟXyfub{5ͳvGjgnXd\n{lǫ͙~V	?3W}R	Ch0>R= 79x>S\"ӂ4zҴ0f\"`1:愸x:x;Zd֔eK;@gTML7N3RkN(iF;)Orn:Ӷ\">^#e;n!Q\0/ԆfU\0\"@Rp6Bm0	!Yr/Tt1VeOQzBr9,@9m!t11;\"cmMu,S<ŮW\"yvK)VmV,bk\"1hxF&9t?܄Iq\0g5MK!,?!PSQGe@a:bHd@(: DdFJ1Ḣ 8w&@⍅'iVmL E/[RR˻ZnfՏٴ_GhlbŇl.3%I[c6 3k,IDX%JSoxvKBq[iDanO@۱m/|iK2RjfVrZEJng\0_H;PHDn-iQa))PgL6%lk:sk1SmNFo(SJIe:ԺJ=lF)ﲋ\$xͣ>Æ9Xo<'mHf!D;\0fSAr/;Vl<eػ2JA\$kUY 	d\0׻|pP!fZ\r@O'_x6;\\4%Z6[6tKŰ#u1|2XOo&6~DqO<<:Ӷ|p%%ֳR&\r*oʡx\0C[ʸ#:lpw\$KL;sh`aRnz;ϔ;|8L=OEǥH* )-T/⛲_H._%H7THSD5>S_cr~yE\0*^,͎FS=\0#>@cEMA7o\rRq{Sմ1''m{p0f2/<m:-HƸ%N'[Pwdf\n5<t	<n5F3+b*qedƫ0@S;鞒d:;=>؁=#NR2`Fd\"wQݵUNRutvӡ\r'K#O\0ɰ씑r'rH.|;OK.8L܄HT|sr̃IMr/4<䏦<rƖ05nln,l?Nࢃafܠ!fo~|@2/<%|1~iL	_1 5'}r!16Eo2s. \rr7<2<sn;r5*OlLDF@l[͜;]ͦHaGw75Y̚5H\$A\\<t|ARQD!D\\Iqv@}_lh(SKi)|iwTμO>,a>T4|sd`#y\nu,\rη@As8=tdYw&		NBhR2t %q,TwM[!O=xNHJ@C6F~a\n.Gq\"'(q\r8CvhJ`9\0/|t&w@&+\0]<bt?DqO:</aX!8YEUEl7G=aLt@1^><ЇQX܀	\0}?CwԜ]=EW\rNR+N#]?1oG}.wG}%6Q#@.h;N <P䐠18t⡼uπIM!]tU֨D7q&0ܛTz\0qH؇tI|`6lIeRM^.5ue^M_\"7_'o+0sQ?FH݋uXR+J̢O\\\r7`N|EtHwY_ݻOa#b@GkN0 SUh7=\$_0cx7e2qtDp0umbر*]^蝍%7N?l/PZwO=gnVŝ veթwn1a^]]<p\\ޜ&AzX4#ݯ7د_=k`Ћ}!E^Kطt2_Cط\\IX3طѝ:%՝w/PQ.ęGݬA?[ݓ'wd\n9p)Ƀr7vj[@!w^R1ڤ7[e;qm[wkش/5٢r, ?b']r[\r/5ݰׯr.%UZv-l6~BCGhS ougMp,O?Ddmw?]u! R4V_!xIw^H9_=>}0ނ)=HO_=dء펝 d 3]_6:xDx7BӼ\0]/=vIJ<AX΁,Me;G\0002x|&\ntSc4u}pv]\"9x_Ob'SK(KaDXSmǍ煇3_<;TMM\rHo*_-ޘR'NU:׬Hڪ%\05g-t\rik5\n`Hsͯis~qOo\r^m>\rO/f&?w	r3*}t󵉏<wO\\eV&d%}!.{Jfם&Fx8+R:,x\r^2uV]qOs]x=#CI}e1bҚotJIwP\$v<Fp<yN\\\0=+5Pl\nSȳӾ\\6탿vi9q4g#|ԤvzK޽t//5j_Io%!7ItQk\nMwLMpu!0K\n/W]ڐ[﮴jz)}\\X)O>}S8@\01G{?yUaG//K~K-O_7}*Oa{z%/,Ե\0#S=`7aZL{H^>p7EO\"/{=TN뽏]G.ԠW?]O߿vLVFʝ{JTmio@xO?z/0OY|.Pb|+ۏ\nJaW/+!?\\V_W|=Oʆ\\FhaboC@Oq|\nzO2j=EQIv074͈ͮ7=z2M=)M7[!jJ	}^wmhzx9{ݶMA|>o)0\"Bx}40K(\rmݹykߧ1|OnPt謔{Cqۏ\\d1ҟa.u]t7cnYDEVd5(}	g׽u\r<T\\\$cԫ*T֜;[q{]U}ն	_t5udkmq_޾7K>+y{&a?>N,5Q^}ѡ.}aEr>+̧@n?ce|X}'oce_vo{}-x~S_=wn\0;=|'8']{CÏn?[uIֱ4)~=uM=1]>F\$sRO\rMw{/I]?5N6uRyJ tZ\"ptV_ȩfsۇozfɹ7̫fVAY\$|z[nP;[\0[/eCҝO)wUBVW\\pT]_	G#_v}5^M/\nDdK\0B\$Qzj MD)5đ4!V\"XU\$\\!W:2Oʦp!V\r9bʰ	U1J\$.萧 p@.|\0TY)%؈V\0Jfs\0R%fp4\n\0GVj1Aq\neȢAtm4O)Ay?\r[^tTD@^GyHה@i%\rY8+ʸ_(٠E,dW<@WArH_\$;|	Q2KX-B˵wPCYD2%WT]2soZT@)jurKo-\\L`'Z/\0nwsazznk hlpUaKW6	\r\ni orV9``:z(.h#-<Nl[PtK5EZxdp\n+%\0	@UtixXpj7aOщZh`NUŁ)4ҲÈQk(M Yb-D\"8%@	G.db.\nzpW9g&˰C\nв^gi7-XїV\0\n{ӆ,m5j1Uk\n_`-,5e4y_\nق2й3ɓ@\$lFaߠ2 f\",Ba-0'Fȍ.h-iW~U DҊ`ќ!V84̒\r+I5&L/X3_%{EZ%s(6MQ9qYtfغ&\\M:86\rั_A~X\n\nXM!5̑1p<v-eg5Uk3\0%?<-</d<y@M0-& Vh	\0|c?h6c`+s\r&!0gj_=3P ÃٔCE3P{جB\\&l(7@Q\r'0B'beXlA'N2{m=xc*>	lZg4Gg\r)\0	\0APA%j\0\"Gg	F/:dyyH6kf2dfKr`B=ź{=F~̗baUt}!B	&<̗D2^f[%?F	/c Y/B	\0(AmB?\rt*plȡY\0+4Y!VIB#w'EI\\^&?(M\"ÄzZZ0\0Mj\r-HW!4BC_	 Y;8I%i1a'z];7L	e*霢+la73/_pXAcna}r(:AمU1&&́a'F3nK/`SX9Acu\n1_p1c?\nUa(\0hBcu\n3&2lLG\\4xXa!dj4Vg)Ն	-6з!+	\nk7#Xޯ6LݍZFm2(V\"EuX2\0cUų5&;,X\0Kl`=32VB`gjz4 	x׶*\n~yZh_t5{/`\$*^	Q\"X4dh֤!L<fV@ve[b5!GX^0)<&H/D0 A.7lFT!9K򧑾~L҂\0My\\=*[0.wZቚZke3WfU+8Ud2_W-SPYPF*mH	,+6fRY3a'#<a\nUWB	L=0ɼ\$'Rȭ|TVHIAOzv}L4ن?v4gN%V.\0D;lz`<	؈DKgQR\"s9WQY4lzνthuz&c&\$cD!04^4M!35%WhlbZ]?bZ{'1\">'٣iΕt#\$h@IWZR.ҤYA&ҳ_\nɝEeL.YćH,3NtkZ|'i\"f 90H'z0Z)'ԮLk͏ҲBFa1O\0+ V&	/*\0XfW0][x?M)2F!fiI\nܤ,Ԡۙ<0,X]Λ\$tB#tխSHh~\\\\*J)nDNDѼnTbA	R!{u)^mzE!ntf[{6q֤yFƀ/\n\rB:<I\"\\*MhC[o>f #pn	CK	q<:`6ߎEK4\$,ة@wUQ4T\0mԈ\\ZD1ٸ3%>`J1oq{/|krckj|qoX&aFY%4~+\$>;^|[1w8vzC @7o:	H!Ŕ4`\rJaD|\"MXPpܻ؋NYhXOR25;8){(>0إ*A\n)L-ba/w0JG8.C\"s1m@*T\$w>L!M}6WU,l=1!Qh/-i\n<_6GFFp:b6-܉*7[VqH:G΁FFqJ\nJR-['Ip\$)%ÌdIvd 鉣q@LSɇ/ Ep1ɀHSNydM#F=Yړ&i_Q\$߱ZAddrƼld\"~!;ne{ЎQޠj	qFΌsFrwRͶRqQq**pJnL7 Y'Fn؆,^GF\\({Vs;LۉhRӂKJ5җ#C;>Sv5[#O~TXe@)4ݬV.8LTUFLفcdF|8lciT~6kUqn4|n7jREo2!n)\0!g4@c6',o=6B8^=m20KxF!TȦqXQu!Ndh)?jtB2*(.RAH,Z'QB&\0֛9݆v4çxmʞ:=xnޫA&:[gbUtQtN:Zn1Q^[CvpS(禮I8X(*TQ#ݎg/8\"_iq;G?ҋwn\$c>PmU㽀dqۤxIGy̟i	PQ9Ysd\0]<Ǳ)LcAX/[p%D@Ju|ziA;,u\\|~CB>8`K#ƅSPۉzOQ\0W*M~E\ncǸ#>t1cG	I}Rx5ST*XM\"n;J\\L+\$X¨̭{1kIJ\$\"Z@u8_{uk.tݏ>2	dPS QNgv0sjdx_ov\\mĒ,FQ|v^SY	 c\$|v}m2ǻmZ9&-B.2H\0=<ؐDd3bn&lJm>q# H\\j	4@xCCzSlqI?\r	'6GtG!J\\^Dkŧ@bTu'(ȉ>ܪjR?HQ2˴ڟU']Rl/+1/O֞F%}:iG&Z\0n	`)`a\"fQԋw6~*#18'nx/dc`WQ>Ї#KN\$N!O(@GyE\$)F[{!T #J|AX%o޼w|Q4n`ᑨQceus2#\\gIjGjj+TvׯDcI*x02\$}j?[tq_\"h% ;W\n#Dj&LDtS#F@'NKpEm\$cIQۍ/MR,za4bOR{)Ly`s0E#܊)2?tK|gO`:E&f=h\0RR;uvr۶#o\$9Ig#RKd{]yك^Y.IM;\0'P^<#6*|nGYISXtKN{2HbUD(ޱ3ii!oMID|Rzޑ'wmG 5)O?ZqP+\nF%?W[\"PhW\$I'?TJ,nJGG\$؟@*T`Rs	QG8eF˔T\$y/]^\0R3oi#))F@ne)/Y=#RR+`c7ȆT`?iBFv %'Q8@/*^4ؤz	=\$}\0M<ZO'\$mB0NA\r>\$gJod+Mdr2ۏ(aZS1q9?좉BNMRtʨ@_U8\$BXb?̫aͯ\0>uBU	Wn\0%K >RHN4:I8}\"x!uGI=)	cwÝUe(D}@J4cL1lv?W|T^eBiώPٓ)O.SX-'0ДN .Xkb\r_z|aאּb#v@NXt#%ƃTz[Bpz2VdB!VhuTIJU|xH\0BFBπ@\\\n9FfI X!\\c,Z!-Cte	薸Ԕ	՟(UPҴYjRї+LD\\H\0jզ\\V,ZȢFB2VxxQ7PQC|%-q`Hˋ'r VZ]Kv)_\\)q,6o. uv垊Ww	\\݋%Q˓0,vrm;e.y\\v't^?-9aIit#q2;>{[4+e@^-N^0y`^≯)i28HE-B`c\0N%6{ȘX90il1&p|%	pC61[\"uC\\eVXwl4&2\0XI/2e3\015WAa\0aT6V0a0`YLf0U\\i0rLZXB3`y0z6k ѱИ.NY:0sX3ЈA4 ,eY3(RρL\$,HlkgsR\"I`o\"0]#Cƃ1S4:hp	6eb41eU؍Z3h\"4GZWW(V1V6!YT5A}k+&9D.U};-*i&\$U~q'bPD(ZF1*	=Prq,Y5gzcQ]CdZ&Rv0æV#\rj5eP]CX˰+6	YHH<ajK\"TPX?aA\n\$ę1&i;)7H.2'+iT.\"l\nڡȤVcO36mhD/3n4|>XHR}&soEi\rRׁ+l%!p\$7N0^pM۠OE-zg%1!kGUǧs\0lz9B.K/^=M7fLߵrF|	lї)OZR#7r#L0)'\"^aԕS*S/JMbuq!W	sҔ&FёƝ83(9|fQk*p5	t*ͩ=3w\nZOS\\Q5Nh#B-M+Kӕ+K\$=v69!K[NH'ZXVOD;&MBFnTfoҝK0NU2-D귎Qn\$e%@-\0,\0Չ%-ZYt)f*+>B8f*EwKQ8N<B\\Kv\\;7tM2oLGNe2G@V(@@\0001\0n0\04\0g8@\0pZ8P@\rN\$\0l\0Yǳ+8yǦ\04\0ǳ@NP\0qS'@ml@N6F\0qiӌ@7\0l\0q|Ā@\0007Z9ps=Nr99/799S.Zo8sg?N.\0s9q4\0S'GP:.t|Y'N.\0m8Zo8N:8s@\r6MA:ud3g*NkI9ד'GNg\0`\0gΠ8t03RN8\0d\0rΠ'aN*:ryS'4\0000\0k;:sssg_Nh;vqyӜ,N:Ns`\rрc6\0st#3(Ŝ:jwNǜ9sͳ'8Ρ\0uͳH~i;rYӾN\r:riNa\n\0y\\Yǧ7O	-;wiـ\rgb\0jsTٓg#̞9t\0@N:JryS	ĀN.+8ڀI۝;r@\rN˝:bst	ᓓ'SW9sޓ֧fNC;sڳ0JM=jrsO{6=rI\099z8 'DNܞ9tSOW;|i瓛pE;yl \r'N\0e>sy'Sτk<zxyɳ'Ov<}џg:F|i܀gNa>Jr<iIOO<{IœiN:m<js'n-t9V|Ti䧴N#9g	>qy'9Bw4S3;{Dݳ'T[9y\03'Zc9V~)-NI%>:uiNm<D!O\\:siٳ'6-:v3ߧq%h\0}9'P@<{H\nP4A:y\0˳@dk=t	3gO?NuZ	SQ=yFN?r9sYι>&s9Q}:xڄ%4c};u3t=vMYʳHD\0:JrS/Pi:^߳ͭλ;~z-Ӵ0:q(\$N4U<J93/Oơq=j~	yɳ'LU;<ڄӝrO:*ͳ᧘()>XУ=uZ4&:t\0hSOB\"y˴5'φ9:{\n\0p@sTSg8N-?Vv<ZSΡY@rY3'P|>6\r蓽'oϪWCRzhO\0M9s|ySP\0m?:)ʴ2j@}zN➛9v\n@N?D،	-gP7!@q])̔='P;~e\0s'U؟Brvy'N9by4\n֧n9BZq*Sg7S9-\0I'/Η;9{DS&OWD|Tj\"3רP*a;4'7d83gѓ=2r93hQ%Frs\0tDώaBx	N08-	_K4Y>ޅZ,k(UяD\r0hQE:S\n3X=	(9O;#;rZ\0gЫ'D۔_OhYGj͓,NnO=bx]9TUPQ@6q\$z~I@^	i(Dʀ})4d)PTT4^\r<)>NFΉ-!:4NP.>{(wCI3'&R!cFS}O>*Y\rhΗXq\rZSgN;IE=!3t:PHDUt=V#Mr\rYTK\0ԡo8ySgNWGmTC`P#E~}	ZM>KzCr}\$9sO%9khJQӤgQ/@P#Hʍ\nDPK5F5\0%'Q٠EsOS>Vm;Th^B	-4<Qs)> IͳPB};&NLgDmyt\\K\"vSIiL2@BsE	U:tUT(MCS)k=sE)Y۔bvR:*|3)=ˢ:2|\$'PU=:yi9QL\"\nt((|҂;\"uUsR\0z</mbʱPze1XG/fb7)TYZ'~}^,O:b8JiY	bى5iYL\"V\"5cR@Jl4<)SiMn;nCf:S bl 5/)LB`	U~y@S1%\\8Jla	Z4Z֩1_&:6-=#P^SJ:n\r)^_	y7~Wt]*tf\"mINm4i`lw<]pk4~]PZi4%L2FrD	0&KL,p3V-X->6SV<85Zi312eۃTGQKbJP3ntµQb4DܱWkf+YSaU͋yvp\0¯&;P16.\rjbb;\0\0Iٕ4`ǡT=&Lf͚6\0\0EmDJр)'\$83;,B[`38iS`nٻ\0V\"\0sk1@״Os_Uf/afWG~}5m#يӧJ&\"Hڍ\0aj\rTMPҤjw#ؙ6cC!וּޯ}#M>\n:!SV_RfR]ße3U&Tby`U8OC˖\rLBx3i3f&J2'\nj;i<}\0C'8˧@+J,nC0DW\$ǥ>wVXVS|hM V\"I'ĩ:Vh6֎,/f\n3Val^kMOY-/Z)b\rM<	0&aڣ\0M_?Q'pKCqTŋp ߴvV{TZi5OؗFf!U~CeURCH	\n%ShUU*.EM)ǵCRX5P\$&\r\n0QUK7UJ*/jb',(u?_UWkQj4i<g\nfU8^0XI[]M5SxSJZɰ<UfǪhCRU9ЪDfpMj#46jd`=Y6abV[dUpU7U\\DVUbqMUW1ąsV֭T*ߩTҝK15e2Y&́[PQ&\0CV~SrcQ&%dL.vQd	eX^p!3U\"nBTa}cT\r`ڒx@ZcuTƎ*BWV4/uQL]bZhSIՃUF\nUB|UfXUU{깕WZլfՋ=Vcy*ƌjSoY\n-\nl+d<5a}ewM}Z:ua'bVb07Yefj5ej\"(EW/U* /VY­=ek0ց[VZa}կC0'rc26q ڷYC!f\riգZ·IWug\nlMjͬZZAjUt_WbU3թ6a:v+UU&0kd0\rg\nZYg\nڗV\0&V6\rRj5k쫠{Oxw+aT\n\rB2m<*A1TRÕ؎SFT\rbzxK+xAU:p\nTV3\rocӬ{Zڷ5q:VDEMjqZ\nVQfuY\"U~\\fSudVbeV\";䕠7;0gJ0٫;Fa³YQY%tu\n3euh7U֑hƥif~+֚\rZq|K\"i,	ռVu5kQC\\\\uݪVeFqzʕ+֓]ik,+3[5t:U*C]⶜\n,*SBk[nm5W3yCkqCh6̙|%`}@@\$׺-X:sOv\0pwWFV9\r30JW&]|\rDPH\0V*0昬0*֌`WN܊\r~Wӕ̪R9:5̱Xa~;p-&_8SɈO{Ne{?V\0N\rp\nmaWgO݀\0Lɜ\rg`vx,YY`)5ZΡ~}yY/\0l1fmC38'}_&:913, .N	4@inO@y`XU=XlGaP<<\nhTCOśv̖kBu{} ݬXOfl;Yaګ9=u*X&[ɢ|,@Y+b\">I쪳ay\\)Uu9\nzj&`uLQ,	aUS\nv#lH;b6ՊZXbOձ儦1l\\8~&5Sz޺P042;)~\\Xg~Umu-kX۰caYvPplqXb°V-:Jg%T<tVUf&LO5``H_cSWϨFM؈bcӺv}vs	xrȓ3ڋ5Il\$*Bn@1p'Oa9'lhPm2{64(mOfCVle,zUVuYT?J^+:0\"0'cU(WTh7X>eW}I5eX1jYYzN\r{#vZkA\0\rT5=MɣUŮ^L	%:;Zf\$&HL\n*9Uh9_Սk[a|A[aUhvU\r\"6*TDeRr3s\r@RLJ}5V7Y=eu\n;,ٻ` 7o)Qy\nN2~Fj=}-T^gJ\"@JOZ\nj@i;2+Aܲ*{;ꬳC: L\"k\0+D=[Lճd\rd̉2oe`=wjԬ`2q5BE\nbsR=T:PlEĸ~NKfYYYʦi`{-fblvoc|=t gְALrV+ٿjM;XAY;[H\rpͫ-gYm1Ʊ_Tz9Xaw@+2c^\". \nf`{]cجs`O\03n^ӦJ2mfڂ&ξ[D-Aj-X֎tU5Cjg%Sbcډ1\n;bYV~a1jݝPv08`L햒dw*|i˵EkVY(Ȣ06 @!Mkͬ-\"G\0(PSQW3s@0ŭU~9\$#A:;*Yh*ٛ-n[lsȠ !5 1ɀ.#3ֿE<J\\'0l\"4P̕0?\0001d\0^\nĴg<\0\\TV@Y&4%;\"]m\nlr¼/\0kl	e!K[8Ml)x{g-\08l٨P6[@\0bཇacQ6AT	)Ԑ[XmX7m-Tomnʹe6-hmKnQm[SmKoa{m-Ֆm[DmhYmmA{)\$@mڐIېI!e[k-ۚnJImomIѭۗn\rj-RnV0V-۟nf-IVm]m-\$-[·Qo&܌+u-RnISoV[ڷonލ{7ۄm-qVmmv-K}ȷo]|Э巧oڽ[zopMk{\05|g[pZvE\0[a7oܵev\r'm6 sD˅\0In\\2Yn;y	\0De4Lop59\nr4pf⽿ˁ(Amq*S&[D1p4ۆ7\n%Oo	7-\\O<2n2]q;t2nz\0C&vmɸq8[6hdE mBE{v.L\\?rb]K#n+\\qrrv=W\$g\\r!r(m\\nț-nܫkr:k6.e[_s6-ۘW3nbYo>ܭۏ73nK-Ycm>e{o3q\\ qJ}{78i⹫sE{w8nֹrMzHw8n{qU뜗=vsϫw=\"#\09t0C8vLkS.~,pnitҌۥ(+w<.p:7Lg8\\>*;7HN.ssۧ7A	t.kL.N:t]ӹDuԋ.Not櫫T.odt{V.N?u*{<M9b+Z.VuL⻮w\\.NUi8=k3zu]w`.Nhv1݊Y:Jd.ݒ?vR|˳wf\r(/bdkg\\el˰\$i\0@ivqK&@]&\0ݝkW8]ĜvE͕j\nn]wB5k ]ƻ{s+wpe_>=Y3ٻwnt{ӌn]仏Gj{s7Y.P@vݹw~nҲ_t]Ğx{v(u2Lk^x6l×g\0 Ht{]tVHsGOOx\ru\$:gl^uzX  u\rWnnx뮗]yJT+-ۻyJ,[c/OxFr;wf]yVk.0wի.T< ˷n.Q;x\0=pz&\0v\$;7xV]CczV}Wn\nޚzzTkӗC#w[woG5w}ީ̷'}z e6 psk_]pK]k6Ζ}t9lx[\rl:WWC\0Ou\rsXe0~OA_]2sWCT\rHuX\0Kk']Z\0ض]V{XBu}{f\$xy_JtLjL(Y%[2t7VWgFI!PY]%\nv	*TBZ.Wš):Zf%YUVZ7:VAfh*ClU\\ʅU|ogׄ)\\;{ڵ|okXMĚ7a`\nh\$)or1k_\n{!>{4@\nрDV^K5ReVƥwcp2^05K7a4Wwf-p\na\\ƫWd-!E*_}.-d۪XGɂ8rʲ^0ZJ]7Xp!Tf\rh`͗X|겫+VY\ryk}mmJ1%W>s鷶a1~K۷:Vv+{rdFJ5_0!?*ڬy9ZDo\nPN8[!U筑Yve&`Fo207g,u-KXꇈ!1616Ρj,_CQE{\rچTzL[3k{fBRk ĳr¨d!YnóES'h<fթV\nt`)mlz%Qƣj\$=zii/4[	ŊJj2Z.o<s6E+_wHZ}Ύ0;0-`mޟe#`r<jp٭g6 HP&&\0005q<\\#~	ͥ-3#\$2_`(S\0'8 .Q`pK̇j&0N~a\$*\"Rl0qpP7Ւz\0`3^`}%ۺy`x:\$PUS6x<F`+~=AV\0=6߃{Υu_\"r\0¤lN@(D\rp1+@UF7/Mb.\${C0`L6\$.K;]m@gka`P	w MT6sۻPp6[^p\0/8-N\nl&AE⚺!\$G\n\$#ATL#}v酌Ei0;,,pF,Y@?^[H3ø.JH9_\n*T}HFZpfbajQ 0ڟ t~tXxd;h06EӆlgA-C\r5Oad`'6k\\	x8-FVpabe@ɪoQ0Ef\"B;*nAm*p,;u@a6RqdSL.l=cf,Qf!-g2dͣ&Sw;`iN`v\0\"R va!6eHQOO0>!ݾ4Xb+`{;uwbRȚT;ߎCPV#4)]\r7lcdb|B>ąKHxbď\r@ėlB%,8bYI%Kҍ3Ġ	a/q!q\rh2^&bt\0Q[+8Êpȍ|YN'\0A6aa,x%\$8hAyqnRAM@RqC\"\n}&bwtptvib@Ő|<WBf`?%'tW/dmLObq`H5#]F\r.+*oB8EŨݣ>W~1O+<#\003غ`X\r@00]ypDë`apR[+uP @;:-γ\0f8eclUv0e6\0bܵ=bӇ4х(\$0yG0<d@+#AKo#.H1jPg/QGS5%VҎbt\0NׂTLJܱƉ8JppEmr5`9MC\0_'\$#E!\\a)sې1\0rnqe7\nNt#Yf`@FqLz4Լo%[ZĎ\"gqMIV靿f)<]o!'ʗ@VϦ\0");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6\0\0\0000PLTE\0\0\0+NvYtssuIJ/.C\0\0\0tRNS\0@f\0\0\0	pHYs\0\0\0\0\0\0\0IDAT8ՔN@El϶p6G.\$=>	w5r}z7>P#\$Kj7ݶ?4mt&~3!00^Af0\",*4oEX(*Y	6	PcOW܊mr0~/L\rXj#mjC]Gm\0}ߑuA9X\n8VY+D#iqnKQ8J1Q6Y0`PbQ\\h~>:pSɀGEQ=I{*327\neLB~/R(\$) HQni6J	<-.wɪjVmm?SHvƩ\0^q)]U92,;Ǎ'p!X˃LD.tæ/wR	wdr2Ƥ4[=E5S+c\0\0\0\0IENDB`";}exit;}if($_GET["script"]=="version"){$p=get_temp_dir()."/adminer.version";@unlink($p);$r=file_open_lock($p);if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$cd);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$Nf=null){if(is_string($v)){$Rg=array_search($v,get_translations("en"));if($Rg!==false)$v=$Rg;}$wa=func_get_args();$wa[0]=Lang::$translations[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}function
lang_format($hj,$Nf=null){if(is_array($hj)){$Rg=($Nf==1?0:(LANG=='cs'||LANG=='sk'?($Nf&&$Nf<5?1:2):(LANG=='fr'?(!$Nf?0:1):(LANG=='pl'?($Nf%10>1&&$Nf%10<5&&$Nf/10%10!=1?1:2):(LANG=='sl'?($Nf%100==1?0:($Nf%100==2?1:($Nf%100==3||$Nf%100==4?2:3))):(LANG=='lt'?($Nf%10==1&&$Nf%100!=11?0:($Nf%10>1&&$Nf/10%10!=1?1:2)):(LANG=='lv'?($Nf%10==1&&$Nf%100!=11?0:($Nf?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($Nf%10==1&&$Nf%100!=11?0:($Nf%10>1&&$Nf%10<5&&$Nf/10%10!=1?1:2)):1))))))));$hj=$hj[$Rg];}$hj=str_replace("'",'’',$hj);$wa=func_get_args();array_shift($wa);$od=str_replace("%d","%s",$hj);if($od!=$hj)$wa[0]=format_number($Nf);return
vsprintf($od,$wa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hi'=>'हिन्दी','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(21).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(22)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ja=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$df,PREG_SET_ORDER);foreach($df
as$A)$ja[$A[1]]=(isset($A[3])?$A[3]:1);arsort($ja);foreach($ja
as$y=>$hh){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ja[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$translations;}Lang::$translations=(array)$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
3043401755){Lang::$translations=array();$_SESSION["translations_version"]=LANG.
3043401755;}if(!Lang::$translations){Lang::$translations=get_translations(LANG);$_SESSION["translations"]=Lang::$translations;}function
get_translations($Ke){switch($Ke){case"en":$f="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\r1rNQ<ΰC|~\n\$u\rZhsN(fa(L,7&sL \n'CΗt{:Z\rcG 9\0Qf 4N\0;Nl>\"d0!CDFPVG7Efq\nuJ90ar#uDC,/d\n&sSsu9GHMw=l8-PȂ!z9#dɍ.\"f)jJ\nN,\r:0Cp΂L*<(CX#|SFkzc9!L\r\0#O7txk\nO@(C\"1ÛR;cBġ#\0@`@#B3:xKȬ,}BC ^&#pˮ3|ܻ(ơ6[{?\$X:k+x šV=45#(.\\\n젡*,1-odcxؒKB]#lR⫣-+\\/.0H@;7\\U\\`P:U&:30)4Nx;\nTC\"}:8.9`PL2+-`#cofފ\"`@N|7rݫz^egkdJ9r()ِNkP+3-JѸ(6<o:ƴٱ؄뺺)@8T05lMW0v74-;ky0*զ}oK,dLƼA06Lı?z. ؓ3`3P/02hSw\"|9ξu1{h<ܟ\r#PІLyX\0S8rP\r\n2b\rQ=H5*ú\np)@y<!9STQsW\n\r6JdPIn#}\"Fap82TbR\nIJ)e0%J}PD(q:nyGFQ~D,0b^8e	`!f'NHa[P%`zA=d!S\rd\$0Wi`xb` AhGvJ\0P	B!8LA5.X0B6n:sNMI5dY3l	1(I<C(,\rr@lF\0Ny:`ཌྷ2P@ڱ`|\rb:Zfi\") kctB`NYߴB#ĀDֈD`H]t%Q2XaW	u\$^ȴ*ړ2Bd6dLCl\r\\|¢y1q4)lPEb{&T#G91Y^64duOCDHO36FK#*KFt[y9dfDU¬0g7\$0p=^KA<'\0 A\nX@(LN`{Ri\nNdhO2f<80I#ߑfoU5U9gJj/\\2fhM!K̟ɦBOMIJRlI8xK5\$IIқC2C8h2ZXjMR_L]6%2IzGӜtlD\\%|\nk}ڧ#>.lmz!6IZ+L+Qe	id&	|d0x+!\\rWbIElʺd%v3@ʍ!p]br.0W9Zȉ٫IXʍq:@k*c\nV\\LM\n!ALx	J4)uw@#E\0\n\\d;2-(Q9+ExKPLw`	E]M=huw4̻Dya{Ѻw_\06_iALv:ئܦbQrՅW(Ve[}4ep!f	T{JW[\n	p}{eSBLQdzi\nhlf ^\\WG|!\0gKV!\\\$,+yjg;qA0)r-љS\rWOֻf-`jn-d\\X@@M4\$lݪc; %]g4P|W,nz<{,`7\n|3/l^GBmK3uDV3GmP_O8WOBO^3zkt\nfNyry\ns`~NMy?w1yXmȪ\"V3!2>9Cl뺋dMċU/؆8\0K\nȯgm#XhoϚiɦťł>\n`ne@LL<nϬ#xM\0Dn_/80JI\$h	tcN'f=.	I	\"(@ddhi2aKPj2NXr!aoDJ4븩¾dlro``n0Ppqp񐺒0n\r[dȎ(]Ye\r0k\rpOA0'@WQE.+\$t\nM̴0l?1gтˆ\\\$Cyc\"\n)pi\n)\n;	d\$#Gj^ލ\$Nj\rb6/͑PcXNo\"'{1c	qZ>H/\$^X\rV`o#~6g\rǜ9d2hG\nZ\\8bE͂p;J`ԏwX\$Ri^%pg	8\r2=رB\n9Q-Ҙ5(<Cm#'EV/&Z;KF<Ғ(ŰOZ+Y,!!Xb!r!X^.0i\n,/q+A-pFES0Vm2kQJEt @	3\\f49	6M~\$*X&R 05ʚ@pPo#ITB3v Fh*ƄTk`(Cn\0";break;case"ar":$f="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`jR[-sa_Nvf|I7FS	;918+[x]š'\$g)EAxDt\n\"3?C,̅Jٷdj=v=I ,΢A7i6LS:h4NF~.5/LZuJ-xk莿bĔ*xB4:I(FSR2P7\rnH7(9\r@\";\"{9#,d8/i,PB̚R:6rޞG:\n̟h\\ArٰhA\\0b%\\\"BUm	Plp-\"<Aqp*+DM0bL*%6mT\$hBP6eRB,I+X]5NKZm%fW,IL# DA[1Q1n\0cE#VKY\\sC XнD49Ax^;paX4J3(ux\r*(\r#x|[@U*TM=>SAD%UZ34u`U;%vZ	\$P0Cu%H!RK:,ҮK%n&9e4(JSP2\"0:0\n,LR\\i*0kSԔU\nJJS=UsY@V[֔Z%.6m\r蠃7B&|ͤ&pZos]BS/ES:SV[\\ݶM\\)ߴ\rcZbף{g;95'ėN4}kX˩Hd(VO.7Z1Q;f	 \r9%t%k\"ychAp3 \"sD7Ceet7-6,`TlfpNH/3`ر\rB)lW+\0PT\r)EAif`o 9p8aCF@u;9Pd[fqt%X\r٠6bCQi@VnDK1p*8w/~J%F*>Q\01JĒU6aIi[JEt	\0M/vMVQxкb^+zu\n\"8\"4aa\$6Xtʄ-ua\rl=(BX\\툊3rn:GfP_|bp:P_Â\"T!9l`ѹ:Ԝe_7yDF\$qLy/!Tr@p\04GM#>4uR\$7J /98*rѱ<(7CJ' )*\"-X1SI:\\9a8H%#N1\0׀ (L@!0VgJVtIRcň\$شgdTjmQhMIcl\$*IWϢgИ\"hMI=\npjRɱ0tviCR@XҞ#\"y:8(*2\$\r~Z[Dq/vHMWD\0¡.l<FGq!F@\"\$\\l5Z)l'8H2(<57Y\n=U%|\0uH,&`zP(A֜h*6h_D,*+f%-̉B&\$@\n	8PTB@.uAX갘~,Ar)!Vm2W<-{`L]2w\r]2ɹ'#Xf7UpZ\r%ZCF,ްoselgd+*F%Qj+c+?am \nW;o@>7	!ZwpcHn,ELuyH#Lٔ9Y\"f2>EIl?В6\na=78SAds\naziA07A? Τ ,+ց ;8N\"\r-ÒWC=Hؐ]B^)9g@:)Υx\\\\nd;^ƓO YfJSꛦFc\$YݪP8c\rd!R<ko.QUת	F\">2pVAV\\RQ;/}	B)p`@\")EAa `^YK0ҝSzdubo-\0@(XuHBx],O3el3G6`Mq`ٯ#.v-\$\$@\\&^pOsI\"1)(r/\0nfH\n\"K%BΎV%Ie,(B6\"TP^R440&!%bB`%cx')AVNc1/%ĺzpdLz̀NM&XVIM(*g\0yg7\rop\"I.\rAc\r#cNɴg	%\0002Q-zP&i\$fVKd0:6alNHBx&DńoeRMdm4LQ\\>FA.Qx»&0 J[\r\r\ro-@?BЮ[0ͪ\rsJ+UT!2έݭU0؀G@-xBK1x1dq܁HR'y H@\0V'n`\\톼gOĖvR15)l \"(2brfD&g&&K&~Djj؄~HNIp!@tC<eLP0fsB\\*/+n	1ш1(\r-*B])G<4\n<rOB[+R6\$\$w%'βBТUǂ#'\n2v%.!1@3Pd!Q4q4~ro\$ro5H#.q26(R8eI	\n'B w&|cv21 @R>>\r70ܾB\$(3a5=<3tЏ8vs@ԣkS5B\r?\$>0&;~'2	9%sA7tBS<t/?#CtRP7<jK>B-'AE#/dXB/\0Tf:_FF4z\rtFn.ь[H0%(J3J=V@T)Trg\$j\\tʁCL&G޽SJpθk/Ne+D҇N\n(;Ώ2#:2F@Sch1Zq4>@ɔ3ϮiЋ!+RCI\$]h,޺bp'U6\rV GVZn# ̌\$\0&f\npK\$\r1%t>LP ƢK&\$	\r5gl7GZ\";@P`DUɔSQr@挮a[nkZ2(\nOqATBIy2K2Z+_.BWJBeVKJ`%X(p:8D\0	|XnK%eg{/DxpBG	uChcb\$bCn\$1sjVKIMY\$VSY^6j\$g8vƸ.3dd\"R\"4.\"Ml^+u:@@FCPG\npM6Ɗ	\0@	t\n`";break;case"bg":$f="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9\$+JlYhmrF @#e&a9kG:~drUIzay2ƁѢ^ЦGeS2uJ\\nEW&oI\\qՎ=rBz~̲7Fp0bv%6ڰÈk;\rlJK=/\0X+ĺL=\$\n\r\r63L[ʏ;qlq*oYσhA9sr] ˈƹ\0*X7p@2C9&b :#Px9x+P9ȯ&G\$N\\K菸;=J&;GmZ7t\$IBҲ-S<oSƩ`\"%C ˈ>FRJF̦Yl Ě'm^qskR6YY1>ǔki(S:+^Bf6+2\rH*284c0c9C8@0߲ܻ/:\rx냄p8NSy\r\r0C@:td7*Ҹp_dJ|6U3Jl4px!Z3\0W.t,Q\0i(#鮪N\nE7]o=r#\"\n)5,P0Cv\"0Ʒ({Jk~hs6\"^hH.\ròIYPۅ]G&Zҳ1\rr;}qթH]ܒ\n!31Eg'UjsZ1;vuuݮ֋ ֥5%#>Rzr>/vڄyB\\)F!\$甃;qK@!/ZkA! ̣1M\rBܻBK5DOP~p6p}Mo6U1'8G1!+D\0d	IwXPOilP!C[q1X@b9%CV\0m36iuq,=)8CSjG0|ڈf\r!IY4X _JJ>Ca	])a,\$<FzY(G`tNuM)UU0w%y#?Fk1rS\r28EF\"=r-5MNXϑ yL\\ieА.+lͷFE; N39脎v)yg1A@OUG䟔\$R4^N')'*S#L@E@I1#2vRk/f,͚pΙ>L2:5|[i3re*Uf>\$N^xX\n',,\\RK0HgFԨ\\*UL̩2`̃4f	&vY佗y4hґȉ1Tng# @1Oic^bi/@-ScM\\TQJ=4\rU֢CHl\r1)m80i}N	aa:0<b`1U+P 4&>dox%,m_@P/2u\0(+`쩘\n}:Y/oc4kC=c2J\0Pg9)l\"G^>&f%FsM*U%+Cc8&*Hc\r&Qj8c2,2%,ChZ1\"8X<t\"4{,q	UI'Ps:zW	Л:v'2洝Ӟ.S#O^VJ^u\n*؞;B5q嘘\rQޟٴla|(zfDJgd{.th8AFgnhQMK-0B<*H>'қ,b.;ܧsн*\"hSUޛI!FDAX.UTU/j`fZ)t3ScZ\rz!F,h2a60,\rOHJPwsvƞl^HNxƪN,ZCg״861D_8\n{^P;UKIˀ.zNvo:)ٺZ]sˤfޒw\\m{;+\\p3)1p3r*ޥP\nF+|:d81(ukxaFژ(J_v AM.\"uz1yPV7lAFx@yp	4grө:oÌzBB	f\0\r\nl2m(;\$2E(c><\$XFlxrJڥ*0nkQO72}ĈLvoAb``\rb\ncLKcT@'9!B6z0HR#R4@.@(RkG}:t+uqU-܇rl(2\0 \n`\0\r%qTLMDeb&\"HځG.r^\0rLrgDD^\$,6O1lQ@(PJx\rA\rܭ#Us-A)p?\\2n/)19/fr[dVB3qqѤܑ2V6'\"v[hf7[A<,x(oYNQ#.TO \$&*07Ɇ12ˮK\rL'i\\l\"1VGAg6:(К>ﮬD&Pk1Ft~߭lfģbH(+V1ߏ\"\"),tgX\rX=#+BpZ2(8S-R·\r1#1R(InZB0Y1@͌YwS0x(\0V42\\pÒB6ʌdrں-w#5l|Ѓ(~O>]2\n]#~mbABBW\\~>Lf.\\I0Xr0gVq+>c棔ষ01Sh\$524m/92ӧs\"?+?+q0BI+!2^D+0E0]C+0#)>tq&83\nEE(!L?]\"huDG1GoyIGIAIu\"(U@0)1|\\_CBb;c[\nmoK	GGG4C1FTv+CHJvHdaKTlK>6M@w:gsRðW ,*3T	Ft+i!zc 2P-r2d*\\Vp	hR\\Ҋ0UUMNC-\r'A?TIE\"ʚ[ePyBck3TWF1*oPLȀs?uNq]K^751>_\"9NOYhaV]abb26~s#{z\$@@pJ*\"ot1uNp_#fȫK[vO\$16gaaagi.\\yPyxnAI6]	\"֪T'E%lrgFf7o.\"BHZhZYm\$COug?uwol4ZBVb96{hhǽirI!v3q6wAp)7-c71_+S?u+c\\q2tvkhjRmOalse\0֩cPz_by0yjlLyQ\nypz`%p%_que?]	[!{/~wa];j~aQx˛]4|3c6QNZ҈VNW55Ӏ7| K2\"nr-L:mCVtIDG\n\n-B1؅.ֻ;BɈ:2rG*ZP|ps@y`t8C:Ɍufi\rV-c#H4^;mu Rb*T1\\\0\np).qWcqUҌ]:!B,<y/x%E֯*JIjU ~'Zr)yT+G6(/YfW+3kWaTQ~!,l<p9FcI\0VuU>FːW19Y:4NQ3	/yo؛5X:m\$+!:#VF\\Αl7esT͙v3COрV2=ssWNkɺonH8'0)H!:H|٤pڳe0#ouM(zcoM-hT4ruDS\\xĨbU\"vVcQ\rް Ò";break;case"bn":$f="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHWβt|,G8rgu\$)k2~\n\$g#)eӫf\nVUN(]>uL]	q:jtZut*#w=vp=L˨\r?JtH;:B6cz*\n(:O-*X#ps{BPB/j{BZ-INJGED!QY\$IMV.<SPw@H<ٗxm^&Hۼ4Ě6ش|/\"AjU<#'˒*Io>)2,p,6IQI4ϻAQU8\$XGKp\n[+l\\OjxIH<OJK,ƒ9uhCVx3x+u	,7b5VIuk\\9\\;MSB/vBK[ܻe>SzAT\n4Қ\$[cBa*Adި7	F4dNucD{Dݑvbn)uhPqSI.N2Yg:\n-A-}P# 4(`Vch<i\n|.oCfs X@480z\r8a^\\0\rp^88ØΌxDȌ=G5xf:EZAh1\nj7ӿ3?/8ZA:DdVT1&ˋ]9U&QD50J2}8O?[K{\\PDJ&Ҍ({/}'1Tہ+*|\"FHq|=P\"OE\\%(~t'	Zk]	Pػ.f f	dOl,@Brt@[l|)¨8\r\0	Ne*}ނc\0B`-J1X\"ƊARM*9(2nHt3iޢ,z˵EbM<|{N/4O\$JeXOXZ2Ddlr>Б>Eli͜4F}VeA:+U\rf!Y<>>Ny'R/wcVRJƓ!sGQ-I)e\rʍٺnqX=)s헟U\\ZKzi|]ph2i'2㒷I#n\\S]5HYG0e-:<	cRސ_n4%St6b/_\\4\\)o+4@jaoRJ\$ÙVdI\rUc9հ\\誉B7+kYf.-k}:gFsd\"\rM]䩸7\nKq=ȹ7*ܻq:Dxn!4ۗTJHR(LioRuܾYQ]HuPUvx4O|%[t_WM.vCy\0iPװD;N+q99'(ŔsnuϺ@v:p\n/5LKqi+Q]+ni\$,5}Yh&=g6&)?5=\\xwJ%Y>A8-5̗y\0Hȡ'WX0ۖ,]H\n/COiK?! PYMg>R6LR>˦=A[,é5r49^ʣϓΔ`Q|tcW+s\\1뿖S~ws*GNT\np@RqF&N\niSd;Ǜ;yjcj#\n?PfO'2!Ar&GW.էWV^ZOcܤ3&{n\n,\\\"⛠鴲nj;\$;\nPÈAb`v/;ȭATh \n<)B6)6\rì\rMAz\"K#Q4XїSK\$@b\n#Dcԣl@ߨp |o9[/PRQ+#R^fű_,5`goe@CzK3,Z'?'UBZA&N̽,OBn?.ȘC\"ClޫWm(z|NҮIgD\$)JSn]|\nb)ie>tZ/<]\r>_.zie#e2<2\"k.\"Ύ̼fzثHx/>#bPcJwŐ'CxM%N4]J>Dm>BC M)f.E1K@j.c@e)jΏ8ial(lȰ,ϼݤfEͤ`7#z(ZdTS\0TB+kF*ێI܄DkM.AˇCtL#j/(n\0eDG\0+nad0~&>cz(e,i2񚓨\\+-p^_EB/\\tl}܌,YTJ0A\r\r,B\0(\$d)Uc~kH2ZFRf\\O \n`6olvddcpe@'OZmjP6A(:ZfnP|\$dLk:>))QxJ/A\r+ \0=b1)РҨW,+B+%2a/,p2J4dFF|\0idP&TNr2nO2RhGRl)?5,3c3.sY)2eQʩ\"EB0.Ĥth7ӛ#*?\$f~`\nNToZsօGCeDg>I|CN1\"Ӭeڔ%>gQVЄ\"01so4Ss\"n}\"'#DZ3	C2CtT>}kC>nPM)CE:BB<CE4wt{Iة<+Hp-Ctx)*1ұI>&t*/\$T	ZO(FfE\"P72ԃzNPdvHIlhuNh\\4릾/\n4a5'7P.J'<jQS\$5CJt%د4`  LI\"@iBG5HIsHqS1IP̰Nč9GRGVVEJiSR{K0UVFMEL74sWWȎu̔[/f9GS^	޹7eZ\\pԗtl?5RuCi:ø]M#C/raaRHa\\UaҖbbQ+/2v3J6_1TP+d4ZKfdoE[|a6i7UZOcV_)L>Z'd5lZu[uj+!~rVDv&,J΍k\$^1&x߯{k`І/zPE숎:^g2nk܃bj5JFI\\N{;MWRr TKZt.fh{rAJiuH7b{jK#(wpg]wDjn/+_\"5'w*I{Pz׊uy7a-o@|7Zbu=n/lFN0dVK0ir7zqBDdyteyuzsj>z,}[џ|`.\$j7I/x3+hbZt#;I0o8_I6P^8ZxM+\0MظlG6Bv<j(0XOm~JvI{C9%&mbG|d{iCAWs}u{xQ^̱X2W츲/^'U85q	M';^ݑ\ruxctg\$DVӒ1/9x7[Gd~dy/2G=sa:Fx)]Uw99+y|9gdۚ˚YEj#ٷheH1ux#8}\$\\2UF)㹑vyxSDI\r#RKُFR9eY0'H*W8DVI3dlSds*c<PhYQse6jyy4ץ0fo:[Q:^*C{\$\ryk*ElvoF:g@r' ϧKg{.{PվiL&`nsxi# \npf_p8#ϤeZzK\\#oN6~yUGQb)bdR)4JJIҩKs٭]{ԒmAU\$_\0ZuXzԹtnE Ɣp#l픏`Jv\riv̀j:ߣ@'D\n+Hf0~|bqstRe%J2yq/`Y|ݾIu*#6-ٍK;B-]v5KMʾV-`[#\n\\	'kB7xwgZgtU6 ka=L;UB(VAW@\n[ͥ?5R|EE\\\rnTGM\$p6<=hmC<JI1+M0tmb<eǓds8\"Vv-(\rSfɄ0R+bJ@";break;case"bs":$f="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4(o9Nqi :igcH* A\"PCIrDqe0	>m7ݤSqA9!PtBaX.	B2w1{=biTe:Eo;i&a1l2̧;F8pȐ3c{1cMYd2wT/cg̒d9\r;P1,&)BM5Қ֍[;\09K(7n\"9X:8;\"@&H\rprҹht*7:8\n0rO㈦)ʃ? :k8찡mx*\"jk>/x&)|0B87㤱4\nk\$6кJ9A\nƚ-	Zpl4\n{s-Ir R9%Qq*#i%4P鷕\$R9qhXHпD49Ax^;فpL\\{TX9xDB26H7x\$MҬ2[*Tl0:r:24#S2Xp++T^5NBdrM\$hc-Pk^7H:m)H26E\rb^M\$.ì\"1o\0KF4CJ<&=7(p:sM\"s@:ߩʌR^5NZnhj6CbiB(؄X薬 R6q}5x0	t\$2 sQC`)A%=t۲Vyh#H-#)ZMG.+Ӆ+pviʀumx0\n5d007mސW\0u˫#NC,F?@X1:@C\rʥu2@i	ݛ:CxfФV̥o1ˠ73êUNMи0\0:g0RH\0nI\0T7D.e8FP S\niCIS,2YK0;堦֘rZ\\ۓҺ>\0@c-JCYWjR'2`Y%unVT\\+DcV|\\Q9Ld|9C7&ЏkHR`tE倇b:,\$9 f9.(cVA62ⱯG3%8ax\0h0@_\r&v3DmR		Hi\r\0(JI)\0#VJi!\$J*P㜙<;9}VN@ 	ܦca.usʧ\\C\$G:&j:Ĝ2cN034Ds#1Ӥ:Z#5(JYD[YDfwO-āxCc\n\"T13_Èu9h3!g֊:f2!gb9Uؿ4YO\naQ{:ks!R\0k<ĵHC1WZ2u`]B`7X \nn@?\n[	HF\n]'Lh9's4%FԈv!Wy\0U\n @B&2KD\r\n `@(L[a,X䙈m)/SdRSj-_JyMVIhPMzS!yUV dJ-=lT2w\$ӄ%\$<c*j\rptN:3Z p9#U>_6Ն_wSH	M\0:,s{Eh!U#f4!MK^E 'nx!	LK:bڠV}/q!{A75@%qۮ<F3.46f;l,9<jh/xHin?uΰb0OH\0؎b\r%B<mM_w Yq6y.0xẅ<\$T9{#e:CjX9\$Ef\n!AhZz!iN[K)ޜf8/\0)fVmdaً8.&猕ʻ괼V'Rp	\n~CW	UنԏMٹ;w]w7=׷p3H\rpP͞	\$v؍_e}Iv~/xz%>'?H_2)\$vH\rP@ICB382eIWAj\$kgL,/V1\rӀa? P>X J ԉ΄!#NC\0\0&&+R|c [/n-έM4RѢ`4qOv0NƬnHD?\r@R'G\0B˦-\"C V	qn?\"/?zx &\n\\M\0\rݠN-О]e\n+QpIҷd1/\r70LJ&N\$%AV Z1OI@Vy% l`QT'\"19O*v\",1l1;Bc%~noNN.\0L	pL1&Z߂d!\$czl\"<1\"-Q_^'&`fBS-K%\"oP7*!+\"\0Ԅ1\"SCL{&5FMG%\$)leO1?Dɦ1&)\$&aQ3yrx<SqyRw'd1`>f6mRj/(Rz\"l6+ r,YȤG]O-9Q).QqjF\"f8T`nZϣȆ0S0.J7\"4R%:\ntx=қ/\"\"ǣ*5i?A3r\"A5C3bhp\r-8n*7Y&#\\9J:Α8C:@ʵ\0⓲Į?fš#4\"0P//ss0>3\"5F\"ᐦ5d)mB-@&@FS7\0	/|	x{2B\"\rxF&\0'xW0Z_E (f`8fB;Nc0p)t\0fMi@r\$s2ZlQ#DP4\nZ@/F>nqzT\"3O1KOFJv|7|u`\r`Ъ)-A4#z?E84IO̟\r\r\rU\"oUdB?4p\rMntfR#GL\"u\$C\"XeUYMrP;lm5T@!5X)rN'h!N{	N̆o1 wȢs *N<Dx8pPκ\0x2̶sb&m+&Tz6J5u9QF.P`P>!o5_Nݣ\nCD\n) ";break;case"ca":$f="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(i8hTC`uADZs2Χ!c9L7)I&ZMQ)B>MΒc:N!i3M`(Q4D9pEΦ\r\$0߯Q5M]YbscL<7N	]WcEY!,\nNxmoF[7n絆^4C8)llމ-ޙB26#r*Z;93(0h7\n;hH;\"H)KS`@:pNȏ\n4\niŪCJ810((<܈hBDB0<7\"8> )NN97jk>rlr!D3 H4cJN ap=<4Jj0#\"ST1<R7t(ElQ:#IČ ]rQ2GN40#0z\r8a^\\U\\|(]2\r dɡ^0Ѻ62t̚ҀPQr0NC08;n52N60߉N*N_+z @1*DѬBDNK0.M\\z\\̌o0q[7əOX3IPi\\\$6/ގ\r`ߦ\\ܧCv7'OaMV&I:85fPZ،/\rV20!\0(P.j#8=*\"WX*V202;ڎ9ɕ%N]lMP 4SD8P3@Ԫ\"\\w~r\"]ܸ4(B{ÎPPDPa+~G\rx)I+9RL4nYRJ!4T((lN(0DxfQTRnj3*LkPOcfy?(;\"	LW\0\n)pd*2P-H*8Id茬VVZems\$ks^HF`y\$iH&ИT#\0TsjU#+R&L\n6hU[Kqo.	Ò\\%B98p!l+.0:\"đ2lF\"Z*\nmGEJLhKH@a0D',i&̸0iT\"!\$%4'KTd5Jb3|jeLHDJP	A>FAF%\r+.x]3i#4λ.W	+hD[o(\r%<\rؗ!FA\"^e\nIw\rť,\\Hc\r-V^D*j2BS\nATASp tu#n	\n2m~Ii/&*H!h䜣@@˥)wvP	CIOQ0aםT \"IJ;ҮD4[6ũdb3&n\$ʥ92yW9@O *REPˉ=h3Z:y#Q4&5RAa1)9\0\0U\n @氀D0\"ekogL-R8C.Jpk b~@у'\n>x{KRtWj)XĎ\$>5vI)u!M3v2u%!@(+,\n\nĉO3\naKl*\$JQ)\$(\0007C.I._n}MwPF8iMUD՘U5:g1(*.TIj#\$TCQT@@u(wΏir\0#[  IԱPEER+]lp僓l!.e0Gz0\03}Ohnn!auM9B@̙\n0T!\$lg/\nRP@7b9(XTnY/\0)?Y.|F_cH20!SR>3Pꃠ.0+f@:+knҺLTl0M&e;\"/=K~:;hUGzi;#xML&61|hDȮn<qnr)HWIaJj/!%\$H@0sIq@2-|B\nIVdm\\oB) bWNThLUaK406>R?GO/z]0^..5s\06AAcr^)Pn@(I2l3@6/;Pi@S΄\n1TĢ&pZS\n-(mDm\r'Bg-`O@U-\r\0hrghRp>qуk0poL\0ԩe4Ebv,boL\rpNE)xz&P-	oow\n;c\0a24nc/ \$Mq+ˏl5%Q\04Za\rQ^b3@cTu\$i,)^^30G9FHlÂ5Lq,ʤ\nO1@٧Q4m8QP:Xgd\000125d/Omّ%9!	NGtcqU'0RВ7!arB'U\$5\"#R6hLr#\\xOlD#1!q\"zG\rO2S\$8ǰrvv6推2T䲰\\>qi'!zxzʑ\$P-zE(.2SM(.IE+*S/2Q-R2|bw2-}29vsVo34JcHSR޳V5Fu3R/#-ʯڞC4L=\$sDC)R 89,..\n[%;#&-/Q<.Nә\$s=\00jg@UkmɭdFbVfNGD@Wb!InFxfvb.4vb;(\n?8KBeJUHKb䠆NkhS~䦦038\$yg쵉@\npHp6{|xc~tC{_I.IdǾ,/k+S\$y6lPU,BCHMCh,8c2+VjCI9m`es+H\nhgV6,hbKpwf5`c@C*iO\r.3Ip5@<5Es<S	55;42%-F<6c5Rf`Nu[U&5bK\nGq\"!\np{\nuaPbF1BjnFt5nHLgTUFBBr.&\rSaE>I6v^>QTD F	P%eh`eV	\0@	t\n`";break;case"cs":$f="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8Ua:Nf@t< ya;Qhybƨ9:-P2l= bqa27GɌ1Wa1M̈vNBɲ:[t7Ie!;ɲZ-SDκfUFcga;da1l^ߐB͘e64\$\nch=-\0P#[h<KfIcD 0B\"##&7!R(\02hD(IX6n5-*#7(c@,2a)ڨʑbY T=&Ə#0)02X1P4@))J(62cz 9&۬H	b!+CC2h4@s(@0!Ԣ2o2\rD!#\$O'%ZF#H@1W*\0x\"(C@:t㽤5ET8^1ax.c@21ElM2Ai`x!D+.#\rrj\nx6cs-XaXc!42r0,QB%v0\0NS]Y`8*. P9cFLB2h^8RY!L|YH:\\ɤxL5~CX\"&+4ڭ3Z9D&\$o\"<f~R#S%<-d(2d#7#dٵC{n8^_B=>].-'#aIv#GgvEL\r[z;A\r\"9/@3lD5*Jx:>BHb(AD#xywҪj8@6az'H4pL9h(Had%dHG̩G(=ZCU)-\$tCm.azDxf 7\nEˊr`_\rDdN+RjURłr9:\ndzyzG4\0K\"95\r*&\"b1TExD]}#2u\rlfVQ\$y_pQPbQ0TP/!&ݝ:jFxğêXhujZ+Mj7W1W(>T9 dT52`R,R#C`aX3-J%rIr1BI4_8C'pY!ᛥRN\\\$Y)f,場ZȒ_THnarw	t\r6hA'QC(<0ZyObMDJsa?֮ڜ2RD\\Bv5H bfMPBXU2.pgbd,5Dh%4B@A̤oVLj':5e\0kaUL@PQJ/RD\$51N)v,<2z pIvf!µU\"(jWl'b4\rD5/C TR\"isIS-񸙂\0F2dWprPL3B!\$Dbz.j\$5r_O*ɕ\0\n_ēBvPj形ȵKDUp%rלF\"ضOLCazd!75h(j*DrJt EgCp6\\CKO`N`M䊑r3Nkj*XIkp,	C\r!_[1&,Etaa\nH lciQv%̒W	&!eءΰ9:F bqi~I8	ǉJuv+D!X`0cZfW/۾ϐSWV3upm(\n^X+_\rlPB\rS\r\rxbbhɍ\0T;rrN!'sfڐ^;a馣3B\"Af[@Ĉs]LdF(!h2jsi<iV*hϚ#h/!-.|sa-?4)Ɏv\$?^tcO}:\0D)̵!z\0PF]]F56,&Pf\nP 0S2zziP5뇦&yVe򑷆f=!FqZibQ>s,u>C#/w	)JRnEeYC/#|d9EMdk97Yx_t)^>WԝN^/gIBL:.oR#oHH\0b`̤P&&)l۩YhLI S/6(τ2BN0`*tom(Q	:m =7^.<G<(dl1d9\nDB#ȃD\0*EcB~а&ú&pG#\n<v`mzaPOwEc}MJ<,j@jf&.(\nFr@&Q8{(.qDC!QTk'8.nv*ab]& زlg-lg'QbP%JjMo\r.QļԣPpq/\$;P}f\"#pbP1ܫB\nq.A'yL{\$2 9zb-9\r&2\"1w\"O|um2#!\$No\"bl#x'~ha(آf\0*y\"t&%Z'ʮ%c.\0X\"*q-JЦv>',BZ6mxy@.&`Ʈ*=R'.&Lr\nn\0g|a&(93[*Q*\nt{IR,G!c7Sg|\rOv3r\"_ʇ6Cf.0DhdHg!|{&\r(FAP)![66Vyq\r)c#5qŎy>3,b#gbs6z?5c='g--G&e=R6(z/>8CmCg]?%3B>Tw%EShk4k g\"sӌh4Z6F)Cm>\"E:ο=KHGm?~\$ITi=sDgKAQLW)T5vMEH&N@J\$7Po-q(M),D\\P5T?Fl\rNS<XJ2p\"udK60SǛT	RL5<\"5T9UD3/{UY'@\"A&^q8CUa7<8,xp\rU'#2/Y`qY5u%r``c'Fʃc|'e`42'8IS1(,-fj\np2&5\r%{M#Tam\$'BU! _GPEGhCC@gp7\0^o-ڋlnkJL#nG3Ga\nJrSL.@E2ڬ2\"Ev?'1N9\$I#?br1sa@Ԩ5%J1vV҃LRKvl{'0bVlǜ僜F_d>Sd35B5p'Svms	Bg\0&*,z\rBtXz7p=Bԍv@\"pd.b6flNԍ:3-NMLu1R\r8Ӣ'`nWem'a*\rhVKb\nD";break;case"da":$f="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9GS<y8MDYCQ\$cf2 )RN17&sIl36Me#)bl51#lg6rY&331@a\rI-	rɺ6G2A]	!τĝ4z]Nw?t\"3ob)t3˭YESq7\nn5P2˒2\r(?戎@8.CČڴ61ij(0ɢn.1	9@\0:0\ncdGs;I[70\"*3)y;\r0ދCBcBnءCs(2\rjAЀ	B1pr@741AA\04@:c/c44&C0z\r\r9Ax^;r+>Mk3\0_p8I|6([31-L7^0ج\rBHè:C8n+WʅH;@P0Lh΂ @1^C(~\n\n%蛐\n=*G\r1˃@(0c;1㬓i֨#!f>\"7c}H{4H*7IXjCJaZ̖\$6C\$H:J&ah1R &\\:AI\n̮r8]6][ P[0PJj9\0]\nTK\\D7&E6£U:om*(	MQXME	<ւ7af#=2F023>[_a(r(/>dQK(3ں6*\r<DQC6Bj#?	yZ)\n)|0JPt#aP4\">v	uQg]=Bn\$X* @U!U^U\\^rˇDIK^/2uܚ\$_f\r&FFM3T8JC/)B,2UJW+\0:=@	.p̞MJ'v&\n2	R,`rNJ%(A+n=_}7l'_.L޿K^}\0J\nRV6dB\$=PkI3:'AR,aa-%݂\0-iPNLO7Qشȕ蒣\\He+ѠM@tPZ9	B\$YH@pQ/1J`WupChv&-T925sR:PbТ&/lP#\$#*o13f2ޗ!2*,&'Dl\$0ֆUL&D*JyAdL\nI@'0Oެ4fQ\$6 qZ\$62E4HZ b͑x\"DRkZc4PH14I--KքbdC!\0~牻8	8PT@-L):Ds2,B?WS\$z1yPWIeahgsNHVlNDHH4VMdս7fIpDž'ʮO-v8g.3عCYmdT6ABN;WFsiI%oѦ8?*gPl+\n1Ա#!'R\\Dm.sVua4-87Stb<	de\0d4rI\nd3բWS.GPC.\$R˩aȥi<Iua2:Jf\0SbP\0ƥ#8ek'e s+]0b?%@@ 7e@Z	*C2}idVwbFk5B05a1i``xKTՐ.`hr!h7<{R/	u\${\r&~W-Zp])߁\0F\\iI`AI/6ѕb	rWʥv]g9&\$P FܦAm B'[A!	yҲ'~HR/t#A8lB}H\rtfRrp\rbo2K*pdJO.yt-)I>\${/]\n(agq,\nT<<+PjI\$'^RB+/4|L;:N4=8%GW6_a_umNpO6/ƎG\$Vs(5.,2\r.&*5\0˜#:o\nRXAP`DgP[\0\r(<*lRꨔd=8TXc|c 0v-.\r@<P T&D7(BG0rnЈ\\0nd֠?Ř^]0\r \r\0o-\0^.\"f0\rozh7Ix21t\rNEĈbcCL	[,Зh\\fHG=/6qрG\0JQJ>X3\\YQ\"#8\\<aĈ(g'у:rLQ\0]n)qaϻ>aQ#qJRK	D28,-!_!;\" ʚD(/! hcC#p`\nr/Mb1d%i& nĬdyC'tdP?&\0CͦHk>Lal>j0PB'G\\5bJ#% +^۠/0naLZr3.z -i-e/薎N6'1>d\rV\rdI!Ь3P8ʐeb~('X˺\n\nxCL#nގ)Btn^56kkb-%#'&kVVC)C9D! 78!\$a2㈢)Ű4,&c	f!pd,k+M6&̻8Sg>^O/=?b?l_>R@0L6\$Hr\r@Chq\" ƴ캠Pcp/?EfJ<%Bcot.1,@#430b>Ll\rF\"oL,K@42%0	&`H@!@";break;case"de":$f="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9S]\r3jPpv >9M(n1\$\$NқbqX8@a1Gc\\Z\n'X(7[sSa\$NF(X\n\"ڌ5MR\r6e]ͤ<#(@dDM^|z:gCܮvܧDSuﵗ6-l\"䇾*,7m+\râ50 P:c.\"\rc\n\"26J:2<T5q`䠷*A\0D,c>!?ɛh{,?KJB02lr!(H-1#nlrM6s:?DR@P25B87D216Ip,2<c-9B`3@U3MC	66OGcz=(Hj-3 cꁺ?\rCS!H*\n.[3:t!S8^ㅚxD('/31Ȓ|ƬA2:C:R̛.h+B;%&7C(C*=Bd7>JC,aj {;D-ÃMBPe,xZl:cKW?(H҂7AH\$ϣ4hΜ:+5/p1&\02mS1b+\r\03B:\r;lz7D#8Px3f.5r(hEC ߽p(\r4c9]ۯ}];=c*T:N729?ZۈnSTCűG<{!»r[Z+!.]k6Aj^@@ P؁a\0#`ӆ؀ee`P:Y0m;=ҠoIA\\eQ'T\\RGc.H̼P@\0lV\$ %\no<08l\riQ*@Bm3Oon<O{9	BA--D6M'OjhԐ#\0rPz3?daZ9\"1v'9^\"r:]\"A|1\$E\\VHߺ^l-WRuA%!4p!g\$8 \"?&`4tԖC/%\"ؓ U:1s2kߋQkKEâ[qY|JÐ1{f') 4C3Ik.ȕ6҄x*n+Dx/&78(BXHa40Jw2KwZr8ؠ!w<paͪQ͙\$AϚub!aaJN77~>2֛֘]Z((z\"\"ʨ,2iB5\$4Emr`Lc7UrW	02&	j7.ծ5<֛/\0axA\",IS\nA-CE2O2-SɊ{!%FزTJ#XDSK!.x٢C4KA:/i`+ʌQ09\r[9aCJ!Xy\n0'@TjZPNy<JMIG'\$FC+AgTH0!j>ώ19vt\nF0T\n.8e\"+kɪ,n_\$LJolhf՚\0qD!P\"bhB`Eч¡S֗'5\$46irqJ 'BAj<4n!(T*Qј쑴lC',{LNL3\\ۅ	YBALt1YDu߶*)?\nDCղ'.qɠ^|_pd\"uR)\rXC+!DY\nlt0mn!({[iu7ܴBÏ\"1Լ&:/	R/clsӻWUXPٰg/4	K^Mm7MgRSԜ:ެ.%bʉd 0eilRz6Tf'vm Aa!.Z~_ZWungr\$IL<|g Rue'-I`Fo\\YQeJ2 O=bޔ?e=fr)`C8mw/Ig1ٜoB8}_@}#hp%,΅\$RC\nP̭KMCn,B0\$`8\"	 ^gZo 'GU0?cf?8fV\0؂|T*F6ςPi:)vVJjn-O>t1	\"%nI\n\nPoG's\n0>\nsĝB؝lqjb#\"<q~Gp!<M%L6Pm:PYL⎆\r-0KZh\$<?R}o&DqpQ\0\"CMG\n,B1Y9U\rv[QcP#&3Lwp7NOg5	Q%CXb\nG1ŗKğτ6F1yϟ'꧌@\n%w\n\nq	n1xr\$dZ\0ETҪS,\"\$Ԋ\$\"2ÄJ  P:~465;e)Ho(||-&@\$K@\$\r&hr|Nf6<2q\$d?,r|%,?-B,uǱ-0\npz.qF3z.\"r.Sg/B@\"fd>o},p3CIIj\"20NMNwF8,6Il6sڭ2?7\n-<~H	NfgzP}/gtR'!ӣ3S;!r93p3hds:8;Y%\n5C	7s8ƀrқI`?1gS5K\nqy@4<nn QqBI,.B#>Q\n?3D/0bN\n70\n,OR',`R;55EYFA`0?4\nIg3l_\rLIubJ44Ȥo&r4p6?r9Y= a`S<60^Ę#R\\~\np	J5Hyq[\0ԩc!\${3 \r#<\$.C1n#O\$Fc,͗NuUL#ObH	6IƴQB!?\05P\"=LB\\S05ľ^0(0*C\"w9-CJ5)ZB\0ȑ@[p!1aл,fzb|H5@V-''Kȅσ*I8\r8ԵͬsbbVQ:EBⶈ`[v8'l3f.+g.'N7\0!'4P6xb*؀6Wd5\"";break;case"el":$f="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqnFWBWPckx2V'\\Is4ADqe0̶3/tfOj,Q#rDIjI\rQe^DAJuC\"\nΕӗMs7>|w2U:RJ.(E,Z7O\" (b<K42LNpR8:8<,rZ\$39q!j|RbʒZ\rCMrGnS1˔>̂j ĚdڨQo(!r{Lqvg%|<B5x7(9\rl\"#15-X7AD 8B85#H9@)/=k%\rsA.	Y(	\\JZȳ.bڭnZjvĺϢ庞Xs>N14h2\n!Nvi8Vk|23BdX]HgNSŢJ2q0Ċ0N}RIȴAx^)b38☇WQF\$ h7Q7N}B9u(P#Nzx:+K!\04@:P9U`X(ӌD49Ax^;pæp]Hx79xDm\"5\"6ңH7x<]}`8H1AtP`WA}!-ܢ×Qx+.j\\0gw_'ϭb9\r\n\0<(}߅;	0׈Ìrav	_uP'-dqA(μpE?8A7bϹihEt1\$PxfNR !)&6pHF)7P2\$#Oʽ픒R	:9(ꛢ+bgQV;L ѡ-jlU\nG91EʬI\0#\$P\0b1,Br*Pdl	,z\0#\$E(@h5:&С\n#B`vx.;-cZ%#bJ\rI'\$R]#+&;,HA#u, \n,6P[˜4:ȣ8r!Ժm8C>n39C,ư4XHsR͵\"CuzͰnl.#.(\n\r92w:T3f2AgY@gE*iOCk5P?oU,<(4ˁ<gISa33mA*LLI:vUFkUj1vSuOx5J)jFEgH*;\nFbߥڃKLjCɰT\rCDl@4c25eo7\nK99'(HttPCpgEKMQHXvK\nWzw\r6\$A-ĔJek7pN8eqȹ7%Dr6¤#H+b٬*K\r\nIxJCH䎇̑_E1٥*Qb.88%\$ٺ=8űuZyN/lh5mv:vC`l}Ƭ8(>C+!כ\0fH6?[m\r,\r6Yrw0*3\"S.bxs\$_>G>ڮbhԖբH\n\0@RM^L4U&75\0pNk\r9(g-S)ZQQYe֬VDXV<\$\0*(@(sU\r~~ٷCpnJUHc\rr{8Vp3x2xVN2cRg0BLDu?!v,┺RZ=*\$Id:)Z?H4!Ey-V7m>rz5Zp;Tȣ%dL[{'BFCITu:Xj.	j\$K-h;(¬ZE\n<)N'cX)c3\0S/x s3ґBAe<\\ l.8rs&/a'\rC'\\Ffj0H0Tic!^	RDC,^Փ\"p\\dA`}Y9XVQtyrAȱ8\\tGBf4#Fub8L*DDl}10ed		ݞfNTTŋJj@v'wg\$GJ!bfVHcz8n@IIJ4L]9͎2ᜄn\"*2䮔\"MJNįV]E*uvGiI\$\")HnWȮ)L!5簼@&<%322JtOXM*\r45vf|JO#\$ y@\"JN	L\rtedȚ'JI\"(J)ピu<&\0rN	qmv\0΢@l&-I0ͧ>7,n\"p?\nOw܃e^|eHMj<R\0`Ǡ8zie\$lԘea11qpFD=E`Hd*@@\rb\ncNRV@<F\$8h!\0<,	#%mv}\n*!Hª#ki,|ȇOƘVňd( \n`\0.j5e@TEHT͈ghVܣ6	~^	},?~rZHw*\"\\O{X`πJ-4	%/pGB+)+%=2Pb.B.bڦb@\nZmBǊ[\nYL^҂b0C,d\$R0D&~c001X5i&b+5D)c.{-j>-\$F^I)&S\$?\n8GzJ+pMmsހź+ԫkc/m@S*zZf-:!3-(2RR{pN!(CP-@0A34~_Ϛ\"\\\\,Hh))EGNY=/0]Fb8n^'7\$FkG+GQ<9C\"&fTt.vGTyI, NdcI ?JJG&HLLo؎?KI Ȃ6##1CYeR\05~h\"S\rx/p\"IC1ȯ6eb)CEysLPz@`&N@\rR&\r \rP\"&XظtZ\\e47d	.ΕY5YMI>ZOTCFQu*XXkMū\\Ζ.	TdU[TTY2ӏ>ISa\0S#()_	/T/m``υ50b4l#+lW2,r-H1HE(vXefB'_UBGbVs*/|8zLv~6gM0&t^LޣOEG2Q'0'\0LZ66E\"ξtT~\nŃbT\0/U5:ъP2n~G)bf\rIo\r@(3wiLqcpf#VyqCiufq#g!	abi\0Ȝv=`z{'@z\$9LjlvGfiJvZMuhЊc6'Sv1xc:!<T]uzA7lWgPL{\nOjyW]Q)}<cɍy5ab-zs?)#FFF8\n7>Y)3~dz2(?[`YrtKywc8:k_̈́iV#v^^W{S=EzkJtP#0P\n,ăHhF7l)H8vg]lPR8UGnGMn{UxUGfyXUMtdk.O\\7qj\\!\$xݏFyϐw͊n'Jx?{xwTˋ+})s5ɓֶRg&jUʥ[+6Sjά)qyeـQ YsUa|M]6m{/G㏴y(ydYT=놙~S^Z12E7	4!Q<`}GL&XEZb?S9'e-^051j T3\\,\nB81&!~d!pbS#'جd2\\ezohR,Edǝ~q~_H]BO1cbdgH;%lZd|*ZpD-2j8\rV`9b?n8HL7v١\"\$ChA=\n2åHv:7\\9\0\np&Ib&.DԗH*e%I\"O4KsO2Ĳ!L7CLԶyGȅ1feI&<lzrbrlyR;_l*챹,ZI7hWǰlHAOO(,Lᳳ>ʦ\"ҝ{r2_{Xȉ%caF&NPFdabVȄe\$4j(=kCgC[kK[utw\0B^oeOl(D5ü)NDݒ95¼V\"{8IC;\\|aBX3xNd28\\f8;Σ(%\"aN5W*fnwse#ܵo'{^2HbaG/pdD3!Q*GG1mWFlY;SڠCh7؅o-B[\r\n*IHX@T3ͻE\$V|P\"EBe\0\$` ";break;case"es":$f="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AECL653MƓ\$:o9FS,i7K_2Χ#xI7FS\rA<MӔia	r8MNfDl4̆gMjE*p2iiN@	:.O~ir2,dQCO&p9H3,0gKvIyfG{[ <\rℶ8ܲJӪP0Β4kR݉-ޔNj,KoǬL*&ʴcc{;;\"F(-\0\n-bsʽZסùi#¤\nbF'e2@P24-!)P\nN{2(9el:'Ѡ \nۚbAI\\!FLgGP7t\n#1K9S 4:(Ds#1H̛T4u ,H;PxC@:t㽼N-8^ x\nj|C4M\\׬jHt;l\r-Mnܣ09	èʜϭC֖c(9`A)-46l!-\0;#l.R,:@;5X*S؍&\n޷KM@x K,38P*S&M#SC2`7Uk& UM%0)\"`λ-V7x!TmGHkx#8@!}g]9(n'v/OR*5`6RC<9Pfh+^7b(N}ؽ-v}Ag'-2k,ߍ}}\$`m\n`3	\$e4L\rLUnBbaeMUKtJ_2f[ x!EUYb5ʫ倎AdLsQ\$jJ\$jO2u<*1RLQ#\np7)lBZ. 䒕q&gԖ[in-b\\ks^۔ypGC!N,'VQH D	mYHQ3\n\nu @JOI|8a4Zւҍ+]lrKUz]&S Lزh~149VS`@bgJ!iFG\n:M\n=`BCRliQ)Q0Ǌp&9.%q\r2RB\"ve+18~`n'!eܡ0Y+\0\":-\0POI:.XȌm	ǌif;i<B\rCFTA?\05%O7!TIH'`)j]I\0\$U/9\\\n[pT\r00 ,Aؗ	NlkR2J\$n,SƨIxxg%O%Ĕ*b4,ZR9!--&|Ub2斚̎MpeeQJ>C71I\n<)C( }=RII+!\r!\"-OvXceD0zO,pYs0\\'{B\0#J0,S,Z6h\$a)pqE'6}C\nWB' \r`mF3t+mB\n_1pA2\073jɟky Ά\\I+}~	\\uSA<gҥuY*54A'~]ճA6ʝVB(V-簅%D\\Wri`@C§+7|Ieh'IIa\0ټ䅅l2IfbrDaA*{1m\n\0r\rPi2m))gOsFA'ԌPhb|\r(a\rK#*oi,)e00n&E`UFͦo<\\B%&<\nW>mw-7mc٘y\$\nysz<#,߀kUP0H*͢~R-av~Nf@'Ơ{1:4z꣉+FG5OlU::`r7LhY2=1s)ߜGbF̊\nyhNsw_}v&y?瓬{xwzXbHwQxt蔟2\$I<>cCی)4еSl	Eޅ>dNOL31+!L20.:Hբ߰ȺCA)?-JF+v?X4>DDT0eD/KƆB214\"lLRJ Pl~ۍ6n<C٭rBH7Lfng*Gp#Bǐ*0f|m#?lt̬\0ʬ!c(BFv	/Ovdдv(i3*&o=R7nbN	DEK4no9NNm谮0K	N(K\n0\rD^\0\"Lz?#4?tC&AED#i&g!&8d-ʷX':&7m?jDeTQbL\r{bP\rވ(\nFݍl#а=5-,cMyLgF .DAB3 0. ,DPX?C\"O:r^M	4xkxƏ\n'zA#\$5\$qCh\$qqub#vG&ruRo+pN-y'e2=R\niyRo=&* (2e\"\ng/,bNX-)\0I\nKr訲Y!Ujċ\$n3-2M0`S-312@A3N7bh{!.35[%ϯ5ʤ3diCS##vfRlD`74G)8Q7l^\"#F\"DSK P`jb*3j&.|~~#d'#:@}QPE0.H\npJ;Nʆ4CX'B!R/*&) .\$O(2#tD#(x#c ,*2s7H`Q;\\\r\"&orN,B^-F&BOl\$(.12q:e,BB&&d*M\nt6o⣤RmKd-\nR!c8YfzGCC@9֛FTBbP9J g\0g	\n,sf2\"(\n5#@OlWg,|CF-IȒ7d3cvkZep%8fp,#5Kv\rLB#zoh2s&sP@l	\0@	t\n`";break;case"et":$f="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(a&	\r1Lj:e2\rq!?M3ϦV(6byeWhsygD̀nZhB\n%( i4sYm4'SRNY7D	4n7hI8'S:4ܜ>NSozZW<,5!Z 6N~ޓ0~3?r3̾!Ϋ'\n3R%b52C, 8#<8+ƳH:lD<\r#+_\0	!/1>#*V91\$p6Lrf@c2ϓ6\"CHNL9BB9\ra\0P<B87@4b_:\n,7T)\rҸ7\"HBH=&{ 5oؔ<:m'J3\r0>8D01hX\0\rdĳp4.0zFC9Ax^;r(As3_q4PI|6031j4^08\ru*́BsȢ.n5ɵ&/ˡH\$:	(jP+	\"(8	3ⵎCS+tcL9Ap?^\n:I3ӍhFҠ\"릣[%a	eF,y*BxMюk;HȸZ#-G#Hъr#X֜K8kè1#Ø40&)Čo{*\0s=ִX˃b'vHX5haDִb\"SN8j9=sP+p)HPwt&jbI⩰ͨ\n'g\0ºFF+\"C_e.aC3.H#@Fd@Մ9AxnlPȓTXjd711\n#0M@)a\\2\0!uV35s9aN<0ra60j\$2\$I\$j'*7VL!98s` 2@c0ՔnjZ+MjuJ[74Ʌ]\0K3^@Ì\n:DEs qߣKqrRNJNڪ\\9hD5YZ`;#hfS=H9\rD׉^De(!.Դug3ԍ+92a29/\0KHa>HblЁ_ aNlI\";}8Bd@&B6Gj28,1H\nyrvQ;\$\0ʸSl[9:jHƗVZzmrQ\"lE\n0zz2fB97Duya^E04Ef%,&4rTK.#Q5K63\rJ˩M,@Ws_EΙu{3! &|-1eztN\$8(j\$iyWHBI\$iZX>y}HDڅa4\0Zit6ɘcU,!7,L) #Jvn[	KVe\$)SXE(AP\nmɄP*VӉ E	VxnaQ鎍'cmk|p!}R>TI!̎7&͔X9Tʼa2J¥'RBJXQJkXpȭZ4I]vY\"&?\\Tyƞwr=AԮ0ъ30'*PtB.4ӵ8ھ'fZ3=(U{6b*l-|҇\\d>%\rcVdu:7;6Z]I;mcd(ާBk_vĶ%\0RÅ+Ud3IPxc%{5]8kQ%ZABw192FLF`ɨ* 8E\nO7n#̃!pVd ~;şY8-Ec(ĬXC	\0ݘmUƬHc:\"\nIF́x Ef./!9Hyut:#>ji6EvlҸzq3fǼ.j;wH|Qy	r\nO؎SK&&@䡒!&X?Ϻ=PUYu&L(c<Ƌ(V|?mZͳ7%W6(uQ:}QQS\$_أ*@9IIUf1{Y=%[7k[POdb,rQRP#=\$DyfB@GBRrmiQ(p.y*QN^>\"J-9/kj9&~h-XX\r *\"-O#>m\0,D<!UM	x/	OP\nU	OlwkT5gnbм\r\rm\$g<bR4gP#NP\"pot3o3l/q<CB0ajj%d7 (7)rH<FJ+x!Ytx?@.,ɸ>.ڎ\\,JnbqHq15*JF@ZďJ#x?cdD0C#F>d&G Ae!2!	C>~lck=!r4Ru\"	:B=%{US\$qc	o)na	&2Vv#Ntrt|G|\"CR	(<(*\"\rf2RyY\$\ro&b`l,lmuʙ+R~LHAr0p\"s.*Gv+O1 3>2QU&\\ѭ<gњh\$)#8vh83Zh.\0#v,.F33fSj'3nB\n77\n:П8hZqFrM34.`	r\\9S;S51h1:s{/s=:Be&Kg QS1+/?>2@Q/2LᣤP	mN&,wVV-Bb`ȢЌWD]2 hLFQP-O3.܍zcd\rV\rbJxB!'%D<h@\nZP.iskZIz(fκob&Q^QL%\rQ4pFK Ԛ5rEB=C*χ]Wu \"\0m!?``mfj]'shF&U%ELċg-\"V-@!VW+ӰH'#x7Ӓ0~g\".X<F6|x#ڛIc5P%	,H\0@&Qbjxg0#wHgRp\ncV-W#9k[ǔ@u`\0\r9&+Z\$g2`	\0t	@\n`";break;case"fa":$f="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6ѶmkvᶹBhHA9!d+anپ<W-l'Dqe0̳\nXvC-*UeKY\$v⬅5NWf+PdFZ\\aT綷Jė\\VLã#u\r#He)nZ4Į>N(N죂ͺ猪j(l4{\\)#7lX\$d˨)SCB5x7(9\r^\"#12,7A 8lz82#YC:ȱdKd.J	TBL!E2Z)j:[nӥmT댾λEtl(~C..!hl)N98r\"NrYIJQ2(2t\"Q#hN2'crSs}nS\"6PA1q9G1#3\rq@;#7A\"r4410z\r8a^\\0v,]x7E9xDlZ4Z6#H7x5Nt!SH#HS;tTMBLA1Q%S\0!ih+#k(Xj\r5f樮\";El4B빋0 |!mK;.,;*N50tP/Ká&nB5΢l*͔%?\\PSG{WCsoU\0(*͏>;E X>f制^IGrW0޶`VR{[\"ƾtJ!+X@mzCgJrs߮vI7L3WZ!\0PDJi=\n&@6PWs1:Hr!厱_C>ll3C,%P CHsFa4ZCt;0ZlʐgDaK@6\$C \$4.0\0ګ|U_S雈EC&܏5Cb x(FY\nxlKJ\n5\$cy)9yox- T7f]6(Ъ!쐬\n04tŃ \\,%Rq04Ez/e`B7!э0DBȥjO9єȢ6\rK/H+0鼣S\"Ʊ5iƤs\r]yUW+`\"%M(~;x,:\"VQC*\$y)yJک5(B~Ic7:2ɭ)i\r#&T\reZkT3Zxgˁqdc:0yCdMxQCf\"'t~U\rE.D3#P	BtPQ\$L S)J/\$KXnn!\n8r\r(:zȹ:+)hմMYFaY#lE/BėC\rQijCTQ]p\\\"v@ia\nBWLa[`Fᭃ{)5\0zP3΢1\r.N	<}RUMsNH#.%yZ#&:nO2W\"ǘ0v!̋l\\v(\"[,MV|FZl9Dc'P#(¶t>Ͻ*![LzsIqClد4XK5Jf_\$vG8Y#xF\nsNIZFzt:%RKcMDwrDyA<'\0 A\nYPB`EjzG<ְ#Zx%:sڥIl2CCA*2\"SȣǴ(MSȁ{t H6xςm>x}ýwr~\n5J=݈V{=8TV\\D/Rh9,ǮhW5cJqE`h,<t:Y7J-m.d풖:/\re?\"GgDQ].B`o`8\\qu%.0*Y(O~hSkٳ81.o8r/\nR)3#O|*\\amdlqk ǣ'z/o?tqNZxb.oc}Z#Q\rPAa cZIG \$+B\\8j\nm3x/+֧&?jQG*cl4lIԾzc,Rf,B,MV9vjj.\rrlj0I3C9\0:)'LBT:pJ #\rGMM\\l~mTԌLG%\\, 'kGR\$.6P\"Bfv-\n%J.:{+BDtFhbnՎ2<P;p8l-MTX<*-V8Pn`E2~Plod.@*m-;'O	pN<.싄o\rE\r\0HV\"/'6bޅq0hmHd\0!=qcjZy1zPzڟj(BBP&)2en&/D|,P'mrsa\"bձcw\$7\$iX9%C/*7\$?B (\nv,KGn.PԌK_&rL7OR0\$o@4/,\r.xr`y]T:2q&㚐+%0.̧ǖ'wi0k.f	kAUdQ\nMlC0J˧ҡR4,3P45Ff7,x6%+5oF7\\x07T?\$Rk2/'<.)G:s\r,ѩ6B};ys,ӹ<sR\ri2+࿠\nI1|䖄t\n3?ʿ ح\n?V./g;,(:0CT..F8d,L1UG7H<eEC3nht=<	\rEL%*ݢ4Ѹ>C&.6RR@6Ps/!T/W+U\0!R)wJON\"B\$O\r-Mv~yr\ns\0fܶ\rV>LŦ:UM(J\nZ\n,[#2/3`055JFFL1sƊ;.ڂ*//3eF<BsO1\\T5UgN(PG-.=!B\$t;KY)ZRDLLpV*zP%-PU*rg'DmK'NUUQ|Gtp^4_]^.r<G]\05\$ubPjp#lJ5\ruNg\0'QhQT\0G\\0<So\nVUn{3v%aJX-]WLQ[EA3'{EN·tܭ4.roƏITgv Tt4ROÝOs4 ";break;case"fi":$f="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 [\rHyWUy8N|=NFI7FS	 ѧ4y0&~AHk!22p2p(MSQRM:\rf(i9׫hCcRJJrTf!7Y4֣I7uz^\r2ÛO 6ybkOd{%zMs24*6Z݊::cД B[P:>/7{\09<è9n!`+TêJ9FPBC.cj&/5(2tҊz(ޒsj%+Ó\rkv(#\nF\r ҕEqS)ZAӰ:\$#ZǏ#\rcM\$+ڈ##N:o1<'lH&LMHf:i899mVxнD4&xmVЅx38^cqxDҼ6;A^0HK@t%@.k2M#\0ܯ\rcP:	EWܠG;NQe.jJ7.|& @ʫbݎ.HC~X@\riĢ :3LLa\rP,Pvp-)8\"2aZ}5P-#\\%%Bem>ax]rccdGG\"9)9J_{B7]9ȏZsփ6<`q5Ih0ufJ@!`x/iSk<Sf3\r#:Z2nF<Tbac@,gb\r<\rq\rEz&fJ\0f2pY\\TFJcTBͳSa\nAP1\"dT*<K3t_cAm &h\0na\\-)pRC#\rN7X7CIMy\ntDBxDNTI,2IQQA0hLPJPqj!q?&) U+|ES<2V[an\n\\ե`\"^!4CFCB`dIHI\\0܇м`IPAɇ5 ZQa) 160DJ5jNI[KqoJyR0ea5b49qpZxd\"ET2n\nt<f(&!PbGcدfK(s61pa01#T^*}|,\"TzƎQДvO>4FE^fCA@\$sR)8b ]7)+MtVe.ȈR*sN|!Mt&FII5yL}D0p<ޜ\"E>-A?_\"_}\$a˳&h) [yIx\0W2e(e&\\0+fMf\$bዧSI3`%ZiF%%;AHyBIJeXV\r\"\r^	LWWU0 -`4R#TA?%F\$=s#g\"B#,\0_t0d`y,D.ɂ@\r>\"J,!@', 3&Z8=mx@BD!P\"@(LQD0ZTL)JL8&f\$\$oa2S3\na/ĵ5E;,_AuN~#BsȒWj|jZJm>І(%OKb֖F^V\$! tVGP+7YRU2=a@BY\nP&wp&B&g?@lC)3\nҦw(W*>sV,Cb\nF*S/~ %`̔iw\rI/\0[\0'EK&!ƏPC/g><Hi##ݷ+H}BA\0b)JWaUď=_tAC	A7%f8	N a5@ui++e=VRoK.雰m\$7K^`;%Wpޡ|XAx\0;7-RH7:2+D{)I¤eڷ)t{SjROM̲>\$>Iw uj!\"	A=)nJ[;[()/oY\\QTŬ\$?2x̹Ld#hXuJGBJ44'\0czƐ\ryl2\"k\nb`=p,5j,5dh:pPXF%pi\"AM W(b	Z\"Kբ0ZJ\"@c-P)NBgt 2'5`wo\"X bԞV010u,+\00\rKc1J-	P3h\"v11H=!o\$	cOZvnXQ\"nOe#v.q29\0\$xB'*F%\rp8d.0A4cDJZ0p\0ZJz\$T\"p5EL)EJhc,-),qf\"\$Fj\$*\"\$=,X\$܄8v8W;B,1WPvP aɿ&ja\r_	12\noNoaR-yM;瀇Qbwx1!7RA\$P\"fU#gG%h&d\n	\nf%CF8#|QA!cRvo!2B58\0jGD\r<!+R-+(2-+,ZP#%H!Pr\rgvw!.rc'wCw\$*D/0\$7r-1P.0)qf\"R)2Yr\r32.Nn2M_g\"%.:?44lC5sE56s4%0@p.eҔ*\$f#0؊U0\"\$nU9l;h#RC#\"F.:=xq=SPM~:2E0d>*E	JD\$ve:cA01w1'3\n&(',ĲKARҤPm;t?D N cZPl6xâ`q\n^	6\"t1N:e^FAnV\0 D&>V,=A?Ը>hG\"^KtlP;#k\"0il#T4eBJ4v.pxC^2F3PF#-UϤkIc	J,p2-x=)  R/pV@\rP.&BW& &<\0\0v(6F\"Y\r#pE\$@	zgXETvρS\0B#\$Xq\0\"̲T.\" ";break;case"fr":$f="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AECj :%f0u9hZvMqM0Pecqe0:N+MޏR5Mj;g*L'S\$yy=W3Rt\"pv2LndNhM@m2)@jF~-N\$\"s93N78-L?O\n77eKzT7@<o0½)03 P\rcr\"L;?t\0Ѥ\0Ģ	\"ɍlנhъ(ꕡҵH2A̦F'\rhà\"܈ACDÁB0es^M@:BPN,✑BeCJ.EdOu'1@P2\$y5KL#5cf(ջ(Is^P6ĀHh1#&>1):pGUte %TȅP2\0x8CC8a^\\0Kx7@xDÀ:ۈ3\"t\n7x\$:3Dwo)U\nNM`XlKI;bYjK\0\n6CCT\"c(\rZϣxX\"ͮJU>	,+T!:N,ɔ##LS-42#^̟ɠϵOCRgrJ@0~qiBb(Xc'n LUq2҈\rbC.aVx(\"ή8>kV*fi猠ml4|,{K{B:;%tϓ\nJɂnlQ\"M5@0}×7!\rz(BUbyE\0zae;Cyc,lB#Ȑ0|L\"4>h\$*\rȀ\$v,81.')4WYAZ&C8My0@P+d&ў0T|Im'E`T\"+5.17u#ReB;c9FH4!c1r\0!,i7l D` Q&iuWz^k{#`	-|?@S\"l\n.<#x]H&M}%:`mK0Wt^|/!Pr`,\r&S 9020\$IFu		2pv1XT8)t8ïIYɐB3<Cg-&*	sgn:\$x:BH&CA5):@;bp;U2\0\n\"sLl!!JI5Ze˝EI8g0ۋIA\\Uz(\$Q@n-PB'\\'s\r'L\"TOX^۱Fxk!) ʒ)&(2Y(xihSѡÝ^EmDL3\\zPC;I2)ڹďq:Vܪzyxq|M\0KF\";H\\JMO\naPF@41E\n\\/UHYZ׽4:>>L]Ubௌf\n\$Zpo_^	`ZTTJk=-ef	-y,Z9%9qu2*n'p \n@\"s~q&\\ڣ6\r\0H:\nI]ZS<81wzB\rU?EKCaZ|w(ECp}&ARϬ*\\1ԕO>8<g' PAd5\$c\nq+us3RrV	:[udcUV&ؒjP Dћ\\J9qm0?5˛,ddkCc~00\n)RdCSaנWaaiO˃b4%%P9+xm0<=&fLT]YfL@7U3cȏ3T%s1=0תl0iwre*}b0yv`R46rpi-\nouP*a{u:-uߨSؑZSE!A2)͒l8֥@]-gݤg\nt)-_IAz[.<|(IϮI2}D#Z7'LYdOd2r. ̺O`̐%u6;@\0'(*5DZb2nb\"2E6N38ʚ3/T	4C<Dn6\$\$Hs(#hФ'0	BK\ni*0ءRAd%~P\ri	/\r1P/dhw©P09}\0g!Ɇog\n(c\n^-N:3\r~2;HwNq4LnЄm.B<8bHlDrbN JWN&\rFDm\$.-k?FG-sUŭ\rOp1Kmq\$PqH:\$\rq0(}Rm}\\\$hp\$J \0)LEK*\$k!'Jm\"O(j%\$l!fZ+\r֩2N̮#P^Fc\rrfT\"Q/M\nFMb[x5 UUʈ\\;6]h'29EnL%U\rpAFD[Ѿm`7\\:\r\$\$%q~{<.|(_\r(&#PCg(1%d\"8(0aS4{\ns#\"Y53ȓJS3NCs?7S[7^iM@%T. EOrA:3,h!\0P##SU33!sc\$Q;!j3G7'b\nbާƪ@f`@:p7BOd2T=0A0q\$DA5(Rret 3%t\rB.?C1+3AN,'3ffC+DC\\%9l@ʶ#`ONGmGZ82GTO{IStc=T(554UdrLm6QKnmsqFP'M7NtK99+.H8L	GL12\\1E/+MuP-En\$CQ'Y%fx\"Ok>MqxuH(ؓU\n2crk)nR .&5'	X0Xb&aARV)l\r(:C?^;úz\$\$m|.Dw*-*d0jkb\nZ\"3<̬r*jY\0Bj*GDePvx'z[Dŧx\$C((X;(e4QU/Q8aO^ls2ã8ܴB΃_«xrG\\6dU&R]`6h'?&֥im%gjdmcQYndD1\nx'&rlddVzO,MuhLk<\"	B8r@p*tx`-Rrí7)hT֍[\\zmV\rAi&<]r \"ˠ.A\0Dm|H\r";break;case"gl":$f="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9\r0  7Q!y<u9cfx(Ys~\n\$g#)	1s|dc4pMBysB02jn0 SvݣF]ɨ9b\rga8ɲ5EA5iÊvUXلA:^Z:n<oU,KVƍPQ<\r/!26	0B	p֪J~I@0C(*ڪ 8#c*2%*#~\"n5Kj8l6)J>);Jʶ9#j~Q:4C+mKPC*p(/V-%P\n+\r?!76BV)DF\r(ƍ8\"~#~hE4篢Ƞ([2/QhjұM&;S0[!t\0x\r`C@:t㽴55b~28^scxDk+\r3*h@x!QAc0<P07t6EM7-\r88<0!*Ȝ6(J29^[Z:ҵfGNQLK2a隇RBcpS5#3ӆ#;33\0pR6CQ?m&Oj&Xr]SIr94=RJ8yT\0(SH;\$\0BL})L3:C\0݅)tOP7 1CK۴ư<z٣-0\\?s@)a\0ڼF6]<#\$<Qa0H! Q24Nl-hD@s%TSpN-LVTѣ#<5He%ғ	^Y(\r&nE\n 6)*ƐHD88zh8nDa \$z!(\nSĈ7Ey**-rhm^Dp!`@rY08*ZIj-eUh\royE6H }\$Bd4Fc:.p%dպrIU	r6\$4n!, Z]l#,\\Y&Ի\"nB}(	\$D]@A-6!h5	\$BFw|!+\0006K8c^e3Vs\\`\0t\r{a8A/86FB\nxI͐d,I4Р\rV\nO3)	\"DT%\r]NȺ\r9I2maO|JYpñ346z3EKihQS=pXks@BT}A3&ZE(Qh>zS\nAVCZ8 Y+R؏PCTFM`ܗR&J6(uTB.Ph#9)h	/X'i(hI#dd׉\"K483^oSs\n<)BKalH4'!֌S'\"72|iWatr21ЄLRZK;*Se\$PE\nedz)*`ACoe%6OH(TLR	PAaP*BA\nUp'@BD!P\"JO\nAK%d̜(LSz/kq8gY6L&BTÆkm_aeL='DX;ЊibteJ9Y2Lmw%Z;ӤRz0(4hQ?2uzL\r8j_CM'uOB\"Ҹ/t/%-T6vډ3j14;Uv1nP<𩅉q0Qf՜\$.zDxN`p\rևc fZ(\n/D\nlCI5M7pqBD6#O!f[Uo5\n%_yc/ԟ{vsM1\niZT5xwT6>ey+LkFpS(.12RɇYʢ{`\nS!@N.	#rY#4kUK*gz>P4/Ŗx	Ottx3xSKԆ̼ޠdD0sSWg?DO(cSS~vSFv.ss6J9զ=ĉ<YVrZ5PoGАW~T39#;ZX=(BG*bP;>\\8DeR`c4* ֣48RB&\$?&&b\rnȸFH%rT0d&zC\$@>4`dp.tݰ8ct\\r&,^rCz͇ {&]8&.:(L\"L\n0#\"B\"8##k&<\np]\n#'<,H-\\xR7Dl\0cNJQg(<ΆLڣB©FZdXN\"Kh\"mdqeyX!btP=919'Ljv13V%>uqBă|czcF%140 x` 4DOXx}Z1S4T\",Qcqűs#`%	̍P(54LB~8&\$\\]Vg'	K\"]\rȴg/`wȴHBB֢J\$gP\rzΦo!\rBC@c5qO%a&)&LU4rW~*҂`q[2RCg_*8P/@m`qdP<@{hW2\r(	&)2\$.2妶y]-php\n.-BRHCgCyjy3-\"qtr]23:ƣ3j0K4' Yh(b3\"=6/gQ6	؈`	GvS@7D6*q8ӐhdPTbv5ɬxPG(KS%<u@l\0hz5Q=qf8/3	\$`ڲ8\$HMfR>\rp':'BbCvk/VV#bfPQ-GogCa\"FP O `4Ʀ@ĭ2i;5)Ħ'lr#T@HZm\"A&Ħ:\"!ا(|\ny#\0Bd0k83N)4EJZS\rG<JwlKMLC&E0p,Mb'a#Ђ\\-T 3!CU)V\rڌ3[T_x,(bk\rMCWUTLj qURWl\r(m[!R/nBnާ\"RI\$85Ӄ{R\$T8 6NxBmTcg{Rc~ffmM\n@CCp#(l*";break;case"he":$f="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r4-\$L#@'b0T#LIRQ\$c9L'3,.N(	\\aMGXk1UPtfOn1[	SVqClql{Q/CQD#) g+n^U¤VnBi'̱k\"1hDAb;9QӉuvGJ]/)\$Q)\n*fy7L\00Ľ 2a: 8@ཎc20D\$C:ziJ\$k/3\$)j:αFMv!DDIz82ۡܬKHS(3)0K#бHL9kތI,DNBåI|a*# 4AB\np09B13\rAP`@;#7A\rp><4/#0z\r8a^\\0D@8^2}YWC ^'/@\r@7^0\n1\$N2%H965&΅0Kd#M\"9\r\nRNrO6ƹ\$3j\$֒(TH4!O<`\rs9%l:_&0^M{T192JzĦRO?!ƴ\$PeB%!H&%)8Ĝފ2^!\0(KMku1LT~h6M\\ۼ)-ף`\n:,mx%*FH	72ϲJ %?NkʑXpZ'\0:pej#S9#r0w\04AD/09Cb\0p܌fSW)i{҃b'e	IH-N	)mOLK4<H(=8LS{\"\$'^	7fޛT\"(R[jP\$918X̓CV@ZUlҼWaCVJY9EA>\$0(װAi9DVdh	!=w\nzj%䴕CQo>DD8ʻW`uaK)f,\"ZKE\"\$@RjDq-%6IҒ|(rPDSA/#ȘA\0h/Z+.FC`lÐm40gTS!: ;T*b&P /-fE`j3ɃEL\0\0('R@CrqX7)Xr\r!`P2ZB/}G)YfZ!r,ݧfRp	\$r\\TsCjaKCUhq-FHc\r+_ixc.2.J.	@Wb =܋!C,q\"DBJL,dGs(΁r*#1<5-2|H1ډ0a8T,;QDIdIk%7:R\\(Q9bq/	¼ÀT\$HU(d\$ݑjV{¢I]eƋlE1*OJC<GmʋBbsQrF,ԣ1Wdݫ#{{c:%V'zۑdl,CCf`#n1h9W\$ӏUsḠ6K[NfбSXyG\n_loE8	,vx#]w\$6|Lѣ!%c)۹sv_=Źf7AM	\n#KkK~1\rz#DI!|@zĢ6Y(soSG*>eC	t7-8HAdMy焎Ve%*^phȺ;\"{a2:q>-C٢P\n<bHV3Ƶڣ#X\\}K)2C	}ATPy!`(бȑ/ᆞZ\rƷ訋tDe!jokmrTꈩ>FJ8e>޻ʨ:IwDD\"'4hE+P_a\$nq̫%ЙnFM\"(s:Q6(7}\r\n=hr0\$۳Im6hI!yJ	Qx#@EI섽d,<rQ䄆^Gߖ70.{`)|\"^^8M@fv\"fOe6r<'V%zn瞢^\"\rAۜ;\0ȩb\$#\r[ycX@ۅ묗X9P{gچ'd~NϪR̴~vErd}n lRJ.-ncv\$#JN&Of)84%\0\"#!\r>#ʿl(˜)L%未dʃCޕj𻫺OTkTqpH4\"hXD\"ViLu	,eGf<ΐςJG,\nNO0Ot\"J%U\"oM\" ͬGE>oXqq\"/1!\"DsepZ\r	if\$s#[q`Qlsƨb¼,:\$\nB\$3@gVoOLWpF-/o\r1*bR`ֈQo(@QqB)Ι3MU q?ɞR\nĂј&\"p(NKB\"ג:f1#^nME1ªQaO&?bc'3Cމ!\rp[fk#e\nhL)NO4`@V0!B<O	>dP9OJɂl4@U q+/O\"\"gL9l`<_2;bЭcD\rΆF䶖dT\$tÀr;!CT(\$zGlu5bCP̋hJ:\"MD\$n7!HS#o\r,\"&07Bk0XKsh9Qd/:3}'&sm7/\\e\r0sưjO)2I&(Ɗph.*jnB)\$_-\ngC!n\"S'c@\r@ `ʌ\"Fi6ʂd";break;case"hi":$f="%pRX*\n\nAUpUYAX*\n\"baTBtA4!RO_IQ@q*`j:\n	Nd(O)!\"5)RW	|`Rő*?RTDyKR!\nDJ\"cU|\nԳu%g\$I-=a<fHQHAԴ%[M._Dqe0̵GYHsz.K`RC3ue\"#IrU쒮IB#RE#ɿ҆>+Iڧ5)\\/bHhjڥOMh\n+;Ⱥ)HP4J*\rj-O4@#M-H!&1|H\",LD'H?Dz1Ӹ20c+2s50!H(Rj-ȓH K;\n}'4'2/GSmIC55?DL(+sXK4'!5Uh+\$I/E@H/R\$-&OķK2[rɉ5X2{94OXI޲Vrx\"MKyGoh3_i-Tj::KWa'UHRay#E%Ae3F-KV*},:.ngH-պ\$iSU.ӯCT=&U\rdj-S	Du	<^`@!\0D49Ax^;p2\rH2Ap9x7ヒ9XJ}2+*@KS^0tNڐ͸ѷ>M)6\"2\$J=FcbJ:ݹ3]թy\"mN)'a Oޤ\\@AtGѤ۴0aG	zE}KX\nCnSE}MIE#6!w93vD\$uI*;m&0uZaRl;8:	GlA|k\\c>*xUMÃvhL~%\0()\"*l'wYLf}Ku`ɞfq\r`[KOX	6>hVdu1ܞ0nnR\")Db\">ph(`mLFcY{&u]*BDJYiQ![SeȨrl	_EԨsH*vhͺ|e¡: Hӵ)ۧ2X+NNAaIdLj㘲	,3`:ME;؊m_:2`AHbSfȶ;WlȞ`A_x5PxR'6NCo2)Rrh >͹s%O\\F	QPuB b2\$uL0MK0qOgR9PTG-4TTJl\rR\"F].6ܛvo\r7\0p!8 o\r:\$'R)Q*zm4\"VX͙.g#n*'bmojZDEJв~Vj^_]j񞚴g-e=s6Pد2V[}oW\\[q8<G쳐s3n9rd~	vDU>ZՕYkJL]\\(_EӲ6MՀ> Mmf]:+BD\"UP+ҳ*Gy!\rJ	AkW5%RH\n!PgAAZ5>@g!G4-zb\rMBm.sQ#+T;릊D8p0q⩻eHڇ;NrXъ:ʫ	+l̪lS\nA*`Zl	qH,I6RIc+,BcM֫.9?҅K9em+zo|QYюϦ;J;33H'0fqQ1]tZcwRn#S\\p\\i|\0¡1O.ޢCS9?Ugn~[so IT\\ؿ#!*e;Yрv\"t#=ffҽme̷\\_֥46uigPN~2R'>&(NҬ\\(&ذ}є|'y}#H#5{qM59H37@!>oNtˠzSjf+1mvFuSi4b4_<_K?cs]vd)94qE&zLz,\nLV`3OtsvQۻ 5n7μe[^`o!<z~sNyn>|:Ӄл\\Ǯ(dȐL\0\0϶).	 Jt/N*0ڤJhDy\"F\"Ĉ0<*H(p\$\"b?lbymd5,r:o8(6p{{H)w>Ho b8q\0ҾǼ@p@~-J^}P4ox~ZExDD@g}f\0003MKeϮbn6.]TĈJ̎\r({^v1jDp|GARpLjQeJjʼB#n;,j3`Bڅ)\"1DffJ}3?Q\"UJ	*]m@ƪ(Flq#*Y1'QFtY)c\$C Z2NАb4DCaY(l|Ln!7\$m0pwĻ+[>9M\r+^c#4C'DTr)VqwRϰ6C6)(H>R{1\nZ[oD\r3\\Sg*L@d3\$&iiY3D|(,*N.JN76RnNrdw\ri,ϏSp-G7dhe,L\${IP#y*@#Q^\r(SܑnM:IGP,\"r[	h~N`ܝ\$>ƫ(ʒ2~k\$&`uVe2ғ9p!8cDitLmFL-7M83I9uOFC39]ުs,ptU;g<HL8>h}\r\rIHy3JZ''4(4+:S8JlAD_=HbT\$d}D]4tyNbl'nƔ6oLԭL,IF7GeR?NKK4\n#n]BFOSDMQdsA)鶮dMnrvENkk@Wu©@XCJF\\P24(1\\lnY꛵&u+T[\n(/Qb?\n*fyqe7TTP_4+v\rJTQ/TU6aa˭`HTKa/\n\rX1JheJ)THaOU9dDdUYUd6XNlve]iiM6˖]Ast:@YiЪ-+Mzv!6P[VP6I4bTEu9li4jg'l%6)\0gX	Ckxh+n>}aVpDĖ<F֔VS6G6eHorOs33nE&79ooori+sltkLwIuv37\nӗ+u7Hw4<YnbsxD_A(+qxDuVucH7Qa4x]?cWAcyfnw{|A|V9}_~&eԗ{4Yu-7n7[Wo.GowL2Wdb(cҟ6W}|67M*fK}?~C\nܺJe3y1\\QMmkr,S4nT3kpqiaTWww;rn2i틊4l5#h#'hC:͗X 6\$nnwًV͐~ M\$j6\rWg֦5^/,\nZn_kL/[<xZVSVS|xO4fҕE%n̴P3D\$Vvf&8JXpݓ)1j-Oj!F-My;K?!בuJTZd-7V#d͘`yyUN1-rk<(?e-(QXS@oqdKWk7c:(h:_Ď~!gd#\"TZ]7TL#JBgXd&37youw;b8k9;W0I	:Cb)蠀sWzH<[n/r<PBjCR<za,7vecȉօrk~1(3ϛu\nV/2L\ng4n2X|Oz\$\\X&CiVހ";break;case"hu":$f="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n#FQis'jbRI;g:ڊlƣjl&虦7CIiMc*)-q֞kC2Q\rZt4Oh97eEyAc;`i;e:؟Pp2i3D&aҙeD67{ɭWăc>O]\rO@,j).3B:9)lr<C\$,2\np9\rT\"<OC\"㦞n9hȕD*ΙA)P=,@5*pݵϠ¨42*\nԠh\" Ȣ%\r##/E\n.R;	AYO#xB:H25(cڬ#b#NŘ%#Pm%A<T)CCB(S\nVdh7|qG1@3qb1Fc49IrH4'c0z\r8a^\\0ՊD]z@P2~\rk?C\r#x|\n\r:C֎6,4\$mG\0cT)@M\rH\rP\$0ZN:9d晵455z˂|=v3-4 :*+z0\"0:a\$6(%DCL13֕:v3>b49XHB@iKǊ[X7Mc\\Z-|77.zf)cH?H@9l(Pܹ2\\tcec˶@B|Ki݈x	۾8(:23#㷊Zk@7Y<x9*c\r(5{KdPc EJI@;6d݉-g.vE2d9 W%P490iԝ|EN(n\nCN\r}@	DlڜÜoT\n/sR9V35;Y <0aL)f4\n)5E\$,S`U\n\n6.%iU8V[kt;Cr\\hdy|!8LzPk. 3YJ\rPXDJA]gvjϑQk-bM.xq]t\$!+&IμKM` J'TEcaCldTO=pW+7\$@L?<4b%!=HTi@eAf%وa-+hD`+C]x /l!N4;%\$]2624k3UH\nԆSs\n	M}ARPES@&7>ù%CD(\n*NK(\$AfQ5\$+e\rŹCaB%D5*ko\\MaL)bFwb\00l˲HU;CrVKIy1&dׇE\n'f.^O*/<hJ:tnbv[s')C&2MQ\0`֯BO\naR BqG9ѕNQ9f&ܥW\$=H\nb@)Jv.*T&IWݺ&ᜠP5[O=*F*s6-Lzh2̿)X\$9plm͎EJpܲ ˁ(2aY`~p3^z&	AqmPoFahc 58yc@w^^m?aU'h.Y \\V@*?Y\$(k p::ذ'<+H\$)cJA	slP}o*ɛ΄X1C޸l:BvH5j<JTbvC(wc\"& :?^RxtFE:؝m'W<z)O!3Ypf\0ذn\$3*zxk7|ģCyC`8Ʉ5){&WbD)旙4T\n!Ax9܉eYZہyڟC^vf 3b1Ѣ)O@e+{r%ۡ?49k;!:9N\\I׋'_޼|o`x\"CFJ4>\r28,T4\$ycd;ǒP]0h;\0MNu1ѱ(oN)\n1oa1?,b.cB@ip&bWp	)!?hAl}s-\0AŒ5C5@51%eM\0:\r02#BJ-X4FOD6Chѐ0\"ML.Ƹ_.l~\$<N#L&#Kzc渢5X/``Fm~T4\r,԰flL1%eN4dcKh\rELH>l\0ڇg\\:J\r&dcOl*<\r`\nz Ёq)sRx'qTlw^G1b=\r|CǺOZ:h/lRb/I)ыg	l⃶ǌ}ULvI.+01Qdd	jj@GdN>0P-6r2YI R1h#\"8)/ Ez<\$VEPhe\$pR,0CXs1q F~@G\0LgdwX,'#)6\r)z#2eNªl)c-2l|Ү@R,qO-0gx	b	\$`##vpBi\"Y2q1002\00Ή`.54Bmp/f//\04S66m@ȧ\$J\rľEAS*5|q235*|sx-~w8]c-\"*3;9gѓjRhf+y<Q&`\nHq,B>?ß@jV<N		~QTs,\"t&U:T\$]3l\n23\0tEC>t/,QD&DBFRh7-oFNF@H83BBj#d8pw#f#?:J4J8iK/KofԽJKC~р-#;2`45m#LcOQQO0SOqOa\0k_Ezk\0̌%@	K  \np)&\$x-0ޝGUeUVGU2\"\$\",\"M &F2bD\$~r^	\r5.@C(.>bУ'GU>RTS˜2\n3I=ybT	eWȅ]W`?ce&?f*RPNQ,c1pFN9Ms\0LqBgrLb!=a!\0Bf&0T2jcCb)*m\0\rXe5.j	5-[v:m>\n`PD`sA1j#IB&,*`O%am+bD\rc\"eb4\r\r8)Iф\\\\D.f@\r";break;case"id":$f="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n%D2ÄL7ADt&[\nDqegQBe\$i63yiR!s\r6Hqj<PSN|L'f1Ir\"ɼ 4N#q@p9NƓa%kIt4V-K7eLxn5b#q)53򍼈e_Kb)\0AuR`Q-\nmipCx{{p֢v8@H9c2\$Oh\$485mjTJ4\$K Ώz6;Dزj+\r((މHlC1k.cC̺^iެBj@:`T!jȚ2\r;c|)1`̍K\"l'\n`@1B3:xQ8pa}C ^'.I0*87x\$Bh4S &Yz	!,*(ǌcjht+s\"7E,BX6I´N--Z}LA\0:I\n\"0:0ʺ@#/34!\"ȳ9:L:Kk^5GJ4N,?gCKl\r(܉kB&Cб;j'4[i5ʫ:޺\rضm\nNjax[\$pBֿgZ!lኁI\"\"kec̓a\\u46.ak0@q(;M+NCx30D%;*\rt<?#6:j9R0_Wv)2SMKkN\nJlK(>`蝃n'u(jSjuOF,U\0U*\"0JYBXLgtHRڒ~}ƂI\"Mf*.Ë-aIX\"T\nR*hUH|}:wR@o]Tp\"a&wi\\ Ar!_#h#.SPQ#(\$pe4QDU(()@[>\n (r`_\$n&\0Fg)\"t!8	\r6M\"K'!zy4QA(GUt 9@:ppn=H)bdi:u6Jdrl-C	C\naH#Kr5Ap 	a؆ײs8 2 ꌚe\$:DAE0(QY]BK3&!8XL7u\$LLWtPI\"X)H@eN8kCR*@(r'Dd@b:gɐsNV&%5r(J_<^蜮҂e\n`٘Ќ%j_uM9NyKu`ϓP*Pe\0D0\"k6bҁ.Y<b[\"#i	 ̱|SiZ<oSq+l]k6D,O}(V4Kam5oI}ɴ	EVԙm}4F\n!^VR^Ô;o+X&a>,7ì Lߨe1NtC0Aw09lC\0vFE^4U+p C!%2ߌ\$[M%:5nCj+scbopb%\ry y/NGuxCۣXpqrAa Sbn@ Iq;x د\$lK\rIKTJKeXΔ	H{+4hs&Ӻ\$x_/!+Lc@!܂F+:C\$Hy,۩ftQ,\r6'NR`i'ue*Z\0)~KC;58ml\rqlB;5lWLk<1(-uKh3[ܙ\rSǍpVCx8(+NaG\" \\S2d;QGc\\ג~bw@ș(rc1r]Du:QA+:\"QX\n9s.}puρB7GP_V+W;i.i91q-ZLbE2\"|*ͨ9|jhd<8 :@cJbs=9|ṯ=yؔS͒@PKu0᭟(04b@I>76}Y=ү䎂O~\";.JhLbzd\rG20 YU/H\"9&\"p2Ep/&ϦfoP@\"\0a¢K`=ƌi\r;l%VnU	V1nPo#G\"5k\r'c#pfXCd4#艰PnqF0	6nj!\rλR1)q\"ĎQºC,S ,Q@!gjFN\$͐Nj\r,RJt4#LHDТT.ќ\nq{qC\"@ P26\$r<F67:ݢ^\$@Kv}Z	9'؍mPB\\hd\rVqt!e~b#~zĎǰQBDJt'V\nZf-\"Dկq#@Qdx+pMR\nEL@A2,*T6Hh\"2z:*[']BD	:]n-Ât=c'Hx!CKP~b-ghiB\0Wor'gN	-,1B&dН 0--fECd\rP4T[@N\$\n f&1HPԠL̢m/ 3<, 3&b#BR4̒#*T1k-='@K &ـGfBG4xED5";break;case"it":$f="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AECI7!li((\n:Q\$c9fq	\"1s0Co&5:bb14߆,&DiG3R>i3dx_!'iH@p҈&|C)yNȃ2bclD8&uLrs<Ix(l̙\nC9.NBD:7Hj:< 	;\"M\0-jRӘ%꾾\"tjh@ef:H\"1 @</{4-\nC*(ކOKsJ;4%89z1/`P!=%r&\r<IܶL ɸ(&:°R0cVs΂!SR4/#0z\r8a^(\\0S28^7~+t2c3 MPx!L+0=QȓY\rb4ىJ9-C3n-\nR):\"3Slڶ @1*h|wꔃ\rb:+j!׋\n3 7C*&xX8@-@/-Bm+EvR'\$Hr'<?ܖ&5<je s3)e٬9\\aȈb-P;?rt {̂r\$!6x;m3(ݷ@7S䭙\rs,!@6Ó2|o/Nv6: nγΌ.~\rJ5mH@aة5-[r./=|x;Ź?O7«l4☶Ô=8=:BglSb\\4J~xc!-B)`	7 \\B+pA/&\r)De}#r>_PNsC(f)m#ӶR\rb|elUr=d7p@UJnJP=b' SM>U UXq\\:A\\Yf>MlU0@IOػʏKtߐWL b5HDJS15O*D2YV(x-h7+UnÁ0P<^C]\"J3E:ti\\44NF<hEDw`yCy6[X@P\0azD?hBuOWx=hF^M=.})Ih%Fm\0PJb\0POI*r(LP6tMߡv0ɒA\$jΓgii)ȜJdh֑\"V	:&\r\$fnt4Pt%#Rąxk!!0\r-^D\$&o	L04+ (WtG	\0<4G\rm?RST9A\$p]fXNrBT'O\naRԲ1_QbaY;1\"2`Pgl-{;P\rL+\$h#Iƕ\r.80eEf/RNKijm\$'@BD!P\" E	8+]W~WD|=hn'JA+-\\an4P\\w5񳑩Rbb\$@EmQ87[A!r>\r\0S!332D1	LJkq\\`\rŤWZ+i!Q˖܈>% %gAA?,!8*q(Cr ãmħR)&M<45³553FHt63HJ!lG?U[-nwhh=~S`Gy 1|*^sӯtCMz,ll\$L5ih0=5ye0Qr-ۦC	\$吒GJȁ*j{0\0\0\n`D0dR#:̄I,Yr ')́)i#w^;w6	1I=3y\$qLuDnms32J`SI(\\B65y4-in\"}^[JZׅq)0̹ZS\r/,\\COk!ўcc+\"̒nkj˒ÿ\\9X1	Llɖ78B'.婄\nzyP|IAZW%hB`g4g-_UYa0x7`0i19cB>cSsfŘq1ߝ:OBpCUsnko/-Gp\0001 @/C\r,0%:@\r(\"b?Mz]9\rޤ䃜aC=B&K\nr<2l\0kG\n	Y\\bp;MP5p8+o\nGSab1C\rU	pT:Ţ9<e0*\rJ2qqo|\0\"0rFzp@FL\"iԸ(\0\0\0eP3% dơB-apcE.\"<89g\n< p<j-:¸(,C,--n,/+-/cMq9QXӍj6ǂ:\ncKr&etC7\"\"#Ϲ\"D=Â@ԃ81L΁-XQ\"u`MW%g D'j(\n%g)Q'\0	fHګ/]D`.Nƀ.L>~r RtE\" 3\"24fςE^LN\"(F(^H(r	2rxF0)cn\rVcӮ=)[\0`x#JH_'@\npnbVj3`>`)bib\"@QGQ@W*?mOӜ\\ÐfB\"32B\r%t30\$@0V:i\"4Nrꛭ]\$d`]N57q>s ?l +3s?TMB-Cl#Pe\\̔B3\$悽l&^k榉n'\r#I\"c	Oow+iep\0><4xK.L.L\nt`MƠˍ5\0͢\\h\09^b8";break;case"ja":$f="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp9 b:W&K<^\n2&(z>\n\$g#)eu@xn胐 Qt\"ʊ\\q4\nqCi\"VηT:Shiz1~BAXMWe[WPqI9kG2YaA\"ʅK2zė:\0T9S3P41y_yA	A\$#L+DOHU1z_QiL	T+DR\$MA_*cƆ6-RHI^ӵ%YW)~NCD8hBHc|E%qEjs,^g\$fi@G%Br;:4aK+\n+bsKJs)sC)P!/rDT0AW\\!WIU^2L%ɲQrsqP(b}'oƸvZ񜤁ʄbAdRa'#2O}^Aiy`\\B951D{'WȂ2\rH2SMrKԴD5me6Bs, /L18o@420z\r8a^\\0V\rp^82Ø奈xDARY`|ݖY~\\b9lZ<\\tj6	VAQ%o{t!V!siLr\$PEF!pݑơ6'\\GI\0QgG[@EgI\\Tbt8Xu^Bx:Q@vs~>[F%U?\rT>@E87MB[I7LuOVIHb\"줌 ]!W^	TзF^H=mؿN'}J!t2\"+mg3}ˋ<nJ\r\$VJ\$'Hoe-E H\0#jݻb\n1kBTFB%6\$!\\CJF4 sM\"RDjmexPCh=H|%9TGB{3)	*܀&(*eBrm(9PP4S^Z4WIN\$X̧M3M,3Ô_!kZRH9+%͡\"\nj-rʓ!\\ō!TU,~ȁR@1n]\$4A! CWfY9gl-i\r)4pa5i  N82=vi?d18'ϰUI\$Ab[>\$BRYs%Ѐw1t0ީ>ţ4r3@͙:g4&A;Iim5C<i^E\\`EA\rmj5PC|m2>DGVc,R](\\M0-؎RG0P4099,~CRGc\0S&RT|tA2@PN7VʄcDAE1ZHmݫep@%ÜDlBby92GI=+\nLŌr#p^6gG&kN7ҸAeԐ\"s#	\$=˒IQ/c'(AU0G#FaڮM<\\ P	Vl`K{/2TݡTL	4)1FqfSdӃQ1rC=%PD !AyRZ.Nie\$\rM#̓ް¡	YPfp!Ig O+2	?E	&\$\".UuzIUXəJ\0@,g\$a*-MX)r54kFcZƜhALz31,:DmոŗR`\n	8PT+@/tD%\n¸ҟu++,F!p氩E[%t}Yr\$}|9( Flmx]O]0c_V\$\\\\.;zTuͅQpRg2&TsaVR1EQ/\$&ey.QK!<Tt^<\"EVD[A>U\"8T;*+Q:)(/\n)c]+8\r/ӛfB`*E絈+Ȇ#%<9' 29I6!t_.\n^mx+F	r`H%/|!hDHC\\ed!./X\"oCc\"\r\r+s#atod0!cj2[.( /\r(DK+;l&)̉x#		[g8\0^6smw%0AJ9	o.o\n87͔h\ncP+\$s&H+=!:aBH(:Fpp&\"넰-#*;-DQec8&0PЛ	A\\m:\r>AZz<J!~(&%FlvG\0NaX89bquf&oD\"Γѐco=2qg\$:0	m<G.H<niojgiJ1n.Klvlw֑p1C14rE%\"r*zĲ\$΋XfnEiGqS;%J1B/~ht7	6.NP\\B\nxB!lꎀrT]|2&?*KbBϲ^~Nwhm*q)H;&%q'1`~d%ap/l<!xJ+hr4x1BB.0Z8rNE!r-4(Y(S0L<RGs&B/!*GF!)*W 0\\z.\\}z??YszVs8Dt?&%8:SYT@*AS9M64Ax0\$bXзˁ%f3G5jpR!@'\0pSi41A0hHf*3]&.BCC3N*T.@tUCȰNxN0\rAC^̂F\"Qȸ@.7224IHvS9.TD(t!4,e,QB+D4ZOZ\n^.\"u*4M*nRJrm\$%0D40t!Νt7U\nYJQ?ooOt4.Pb./C4J[[S/+TTST?u8[hE{B\0\0*U\",u\0P	\0%C`XxZCUZX5YP!A5Ia4Z0_X@uύ\\α,ďlx_DaWUEP\n/sT.5`gKRZ2,Io7jD¡%c'v;p3\ng=%TsGu]Ь4Ű_-<b뮯eye=#i\rWC;ENfɱ.*1*\"`\np)4A-ڬ]3K\"b,\\S8xU9@+9!\ngpOː&KlFKl-oK31b:aT#\\>.-IL^&4r6\$ <~oYlVu\ngQfm'uhwm}Oxwz!\0wB1y\\*j\$֑yH2'(nGW;R7nb\0Qǖ©{\\o!6P\n`lyyǘA?uH@1B/(+epg\rE,.m'wvsnOwx3#c@HNBo r%P/%HEULLa";break;case"ka":$f="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fT+U	]MJH^x894\${]&?M3s2Ԏuiz3`̞*Z%\"xܢoJitҵTA=D+I? y12EQ~\rux.ue}2T?rNSzhĬ	ZԸH:\0'i.o.ķIă[2Hָ3Ђ\0[W-o:\rp\$H<C'or.+(dɒ.׽\\3)VD+&Ji01Vn\n4-c+(V@OPS-P2D.:2ֶL\n-KaB<ʺe+Ҡbdq-ULC:zExLSk9=~\\tϓbԵAίL#1IRʦNsfrc75dv_;(7j*QWCNiZ1P# 4(Bn0'M[k.\\ݨ=B׉L_i!\0ΌD49Ax^;pÉb\\7C8^2xώc21x?	<\$i;_ =djպ)Lđ%uao6L.aji>VzA-+q+hǹWNTk(ձ.JMkkbENO6gR9o\n'IlM\\Ҹo/5|' w>,ceqJHu?@5/Aղi~.)UWn(AtBkgY(Ⱥ6D(0lE\"bIQpoqÿFs~sc)}¾ZEJʇba}\rbߠ!D\rY2/(wS0i e:d;pݺ\"fV bZY,\0Ce|j{lp\0CtCnIyk|o\r4y d>4@\$o4őTIҁ]h|}%jP&T̖f+˙&'&+1X:M'PLIN\$e>TrƪlcW,KiM&u,]4{\"h\0;D/و4F*\\UaYIcWuLd8gL4\0ШFi\r)(t\r2vb#&	S1)7eqB<``_&A>ڈU+ƙհ2*bV.+D&4:Gʝ'&H~yH;tٙVj;g6'G;Iim42KiZOZ~JTH*uٰ9V!(S9D\$Qib \nMjH\nn(j&*\n\"WΉZZWD/)CddF3^jFl	*gy*T	Zʽx'N>Xy71\0PTI[!E)<iכZ'(~9uq#'e[R~|u=sƶd1Di)/hQNF(MSR4#/i\"#V*b']=aE28up%TRc':kVF'vktXVJPVIWsn3շe[pW7kjZթs_WI(Z+JdlQp}9iǥ'LXbc;ԼNP9\\BIO1\n<)K}&\\{nyƧ%1 Xm<	Y9{7gͣy{d-_VP(ŭ؊m\r^9:Y`RRV\$2wF\"q͹d/9}\rt\"\r*XКBaNa[_<bUuC`4EAN%\"^lm>+Y 8&s[\$v0(alFAו4c{L<<19\roR-ZƈJ8}nM⦹<&%W캀cX>d	ɗ08w(4s'&q{\\Q]U{Cd8ءfp2\0ç|ho.t\nv8M*+1_phb:0@o\r=U\"{hڊΤ]O*(V&G\"TT&ZKG\0@\rb\nc:#Bp@\rbdu&\\mp6`/2@CK>kC	t(&Dzd_\0CJmkBD8F \n`c\rJrQ4uHvh(1DdtRd ^-m^ZUV'꨺oI)^D>%@dL{GLip0ޅ,YQH,1hJ&EPm4nntBN䈍q>ר3\n'6NizE>61palpfw	Qi1	дϢ~xdѢp%8<SIHX]291\$nc@%@:̤p2S/%V#,唅etl:^KF@(LΞoqعCD3\n\"9dRM#rtҮҲ-B}'nGPhrZ^5oI\n0ĮGF\ri\r/\r pSNV(IB\rDr!4r%qο#/jQg&4S7Rk%4O	\$ҝ\"q4P«|A5*-q16\r\"Vj֠8qo\0tw*5r54s25+ҘQ	!c;\$.+2~K54P+==΅sm(pcOd CÃ \0kROq*p[\"TRz|L@K\"64{ANH.d>U-h:9	zS3NXǸxU\$q AFV^9K\ndS838s2^,s1&GOLm>!&EK.\\TnnoHQܯ<2=BeOO\\AL \rOQ/kN7eRQO&\0O!S\"EY%?ҳ@2'1G(d%8q\"q%UIUpȬ:('-S?S%|^5e5C?mlR4^#0~̻Y\$BK[<Y\"ǞU9[SY5uN3N}Du1e)t:Z>s}`.%,5^Oa-%auaт('[a\0ɞ}6C?OU}1HXnYԍ1[a*udȏbY6W/-^+1RfC>\0\$\0bc6֎i&-iօj jvi\0@Lc/k>V0WQeO8}a34PXrf4p\\;d6ւ^gh'xU5T1P6U4W r\$)8D?n376{loV\"4`Nd{o\\ZK>[F1r'=\$EuX4qrvT[W/Dsy.9<Qpvv#,ȡEP \0qpH}!CO+KwV})\0\nH^<7nQA\$HDMGM.ڕfX\0V[bWR|oM^~?+](s5i{{QH\"OgGum-\nХ	zqucroR\$8w8E8x#Fx\rpNr1\n_pVd<MGxqm6N>j#&2FR]mgL8&eK3hK^N[@&,=>N_Mǹ+%eJ5\"{hUTKjeQGа+Ǡy6Y4WOTfH<)xS>swB^QyE	GL8l[bՐ&(qp1'9HD9XKrnG51qr6\$[`,˙۔aZ˦4A ";break;case"ko":$f="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4(s2Cs;jGjYJӑiRAU\"K`I7FS\rzsaV/|XTSɇZvHS^+v&kCi=#qA/iHXElKȤ;Fv(=v!ȉVWj)qss])Kq{fv!松i<Ro@Y.H (u3 P0H3kN.\$zKXvEJ7\rcp;9\rV\"#11(@2\rxA\0:c h;#\"LsLJ^ G4T(izO4[M3AVQV7 D**>d\"5/\"p\nm!InӸBZCE%.S/DLArBl<D]LnyNS*u:L	Zev(E# -1z9|!Ȳ8@0c9=ƱrH4\r㬂0H%ɡ`@`C3:x\rpFQp_`I|61,3F#lj4px!W^St춂A	15'h\nxv/2׶.Y{?e)%Sb.RR\0PJ2@僪Z;a/4Q%K<dy2 @B 3# :6!Q:NHq2dLUY@V.\$4DCڥ\ruePܐصdt9c	\n\"dU\"esЯ?SUOu.5	AYND|Һ}wvA_^R_2Dm9I3ʟ- j9Y(\\ZnL\0lk\0ShPƄ'ksM\rR@CsH,!C-zK9 Y9%p9C0i\0002Đ|бFa9u\r.\ry)lCtd+V*Hraȸa%DYgJb@ :䆻Wxfr@6΅EbYnp/\n)gk@	Y {@'ZTUg\nT9^ nZX0c2.Sa=6*ûcs&>Az<aњ2 D3BXCz!JqυQBr%}%H%+FilS\$ILZN`%6 Ęcjc\\Ǚ\"GNVPʂHm86-_aI̃[.ILp'l&%@Ԩ3R#e\$Jf^#s%r.Wi\r,1#-n3PdO.JtZWk\r<0@b,ͧFڔq9RRqP&r{i\n*gD1BD\0P値u*h6gL@,\\X \09pje8/[t40);v#C-3xF#B'R5sehLb)	R2L6#jЌ䴗)b[YOA#38)LW;!2ku!.b\0̌lěk\"%Lr	&ՒT@!(@@[W<)L9!9XԲea׈Ą\"\0Hђ%#@\\/' VEeйT0	)E/@[`;_ĨtGM&ת^9D\nv,Xt+&.\"?O:#jB+QZR+]o2Bxəm`|2gu~РZ|-4i@ԙ7ro9\nlw٧w,G\n5 Zx\n O55(3oZXz\0C돎J9+pBP;6tͦt'(\0Km.lNi\n	ZVkqpz.5\\mD?W7u6kerK\r}KqÄO(BCl\"}6ޛ%:\nf-A276B&#FuY1ir588.\"؋\nU&ɨV\nPA\nP 01i\r(0YHrƠ_l t2x#.U9K<mkXCt\\#:1(z+\"@6///g wd%XnT(9TcS\0P<U,M.>(B\\0\".xFDx)!J\$jGrolC.3Z\$tg:lTUʎ\rl̖\$ \"hNTб\n0\\8#\nf6-ݰ:kL6Pب~mi\0j`UA.6NO5 GF\01(H;iM*/bm}p\ru.o\rF%\r\0@rڑ~1tۍXPgǂ׍hFA|7G\0G:m1,m\"PCqN~#3Q'L!t8bW#z'1JӢ4~M!\"Q! r\$U1NT5p>bj\"\"lp2%&zTaDЀ2e	E%ti)j(0~!#2&X1G5#p,#-Bw\$hR&vy\0@\rq/R-h*o.OH~D\"i1EDV#b#A6:=rg3̳3DS-5	\nq#g>ҾOC=6w0NLu7:0@{7/ړM5/sL!62:H!:!pnӦ|ӄ8hE#\r:<q6\r6S(%#1%V/|v9:	1BGq -ĜO/@%ȫ\nr?A@'&\\+B=-9	O4FóWDE/8gӫ=gFC6DR1s~3U0,Jp+4+>4U,EԓH[1rM.	`ȁD#<@:ЈK>TnpE#zT-\0BB	2)K#JX MMpRaaNlN'PO\nB!p`l~*\0r.GJlh\r ̑e%`Dtj\nZęQ|BWQB48ʎ@A26N(#p\\ƈv9B#`Rahk#7c{	m]Y)d}R:J07FL2&/-:ÎOdO	)\"1K0uPuLp@DCR/a0!3+jKgXv=I\0ȗGTE	[A6E)/4E)a'PuCb'(FM֖9S\"Ds8D5M&c~!\0Yu3.ajV/6&\nb4:.l8߱䣦p'&ƹdhS!\\v04*ʈoGQ@";break;case"lt":$f="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 t7\rLU+	4Y2?M3te>\"K\$s5Ms:o9LtuY),#)gALEuy&C\\MQp7Cj|eVS{/^4L+R:I'S=fPkʼLnx\nO4DXi:zE?FĲC\n錎*[r;\09LB:\",,\n9K7#DDc\rﻎ޲Rؼ\"s2h(֌hҌP\nh̖*B  2C+\n&5x2lĨڂ2'/(**#)#\nbz_.spܺ\nm+OT 6X7F8D@0c0uzYx@;Cg5DU\0x\rhC@:t㽬5J9@}C ^&.`\$7x#\0\roD(C>%:ߦ)V9?LТ̣,\0V\0쌏C#*P++ A	4yv`:+ڄ6İ4\0P6*PԶNL2)\$_WD#0CXIζ\$79b ӈI%\rI:cc	c,KO1sʲu\0\rc0آ&8t\$@T24Ó/bZF_\":?B}mĺQN޲Xղd2aP\n)^H6ղ\"?L2}\nhi'DKt҄UP0`!0be\"M09R\$c\\%;2..GE6X<_!Б)Dy\$<8`UXɆ*|Lr\r42\nHJaDS(d9f\r\r%sHMb8d26)f,場amŸ\0n\$Ư)4t\r	A/EapiF~j810,BA8;,Rj5gVِr\\9-a|1󣦢eM_2I}DN%MK	M%<ȰbaGDcXry],AQ72nQE7,F!̆di)<6C3T%̒:G4!J\ra<\"ܣqBLqdM(QؗGHn'?to\rg3)&'wȱ&\nN7Xww崾BUx84pW#.%yp͒pʋc0e!0q1'8KQ3.Yݩu %sGB4r\0DI	1(2B\$]R3@3a,Թ/%@ɳ%eg1%8EШm2USX4\"9(\":1:'0hQ	./-i¾.강!ꍮ4:(n|4\0F\n˗ЉUM<9'_Bd#'&0<Wp:KcL+9ϚAt<v4B1lG\$Cc 4:OTB>^DȿDP<.ɢ	*ߗyJ00PBLkv2͖v :MG?U\"ՐsՒaT(eP3O0;B>7_hk<%Mm>%&ccc/|4_DdNR!I.pl4tuasEʇ5}9Yi}Di&ժh;F8g.bu~#ഈbLgnDbKP!M\$J1׹/c\$5 	CY1HM'?L0W^ey(1KeC'7V\n!P*~\\Dܕb&.yB/'(m#&lqygU&Nk%wk<6.@'wt5ZxE~SºO+׌HCL/2^*I9LoMHg(gO53{DW~HkV'\n4 zbiKB%KJ\"`<Y8v`\"2qD\"c`un:`\$F4ȃ,HJpP(GnM.*C.*p\rRPb/ͤ/Gpjy̨\$p\"/N8q//\r,l&B.\"IC<F\nJ?c@Gġ\nмGt!LG\$3Аgb*9Fh,)\r\rL\r`uL.ɭ %<J-\$ylvyrN'9Hx7c0fI'NbIEGG:/O6o^Г/&hL/<wGQ~aoN/9pr;D9NJ2q@Ƣ[aK.L;h9KrCb,8B\">+ދ'!<s&~@L)1&_ @F#\r;42\"'b^1e1C%%R'\"f(碪ڮQ޵\r]g(&:/Cf0k?G!)1#>hg+g,\" q,P!R%R^@ {SgZ;C'Q|{mM{Q1ѭ0C%)rwO>\"mC2@_122*GS{k\rhIs02e2`KQq&zF~,dQ6q^p1\0&3Ҧ+Nj/2Y\nFE:lz\"(Bj\0S<Sj];*@drĸ#Ni+># :t- J,D*ΰO,d?-O!F3BfE@T04#13Lxd4Fh7q|:BviFcl,g	w3OGF_c%#hAFhGTRf\\1/D2q,Kte\rV\0=EVkJ\rD?n@\np`#/Qr#Q\"MX ~N\rN@\"<0A@13H<;U-0265h<]nB<:	Ȍ%V\np \$LP0*D`F0enmRѐuT0xU%]	!0\$u]+d>6ľ3\rpͭ;\$2)mBm3k9C0LHBq-P/\n\"2u%i_&*`I[<t@1f԰L`u`]\$zR'RRش*@V\r25J,J5hm.C<@";break;case"lv":$f="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(:T|i8AEh2q1M~\n\$g#)e\$:bq[8zLL4r4wa:LP\\@n0=))L\\逆X,Pm@n2e6Sm'2	i ǛfS0ƁM3{q[ܾH=q#\n2\rc7;0\0P֒c~\rx02M!Y^\\&KV@LBC%À9\rR\$I7K:s	k\r9Ĩb &pr#J^-Q(N8-cH5H(\r4(*XF!D2h:4\"郾\$\n5 gRO\0 H\"H`7-B6I#^l^.hPEXpD49Ax^;؁pO#\\όx79J|;#5#pϦ\n\"z:xFI2BmMj3C:D8&VG8M@-H%/RrK![-A(EB8>R*-(:{I\r5ݏ	|:m^cUŸzT\rw;\rI ·k:zH2C[ۧ	kôN7A\nP3rMz((#pD]6&U#(90k~9уX]5MbGXU4O~0%ßhIsXS).3l[DƔɂoR5k(1L֒\0006<\"^	02:j=Nw?!:1(i~ֶԎO\\e+wC\r4s` >1+& pw3g`:,gQst\nOA̡:GHRN1;Hr\"扑>ҩ}U#niA&'TSa%\r0PK>2#Ē aDI58˙-`\0Ɓ'#Z[78DTPQR<Eh~w%C5qLYB B\rڲC AdY\"ElҼWa,@AJYK1g-l<[\0y\")\ne4LUn5fd k^;V%,!@[a8-@]1]~VXi%t\$m-^h<IIz7f%Yu^);1,tGӱa7srS,Qr0Ia(MC3h	8Kču.<u2Q2Fi\ni\"%!8R<O @P5iTg)2KHPTAC4sIL<:(hz{#PɜniDa,gJ`&m\nī?F44jVU̠7Ahg\") v8rz5\$!!qhf1&km\"Ҵ\$VQ}7@ :J'	re®fd۝*˙/'2*P؈P	\r:Ą)M:24+0jN68\".sGֈ#S1\"XF~ P5itkFfAEď#96GH!\$d8ɣ⤌07 %U)a?	(\$fmf\nH0\nQNr怠z?\\|][\$!6:IXR0e\r\n3Pȃ)|QC^D!nPPy%#6:AXAdH!3A9\\+{pgGԦk8ycw\r_v]k`o`oX蹑AC)u4=KV!}'ҋI\"ݏ6*AB%\0007Hʈ4\r Xzͦ)0XFܜrRom:ԋ,xC03j@ca5\0QY匿uɍ%fA=bCu<7BcPZ2/>]xu\n,< @BHIa)JXT@}^TiBls#\r<%eT곖*%2%\nt_~MϪQ;/0Qf =^T}dq]ÈlIi:醼brP\nes8i?:%o}AɗỞsc_1%\r഑f2#ݿS\"(P\$((^l0s O#,}`JC܄>D\$&\"Øn`_T{Cb\"n0>jfB7r7k #/o 5\r~H4rK5	m%~C	\n),BZ\"W>if#ކj	/Bb(uI,즤Mfz,ǥ\rJ|J	~P0.frR`N\rVB<\rG`-\nH9AGXQ|գfdb.	VE1Z0|QFwj%…pApUw.&Qgdf΀gl!1b/ o|QyK1pm\rQQ1^PiP(%Q)B̑ n׮(	\$j\"VcClD1%i62DL!L!`tD('d.#2HmĩrvHR҅bN>׭dqbYґG*22{	jб,a[ỌP`tDt`?*)q?+010)'F&Ǡ11&\rzyk%-srR\"@azd)QF)rVS5G(evSdLu62?V-FpW[S'2),a0}\".#U_h\07BR@铬\"\\\$\r`@N<Sꀨ8S?(S?ί?rg?S-.-@\"I*B\nmlE2BDPRP:,8)`g4'Rd%&!#23ny4,Zo;,nbgGoQH	d\"/b0n.pd>|aqK/%4%7#Dx;@O\0\0V.b&2ތrD焚#N\np,9{l7\\/=K{J:9:*AQ\"0NC;\nZ@D)Kv7,\n0d7T'LL~ԗOUz̑8)j	#&\"DdHPze>R<Sæ!0]73'S:dȬ3r35`AIT\\[D	76ȂH#`бJ\nG-LB!p\$(5(zBb-]3I`.Z\"Rc`.<SNM^J?'=/v6M	 \\CI@svL[̎JFK	.";break;case"ms":$f="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7AD 8Ls0A7Nl~\n\$g#->9`\\64Ԭ\r pa(bAS\\݌Z*fjSi*4\rfZe;fSsW,[\rfv\$d8NJpƹiɺa6Ӯ`&s=2#*L=<Cm(5x=c9#\"\"02\r*O(8AhS9cI)\0:z9#i~#J	{H5@#CH?.\$|ŊL2j38=-#P2iS>';,0	؄>s\n'#&\rkS͡j6, =it+\ré1\"X|\"H4\r1-F 4.0z\r8a^\\PcsAc8^D9xDl4x| &\rm;̋&]	p:\"KԔ4c+*X @1/P~,	c|+*/ɰO\rPK\n,S#;i\$\"ˢ+93%+0V\":a+72Ibl\$k:Fŉ.Lcz㲋8&Nj\$>?SiC;k)KZYN&ڤtϊTg-hܮ\rl:89Ju9`!#[8[N~=UMd.3GڸjZN93\r+\"ÔF`PBba(1xь7\$b6H:BNZ73]#3e.!8Qs0K1:o*i\"ꐒ\"gfg6\$䝒d\"SO4֏2DHHMl[ov\"X*	B%HX\\%~m݆zC0 UU*\\V䯖!D7,eL!\$.cbzRiQjz1i(tǠpЂ,.k.TTZՊV[t꿉EXݡ!y\0Ə_7Tg\riS#IC1\rL%!\"Tzԉq%'lo#Q86=scyh|	H\n\0POLrnNRQL[M<)ss;3%ęʦ((EUWRwJZ DKXR#hel\0F/օ#\$6T\$͉;Dd!1ɿ.Z:\\]%lL\"t\rʠAḾEn\$C+5zr0W)ț*i+W*Օ<хf<\$xS\n䅑rbatXS.P:sԜx4}H[}!xv91EXcbHG=FlK\n]%qn8\nl(p \n@\"n=&[Ɠ	aDB0h'}6'ӡ:!Rz~SfMӑJM]>s0nNBMUvc<!o`fVjRA\r&Hކafo\nUTW/~noe(=\"\n\\'[`lft&ӆq`ie\"!!i֠iL 4sz\"WʿkOQ0Lr<OߒZ}lMpeg24Яd~Qi-M\$AY=dhBV֏Zq=\rv\$`ci!OCX\nH{5.G\0ݢg`ydx#,_JPzG{;NKM\n`nh\ncmA K#%dF	\n\rAMcCXZ9LD\$]soBb<C~\ng%RBe0\nWrR\n(vЋ\rʓ)7~V~O\\fFqV<᫢}L	Ȓ(z	1^FE^t	mlF\$܃8g:>)r\r_r	^23Oom@a2}T?2eCa	r[[*%\n-cd-pl#8l.eIacJ6`|E%/xK\\	|700^&aOΑt[ξ퐓g)@87ܑN0طԫԋ~8Z#\0K|ڎ&bP<4ĄEV&`n5^caώT,K#9	:>o/Z%)b)IaM90<g&ܽEoL/\njC,T>oqP\r0?<LPqc vD ,(5g-<\$O\n%)p,_c,Ny dc\\+@\nMxC>\n\neª\r;֝ф3/دY#N%Q\rN1!Q PT\"&*ZCl#1#	lugIb2H1A\rb-j=r/ My\rmvLr R&3DXd\r-1,D\$=\$~,\nqRA\0`L\r(>`\$}d\$Mcا.D&BmRP\0zH`1Q 8HhlXFJ6RL`ΒH@\np#-(edBl&M;,ND;b3XE@خ].5er-RcpM,k̢^I~\$J<\\ʮ!((tjn@{gX|p z0(\r6NNHF|Ce;0jhmS^i32\0.?.J@껀,S8q#3ڛbt+Ѵ/=^&\n[3l<,C#g@<XP-H\$;G*@";break;case"nl":$f="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7ADs)u4̧)іDf4Xj\\2y8DEs->8 4_F[Q~\n\$g#))UYv?!hv,c4mF\$r47e5čʰ*wEI}Na#fuVlnSoгi@t\r2a1hl -湓6FG5!uYq|P+-c1\"̴7H:\$0:(r6A:;@;C-t@;;h9Øtl(:f1t\"\r`@̺Pݰl#Kh܂{,Th)oh,J9+1\\[-c<(چ\$OHR6cAPhH!r^3:\\:IQE|Xӌ`@,3T:<^h\\r48^9őp^(&0(x!J*IǶ5ij,:[[O-r:#J5CkcA.0\0JC4h<	cz?=\n!t\re&\r<V#]g% P^+y(^C|0O{̏(l2/5iTh훮16 bQ D:7YCP݆>A<00=5.Q+? P2\0kv\0O(3(6j9kSpܼ!O|[\rz*-p䚻<wjKaX7.?O\">+BGQsm7~Z⒉tD}`tO\"WY%kJL\0` B`ׂg\$_xD{9L@_d ǪH2` *(DHbe¢hIBun9\$PІ9H>Uc*+X%eKP9-e\n3\r%QoN9|*BF孮`@Ylo唡\$\\(vXr3, ʱ1?1g-C#nZyGd#䑑vyjL:]&*\rrPOmfHY:P9\0x e:h+VGR%nVisN'CI2Mf\$D03b)m^)w-9N8\$ԘG\"H\n4hJgPRIP rD^UF\\\r!4CT_QqE3D`L\"Ĕ?\r!t\r'WNg}ty*\$@= P401.>`R(*|\$%\$䤕Ԕd\\\r&H3[K\\!I7>k,OyJ|L`:x0M<pڅ\0 -V\$VvOl=!\rfиϣ\0oMa\r\$b٬(lRE1>R#e5\rm n0\$E\$ʂ\0(E;dMIicNMI5-IF#g	*\0BE@\"PpKCdNσ-xTFHOfLt7rH0m<ꐸk!s5h~4CpyǼ}oua/f}|M\"T\"/FЉXÉp@8vґ6cd^&%jݹ	C`353`Adsn22|Hi#2vs1cz1\$<\rfL<\0!	yR.]@}'5\0`CdAi@5ʹjvڳO8@PP-s6^PUbF?uvsP@LT!\$U3'(+tD\r-C;-Ax L0p\0Qu|Zt:!Yȋ^3Tqj[HĲ\0ޔI}zVCvddN's>O8i܂O>ɹ/4Eyγq\"MF>Y}D_I\$ٻ'	CTXC\0(\"h`*͔*PB`)2\$94.\$%TU_`O!h;g,\$R)dsM1svRةhǵ_\\>wJ[hYğC8֞˝2yRӱ О,L)6D3\0RDiЍ%/#o@\0F0D}Go\\''\nc'*!gr\0-'Ht.>m\\,tt\\Noor\$\0οMv+Ohِ'#lZJj\rl&\r\\r^p&0`؟DC#i\r|=鬩#2./t&\0\nP#3\rPǋiM	KNM6\"@b)mFN?8\0aF1.԰A#i*P\rQ0ƠuzJ>\"0aIA	\$\\*\rt[gqLOgg\0001vEPndT\rc0@PD#oK10^LqpF&1J\rQ\0ئiRMa#s6TO`ύ0!gWoQJL2:( GX#r@S r#veQX1(#\"1\"͞t 4/,p2F#\0001l(vXK&@&1̱l=@mP(߱E ҙ(eE)!\r\nTN1veTR2小,m*r	\$K`|7\$o1(0d(vu\"\01|o0\$42tb0TF僚1tNbD(r@kvFφi.r6/֓\nZDc%j!<&C\$o0!awnn31`\09: m(\r^\"gss\\lRF \r`NTsV:R2 !4JaE.\"dR@gDDDdhD\"`-\"l:h&T5:-b=A4@30L(R&E#4>6T5Eb0\"Tj:400\rJ .jVrg/|NfI8g<.9OLD:!1FL PN6\"#CZ\04J&b*I%Nv,%E\"jE4Lh<odb2@ZBF";break;case"no":$f="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8G#<t<'\0,uCkQ\$cġsn,p&=&%GHi3&m'0te2b,e3,	hG#	*\n\"Z\rRs3\r,o&wÜg ahf\$A29:ta3\\TϾͳ3}u8h韡B>\n)%˂kW?Sq7p900+zꋰ8c2#7\rB&Oӆ#Z8l'C%Ld	(ڱ<82>\r҂+KنS:Bs::#:þʎ6	Ģjp7E#p(CQAI:('\rZ7<cȽB6jH|#	P1prDE<1Ac:\rx!.90XЙD4%cxY-\0As3_O#I|6Z30ZP7^0h댓`+(#t\"40K%ʅH;˺ҁB9\r΂\$H<M(7NH*,#*Gs4޽i\":5(0c;1c\r8#!	h3cۈ>	43n6i8)«nů2!ZŃ;L	\r`c]`Z9mc(h׈jxPS7:8Ø5X'#׻&\n=1+M/{85#rmq(\$JEp2m@q|5~7\$GRͅġ5Bd06|!q}2,ߨ>޷چ<\"hFb\\&Z4&ˤ,]*376z?NȄ!%3!	ĹFn%5n((`P iJ&<CL70Uu'\n1DRU( TyU*諕VʫL<7,@}Bytayl&@Q\"O))'#9Հ-l*EL!UYuj*W42HX΀7҂r'GhᨘcLR+F	+!adXu8:\rK5\$,Gk0g<AT\$6@P\$9\"\\ď\r&-D4ՇMN9UIP-0r#\0PNLqHLB_H9!)|q@/\nպA@bpʐNP}(Dxn-:кz*aeCK\n^@ PV\"C.[.aVQS\nA\"88S:C\$#ĀBLkK[ћ&TުyFΞm aDzStL2\$36kuVoșnXIPA!3rԒ	b-H3Nk/&\$zcN31>C2LiJ0Ԃ\0K,.ȓiN`qt-OIHLL0΍p\n6ó\0U\n @@D0\"SeLk90LHL+U2R@\$@\n\\F\$Bg\"-&KQ78qKdmc6W9t.` y;N}<Ȃ<.ås酜fHza!D@H&Jfl4g!uHUSVGHc1y<.޶r\nH]1Eg mӂc#s:a3wL,3f\neĖSˮY#U6IHKS<N䠴.g8wu!bP*~و9`\r2C2{/t&\$00^S	p\"\\SaNp4v\"a\0Ok|/x.w'2R^.Gg1Blʹ	`vNLxpKp͸#.NHԹ@/ps F4CK'c'QZEiEV27\r8ݘas&C8k<f	aK;\"sR}]OI'xS<17x-&|9(-s߰^wJ_̲	YHY{DfQsF%4HJOd~\"IGs^m`nF'͛QH\rO)3msM~{H1:t3ѣT\r|ϡp^_@\nk2*v0\n'\"p\0p8o8ng(N斃6'&@p>\r.,NogBFb|\0Mh0\0^fmcBh0\0ԀʋĂJkο	 dGl<,Ti>IZn(B+]0\rFH+&6\$P)f7]\nFBga-gb<uR<-X:]	mŸ]#:0\"l<\"dm\",:1 b::քDp0onsC<\\\nd+C	d XC\$de>Q-RQA2e0~F'V#3Ѳ&3r#ܐ('ls	f,I/:a\r#\0Q<Mn\ro 1.)\"\"S#	dBmm#.ג:2H'-|\0+ #<ypcw!qRr,r#(|adj6EL\" o*rFcfcaJ]&b\"R`qQPRSq@TE2 a `d|&828P<Xy.)1oct\rV\rdB!1^~;\0+\nI\\I p}X?ޣ #BFtss6fR9O0L\";?\";0\0Zj)*<9,XEܻcDdv,ŵ;\nhnLu)&B:̳!o.SlFJ\"2\"o><l,no@DYA>\"%VD'7AlD\"\n\njbu6#LC:TD&q_B@oOD2.=>*c<Y&cA\"\rHjP\"\$;DH\r ";break;case"pl":$f="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AEC :'Ik0geň\$y;¨\rfwS)3	1iz=M0Q\nkr!c:DCyêI#,d	CA2eӘFաњd	B7N^ qR yW~Xzqu&p7v\nBBR\rh01!	`?(.ǌ=%s1\n*7C.:J4110Cě.C(3+d==,2a9J ԰:p6OT&藹ZHޑ3J\\92P&P293`PÎx\rbPĲLk8\$Ep;`?c4t9O`23L\$]EN,f:>蛌O-Y!`@%Ch3:xg\rI3HAp9zmEkxD˱2183Z[4x(CzЏH9X:.ʈ.ԈKm18kx9\r;tƯ	LZ:9&L9, P7\\pp V0~FJJ0I銛'0ڋij8^\n>è5O8ðCׁC8=!ؘUIX1&\r,\r-pܚ͢T0z/:=>qE`&Cx;8AOck=CF\n8@KPW֯]pb֋e\r,l^,k*Ϙ2`\n3k56ݴrMtBH۬iH\"u`B4bm꥕a\\;#Թ8a\$@1u\"\\L`ҊC#_Lk}/P1\"`̂>\r\0=\$(zu8vbs@}ĴR12I)B80ET`71vH C풪V]p	:lռb396c>7RTv<q=D12HE',9CduL*I<ST%0F]ȑLjqȗUHQc,rZS9-e`/8ĸ:&KgL²H/+|\"RFBօp]r^ȹs2v]fJXdZUkCÉ\rZo0!qBaOC\"5'˱8)h k%mQ+|\$-g}5\$<\$(Jy-%RB\"&bM\"榝ό5>lA}be#x\n#ͪ!\\Z82/T13`]-R*2>dъ aUҕZ	{\rR6q42iD=\"bQ\"_\$62ZU!540lr%S-8j+֒/iGȞCIeO!) A<^#plizcC[2N>rRީ`Ȇ)a  .`k~t&jNfLDJ\rzqo~`Ej<fwdR}HT\"eUk7!\"r\\t̐Ka,'`\r<#H\$䈜L i\$;psO\nRsLR&(`m\$-:\0SRGBb-iv6+T i	lh͎ޣu)_\n\\ E@C\ra󧖌P\r1֞~.7̋\r/M%^o`jW*y<S/MSfluoJB[At6b첲Kkt:R:Fͬ;hĒp(Om5\\9CDw'(8P.26g 2\ryR݀=h'-gtB3d@9껿؊?((u%-2؆6(\r0f!(;c\\;ڢwl՚^x4)zD3Č\\VO:M7W`3[SAB%eRi=_(CZks*@Al;BhB:dy*=1M\\|oίǹacXH`.SGOƤ%?W_jK?+߯!7+V(Ψ檎0!O엏?/TF\0P?DkA\n5G\0pO\\\r 0\$.bꂈz@RD0pNb%c1\nҀ'`B2|^<bf#01Ю;`%N\$~No`=).l/6,\r	&Nϊ\"x_%飴\$BcN>Q+n>PKi\r>Saj~%z\$`q=zueq2MJa&\ri84if&0U6%@&1p'\nhfsꑊ=GXipnpqD+L.~ GgFj\rKplkEDB۱(E,LmH%>\\CHۑL,PABER\"'xJ)΀#\0h%\"\$24KRA%0'ރr*,\rڬc\"@'&\$`e'4%*A|!&r})*0d-ű#9\$&NN%ڲВ,r[\$RłHܸ\$URMJnFlv\$H4l2Gx+Wư&\"6\rĜ)D' 槒`d]3Z6\n#dpCXdd..C#,q5?0c4jX.abqK-ꎬMK)	{10(S9s.Q xoa (\0}~#-=̵RGܓގ3!Nb7ͅ<>\"1A.!AC<-	js\$q,\0L\0j{q:Rc&ҭ919r_4C(U.?|aE\0=GH{D@S*l<`}\0}CF1+=p\$JsdS!TK ҁ4mt}l@'Lt=:-./vasH-JtiLMPo\rP]!2K\"4\0=0/3KΆ!6QT44RraM/T#MT\$-d}#e{\\,Q\n{B#-ҁ-WU4GV%w'<?_E'8*N|a}Z--p((({\\&OeU,|'G^Jt[cBу7һ\0҆R+5*v\0+D\rV\rbtƢa*1*Z=\"z0\"ncZ^P\npڢ-\np\$cR,=*vjr\nŶp~lZ(g0\nGKhD!\0QHH!3Z\"BvpgcXf\"c]4ůqj01nb\\9\na`fn0AD-@Fov~U)8#)+4#j8ssqh:Aq#r}sGt,<f;W>;#8;g\$=	\r\n6ltgdcTW\"Ph\rG|?\0¢_\0APj\rmuQmCT#tg\\k|q5M#hVd2V}ft:%vi:q yK,?6";break;case"pt":$f="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTiC,i؎hQi6OFTe6\"PDqe0̴m,5=.ǋo;]2yg4&6ZiC	-MCNf;7bh<&1N^p|BRY7DV\n8if)b:[NL,hlI]bo7[2XOԸI2>\$P#8\"#kR߉-ޖB<\np7\r܌I8䔈jıi˾뎈 821ĎcJ2%\"Jά:A\0ꖬlK8&k*\"Rf\nRCjQkh&kK5MJf\rP\rM5O\n<`ɫL#k\r>Qr.-=QB+5.jҏP2BrIqrk#Rkh1P11\n400z\r8a^\\U\\Ҍz2~J|R34jx%\",2cKӓ#tP7<f7ꍩX7T< Pp΂ @1*6\r`+~q1?302\n\rkx:(:CO7k2U;n(\$ߎ/xٶ`1`P-ɢk<<ij^!J0\nkb/_&7grr\nb63;=CI4*C}\"#НdcV4hcQ2mh%eS\n **̌|r߈Ǿv=_(	˳\"\rDkg]8rCy_+씿\$.0|c'JyNVSRs`G:AZv:H1qUĤ*Z}LQ@AP7\\RQ0r5f'C8a50D2Z[((`~S,T7<ܼUtA*:/B<\\!f4Zz:kEiUV}VĹ0n/y3FEtqhp\$Ɖfxg]r<YLLcjϏQk-ȮD.x@Fa]ƀ tLK4ZZ!ؗ4rRK9\"MˑR4&65p XNIrbe3J9QMasfI!,1m8'!!A-rIo'P鶌H\nB\n\n)aA-C9\r]:H;/ C(t,GY\$ey8jC3.'EzK'EztY(uF\r:՝3\r|D) jHd)6}IjuJJHQ=NdM	@N,[I/G+!?-yHy:%#ENi,FIru6O9Ggy %J\0ΚAQ	2RGS&,YMy(19ˤ܋F9MAw*Q4a^H3[N+MP&)r =I3݂p \n@\"p &\\.M>1Bbe\nKv\rƸjb̚wOeJj/'w\0i	;|`Th0,Nȑgj]kp.eSOEBdΡ\")+WfEM6bD1AP@Ϧ*rqs\0Q6P@S.m}5j&e\\y+6x2`I\n-\0ȝO	72bYo`\0pSF\nq>ݧ509a`4GWMڙXNy*mC/÷\0\rd_	 c\rdrI6|\rƚēSy<AzsLo-Ĺ,C	\0dgm2G栄TRBUVU5@^T٣9͗t#ÿ;L59AF!S>P\\ioJ]7=N,]S=\rDΕsG`m04h/;y>觪r9T6g~hOӿ˳EWNO'4\"TE3IaАøeF1	!{\r,\$7HТ\r`'˯S HK4\"M:7kHS؟9GPo#~/O\r\r#G0ecU0~aj4M}5fL\$1fC\"x:-hΦ0\n-FbnF貦z',lO \rTg@8 `Ng\r̲u3Lvb2OD%0Q#8)Fou0w0wę	O\n	ﰍ-%~/Μ<9Ϊ؎0\rN\rʜ:eB?	pކ\nl0	fvITD)ԛd8E`~&f,\0YÐAD!a[b0B&sc)N,#&RޑVQMoλHt<7*٦;P>\0K*Xv&{f\n\n&/qz\"O݃{GMG8&k &4G\"ҫy&zqr y\"#H<k\ns#y#1|ĈlL\"%R\$djPQgzу\"|z)	rDT2Z\0*g2\ni'@71uQJgd- :d62,p-dm-B-j.-R蝲h.0N4N4\r+qچ#;\n\n\$2>%1n3 `e(.;4JHsS4'5=+	\r\rMjZn{Ǟ.h(q(m+8Ȋ3\nnLpFhDg7c~f/.\0pc\rOkl\r& Df\0^\"'Lr0`J*~\\6Ȩ\nZbixeBR\n:% @B!JTTk{rN\r=^W6h\\E)CV:h-#F\"xfdatjlɃ(Cr&I*0\0QI*UBh4X7ڃdfrޓJgԄKlL#,T.>B.4>8n\$w*Pg^)\$KGN,^pxe	}v2p 09\nΦIfO-8LbET5NH72FvݣtPl|D@/4 UQ2aK/9tRM@";break;case"pt-br":$f="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rAscIEGSbr4EcyUz0Dqe0̢\n<miiQb4(&!Nod?S4L<ي-L,ݒq`S 쪧(o:\r>yxs-s8kjFI{Ct6}c3ܡ\rê:8lܛɭ@ҏ;cp͸K7`P85x7#9\$ ޲,nâ:t82#83\$.ꕭ,8k2R)Rb*NCj|C;MKh΂KjBʵB8Ck)-#iJЦ`Pn	{e'XȠ\r7Ltǭt0l*#9[҃ c410z\r8a^\\U	\\z22&x@͂V?^0ϔ41#tPBP[`ܴ6*L HJ7ӥ	/B:B(J29>SP7\0Ѯ3ԈP`	X:뚌~6lو\n(:\$MEU\rh	22-Y¿(:R&<cZ؋1\nb4H?/)t%JG7a<B!](CB(WL=FdѰ\$JM\0002:D0C/>(8B870!uWO>8@6Օu%\\07}`τ|eAmܟ&CoN*TҠs_̓rXa:d01U'0Py, UjyCfi+!˕B9HDk)7h3ZI¡DxK rQY=h5w[jp/&zGD3NO}ny+ ̤G}TI8M2,5adsCO`dƴZam-ڌ#zf	ҺY@Ɔs(<0|T+#BA!Y-T8v95d(B W%S3(!JBma5J:d2f0<8 9/ʸ2I)O\$ׁ\0P	AZZAG\$`yP\"XS6ĻԞ4C-\n\\tU&\\(E8B[C15Q<Me{]V1NڈHR\\;;\0gZ3vFdoȰ!0yEN)6Ti4HHUPQ@Sـ2`L`*P͉\nP)irϐ@-%\r̄{qlU\$Ce<E{H<)Df+Nu6ʸ OA:>{.#q'sdI\$Qu1*m\0Tȱ6Yq@gD&\$Jӈ RPMGALEQ2;dTLny\$	?=P\0\0U\n @0\0D0\"f7<Mfɼ'(*ITK	sl\ru7#b̙VR8+	CzOD)%(Zp@4S j{\$dBA^Հka)}	+LH{&mb|HQGRr*fZk~P<(<X\r&!C8g)7@YMI`ȖySk\r?:=aXiȡd#2}=]'#a;rTpM2gP4fٛ9ZIU-ѰMr wɺ\n,A1c۴+[ob|q.e((LFm\rh&\$&zFL,F]	xہP*g/U`EE)C]Xboe㢘N-e馇-S݋A,lx mgA6H3)G=-)t@箦ؐ'ewTEh\\tӻ_/)I(t}\$4xGGP;W'iiar6	h0r<1@[[4|d[-Bl0Y>:\$&V^Cw35jYd	'&ś5c'dfQMAm\$o5J(yOϥ?Is~gW&Ҁ&8m#-D0:,3/XH v#6`f -\rdpT:p-Ƣb6~ff83k/P6gM(ʬ.,,ɣE\$	#C]	b6u_	0 A.Pп:;bV8|xꎊCW.#gn5.	;А/	pM\r1,7f,&;̾/\r̊-\$_ɖb#\$4\0o*0cbj0\"\r吙&7\r-441\\f'#@DRM珖Y|#%L)@Ͷㆦ4&\0	0\nq*p r2\r2# ֆ@`\"&du2,h#\"g@&dD!MΘ0Q4GQ7&'qW 7\"<B\r(l\$&I +b\nRI}#`E/(QG\rB`,#,,ѻP(Bzr.r!3!0r\$0ۤ(Fs /M֚݀7i@Ga2m2ȕds>;s.hgm4S)0M(N\06r\rq7R#\")r(#ӆ\nvg2?\$'3x%\"7r+:S11Xր2 O2nfyr8]*&RB#	76nfF\0eѪ<66\$|+9n>8Sc씣\$\rVl\r]+R5`Zm\"O%'|87 Z018d,Q!>nBEޯ5B!Bb.{\$\r \$72R\0(ODJ\"k#aDH*\r]j3mNpB&%>MF&t<dA&\"ԇd\$fQ#N70lx(c#-;3G3`Ҧ&ҕ*F_!SDqSTE6(BKQD PBMpHB\n`p~&olA[H:!FK4&IVM>/8_TDL75>Ƶ̸f\nhf\0T<b]\">3MvM";break;case"ro":$f="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9\r0ӑ@dC&It7AE3ed&3IrE#Q&(r2NrjEDj9M 4ݤ'LqL&V< 1my1&A.Ś2ȦCMeyS\"Dbg3BiMASM7,kYF\\S>t4N;g竔sgA@1B:޲IйlKp9<P6 P\"5xפ#╈{|6{8.*@c2%b0̺ͯN#^8CJƥR`*	P.F)CJD(0pʰmT9BM P2h::˜2Pí%>KbܸQ)% PJ-nҎ@7J9&cpʻ9\nrФ+<tG JE\0k4bń4;vR\"HÐ4410z\r8a^\\'U.#8_]nxDj4#2♎L\n|nW\"h#\0޷bFdY ӓ@UFΣ<C+sB3(\rF/'B7#s#2H먱(u#b 3lb;5c.4;Z,K\r:ʺ­ҍTlKΛ1/J['.C##r(\0Cƌo99,ضkE{㝭1TndE0\n~Rf6C*=񼼾#(ȿͼh#WE^*1#r2E\"DaCjL\"e)!7L[u8\\ Qa` #^HHrcA1\"V#R\rpJ<40c	Wp\\ڻ/9FQnQh+`1lWD\$>Bo<*<Co.rZ8fW9V8#QXT;0 WԐKAL\\@r6κWZ];5~ _aD\n[t@SP|NŗꗖP	跮d\"	&GUcRg&>GKR\$3%,]Kw/_2}*X	0\">ŰBB\$*1BךR1RA0P\$!yJ+TC~2h3L  kD:WT靉	i.s&;Ը1Ѓf<1.d}\0@ ;5ܮ=L4DPbAK7fûMy,%B[Kyw!! F oB	i^|@n!	nM |]2/k\0aL)i>\rzv\r\\Rrf~:\$&dԅ\"\$rK{d 4+;NݛYL4Y/P0v8ihņ|ux\"\"\r'Wh\r&XO癅0bxS\nϳ72LE\nx`uIfLu);R,,d	9\\DJ_1?%0fЧ\0)!P(h \nA4 3]bNJj/HD<%oIҝ4qp89[QN'FWatjYg*&oEТclC:	왖ak	10Ap*\rUZ\r~n2lYUq*6\"BbW{@7^Hf`qAY\\پ̔\0uCOt\0J&J(ʽgtֱzǊ*〥Z1MA'̇!D*̜U/\nq	lHu~@>nYMYm2uos5.b(tX䖀.AA&p@e;.a@*f~apս	x`A63zZ\$#դ9-XN_j'j#ӁIJ෧_ǳgTzh @BHuWysAJ93in4^;kG̴tAEEҡ1 t\\\r7y9'<DvYC%6	;\"}-໻u_BZFTL /VV\nk02\"Ka3	=ϤA?{5\"#Ȕvv3Re1]7QC/XOƹf4Ȧ'o<V^E :K4+r(\$&А-eBI\0bR&00&G@5+nDDs&Q:Fk-84,m\$db0t~g@hPVSZIELcLktO2e6P\$NP>2jFT\rFT\$U\"T%TU0>(Vέ\${Ђw	\rPN@pR{pCLzlOf(JWmyq>'@#noF\$|4o*OH1d|Aäd!\"xLh	̃!286%n2{QC/P@1E*\\C?-ƨWP)`Q(V>,f1 .1Lg\\\rd N sc4 [!mh4\$,j*N/WLcQMkx4TfXs1Vr[q#G@e&RtPgWgsOp)]0RhR~'VT᧐@\0)l+CZ2b@3\r%pw/|ppw|fd&5_FR0+}d2f'72@3/?f&(8/.,~#~v/ 3&M5~a6S1-6\\~76!w1/S\$A3}76\"493_9a9,rR9i\$NNVPi\ri(1K`Is'~cVPS3;D\0,\"寙&4ӋK/y)2WA9<FOC,Hr.\nTNiA30P7DRIE/WFFBF%`1G|h9\0nrVFeCƛh tI	\\31C6WF55o(,4W%B\$gcJԱBKnðj%(\rV&_=<,jx\"\$EsI#ʂ0f\nZ:\"COLh掳Eo[S'&5Bb!K!zb gXdQM	8f1M&Fj,ls@~1'9vƨhgU-JD6TU\"Faf,*f U-Vޣ\nG6U]C]\$#^D\n0j]^0+_5n^n';5S_,҃\\\"fʀqMkjG3dx8#Hg@QSsO\r6P\0S	rfjnTRDT2u:FX!!&wѶff\rb{\nίf\$R1L	\0@	t\n`";break;case"ru":$f="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4Ըh/	4&Y9ڡLQcQ\$c9L'3-hKclqu0hʮsizxr#^3KB!A%X֡PTB/G\n>#=Ii\\\"\"\$=i9*JQI`=I3(@n:4<){)h4@F:PD0\r\",fƨIo#4cA%!1c)x%\$*J)G1ۧF딿Ɓ^\00Ŀ̂8@+hڢ-*IO2=L9R+!',' A02!\r5=!q+HNȹ&삔\"]hlK-<.H1(Ռ(ғ-qg3lJCDP2<(3bhHhFT@ ū@,FBSR%k9NMLF<-3\0'ξ\rvB6#p9R84LBt<X=1S<[TG\0x0Cb3:x﭅Oap9x7f9K(}TDe\n2T&C'x!Γ\r4/D.ݱ!oˣ̯#*z@lZ'9Et1it.c^!(ɞ.	0x\nL85Bϱ~Kb@Ilu}bIkcVaWIQ\\JGNqWE!\"%43@V>^PcO:~#]\n'Rһl\nU9Ը,T4@dWc.+x9Ȁ4QhAL(Z)\"zHDZw'ɕ*\nr)86|UO8tm9g חchitYN1!U،W 3R94\"\$S&Iq!*!>D	;<e3]GUz< 0d[pa>l#DQ8JUN啈HTuPanG,e&J]RrBeI\$b19AB&ش1FTP\"J)#jB+eN[a:\$fB\"h !v9Wbđ)LufodŵRCf/G/\"\0A[T\"!\"3DxmrN p	Ғ e-%!:d2T{S&uil}pR5J5Mdl<\\U.HªR1UeYBUM+&IuV	OeBƸ\n*Uv'ydQr/	UQ	mW:`ժ<N6sVy:əC*M&\"^ҧ[`Mtc;Ki=6[uۦ3h7npno=_{\n`v(DIʠi6?Z''%CA;iD5;Lf\\ZRjY5׭alm`8s\r6}\r*CIJ6CبMerf24ED|h*.&_^F2lo\rr\\%gæ4AR֌:]!\nE`Kq}5wN;Sc2dii_gN.2	@\\q\r2*/VJ҄7^̎{\n()-偣@<w)yե5^xHy2YE~3ϡ:0b(bZ0F8yi|DHS}%khF]]mA9Wt*DvzmH\0C\naH#oM<ڟچɦx#I4䁖qR}[3B?j]jGi٤3\n3ʘ퓡@J欠_c.\$\\+O⭰9I\nnRm [\\NuPhT'Q\0P	L*D8TPs¬ݴQXDE:鞷Szݻ#il3މXSJVR&I\\JCP7ObV}&Dギߠ P(*F2\\\\K	&J2\$;[e6cr+'j-u\"RD>ݦ?{b?r#?!C.;chqD6_f'\0M\0H>ĠĔA	)`QE\n-bE#ENt2B	\\HD\" &GtMVbN\njB	\04LH0,.[KG@t60hJ\rFϠn3oB#:H4_QY;g7H<W\$c`R\r\06F3@(oZ2dHuS\r\"m\rd\r܈\0\\\rV\r `@\rr^whl(o+S\"d'NMFMNtlVϔ \\?[P^O'1Ǵ-KĎKn5@w1eB\"eNj>QWF|L[ژm`C0|^ \n 	v*@.jh&d&BN	Pj Gxn[\" y*q*Rq7.Ap*BOQLrhYb01+k+n*.,M<\$B5/:y2Ң!q-2.rƸ# AhjC <)̫gx'3-+0,2ͯ\"3s\0Z3>0UK>`,ܐO/Sx&*SB-^2bCC2AeЅHҧ+#\n\$oWdB_do:*eu:):nnNd_MD}iTsc)\"\$cU0֥%bn>%E낖F30qpIO621R#0G\$BP1b.G/BSA¾奍T:-Qjn<\"8	t#DţC.EDYFtV9oBOҔQ2sHYIన`H\$M(gsHUF5+LG \$lI\n`ݏaF\"/ދmFЁ/Fъ3l\rlqx\r`\r\r Ȇ#O5MGYQ@xe+N[>~IG6b/F7M8BOT=!TTjtb4%U?UJEN3\r7t\$*>Y#2ɣ5H2XIO(e8/ȄEGrT	'/&\"5([\$E5ڣ5;jO\\a]3hArXCO6U^b^5v_Bg`&[SBё%T.gKc/d1cVKcqVhH\"ftu`DeȬuld0\$C/cyד@<mCXH\"TP!(~r@%}lڣe20aLiNrIB!\ro(qqqK,mQc\$6+`v.vELEkEG4p'qUq7#Gv|}	+swHބEqw/Y՜>Yb54\nئw6etW{1xX1ouRL8 ת\"'uh23?.Vm:ddshag+G91YF7_W0I~5ʒs}yBWoP\"i8v}5G8*AUt~x ;טZc9o(nzi>0\\33=Eշ5Ʋm)I@񯅦nX'8NXujxxݍ\"1SX=wtŇuXD+hr{GM})[I##4Gvf.hxrCuTg&yBQ;2WVgVx	@EQAcVA/\"-f9\"&+cE9屓y)1yY8\$u\\[\$3%8{ߔ\n|ژW%L#*W{%Y-t%-Kc(AVA}Pu_/Ԑ{Ar9T#|=,I-XjZv2vyaL&C`C|Sy5&-bg4Iս}P+\nG5GR͞@-;/r]Eu2!@a1\\pn\"Fx.ȗzW/`p56g\0@\nqto)*bץ_F~~\$ؖëy^'OXIt&I=Nc\"'%1qKJV<m⿯K~t.Έ+O3: 7bD##g/P7ZoъLA֒!=?IUDiUFu7]gM4d̷G;>w-vYJۯDlRE79+dFD&c\0uA\0<*kWAdJBlR-h[&(!y\$\\M\n{	-pe?UaPtK((vy9hT!|zzs(Stgd'cxH/lM@";break;case"sk":$f="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8U\rZv0&㙭'(a7&(n1!%iAD9ϡf?BKe|i3fRSzi0\"	75d%Stiы&KuqmNemB~Q%b	a6ORj5#'MnqoI{<q\"7)RPcC(p7G)B,CXԦcCh½7\"T6<m1#Ȝ2M4@1KZ/Jj\$2\"J\r(\$\",jiJ',(Ǎj(椲Hb4*ʐb\"PHsBʏcMP9\"3܈(6*6Jj9B:2е&P#\0TbQ/!\r#@ؔpL,\nQ\rCQ,+# I1'Vˣ\"hQDyL!`@!3:xoMnAr3h^80xD͸1\r̅.|˜X<.-\r\$7!\n1@18\rc.(Л+(OPȫB(KYl<j0bC1%;փ/Qȗ&\rx{;r#pbQdeRCX2)k2=tȘ\r#5,Z⧼Cir4\"q`ʘ\rMc\\.&WÒ͕@Vė\"70@XB=cpT\r`a\r1_sNk#sɊjnb(*#J6<p<}1O+aXhu*+<0CT\rP9!Z!\0u0P@%e::v)\nWP7s,Q\nE!6PؠD\r3 HBxdTJ\$\"vPq4-gŎ3(sJT2B\nDjhjWR[Rd*r2Zx\\Hd-FDԍmuQGkȔu2܋Gdc`9q8\"%+	.fLTDdʣPAgT#R\$)g0Z4VrG	j-e\\\\.UκCX/X,mX8F5|`G68,س%Zu)VijDs-2N;.\riUV[piaBc:r^%0TP2hyW苑VXoΐ:\0FxfrtO'YA\r6%1\$7귝N+ƑCIDP5+rBiy/0VC];kӄQz7G,q \\}u@`RH(p*nL=0%',QH3	Pj>Vľn!\0C zI3fIšdYh}@bS\nADJ\\iD_a\0=B%g\0\$dDmrXfRYPZ1ʉ葡\n\rfI6ӣ=mܗ%R D;1Kٛ;IQQjmf'Nx \n<)Frx v]^y0A־jAJ0`3|]0LP(BYn.E`O\0ø\"@\"6n*\rG\0_/V@1QV쐄0nLk&\"\\`vr|ߡvr4E\0ƅ􋻊밎Ҳ:ӑe_\"<a5|HA<sW=aO\rz0L_Xa2!XLh\"#\rc;p	yяCWU>h.iPIU<xP	WJa*ףBQPORv&=\0ts\n`NS4Cr'gby:ACVq\"{LZj)h2qˆ-&Hhon2p=\"9\0̐Aoa4hU5\0cԯV7:<vz,,yux%A\$r-O˂i\$vYI(hODaKe\n}0˅\$ZblH\n@BH]Bq}y-\ng 34[=/~N\\nuU^9Zg,fߓNۻ!\\l?R<'N)oȟ`eOs X\rv\r(5IPuoH:j/Dr6p%j/FIY0Oq\0\$DJ&qen81\":\")f,aUI~ ĲæR0p\"LK(D*#d\",EhY\$0a:bx\r&k\nF.Ke`|r6lA A'.eBd\$4/CFH\"^G%\r\n:rC@3U\"^!͚PMBh1 9\rH5C*cgHBA\r\\kc6'8 2?\"//&Is.t9	lBBB^/XN)< س.\rv\rNQx..@,p4wQ)@1SgtF6͎ڱg!͋	kP)'EpQ!'P\ra\"/ \0?m{at#2BY͗7xBb&/RN4rUX\"o&rG&<Brp%z|Lr,ĠndL*W.y+r2> 2+,d0`\rFN.mo.,ҤEJ!4'%lچN\"%fg.}0j҆Ā#\"mLwv6{la/JKb>?,*n-fN1E7'hƐQΆgϩ!{{*23%r!sg3z,G!cӍ;\$\"|ym-s?n';s<C#-#âi\0#|{r@EX5*B@#qĄkq&K8\$RIS{T<\"js\rx\n(F-9b? D#D&b< #*\nQ {Ar,\ng&4{CGt-!0/4H?#IGE8TE8!Ks<-}J\"iTPA4ri'B-M;Ԝ\$4Hq)HCcR4!WNP/P)BCQ-4Ć\$4>U=R..RM:tR}KLR5F-r;QDRuYL4;K:\r<3@k4c(nk#sJ4\n&r6Jbt2fuN@XOu#	:srQ\0Y=zo9zΥ\rVB@\rc9cZ>rYzuB@\$9o7ı*S*?#*-fs2`\nq\$ҳUϷYud4O&{e;33e\0\0Q()\"n\"jF>t7Hb6.=0Rv;h~l\"ip<IR.̎Zlj(Dlb>*?ʚB;B\$Gp玼s똿v#2JgP	\"qjR!HʮAg%M;71ـ	52W<3za@Dc@@M;q;6xH%nGMup	/sLto\0O-r\"V\ryk~`5Vdڑ#~i&W&BV\0ܶMb\n: ";break;case"sl":$f="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n*!fPsSYPaDqa9Ύr\"tDgNfoBAoB&sL@Vdk1:0v9L&9du2hyr4\rS9 դh4Ε܈h9\\,xAcFQ =ptgtfYyS=bX,ģ)^+Nĳ\npǎ`9HZ|2\rjn;c\"D(A6\"C%cxȌH`;	#IP#';z\n?Pʌ#	b)+(6J⛒<D_+\\\0D(.h0R<H4M\"	;\nԈ6g## q,#Dp%n,\",45D[2D49Ax^;sG\\{ã?v!Hc3!cj64^0h´\0P7H0=1\r:ֆޢ0:݌0^t\nO ,f1\$*4+8*\r#%s9>HP21;:|6}\0P:;C :*%0֜I\\MC87uFq 9@1\nbFKh93-|Cɺ܂z| G6!^(=N#MI88,K:>.\0Ō;\rJ<W!t4ܚjvAXhd+Td6z|!3&:}u\$9<!ay2܉A{vA(Y6	T`K!\"	@y[A<'TҜ#(Jb0܌ u#9Fn	+z,D\r7`9%:jAh1*6\$1ZurX+\rH,ep/B@SϨ7B\nA\r(\"Bbz)+F<;`\$A4芳Vz~ಙ\\ՔTV]+|Quc%i> C`?4qёAt82Dn4V^LtX%n?tJ1Sةc_eDf)&;\n	\n`2pEȌD0EqF1rEB4>P\0('`O7I}%7Fv.MTD7y_)-P%ۺB9*!6z12*Qw9ή8!=^AQdpF묰Z&DJ\"tC|\$𔐂CIF@V80Cd#%郒qK aבnFg^fA:\$r{TPߡ{\rI%Do/O\naRG6W%΍=#\\DrENڦ\rOX+4#J\\'CrڰY2egxZ\n>홾<Ѩb;:@~忲2`CFWG	M6:QO3C#-\"GKd[S~O)=m騯D40J>/MȏbW-\r+ J`:~kܘP\$lJ(P^Oa0h2AiRrѻ,1;>IQS3l0PlÒQ	QRa9pd09:A}+mH26H|Ff2wZif\n#JbE.vH70F7\rp]ߐ'\\CR_Cw; Ǯw-5웅+m2׶bmzBpfPʦƪh,Fj@	4T`T\n!Ae*A7I(D<L31T\"KFy/uZvH`e=qxvîqLjP	]|yࡏ^t\nB9|'.Tos.9ab#mϸ!gF׺_57;]wheWph/YNwB	n-ϩq^zۨO+]d47ߞS2#Xǖfޣɚ\r?׮M &^܊=;4݇CZm6C0q~A9j\$YZ\"tb!Ě`QֵT)SG_۞f\00f0B(J^yF~Վ lhe\0px!xdLLN1P-#PÌ,I.E: f\\[p\"Mj=Txd\n>1.tDC:efZ=pQąN<i\0B\" \$c&1[ư:tɓ\r^ꏂƀn?P.9KCӐCqМh\"\\ %=@f\0'^#箦B.\n%n5o:1Q.<\rQ\$^1jSn+j}%1H%K\r\rÿQ.\0\0w@2R!)zN.:T:ȑG)\nf;&FҠ#(%R+fAcLQ1!BV9p8Nl3!Ne-N`Ivf0P rg&+\rrhp#0(`&1)	PߑɲRF'##(&^1]Ihu,pB\rc`\r\"]&(w!).҉'q`0fP.k/xG\rfmr1{Ҽed\rghp;3gf1o1DƓs3R.13T^YR72R3seҖ6C~_ij|eD٭6\")\"):;@N &R-dņ0\r]%	z=r41=C8@4\0M(De+0=3VN2pQBB8z`4^̂pT!fTю1QTf7OF``)]F)GkE\nrCbREI%In>p9teK×LHoL.Ha)^`Dd\rVu`}âD˲zc\nZ6C@S:w%KD#Rnwl)k/TBu>xc@\nC6S%\0gcP@M\0<\0r!\n+XʔT5BDkZ&B\0Z\">pH3r0O(p\re,y]/KTe͓]J2o(p#~6Ci9.QQ:u`	&mF6MW`Pʢ\\&\\d<g#OZ!T\n2a'J\"#-g&]b>b]H-B:pj 6̀El\n@7<+M֚BIH";break;case"sr":$f="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9C\nD?!G: 'a%e|Dqe0̢\nm=c/\"mF:D\"Uj8k:]\nHƖHr9a (h_(әHY7D	Fn7#Il2̧1: :4c41?\n+ʆ4I(k+<F\$70)pE0k/쒎x)H3Σ˩ChH2xKʾ\$1*[;\09Cxдc @5\r;\"N5hS^\"((9\"))96[xQj)R1)-)HȋM\$P(#R|NHNUFlĚ4Fr\"BU\0;qQk\"R?GJ[&Ԗ1wR!tOJ^\nCbB`P2\rLD6p5#q71L\04NNS2\0yC@:t\\7/8^2|9s^+/4q/\r7^0Κwr\\LhȪ\\+]U/	H,@\$r&G;YI{W\r2Hn7aH(J2\".(<?o\nh/J:tUYgjˠă,MҾ!GG\n(0d;#`2:H1I	#)6Sť7atD/Yؼ\".\"&Zzi2t9DGF'wF쒐wYFtalY%D)eBHێ\naD&'Vj*|d<1mP8IZ+-v78HRIn\"C\"񸊂5!3S7K\"W\rY<'܃\nNq^00\$rN!|X7#ʶJ-<bNcT%m\"\"\r[يqhui>ae ZsP%90i2Ȑ|i>	 &^KAO8(e706X#zXa!3i^P7 :f \r3Cr!35&r\r\nJs%ebf%P%SÔa(/yĖc2/>z\$d̡2\\ك2\rl3VnS4- }FZR?n-bVY]F̲K2mJĤ\$mY&	>Y=cih<\0gӳd%vRk/f3&lgC\r:IiAXث?0Ǭ.Ct\rY&պFƑa\\h2<A`m1#\0b4a-ϊfg3ɡd&K,MA\rcx2PF̰;(BRPk(r%\nf	|WpdP@@P)P@\n\n)QVW(%<7Q0Fk>gZ||?0kJ0(9]_r:!-SCq`M fc8hIYi4Wč_DrS\nA(\\D^fo\rȷjtO 4aPdF?&Nq\nFyA)䓀DSZg*UI a\\JCzk4A sgË`3%?hd13EiC?X\\SP	L*\\E'Ewִ\$4ٻhwuRAd\rĥ0h#(ȣ0lbH(n[2Pf,2 A଑ن`rd7DכC~o4A%,ٞCld;YDRp \n@\"n}2)ijsE8X\0D0\"K*XPwdjzQQĖزk1XbߴP{&j/Z00h'4jŻ'uC@òȾ%;SЭJ-oK8=0O8m3桩.)αoI\rCR\"cW6#TtBȯS^\rIܼpI\nU\"\$v5D`Mr)\"i}<?}zJvCӼr;Oߵ\"\$S{1:\"\ne[\r7_ES~]ϰ2w1[ۙbOtޑ<.#P(~Y@S2oƲ&&z˲n۠k` 34l\" N0K)H똇#WG(%ZѢF\\Z.\$8M\"V.pG`\\\n`K`M=`@WT%eJ@Gmg\$<0n{#*F0d&\"'(&:q\r80D`c,p,em>ms0ƅN,=QʝaGLBZbvlzbP]g]Kq:?cP0oI̔8,&#iQF\".뱧	_\$K (v)7{\$Y1E ?>(41?'.\"\0GH.{\$,(>t%2K#na%\"0)\"0x:ŤFB&o((.#''Q;s2o<,+oXz(%ڎ'E*R6b4Å)n4BYa\09x\$dð7Q\0-BJC	03R21O..M@,dZ1)Bs1\rK(\r\0`w@ڕB\$e[ΔҮ'qR|\\0s,(')A93h(u,Ӥ~9S;=,+Hjs\$s,s->S+ë=od?ƦQ\$bCMoq.(15@H(;@ACI01<1BS@ltTSAAO۳PFKF\$F'kH耓)CPFv\"?;\"pX09%h3F!f;Jb\"KGXqCHN|T\n\$1.6˄+;<(×LιHͳI~)\"CLOQ&s@>rn48XQ3HrRSHSuI!L<t,-NDT:(\0CU++p<1ZCuC3VX.U8{\0pCXB\\V#X`/0XEE0B\r\"'H+(q#'7QG3O^U?BHNnM%RUBxlfVEJvYa1b	D8omsuUZYeՙGVW5YuG`h^qnU\"D%6['T/4YtUv7vS4e\$YmL~\$jbSp\rc4,,g0)\nּ=Vw*~mm`lKYp'l_p+D7hi6DWHUp2)pGU6y\0\$:'WB8/<CqV (XդG1%W>/Rauq+duQiri/^C0#슄EV@O46d\"h8BC3zzNJEccWж1lBQ9p,0~6A:y~(UEK nui/q0\"+]t+b\\ʏMk\$\nZ	FLG{CU]Z4!\r1%zZTTBw^ÃtcYKOW\$-쀚\rUo'0\$rhWXTʢwKmGE/*Sc`p92쥂0[&EF0\r(SNVh{/(dW.n-I3~mH+oF8EVőGBKy9*\\1xRǝA(ljpדƥkS\nl9\$Rnn&渇}'E6iN%^TàQ3{!A\0000@`_oRZo\$/1@tޏh\$%I~xLmHsF\"qDyqϒ2V5Y4;\0ڠ'y_ɨH;8\$U7@zT";break;case"sv":$f="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7ADqzn\na!CzkDqe0t\n<pō9=N7'L	n%#)HrL×3|+f-5/2p9N\\C*ĝ!7K\\ 2Qч9g6fs+ϦuCS7OenTޝ0֭	Zb0kʌ \"0/Crp2\$Ⲿ64r)\0\0@1J:e#b9&(\$D\rH@)0'hڳ dlcưP1~3#|'\r/H򖌣kҳK+:E2j6P\$܋cT̢\0P\rJd\n6\r`&p16tD/(]&E3\r\0x\rCC8a^\\уs`zJ;axDm\$ԎT\n`7^0z6\rNDӊHIè::Ұ8:]c#;1/70JC\$ XLN\0PXTA\"\r3/Av DMF`PInFs6 :s?Tʍ=6˛+ABZ}í9w3Ø☢&\\@zK#%؎S4O3L;s+\0N3rݤ)S4j)\\Ȃ/7+	#h5P<tk){w4fXhC\rFMpk[	=WfvD3#/FJR!CެN!Hgw殌qx;#0W<HFܐ0Gb\r13R35dl\0'hdE\$#@@	R25\nrA6y^)`Ai\rŵL\npaX؈a`7Eh+Q8\$,v|oa	U`VU^UV;XAEV8t*f(Jt~Db8	'	;PȩU;'!yce:+ElҼr9,6DLYK1Иʠ3|//\r !GIʴT:ED	 C7МR@@rQjbq5QL\\R1SbX!ù4k!H\0s/L3bN]9	}d8`xP	@1HQsH@2PPK!ϭI9\\Re)\r7@RK;BNR\$	8O2mOia'IpA	HfyKCкNjEMrF\\KcDS`HDTF`@L\r#A\"CĒ%DMD9I1ȿY942X['L k0u`̓)FEEzo\0hL2h|xS\nO#9#4\0&1HK!Fɇ;xK0K4 ZzF#󬛐	'7dp#@kt IJ>vz @a,3aHI*\0TH\$pB	H*@v\r)#BvDSjT@eי&YK5i݁WԈ~1t򧷒fF23Kekw#WX\\.Uqjh\"L0i9}\$b\nLZCuBeE\0/Dnl΁2\"7*\$ȓI:JE%@?E9^E\0u2e\$2I(s\r+d:BtP\$&eW-+/]\n79>ϥ.rCun/`1F@PM!/#Oj{뽤L\nnP]p p04d;KrD\\NI/T2BP贚xF'IĞ[o\nm\\UEJY(fvq\"hSs\\'&5{?G\$9VAM09>Z}3snUyȥfkVBԘHK:\r@6ǭ\\𓄳b%\\h,_R4Ƚ4{Y\\=I\\=teC2&h-]9FN)ZN_*Nb5|/q.9'Cy|r\$NzYotӈmԏ&f%9@10Ds_}&gJAKމt+؀A\rS]pj9-\r#9q-\\O9Cjl`!/~[\0쒐jV\ngh26;åxmTU2Nb&o+lkv	nhg(&djrKN(km8ɏM	B&pWpi	pLne`ЀKFԚh[\\,`؆	\rH(F#Gh,dSBʎ2͕\rpMJ݅9֯WНcFR^JN\n^Ls=\0e\$=S8s\rOҀS_`Bd\r#89pּD !ac\ngo6S\\fÎ7-.94e-M0L41 6)Qwg3 lWm!mC'\n/Rӆ\$	\n#I2#/]r^b3F `ʉchm@S\r>4bO%\\T#8Eȑ'A'RbMފC'c-M\"qGQM)lb!p2)G\$)rR1RFIqh\"\$\0\"*jD@7b}2ɒK/\$/r.o`0L\0/#h@qN &\"fG24ɠpRg7̙3qP~\"\\h(>ܳ9208C>\\bs/ș7\"D\rV\rd@O&L뀌0Ð!3\"j\n\"d\$n̘\r+uR3O4k<^4ȋ\\Rgl\rG\\ϕ\"3\0<\"4D\0<%:Ț\"7>\$r4%Q?FĬS!.mB5fuǰ[D}rh r@hh&G4eHvP;PHg[hNO ȥoIz#d=82=D>)T4DP=N4dGqxR}V\\\".(`@e|\r@";break;case"ta":$f="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8UUɼ_ArªZ.(qg+S\\+5~\n\$g#)eGKN@r|,F,u]FdXGiSTrP+_5ȕʙa^i6OCq)Jj^E.Q@+W@J,W(I{\$#x\r\rx@8CH4(2a\0\$ :74#1EH%!p#%9nҗ@P#x;j\"r\\K<<2Jj2t81Pd2Nx)CH3(Q*ڒŢ2(7L(\npp@2C9)\$o7J: 8Ql9\04xq\$Қ~Bp7bJ29#xܖIp,37k,)u*L@dr2R\n8㘨934NE_Xa(P)M\n2	Q>a>\\ʻ+OekԼ87.*<2\\&Ճc\r03AZ3e{Tc*M\\3H45\"Ɍ\"Fа]P a0t5-^L{8l. mP][W#f9V1<mN1U!\04P+2\0y΍\rC@:t|%|PPp_[utK`|6m3Tclol^0ҳܨY*лB}JnQ<اKVW_\"`?CWÃR徑jJJ)D iˁ´˗rLoܯ(CnPAPKs)&C%cmG@[\$JDfc9U#r2m\0C0aX`e/LIGAR[v3ѕ_9mm4dN)I^¹ORlݘ'bť2Yc=#7~MNE\nY[zGCb2G贂0Q	\\όiBJItBFpӺă\nA|λ	cA9&F4o3R-Fy{~A;>83\\5ͣ~μކ/ak1dAk6l\r(Ҵ<r8:e(psvuT+ۛd,9ȹ%OT\0JU;В\\thBk0IMfP\$AsD ؜t47}0\n3Vm\rmu.qOBC|!׽ 0i2 |nA7*K3p\rX[FBSD=!?\n\ro68vZe*@މn 60f`uk7sX(j8yW8e &Q0m\\ȉqIIH\nM#<%@C\r!:@읣w;KT<Wbrz\0_rFA_VO&\0+(efa'79iH	^Z4EwYoX.ܻzx㼗^MyOD9nJ+5\rҿXjaz3h5ej-F\n&e0XI6+Ke1;DfSU[n	SΎX\0n͍UyX2\r9j\rel4)!*C(\\Y[༟&H\n9깬\"·T肂ٮIC`*sH\"]:F(W+,xwI	Z5|L=\n&:ճ*y=`.KytvFcNG#G\"ѷ)) KLP8ՅEv5h<CJʦrytg*pKΩBCs1Ä͟QsXrYCӶsJyyG\nEzz4}1_.z7}NA5'	@qrn\n;F&8mގ\n)6r+d^n+,qƓ8NBO\naSOnfq5:oxre~|*x)E\rͦEA]HzRO2UtuzN]\n-[Sax^i´*3B\$Fopj_lÔa	@\n\nP\0 mf4jڕfGF2J\nPlT\rv)k0Ja)NCIRÏh*|<K'j7Qc(a5^h\\npcə	h.NFimϊL>_R(ڂ0\r\$2PN=I	\nLM	'h蠮bKF}J\0ʿmd논Y)Ov0\0i\rΚPR5kقJ\nPդF4Qn2SĠ|&GҹſK\0GED-mhZ7+*Rl(T}1-:^nI~\$h`h?w\0rʆ>~&\n`HĮp(\n`EFN@%mR ʤO*eݬ9Dz5P6(^\nn  ¹ljիK ^E`겂h68樊6-FE \"Q\$O\$6+[)(K*E\$>JEϭ,Do<	nFzmF` 6n7_/J,q\$p_-0nk0.)24TH\0*L&!`?KS0\"d5p,٠{\$n'^J1FL` 	\0@,U@\"-Dl0B`(`4xOjі/N)t:p10X,\\e\rpQΜFuk<r1hRQN^	76>0E\$7^L?Έ49;Dt\r>3Η3?mГ@ͧ?B<sEPFLN-DjAT|=QD4 ʹ?T(BT=T͐g>BHD7֛n8-HJbL%*\0+T	DFDdE;CKC.).AT\"wr	ApB\\HZp1I*5:JZ-RVUL]<	B&\0EPhN)GDJʔu)K!Q'D)EY?#ԛD@5[%[qI\\ƈON\\m]?t(Zoru_LG_4)KY_g\na]\\`<v~sVb4b=BHmJhBW^B^onJ貋jt`.J*\n<Dr5=3бh3i0KVvJKS]5ni19)EgRKWc@QcNY*C%6\0@\n&0 Ft\r\r\r!pSbLvn\rH{ԅI),l`7qA23x`j1+ltlCa7srWB2+S4E^s>v4E+Qvcҟg)̠Nr]s`r7y6#7ecs7YxLuĝWtJ7SKI,)%,QJ;kŷ}\$DeW&8ָ̧f	<gPAj~NlU`7sx^,('OUVÁP#yL0uNЃ1Cyv3x˵-푀xwW[7`w[{u{A#w,ҞiJꗀp?.,kʯ\\quW@y'08vpyvPTh.w~m壯0~a\\cQVw_/++)H/^h6 vYONwoX`8e6;_iDxcTX	Ω	R{p'Iٔءux|%u{1ms'\re85񝘀9ՑvKJV4`iDlwٿ3ougڥZ	kK8q[Y lfulwg{W.\$7ٝz7RF8I-#գO:V-*2zդhp-,dqI,#͔kKoI\0]\rMV:(\n1_QZ5~/|x\$GKzQzH֍i>TW>@EiʜT&Izb]WV!<hղ_5|%\nFDZ0yVyrA	=mxY=yb\0ne3];AmnOv:W{u?#5!/ Dl⧒qz%w /[F-Ƴ/dC\0˾S/o\r10 1\nxټ;|@S	Y~gx{Q{U>?/Uzw×vKRCMOQ1-c	ISjQ>1^7pi9Ѻ57U\r9f'}#wɱ4b5sx}<aw] 6F!X!0tLnI[&;\n\$:T+<pcv\$Bhi:\$#vj(fX%J/fkcY)\n<;ݣ#P7\\Z{66bo2\r;;%hFK`\rftͼjV\rp\npKq)NrЩ)%/rwG\\3߹=T4Ψ+Hk~cib\\K٨84A0WظF	\r=[~+iR-mz{{v\$'[Y~7RAWpREOu}!Vgs|^E	w)-Л*nj\rdǪG(>Gc'e\r?*lGYW5հI﷥QY\\X)ׅ,(	7^Oʼ77\nF\$BD{SqRqYqk5UQxETO}C\r)K6HMZ٠Pg6!WnnYpT|\06Ÿ{;f@o՝`\$ f<eoBeKƐ;iY^b'%hDg?y֮\$sPT0T7Wˆ\rPR?ղ4,'fFZ	r2( \$ @Mh0";break;case"th":$f="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=G\nASZg\\Zsf{2q4\rvuTq,..+h(n1s6t9K'vK֗!AvyOS.lUشt.}pTkp+nC퓴>>Bi\"X *~-h+#\0,@4#7\r\09\r#689R: :8à4ƃ1FK=\n[;I쎷+c:lִp,,C셗\$450=9s?B.jQ@o뚑B`P#pΞϓ.(cOs̅B57In#2\rA\0%b88RKf-Z-R66\$9#O=ր@ldsg ٫	3ֶ7(00	wڨ,s{j3F+m\$L+A\rY'CCgH:j KoC>,lľcݥ{cj~VJk(8Nx)iMӳ,ҏ+KRB{?\nTˮʓor3e5QlH)g>Ù0zFN# D!YWVi[1c3P1UA\04\rb0Uv9`@sC3:xׅT p_\\uxK|6Ԏ53Tlv4px!09ܼm*E~9e?#F\r0&=e?Ջ\\vعl6u?S[X܎r\r,9J!?D=RdjHB)F3wD=]\$yhpN1vwA|EY{JIZ\0C0aX`ec5\$Ҏ|KbX)sM9PrPM3\"ԥfK[[l7l䞡^d^؞nlfBrm9>AFO[#gmEB4K\r!dnPܧEҢQ	;ZR2 \\jH7BG_I!8h(v+ØcSP)ͩܓ-='1,AI(\\	M_+0bFl~㾟)M qgo^u3Ƶ\$4.4ޚ*3v]\0mXpuNOCz\$0|hf\r!Zd8 Q+#\$	JqTH(xG<Ӑ ;hd *&\$>\\)3`Jz넏+T\rTĆh`o\$9aᆡ8/HTHuG9Gaᙟtlu^.?ITDm<^R\r彆BV\r!F+u.ֺ]vۻ^*`tyU?'5\nOezӧf	mTo5\rgSUOs9<	Zx4%z\rtΡ:\\T ;uTjU\$k+!!+uC]qjMsԬ<;S4(cO5\"F0pT6낯J;`G 0ÈA7](U ,rS疨34TAYpp1H\n\0@Rg)?@bE3Q/pBqhZюcEJ\$^ܸl!1WA-@%fzJ#G0ÈJ}<`,wnt6gt\$eÍ*)ezpz26v) u֩\\m)|:+}˙K[/6I\"IQ!jK=[ g'o<+\r:Nk\$㨁\$-ާV'7b~Fj3*0lK}ت|152FZҗbtIfIA(ekW!KdP!<vZZ1nzLtPvตE~ۋH\"E*8.Ɔ*w,% R948G)⹲T(RȫDa);6pp \n@\"}&_o	C}#]	V/	vʂ<?#Лo#\r_qeǷ\nzޟG.-@LW\\\"eTTc5c,mf)M/֟ڜCNބ(.F_h&6pjN\n</֜oP4r7+i<<*ʶ[\08hD tpiI.\"~\r8`elUb>b~74\r'>9k20L\0?<\n`H<H`L#	vMD*#w \r\rPIi>C҉D\\'07E赮lg\")|Q؏og:BܜoPd+J,@\rh*cGm'Yvq,FXd4T'(@0;\"ftbf1djľ%{j[86C>hl\n`dE\\\$NjDxWV[\\(,\0^0~\0}\raF:bdi(K`E]H2i8-в@2FКl@fc\"k&Pz%y%oC&B-*\n2r Ó**B2 	(F*gdЦAnmF HJ\nCO8MA	ֆ.I2.O5&3L-9ԭH9Jƃb<a\n3F2(!>&Iz~!\"d'+0Ds-ƭ&i,aO,l̍\$O2ӌ] 9[2mHfN9%nNZs7	¢3|0\"6=GC63N#g6CO(cO{RdNmQO~=LFz\0c\\'T+,B+2Mo?idDO`ZQtg*đQw>?)FZ\"\rT(\r\0ފ\0ڪ]?DINZri?/'?c~<gp/m:u,p=@sQJ:tF@piNp<S8pNPiPb{LUyUԙT=`5M@.);+@A!Nj2v\"z#g%+҄pVOÓkL)eHSQSC|m)%UStgSHS8=WXM2RU#Gg\nӸXs5}t(@&EL\0,gcAcl(-G&.fu\0bINwNO:oSBoRWuT~_5Nƶ;]Q6	71\\.-(cmY^yZU镪91*u<5M―k[=\\Sg	)6jSjk5kc}gj'k柳lU֙bU;lyZ'mR:H`Csk4RmSѼ\n\"N[)Kc#DB/9E0\nG,o*O<HWMlvUl{o4kuWJNpVnՠwd @#iUO6wɁxV\r{p\$;x*GzEEGy~&mC0~	,60fIvh})Vw3kw7n1g3wi~ulWP~#~u~%ӗ]W+8%A+LV\\K3s{{zŧXO ;!&!f`F8ro\"R<q\$hzոmIx瑣#x(o\nwXJw	oWy74wo=[ww_x_QǅXeBcWj>hҫ!B)nwci83~	u[\"'8Ы	侯8.\"(fa8ivbO?N85+nakM9p =g\$]w{rNbs9A5()7WXf]`nz\r8pdsg6|dBxJIm@Z\n.PQR'ĩVknvX7-z/:&M(@\rP4^i&͜\nRe=ebdM'4Βs7|O^yOxGDZu:IRO#r(261M6<vӂ-K-Q+OZ9y)Aq?WM4XYu8hDMxz\rF=j%hi1-A<bGGQ## _\$&Z/~+4>;|_o\nI9jD#e;{[D0Vn9f//Cff%C'N4Ks6;@\r88Dp(3+k<49u\\6{-R	\0@	t\n`";break;case"tr":$f="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9Φal1N5+b(Bi=Dqe0̳U18t5hZM,4&`(a1\rɮ}d=Iⶓ^a<~xB3|2u2\"SXS8|Ii1gQ̑̚\r;Mno+\$#ӆҙAE>yFqH7ҵ\\Y;H'd1/.2aՎc8#MX༎c42#@:J+j2+`҉\0֭ܿ(B:\$&Ԗ1+,0cC;OȈR<čH  P2\ncH\rX7*+ɢXB7PXbzN2o8#\"։(\\(95c1p3\\Q!\04@ޣ!pa`@!cB3:x]\rAr438_SUI|6KB3#Cl4A^0扠+#H\rm/R2&JB>\\M6[z^5\rSDJ2%@xh,W\"4:\"x,H&9Sy]SB35!	wro 478\")1&\r(&Px&(a>\".@<=bK)7NFI=2bȶS^{pA:ރ3llX͈Aݢ6HRZ@Bz<H:#^ȃ&䈜|q|n2\"@WkK\rU6rIS\"<͵n#e!C03//Df7|p7-H6K`Q!OG0W5G!h =8Xņv[DX !\r-2YPt2],;h!\"gPBÙF0(Uy\"ФHoGX50aUWU`W\n^+莰Xĥ/Sĳ>BൗI}qd9yHlU29Ȇ'B95ʔ]1\"CAp 45ىA1Qn.fUWa^<F\rw0hs.M@ãi8(6-iX,a!kMp*PWsQJ&I/pO1c༃;mS8l<0:RCr#rt `E`\"\n (0K9!\"\$SC\\좚\"(yD@ɾJJ1H8֛\$K\\r<b%	\"fq%wVpz!u<I\n-\$|M> QBYJy4E:%Ph)U@\nS\nAx@ fA3y%#jZ0*Q20S&H\"k,,ĕJ\$&OA\0ru\$Pxy/G\"d]-+bb,РT:\$L*F<2:rBD3:_,yèy{8\$C!^18`GlH^]Ay; SmJ\$YzNhB	A/gT!>e+4r,zwp \n@\"kH=zsj\0Da\n].1&\\oqfǲN5P %W	mKEL\n`u\rgsx\rE1QsTr8)(*l[6\nw܊w&x~vX=1p7r𙃐Qܷ8	Ev*k:}\0=(ȼ\r*=Fo\$m\\o7xDb\"C4&\"bEin`(	ŗEL\r\rg{x%2eDsk}8Yk).#w!}4\\u\\\"a֭4t{:B2\"9O5\";o:	Hq43@(!9aw\0^^ec!SnAMN*\"m,Xanɞ%J9]S\nP 0xcI[DEvR!XaE؈/)Ew!)WD8גEgy`mb!V@O}=z)&a0fSNM47:XdAs{O7բ{'=dhK=>=jhF?%f1/l?(x;Pģp^%b}c's((|Ġiz0+ײ.Op\"*=@_h(s\"Jl!Rt8bHڂ>,6oj\":6c6Ө0mcdRF'\"GH.L\n!CFP_leB\"E/I\nN0, T\${\rDm\n=\rN7%4rF&|c\n(nΰ+i-rn1\0w'~!pTpY(c'<YC)/6&:N/\r&1FE?!bZ5oEF+PlDN1\nMı.6>m4fԜr,n\")THH=6%LqrR\nX(^𑎎-&\rB&2˱ep2&QR)GJt*L5!I\$R52J,C\$@@kHfD%tmqKoI(÷u#kfb[\$D_\nc*⾑\ny+ME\$\\!Ȏ#\$G*\r*R+Q\"2\$m+.\0.jW&/Ay0r@l7AݢP@d&=92N^-32CX(/*G-L3Hnjx^{)6W+N{1297I)q6I0%F.0Ӛrn){:\"#Hzf)E@@[1|2o/t<5sL=qN&>qJanNʱ^\$b?t.kU/NDEb7d\$CEd\rVCJe+bB\nZ(/`\\EÉM>QYAp']Gm0\$ˀ04b<J\$JڏCCP).%7nHr3Bh*!mF+Pgb;lڄJ%vGPEOdtOY?9HQOqQC5Or+*RH!Є]N@\re%o\r\"dP\r-\0H@<8N \0BH=WP\0hWi_&ST+bjm.όQ\rZJFxFP\$@";break;case"uk":$f="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9(;Au\r*u`Cd-|EX~\n\$g#)exZ9 G\"HESXj8R9ֽ|_b#rk:-HB!PńRDiyA	ǖx]5KOcJvf[5{ftk,TIjh0'\rz~8ȋ\$\ry*.#΋4nNƃ4ê*0(r}48죎'plA\rDn<@#)یF^ƭs	X ?V	/傼Hʹ,)\nZ\$,\n\$÷H,,F#M!d|#eEMj)Dm+)Z+;QH1(1;Eҟ/!Y&X⢪z_\r(hn?!T1CW\"6Nh14\$f1>)B[l`H1GbtwNH1rh\n# 4(:E!s2ԠM0#{&#3SApx0C83:xbAp9x7<9XJ}-w<ITndT^0rjX˒\$֒r4Ȳy*,*euon6yK\n6ShfI_#hyz*Cj/)!̄^IdV=GT=oS\rv#s'v#kY^i!b^ԋkξFrv]Ͳm#7\\֑\\n\n_*șB\ru*6w\$FA3PU}e\0Gqh-\"'X=t(B|pJj::dBNqAL(ǹ	( ^)\$FSJ=\"BM}|g *< h\nLE\$F>B8G#n\"x\"rz_(tSG \nt\n1N`aM}cu/	R!Z]tCxsгaa!I8|on(|̟Z%ىmMJBR8oEB',%aR>rl_̪yTǎ8DwQ\n(^-%T.T*E,U\n^S*qzۊDC|p@2'h%7Y4xGI \\F'a)t)X8Hrb:J\0ɌzB;?W).\n <D:/FOeg]FIN4vy	H\${UL΅-'Кaiun%Q:{ED]DwΪNMR|)TG+\"p\$HƏDQ5䣥\\Fg2\$L3fݜzCfsP7m#XkfI\rB.^Z!jCsk^iQV\nPN*uX\nGԪX2V(}\\%3c!/Mi\"3`<g4FaZKKi=Ýj\rf[B\nTLj5Z,!V{HVX&鄳#O?sn'&/[va0PSC\nU*_ry9q)[F)b92r<yLZ@PYOͧAZ8,cZqC(3(+3/L		s{)5\"P		]Ȳݱo(j,X/ʥi\n>ExQD3w(>zku&%t\0R%\ny32N+02.˙	'&,Qr\0Y\\O;yAI#<B(tv=B-;g!\0'Y^?(OAnCh!SvX{m(::Vd}Ө֓Fġl\rY@xS\n3*bY(X3tz\nF)驽z\\&D21ǘN(WC5=B,BF6\n]i\r*YD/{X9q&!ccv抛뉂0i	!\r,4hWh	#G<qגGJ	[;F8bѢxױ\"p(o!-U,2-5(A}s(\\	nFgƜ3tR(Sq6Njʤ\"2_*(\"Âᢈv蜈*%hO>'+@tj,̅@ⴝI_P/!KJrE~H\":H2q(bX)2*\0K\$(\$}484dLBr<3`ʿ\0\re0.H>9&Dc#f#Mmhrg*@/	0Wg}.I2\r\$\r 虀@\r'b|	bppEAązfBwBHE2R#qnL#deR)j/(rrWg\\ZBkB3\0u (X	\0Q\"IЊeMNh#BڥhPxI*H]1 V\n 	 yOOl΄LM+n\"vu^-~ZgLatvC!'xodF9 .ꊌAp&jkpz7\$ta#,`|i(r=d\$HE w!Ts%&:N͡\$'7&/\$=C=<\0<Rd2wqRvq2#h&R\$]*1d4Kr!O#+##	%	!RVCP\$l D\nTG/}G6.%Ko)sRV(2d(\\*0d@0:r#ưM\\d〼OoQ2LR&ÄFCrET6UAIroH3\"œ(awJg'a.9:-AƛbӺ:=qd\r>,ob6X4^&nFHso(n!\r|В*~D´2v!4\"W0yCäd@IcIAmaCBI9s>nA;|\"~f;jp@\rip\r`\r\r DjK\r^b\nS=LGK¯6h-/TΉ+W>)?LMGyGRI=<9LP:4̌\rMsGu	/R	|Wꝲ*A\0!HK,&uR-0T59TjW\0퀏-5ZH:\n=Sg-6\"2gTUyUfUXPRLPMWQU4\$PPCy\\(6n[,<<PA/\n3V>>q~'UFLGeJBBRoa@m-@-rE(FU\rY\n10Nn7iζ#_BU\"O&*QNQ/6@t>Qp16:=Ai]2G]rƘ!5Q)uL֑j\"{UOu35\"O,Ljtj2v<]U5lOU%S1745v,U'n\\Ӯl\\HϞ,l@o3%>{D\nbYQeLpL;T?iZJ0NOSn`v}hA}~'o(5W9W'owt~xcbMxW?G͔ؕCvO1\02VXu-=UvV\\fݕkvu]uUv}.}ڙ7yV6|b,z\rZumU/T}kVv~e`ք<bD_lȘ|wi0MX0T845!^͂AZE+{;f1B{Lu8k}8?#\\_Wi\\Wlq\$>CQӃk\nCymILevx+JCe?\rBwT`Jd%cpҶSػrp'rK,P#\r#*ߒw(\$ْg8gpwEW8Hvpb'L'7#)+R|s4Y%uis'sZ1n5)\0u6it]X\n[NEM46R׃)b[j^F&\nZ]'RMVUN2ȣW飞!5SZZp\rv5B.h#'Su7{	F|4F;V\\\"rkR>VF~Jnz0П1/4<0왰V@M\"ceFUdzCRPm=\n5803<B~tSa㫖vxXYv:t6j<<xdB!\rծ> viZHPo,e	WBzO`c]b#h(W2w\"#0yos8SI-HyQM9S}KOvhčl&8\$&ML:<}}Z;DT8=lAp\"2";break;case"uz":$f="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8!\"n:far Io7X&9 5瑃Hq9L'3(}Aap-rLfqJ֘lX*MF\n%mRp(+7NY>|B:\rY.3\r4Asҙuzah@ti8[-:KZaO7;|kul7*'֊+ɜӉh@<6`5(0L8#ޅ!,6\"#ZB0*8\r{9\$R'ɪ8ȎNp)3C%ct\$o45M P2Ir<3j쑻#(;O\\+@7/KXs\$>7GMCֈzF4+.ӈ#\"x7OQ\rJ	!D2eO=cC}\"fȌr!ь0z\rH9Ax^;r5Qsb3(;# ^'PUx!;VUԋ|L4:IÒTXd9=P{QwaQN֋.2(mLbx7\n/ PJch.\n7_c=dP;zE|+`@8ӈ-h4#;\r(j'#j2I˪9Ah!z(>k!* 7 _<4\$7[v23I(ԍ+(<8NZ;ml=V)O#=u8^OقtwM r#j^Rk(ȳB\\Z]5˂@ލS8863f+ݲW	hWñ&W*\\Mx;d8ʃ'4#C>aaa	҂5\$6\\Q:M0%\nG)cy\rtXpJ)sXCf&1<5\\Y؉n-)֘H3 Z\n\\|\"A&{B:Z#xY)19;\"=#D%hh\$}T+PBZBNA|E14m,`V2YK1g-\0sZ]l\\9p\\`9n!p=\$<!P2^JA]%|:%	>\r9ikʙFY&eh\0y<S1\rӊsIM:|dX\$:,֊ӔAk%xhJ[1Ź%x/%xih]#Ezid#&5wI\$P!r`\"E4\$|?\nDOhJe:2S]EF/8@PHU	\"v#AA>'02:HZYF)(ׂd||*EY['%\$'`FdiB-FWii䗙\"hY\"ƆÒAF\"2'b)d~!) ]ILnQI`03FⒿ.rvHl\0IˉPfϘ[r>ITr4\rL Mo.W3O\naR;q]˥E'ݸ2C\r4wboDf'sK)BjM@F\nHC&'\"Ikf@yg40d;d Bf=\"	H	!K d0@S5fDt6j e\n\n|˥VZ1lp,<1(l:5=\r3{2X\nRY^v:l;Cwəؿ4I+.9E\$\"ҴT	(-h(RQY+*5bD JGp6;0ӓ	\nc9vF\$B\r5	L>z4dŜu_,93AzcUB;^^S:ݝY.4W\0C2*&i!-6'XGr#LĕLꝙ-ѷX3i\n;:hu-8z:~KSg!<(@RSjtb\"s7ei7-7\nB3i+6BT9&颠ZQmHFTZ~o.\"AyNf1A&`R{K?YiEݙ́b[;5.4ĆxLLDy6,~}D˸96u3m|=/~+*eosx̼i0~_x,m\"KSO\$f ʌ.&bnoz,@օ`r_D!t3~f`l97pJ;\rlL^5C:c%\r'F<d~قg0d8Gn|qbE:#Pʌqc,\nfb`&K D'G1>gqJ<\r	4B̸-`igN+V/\$)-F|&,(@Ed*\r\np\$\$\"˰Άc\r\"ҋӧN GnZ+'κ/SxW@w0'j\nq,laolgRyf؏ri*GKV1Fy1L>P;6Q_&@m\n1~oq{ldq0&dF=V48lpGLD\"ZVk0Ă#1))f9b\0Κ#81ӊJ:őn:7FpZCk#N8q;#HpU\$f 2L#ZzǱq#\\@`dzi0&bTllrxT5fڥ\$5M\$HhfJl@;gPE*+2;+g+Oj`j'(β+\rFj(RX4tVyʪz'Crj0+Mru\$g3D3	+\r1Mr\"R320(%&0D\n1q~,.3G3T?0##w6e4k5k4X\n]zT%5rO8S~Oxls|K5L:(%A,K5\$M&)Pbsg#ӼPsP Q*-j6(6,VabH&<cc\"?P\rJDp'<\n\r?)&9po~4+8'\n0pL'*l\rV\"o(`\nphlt4k5*BeOGR{TGtiQHF7)ntCb%\ng\0\$4q9J-04jKcl(δAK#@O_M.@:&\r5G7\rΤO0PDL'4Q*V13d1U\$P@Q\$|3cM6YRjV;\$SÖVubc Br'g(W,	 (RmN	@\$uDAtDCBKBbyKoQnkKv M\$L\\ u._HǈM>KRhL+O/h";break;case"vi":$f="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn810Lthb*L QCH1b	,Q^cM3s2Nr=v8]&-.c\rF 1XE)C	nz477JqmU`-M@daH9[׵\rH!y i=Yd\$IXWxmmtWjYoqwD:<6\nc4`P7e'@@#hߢ,*X7@9Cx䐈0K2\r(	:M;#@\\j LäJޔ)l\")qvOƎc0I~lK&B#%\0A:0 K P5\rhA98*\rs)'BB~MPvSh򐅥(;%re&llK!\nK!v\rAIhCbTrԡJu4#p lgÜqQ1q!Ep@;(p:z9XоD49Ax^;plq<L3(w2t\r30\r#x|,[W\$WK8JFt6o5Vڄ\n`eeۿP0Cu؂#0<(P93:<j@N]3(1\r0fLD'dh*ư*j0\0@R TD6e^<b9/\$-*P\"~iE\n#T0a@3;BD\r)\"`<pcEd.!b'ۯԂ\$l\rlJB%\0v!뙱tPR^mPeNm9w	UW A>)O蘒#eo}@CsFZ Z	>f`̉<`!C<@ @(\n0 `a&iEe\r7.\\`\$ÆC\n+\"2\r([Am)FaRHt&\\Zu^R,%Bw!]춹W!I\nMK`˃<Z!amH0o\r!n0@a)0 ؓ6s,ēNXB!\nOa@9?%ˤ~\$2e\"[\$*C=P6v0&	4Ka=9rciƶ5\"fIԉ:nfӓu,!*A4\n.ZH!\\Q/0a0!Za͆_%к0u!7q'0)B3tpӔ4\\ҽ6K*.\"qw<]tl@P\$`a/ȁ\$F] 1\0P<_A}#g&d3ۢ6NɨsG+pp_\$>ݹ%AT]\$*\"5}H#Z(P!#\0\rȠ#iJD5r\0(F\\;*v(ѵ.vS<H}4ȚI\r*YJd1g#`wNW@|.׈u/Y#`̉PbU`њ=hr~)6#(\$\rbMǇvarKmBܖFzj/;wRJY§:ED*I&H\$?ef`]Khbna=L3l72ޫ?UV&直)|\r\0zQi]54#Zaac1ն\$}rRƤ''` Lz*\rA\0zNCC\r63}hTRc'@'YeSK,:L;	2C`Q`,jv@dפ5OoSMZvG9(QF,-\$D&UÔ\rP;ibvp88AC|~C6ѭFW! pOYD!fF^K/1qQv\"ohwtԅO	OT7:!c{\nvԔe?.ZbP3t0Bi\\P%:cxrEkKz\0*EL T!\$Ib\\HW\\ȻP.\\&G? \0lpk@XܼFuĸ_phcK'-{E.hDVRy!\$2SI4*QICCzyJFȔ;XTcϑ/͑iR\"2IP06qpP2aV1ѣ|%\0ΐbp2	ƸC0Ҧ&svҁB.L\0	fKϐ2.z-Bw}'!&klL2nl.#JD*XM\na\"HJ#bt!D.nht\$gD)R)Fr&HBn0VPp4#Cj<n\0C\" Ю\rt\rzGvP0ZȚM͘Al2)1^ZnBfW''g\"ep\0dJ__x\"Rr7m˸QYx2>\$\"q֔Ж1Ć\$4Zm0Y1Tƚ#*ʬ2fpÒ\$@J\n\"I\rNP\"gMU\" t,QhM&&3Q&jRq19UQ'xZ~C샦{Q**r+n/+R+˜,l!N<\n=䢕bUTP\"\0?Ɔ_ȁr2\\K&[r\"I	0qm0Ѱiu1Gt~,#\r231,)+\";/5rٳ!)-C6IF]S+%n#I4D*%d»+'9K,2Ȼ2w8v\ri/cCHSSF`bp\n;3;\$1(3 p-t?b9?@3@AC?TACZDZ+R?%@sv0ϝ6BED¹ҧ XJ#cQl%f;%((@MjOmq@\$,\"Ƽ*nQ3bB	ĐCMJJg6O0M}%7d\0\"\rE%d4:`ЄR)\0\nq!\r\rB,g,7c&f#S0Sv5YkL93eL#49cp&3gNZ-ņ\$muGz\r@RVMQX\$\0M/D5m	(t!R\r%(0mXK	\"XpiҊjg++ugOXJ	\$\n5!^kFo\"/\0viK\"'&`@|`ˠBE	\0TA-\\0pVCVPpj&eH\rI Fpm>(Z Zp'Ц`B";break;case"zh":$f="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4)ΔT9w:vO\"%CBrixM3s2bV}\n%[L`*9>S؜%yP⣎uYоHQ)\":VdjdK:tRd(t/0Vc5_hIG*\\?M[h9ͣQpCqH\nt+ծB_cS>R\$2{T-&ġ^s	W9@@nr?JHkIRr\$M'\rz哸@łK*<OĹltV9XS!%]	6r^.88J|rYn(\$QBr%B+EHd)(֜RL*E0Pb6#p9%0dBW6L'\nRY=\$F@4.0z\r8a^\\0tm\rp^8.`xDωLsd)SCx)I\0ڑeIR#|sӦISr^mS|usmkV)\"EA(FAJº(fT[xaCG)T=mU#I!@Us\\{eDH Nċg1i^YKr/A˲Z5vM!(JYQJ!PD[b!g)xK|\$>|rsYy~qYO>AG1LA::R s\\j8xG)]=|qu|ru*;Zg\0:cAT:Cp@0C9#yo97Hj0B+DW?aK}4PJ6YE2eBrR:u@H,G@GBʚ!Th!H1@G-++ME	Wy|tDXQJ1G(6+Ÿt	\"MJGbTZՊV\\uvaXKcGCi{k8v+nEZ:E\"tQ\"\"hc?RI_N\\r~!;2`W\n^C~VX:,P2{itS`pJtN+r\n9D`\"B\$Xq\"khLFdJ4+dB~&s\n!sȔSk̡܎i3T*@\$\0A<H\$TFqA\n\$<9pJsm8QPDA!E,bdF.`b^A@yfbxŢ\"LNCE5\" 00 \"⒊6 F<H\"LfG(\$pte# \$T,V04D\"u'\r\$:*tqrUt@h9DY	4cr ('\$,R\nzp&BEھ؅/5z|B*\$d\$xF\n@\"`X[q	kMM҇)iP&^.@PO	*\0BE7\"PoJCZ4@̨J)Iw%(!EQw^*]ORݫ((34\n\\.sb\nG+_@@_L2\"â]2!ұ?\0(rs=bߑۺ3ɔqB9r8qz	^V`u7)2e0h\rѕ	-`u_̗xi3 JBoJ\rQrE#Ha6\0pt[(	\r4!\0C.=lK	7bؚ;H-%\0b&0M&H@Rg\\.qi邴݌[b6|!C	Dk.\0x w(d-\"0sBNø Kb9f6b&7cۄLE#c+څ'®C[d樾@D|U]ղ¸e\\^-a\nֆ.+^]k~C#IC\\L\\>UB=as|RoMslY`Kޅr-4nW׆hD;/Y+t1J1ʔeZ\\C0͘cp#MyF/lI0m\rH6,PANX\0&f3\\&n>{;77q_pG` Bsj>0-bOovPxԆ*\$mN0!ʘ\$6! bVvn,%N(mRb&p<`O(;6RPAf8&PC-^tM_=ЪK\"MoRtu2/_H\r`P'\re'Rl2]lL^q\\lhH\"9!G/j0ZgErun搨^v/Fp/6V,QGJ12tf+Qq\rOg1qP`Q֠V.,\0Q\rQygQy׀/r\rm1щMDf!H1,+r#!oM#	\0s\$j n1t,I^J# BrlLR`\0'\02Az;Kh>dEm\nZOI\0n%|4!b̦h#m	(2;#C,#@-0\$fn72v2,2dĭ)#-<m\$b\nd2XaI'!m6	2x(780I_\\8ZgA3M6Aҿ-B򓦿tTDINf@ \r!~,#G4%ԭ:\$\$5\\vdҒ>{6l(1nl*s \"dAL";break;case"zh-tw":$f="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/WtЀBT)*yX^%ӕ\\r|I7FS	99STB\$rNuMТUP)&9G'ܪ{;ds'.̖L9ho^^+ieD:=.RFR%F{A,\\{Xs&֚u\0rzM6U!TDǇEtl6N_'zV~NZRZRGATO\$DЭ8UJt|R)N|rEZsiZy	V+Lr>[!kg1')T'9jB0,1/:8Dp.R\$LGI,Ii.JJő[e|kzDYYrQbB%B<\\gA2EyD^ONv`\\\nsT h7P	|\\DTZ\$EQJ3wH	)	O*F@4/c0z\r8a^\\05]Z\rp^8/pxDARd)SnRQ!^0Q@b RW!u%39As;,W-\r_QetV)\"EA(C2R\$݅,k*ΑgANQ=tEUdҘ\nI^d1H N&k9]g1G9{q%kijCA\0Q7z\n(:I*[ą2=+\$<B~Gb&Q{1IK;)cD/Oo_K;%x|g5}'O:(APEtG]?lC1=ܜ-xTxXV	e@6d:Cp@09#`!Hg~\0Y0CS+0Ort Ȗ	d!Jyd6@` b	!RSoeL8!	TK&icfNYz8äHa|#HS!KTTdA>:`+(PT*TMwbQ\\M0'dHVzZkUkp\\r.`t\r0w#XD1W\"`iJ\na99&IK|ţJ!m#	b Dr]'fUZam-޷\n\\îY]%|+`\$0J\\\$sSBq-*dז	:d 8BR\$!I(/X̨i\\HL90HBjC(rB\"EH%%\"[8O\n͋EH\njH!\$:ZBHΰn\"\"gϣ\"\"#Vq@JR%Ghs(_G-1z9&b8ttXdrGp00 5R{6ʵ6^bBj(Ȅ[OM^LØWX.\"5p@d g\ne(CO	Æ*4T\\OFcX)h:DLB\$sOJ:D)A@'0\0WDĞ6Lꛖ%~v{kO-B؀Q\$#@J=gx&q\"PD9sn )j`\0&i'@BD!P\": E	3t/J撳_x8t㚓#6f۟	+ @eQ|]%D9dȘp|Q\\AdJq ;tf㠕@Bx?QAMA#M0T\"ShP`!?HYVDJg\rS|p4A\n/A޷+/:uVPs/AkEk\rjL9\"w1%cG]phU:>xm!Q59ußrnb0!v7Pv<+a\\2\$KcAqqe0bq v[sX\0,Aա4ؼk-mfw#eɪFC	\r/+eP	8ReZTs@Ztp壡z,GH\ni\"ؤfTb{^3NU<΢QD?X(N((.	P7]!ߎj룥dDyz\$G@@- !*_Vk\"\rE/)H( J&<Ƞő:fёЫ7nS!5~bdQifVb{O_;ccEiT\n֡Y!`gt<<-bܡxrݰ\",B\0 \r\\-\r\rĀh\rzq<j<X<oDl6DL&wu~dՇxPxnvo|+p.TƇyopj&\$Н]\r\rk	,.%r\$>\r)U#n7ja,gŎoǚZ(!p̡\"Lx7bhT߰/ͮà:M6J0c<;yqڑ\r/<zgz!m-fzIuAsgFǐbgl^kj-\"^(F,(!_ .NkvE^% \\Frr&_%`<\$\"q'\0\$\rLDs )K\$/!1%\rNY2D>1o%]&/'Ybf\rx~\0\rb0R(`(([))(*e\rv\00P2f`,&fhN.TQ1N--#\$÷.r<-.P/\"0dLDCDj+.11\",2.	@xжkf#{aDAn\ri	X+2oDD!H`Fb!k6Fdtk8Az>?^;FM9	W2AP\nZFxz8!`|aKZBjbmӼ20Sn[@G\$,?J0acDv{&Tjjz,D:|d!6a6*EgWAc<QqΊ̡lf#\"0^0JqpLa\n, \\8\n`ڔ\"+#FNxmRT<{TEDv,AFW6l^&3B<)-=0N";break;}$ij=array();foreach(explode("\n",lzw_decompress($f))as$X)$ij[]=(strpos($X,"\t")?explode("\t",$X):$X);return$ij;}abstract
class
SqlDb{static$instance;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($N,$V,$F);abstract
function
quote($Q);abstract
function
select_db($Pb);abstract
function
query($H,$sj=false);function
multi_query($H){return$this->multi=$this->query($H);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($pc,$V,$F,array$fg=array()){$fg[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$fg[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($pc,$V,$F,$fg);}catch(\Exception$Jc){return$Jc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($Q){return$this->pdo->quote($Q);}function
query($H,$sj=false){$I=$this->pdo->query($H);$this->error="";if(!$I){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(23);return
false;}$this->store_result($I);return$I;}function
store_result($I=null){if(!$I){$I=$this->multi;if(!$I)return
false;}if($I->columnCount()){$I->num_rows=$I->rowCount();return$I;}$this->affected_rows=$I->rowCount();return
true;}function
next_result(){$I=$this->multi;if(!is_object($I))return
false;$I->_offset=0;return@$I->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch_array(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch_array(\PDO::FETCH_NUM);}private
function
fetch_array($xf){$J=$this->fetch($xf);return($J?array_map(array($this,'unresource'),$J):$J);}private
function
unresource($X){return(is_resource($X)?stream_get_contents($X):$X);}function
fetch_field(){$K=(object)$this->getColumnMeta($this->_offset++);$U=$K->pdo_type;$K->type=($U==\PDO::PARAM_INT?0:15);$K->charsetnr=($U==\PDO::PARAM_LOB||(isset($K->flags)&&in_array("blob",(array)$K->flags))?63:0);return$K;}function
seek($C){for($t=0;$t<$C;$t++)$this->fetch();}}}function
add_driver($u,$B){SqlDriver::$drivers[$u]=$B;}function
get_driver($u){return
SqlDriver::$drivers[$u];}abstract
class
SqlDriver{static$instance;static$drivers=array();static$extensions=array();static$jush;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$partitionBy=array();var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($N,$V,$F){$g=new
Db;return($g->attach($N,$V,$F)?:$g);}function
__construct(Db$g){$this->conn=$g;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$n){}function
unconvertFunction(array$n){}function
select($R,array$M,array$Z,array$yd,array$hg=array(),$z=1,$D=0,$ah=false){$we=(count($yd)<count($M));$H=adminer()->selectQueryBuild($M,$Z,$yd,$hg,$z,$D);if(!$H)$H="SELECT".limit(($_GET["page"]!="last"&&$z&&$yd&&$we&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($yd&&$we?"\nGROUP BY ".implode(", ",$yd):"").($hg?"\nORDER BY ".implode(", ",$hg):""),$z,($D?$z*$D:0),"\n");$si=microtime(true);$J=$this->conn->query($H);if($ah)echo
adminer()->selectQuery($H,$si,!$J);return$J;}function
delete($R,$jh,$z=0){$H="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$H,$jh):" $H$jh"));}function
update($R,array$O,$jh,$z=0,$Vh="\n"){$Mj=array();foreach($O
as$y=>$X)$Mj[]="$y = $X";$H=table($R)." SET$Vh".implode(",$Vh",$Mj);return
queries("UPDATE".($z?limit1($R,$H,$jh,$Vh):" $H$jh"));}function
insert($R,array$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$L,array$G){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($H,$Ui){}function
convertSearch($v,array$X,array$n){return$v;}function
value($X,array$n){return(method_exists($this->conn,'value')?$this->conn->value($X,$n):$X);}function
quoteBinary($Hh){return
q($Hh);}function
warnings(){}function
tableHelp($B,$_e=false){}function
inheritsFrom($R){return
array();}function
inheritedTables($R){return
array();}function
partitionsInfo($R){return
array();}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
indexAlgorithms(array$Bi){return
array();}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$J=array();if(DB!=""){foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$K){$K["null"]=($K["nullable"]=="YES");$J[$K["tab"]][]=$K;}}return$J;}}add_driver("sqlite","SQLite");if(isset($_GET["sqlite"])){define('Adminer\DRIVER',"sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){abstract
class
SqliteDb
extends
SqlDb{var$extension="SQLite3";private$link;function
attach($p,$V,$F){$this->link=new
\SQLite3($p);$Pj=$this->link->version();$this->server_info=$Pj["versionString"];return'';}function
query($H,$sj=false){$I=@$this->link->query($H);$this->error="";if(!$I){$this->errno=$this->link->lastErrorCode();$this->error=$this->link->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
Result($I);$this->affected_rows=$this->link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->link->escapeString($Q)."'":"x'".first(unpack('H*',$Q))."'");}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;}function
fetch_assoc(){return$this->result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->offset++;$U=$this->result->columnType($d);return(object)array("name"=>$this->result->columnName($d),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__destruct(){$this->result->finalize();}}}elseif(extension_loaded("pdo_sqlite")){abstract
class
SqliteDb
extends
PdoDb{var$extension="PDO_SQLite";function
attach($p,$V,$F){return$this->dsn(DRIVER.":$p","","");}}}if(class_exists('Adminer\SqliteDb')){class
Db
extends
SqliteDb{function
attach($p,$V,$F){parent::attach($p,$V,$F);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a"))return!self::attach($p,'','');return
false;}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLite3","PDO_SQLite");static$jush="sqlite";protected$types=array(array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0));var$insertFunctions=array();var$editFunctions=array("integer|real|numeric"=>"+/-","text"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("hex","length","lower","round","unixepoch","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){if($F!="")return
lang(24);return
parent::connect(":memory:","","");}function
__construct(Db$g){parent::__construct($g);if(min_version(3.31,0,$g))$this->generated=array("STORED","VIRTUAL");}function
structuredTypes(){return
array_keys($this->types[0]);}function
insertUpdate($R,array$L,array$G){$Mj=array();foreach($L
as$O)$Mj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($L))).") VALUES\n".implode(",\n",$Mj));}function
tableHelp($B,$_e=false){if($B=="sqlite_sequence")return"fileformat2.html#seqtab";if($B=="sqlite_master")return"fileformat2.html#$B";}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$this->conn),$df);return
array_combine($df[2],$df[2]);}function
allFields(){$J=array();foreach(tables_list()as$R=>$U){foreach(fields($R)as$n)$J[$R][]=$n;}return$J;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
array();}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return(preg_match('~^INTO~',$H)||get_val("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($H,$Z,1,0,$Vh):" $H WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$Vh."LIMIT 1)");}function
db_collation($k,$lb){return
get_val("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($B=""){$J=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K){$K["Rows"]=get_val("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence".($B!=""?" WHERE name = ".q($B):""),null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!get_val("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=array();$G="";foreach(get_rows("PRAGMA table_".(min_version(3.31)?"x":"")."info(".table($R).")")as$K){$B=$K["name"];$U=strtolower($K["type"]);$l=$K["dflt_value"];$J[$B]=array("field"=>$B,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$l,$A)?str_replace("''","'",$A[1]):($l=="NULL"?null:$l)),"null"=>!$K["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["pk"],);if($K["pk"]){if($G!="")$J[$G]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$B]["auto_increment"]=true;$G=$B;}}$mi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$v='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$v.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$mi,$df,PREG_SET_ORDER);foreach($df
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));if($J[$B])$J[$B]["collation"]=trim($A[3],"'");}preg_match_all('~'.$v.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$mi,$df,PREG_SET_ORDER);foreach($df
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));$J[$B]["default"]=$A[3];$J[$B]["generated"]=strtoupper($A[4]);}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$mi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$h);if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$mi,$A)){$J[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$A[1],$df,PREG_SET_ORDER);foreach($df
as$A){$J[""]["columns"][]=idf_unescape($A[2]).$A[4];$J[""]["descs"][]=(preg_match('~DESC~i',$A[5])?'1':null);}}if(!$J){foreach(fields($R)as$B=>$n){if($n["primary"])$J[""]=array("type"=>"PRIMARY","columns"=>array($B),"lengths"=>array(),"descs"=>array(null));}}$qi=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$h);foreach(get_rows("PRAGMA index_list(".table($R).")",$h)as$K){$B=$K["name"];$w=array("type"=>($K["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($B).")",$h)as$Gh){$w["columns"][]=$Gh["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($B).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$qi[$B],$uh)){preg_match_all('/("[^"]*+")+( DESC)?/',$uh[2],$df);foreach($df[2]as$y=>$X){if($X)$w["descs"][$y]='1';}}if(!$J[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$J[""]["columns"]||$w["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$B))$J[$B]=$w;}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$q=&$J[$K["id"]];if(!$q)$q=$K;$q["source"][]=$K["from"];$q["target"][]=$K["to"];}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',get_val("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($B))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){return
h(connection()->error);}function
check_sqlite_name($B){$Rc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Rc)\$~",$B)){connection()->error=lang(25,str_replace("|",", ",$Rc));return
false;}return
true;}function
create_database($k,$c){if(file_exists($k)){connection()->error=lang(26);return
false;}if(!check_sqlite_name($k))return
false;try{$_=new
Db();$_->attach($k,'','');}catch(\Exception$Jc){connection()->error=$Jc->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($j){connection()->attach(":memory:",'','');foreach($j
as$k){if(!@unlink($k)){connection()->error=lang(26);return
false;}}return
true;}function
rename_database($B,$c){if(!check_sqlite_name($B))return
false;connection()->attach(":memory:",'','');connection()->error=lang(26);return@rename(DB,$B);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$Fj=($R==""||$ld);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$Fj=true;break;}}$b=array();$sg=array();foreach($o
as$n){if($n[1]){$b[]=($Fj?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$sg[$n[0]]=$n[1][0];}}if(!$Fj){foreach($b
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$B&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)))return
false;}elseif(!recreate_table($R,$B,$b,$sg,$ld,$Ba))return
false;if($Ba){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));if(!connection()->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($B).", $Ba)");queries("COMMIT");}return
true;}function
recreate_table($R,$B,array$o,array$sg,array$ld,$Ba="",$x=array(),$lc="",$la=""){if($R!=""){if(!$o){foreach(fields($R)as$y=>$n){if($x)$n["auto_increment"]=0;$o[]=process_field($n,$n);$sg[$y]=idf_escape($y);}}$Zg=false;foreach($o
as$n){if($n[6])$Zg=true;}$nc=array();foreach($x
as$y=>$X){if($X[2]=="DROP"){$nc[$X[1]]=true;unset($x[$y]);}}foreach(indexes($R)as$De=>$w){$e=array();foreach($w["columns"]as$y=>$d){if(!$sg[$d])continue
2;$e[]=$sg[$d].($w["descs"][$y]?" DESC":"");}if(!$nc[$De]){if($w["type"]!="PRIMARY"||!$Zg)$x[]=array($w["type"],$De,$e);}}foreach($x
as$y=>$X){if($X[0]=="PRIMARY"){unset($x[$y]);$ld[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$De=>$q){foreach($q["source"]as$y=>$d){if(!$sg[$d])continue
2;$q["source"][$y]=idf_unescape($sg[$d]);}if(!isset($ld[" $De"]))$ld[]=" ".format_foreign_key($q);}queries("BEGIN");}$Wa=array();foreach($o
as$n){if(preg_match('~GENERATED~',$n[3]))unset($sg[array_search($n[0],$sg)]);$Wa[]="  ".implode($n);}$Wa=array_merge($Wa,array_filter($ld));foreach(driver()->checkConstraints($R)as$Ya){if($Ya!=$lc)$Wa[]="  CHECK ($Ya)";}if($la)$Wa[]="  CHECK ($la)";$Oi=($R==$B?"adminer_$B":$B);if(!queries("CREATE TABLE ".table($Oi)." (\n".implode(",\n",$Wa)."\n)"))return
false;if($R!=""){if($sg&&!queries("INSERT INTO ".table($Oi)." (".implode(", ",$sg).") SELECT ".implode(", ",array_map('Adminer\idf_escape',array_keys($sg)))." FROM ".table($R)))return
false;$oj=array();foreach(triggers($R)as$mj=>$Vi){$lj=trigger($mj,$R);$oj[]="CREATE TRIGGER ".idf_escape($mj)." ".implode(" ",$Vi)." ON ".table($B)."\n$lj[Statement]";}$Ba=$Ba?"":get_val("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$B&&!queries("ALTER TABLE ".table($Oi)." RENAME TO ".table($B)))||!alter_indexes($B,$x))return
false;if($Ba)queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));foreach($oj
as$lj){if(!queries($lj))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$B,$e){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($B!=""?$B:uniqid($R."_"))." ON ".table($R)." $e";}function
alter_indexes($R,$b){foreach($b
as$G){if($G[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),"",$b);}foreach(array_reverse($b)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($Rj){return
apply_queries("DROP VIEW",$Rj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$Rj,$Mi){return
false;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$nj=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$nj["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",get_val("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($B)),$A);$Pf=$A[3];return
array("Timing"=>strtoupper($A[1]),"Event"=>strtoupper($A[2]).($Pf?" OF":""),"Of"=>idf_unescape($Pf),"Trigger"=>$B,"Statement"=>$A[4],);}function
triggers($R){$J=array();$nj=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$nj["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$A);$J[$K["name"]]=array($A[1],$A[2]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id($I){return
get_val("SELECT LAST_INSERT_ROWID()");}function
explain($g,$H){return$g->query("EXPLAIN QUERY PLAN $H");}function
found_rows($S,$Z){}function
types(){return
array();}function
create_sql($R,$Ba,$wi){$J=get_val("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$B=>$w){if($B=='')continue;$J
.=";\n\n".index_sql($R,$w['type'],$B,"(".implode(", ",array_map('Adminer\idf_escape',$w['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($Pb,$wi=""){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=array();foreach(get_rows("PRAGMA pragma_list")as$K){$B=$K["name"];if($B!="pragma_list"&&$B!="compile_options"){$J[$B]=array($B,'');foreach(get_rows("PRAGMA $B")as$K)$J[$B][1].=implode(", ",$K)."\n";}}return$J;}function
show_status(){$J=array();foreach(get_vals("PRAGMA compile_options")as$eg)$J[]=explode("=",$eg,2)+array('','');return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Wc);}}add_driver("pgsql","PostgreSQL");if(isset($_GET["pgsql"])){define('Adminer\DRIVER',"pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){class
PgsqlDb
extends
SqlDb{var$extension="PgSQL";var$timeout=0;private$link,$string,$database=true;function
_error($Ec,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$k=adminer()->database();set_error_handler(array($this,'_error'));list($Od,$Qg)=host_port(addcslashes($N,"'\\"));$this->string="host='$Od'".($Qg?" port='$Qg'":"")." user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$ri=adminer()->connectSsl();if(isset($ri["mode"]))$this->string
.=" sslmode='".$ri["mode"]."'";$this->link=@pg_connect("$this->string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->link&&$k!=""){$this->database=false;$this->link=@pg_connect("$this->string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->link)pg_set_client_encoding($this->link,"UTF8");return($this->link?'':$this->error);}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->link,$Q):"'".pg_escape_string($this->link,$Q)."'");}function
value($X,array$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
select_db($Pb){if($Pb==adminer()->database())return$this->database;$J=@pg_connect("$this->string dbname='".addcslashes($Pb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->link=$J;return$J;}function
close(){$this->link=@pg_connect("$this->string dbname='postgres'");}function
query($H,$sj=false){$I=@pg_query($this->link,$H);$this->error="";if(!$I){$this->error=pg_last_error($this->link);$J=false;}elseif(!pg_num_fields($I)){$this->affected_rows=pg_affected_rows($I);$J=true;}else$J=new
Result($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
warnings(){return
h(pg_last_notice($this->link));}function
copyFrom($R,array$L){$this->error='';set_error_handler(function($Ec,$m){$this->error=(ini_bool('html_errors')?html_entity_decode($m):$m);return
true;});$J=pg_copy_from($this->link,$R,$L);restore_error_handler();return$J;}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=pg_num_rows($I);}function
fetch_assoc(){return
pg_fetch_assoc($this->result);}function
fetch_row(){return
pg_fetch_row($this->result);}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->orgtable=pg_field_table($this->result,$d);$J->name=pg_field_name($this->result,$d);$U=pg_field_type($this->result,$d);$J->type=(preg_match(number_type(),$U)?0:15);$J->charsetnr=($U=="bytea"?63:0);return$J;}function
__destruct(){pg_free_result($this->result);}}}elseif(extension_loaded("pdo_pgsql")){class
PgsqlDb
extends
PdoDb{var$extension="PDO_PgSQL";var$timeout=0;function
attach($N,$V,$F){$k=adminer()->database();list($Od,$Qg)=host_port(addcslashes($N,"'\\"));$pc="pgsql:host='$Od'".($Qg?" port='$Qg'":"")." client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'";$ri=adminer()->connectSsl();if(isset($ri["mode"]))$pc
.=" sslmode='".$ri["mode"]."'";return$this->dsn($pc,$V,$F);}function
select_db($Pb){return(adminer()->database()==$Pb);}function
query($H,$sj=false){$J=parent::query($H,$sj);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){}function
copyFrom($R,array$L){$J=$this->pdo->pgsqlCopyFromArray($R,$L);$this->error=idx($this->pdo->errorInfo(),2)?:'';return$J;}function
close(){}}}if(class_exists('Adminer\PgsqlDb')){class
Db
extends
PgsqlDb{function
multi_query($H){if(preg_match('~\bCOPY\s+(.+?)\s+FROM\s+stdin;\n?(.*)\n\\\\\.$~is',str_replace("\r\n","\n",$H),$A)){$L=explode("\n",$A[2]);$this->affected_rows=count($L);return$this->copyFrom($A[1],$L);}return
parent::multi_query($H);}}}class
Driver
extends
SqlDriver{static$extensions=array("PgSQL","PDO_PgSQL");static$jush="pgsql";var$operators=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT ILIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","lower","round","to_hex","to_timestamp","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$nsOid="(SELECT oid FROM pg_namespace WHERE nspname = current_schema())";static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g))return$g;$Pj=get_val("SELECT version()",0,$g);$g->flavor=(preg_match('~CockroachDB~',$Pj)?'cockroach':'');$g->server_info=preg_replace('~^\D*([\d.]+[-\w]*).*~','\1',$Pj);if(min_version(9,0,$g))$g->query("SET application_name = 'Adminer'");if($g->flavor=='cockroach')add_driver(DRIVER,"CockroachDB");return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(29)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(30)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(31)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(32)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),);if(min_version(9.2,0,$g)){$this->types[lang(29)]["json"]=4294967295;if(min_version(9.4,0,$g))$this->types[lang(29)]["jsonb"]=4294967295;}$this->insertFunctions=array("char"=>"md5","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",);if(min_version(12,0,$g))$this->generated=array("STORED");$this->partitionBy=array("RANGE","LIST");if(!$g->flavor)$this->partitionBy[]="HASH";}function
enumLength(array$n){$Ac=$this->types[lang(6)][$n["type"]];return($Ac?type_values($Ac):"");}function
setUserTypes($rj){$this->types[lang(6)]=array_flip($rj);}function
insertReturning($R){$Ba=array_filter(fields($R),function($n){return$n['auto_increment'];});return(count($Ba)==1?" RETURNING ".idf_escape(key($Ba)):"");}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$_j=array();$Z=array();foreach($O
as$y=>$X){$_j[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$_j)." WHERE ".implode(" AND ",$Z))&&$this->conn->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($H,$Ui){$this->conn->query("SET statement_timeout = ".(1000*$Ui));$this->conn->timeout=1000*$Ui;return$H;}function
convertSearch($v,array$X,array$n){$Ri="char|text";if(strpos($X["op"],"LIKE")===false)$Ri
.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$Ri~",$n["type"])?$v:"CAST($v AS text)");}function
quoteBinary($Hh){return"'\\x".bin2hex($Hh)."'";}function
warnings(){return$this->conn->warnings();}function
tableHelp($B,$_e=false){$Ve=array("information_schema"=>"infoschema","pg_catalog"=>($_e?"view":"catalog"),);$_=$Ve[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$B).".html";}function
inheritsFrom($R){return
get_vals("SELECT relname FROM pg_class JOIN pg_inherits ON inhparent = oid WHERE inhrelid = ".$this->tableOid($R)." ORDER BY 1");}function
inheritedTables($R){return
get_vals("SELECT relname FROM pg_inherits JOIN pg_class ON inhrelid = oid WHERE inhparent = ".$this->tableOid($R)." ORDER BY 1");}function
partitionsInfo($R){$K=(min_version(10)?$this->conn->query("SELECT * FROM pg_partitioned_table WHERE partrelid = ".$this->tableOid($R))->fetch_assoc():null);if($K){$_a=get_vals("SELECT attname FROM pg_attribute WHERE attrelid = $K[partrelid] AND attnum IN (".str_replace(" ",", ",$K["partattrs"]).")");$Qa=array('h'=>'HASH','l'=>'LIST','r'=>'RANGE');return
array("partition_by"=>$Qa[$K["partstrat"]],"partition"=>implode(", ",array_map('Adminer\idf_escape',$_a)),);}return
array();}function
tableOid($R){return"(SELECT oid FROM pg_class WHERE relnamespace = $this->nsOid AND relname = ".q($R)." AND relkind IN ('r', 'm', 'v', 'f', 'p'))";}function
indexAlgorithms(array$Bi){static$J=array();if(!$J)$J=get_vals("SELECT amname FROM pg_am".(min_version(9.6)?" WHERE amtype = 'i'":"")." ORDER BY amname = '".($this->conn->flavor=='cockroach'?"prefix":"btree")."' DESC, amname");return$J;}function
supportsIndex(array$S){return$S["Engine"]!="view";}function
hasCStyleEscapes(){static$Sa;if($Sa===null)$Sa=(get_val("SHOW standard_conforming_strings",0,$this->conn)=="off");return$Sa;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return(preg_match('~^INTO~',$H)?limit($H,$Z,1,0,$Vh):" $H".(is_view(table_status1($R))?$Z:$Vh."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$Vh."LIMIT 1)"));}function
db_collation($k,$lb){return
get_val("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
logged_user(){return
get_val("SELECT user");}function
tables_list(){$H="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$H
.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$H
.="
ORDER BY 1";return
get_key_vals($H);}function
count_tables($j){$J=array();foreach($j
as$k){if(connection()->select_db($k))$J[$k]=count(tables_list());}return$J;}function
table_status($B=""){static$Hd;if($Hd===null)$Hd=get_val("SELECT 'pg_table_size'::regproc");$J=array();foreach(get_rows("SELECT
	relname AS \"Name\",
	CASE relkind WHEN 'v' THEN 'view' WHEN 'm' THEN 'materialized view' ELSE 'table' END AS \"Engine\"".($Hd?",
	pg_table_size(c.oid) AS \"Data_length\",
	pg_indexes_size(c.oid) AS \"Index_length\"":"").",
	obj_description(c.oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	reltuples AS \"Rows\",
	".(min_version(10)?"relispartition::int AS partition,":"")."
	current_schema() AS nspname
FROM pg_class c
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
AND relnamespace = ".driver()->nsOid."
".($B!=""?"AND relname = ".q($B):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$J=array();$ta=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT
	a.attname AS field,
	format_type(a.atttypid, a.atttypmod) AS full_type,
	pg_get_expr(d.adbin, d.adrelid) AS default,
	a.attnotnull::int,
	col_description(a.attrelid, a.attnum) AS comment".(min_version(10)?",
	a.attidentity".(min_version(12)?",
	a.attgenerated":""):"")."
FROM pg_attribute a
LEFT JOIN pg_attrdef d ON a.attrelid = d.adrelid AND a.attnum = d.adnum
WHERE a.attrelid = ".driver()->tableOid($R)."
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$A);list(,$U,$Re,$K["length"],$ma,$xa)=$A;$K["length"].=$xa;$ab=$U.$ma;if(isset($ta[$ab])){$K["type"]=$ta[$ab];$K["full_type"]=$K["type"].$Re.$xa;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$Re.$ma.$xa;}if(in_array($K['attidentity'],array('a','d')))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$A))$K["default"]=($A[1]=="NULL"?null:idf_unescape($A[1]).$A[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$Ei=driver()->tableOid($R);$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Ei AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, amname, pg_get_expr(indpred, indrelid, true) AS partial, pg_get_expr(indexprs, indrelid) AS indexpr
FROM pg_index
JOIN pg_class ON indexrelid = oid
JOIN pg_am ON pg_am.oid = pg_class.relam
WHERE indrelid = $Ei
ORDER BY indisprimary DESC, indisunique DESC",$h)as$K){$vh=$K["relname"];$J[$vh]["type"]=($K["partial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$vh]["columns"]=array();$J[$vh]["descs"]=array();$J[$vh]["algorithm"]=$K["amname"];$J[$vh]["partial"]=$K["partial"];$ge=preg_split('~(?<=\)), (?=\()~',$K["indexpr"]);foreach(explode(" ",$K["indkey"])as$he)$J[$vh]["columns"][]=($he?$e[$he]:array_shift($ge));foreach(explode(" ",$K["indoption"])as$ie)$J[$vh]["descs"][]=(intval($ie)&1?'1':null);$J[$vh]["lengths"]=array();}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = ".driver()->tableOid($R)."
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$A)){$K['source']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$A[2],$bf)){$K['ns']=idf_unescape($bf[2]);$K['table']=idf_unescape($bf[4]);}$K['target']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[3])));$K['on_delete']=(preg_match("~ON DELETE (".driver()->onActions.")~",$A[4],$bf)?$bf[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE (".driver()->onActions.")~",$A[4],$bf)?$bf[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
view($B){return
array("select"=>trim(get_val("SELECT pg_get_viewdef(".driver()->tableOid($B).")")));}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="information_schema";}function
error(){$J=h(connection()->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$A))$J=$A[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($A[3]).'})(.*)~','\1<b>\2</b>',$A[2]).$A[4];return
nl_br($J);}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" ENCODING ".idf_escape($c):""));}function
drop_databases($j){connection()->close();return
apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');}function
rename_database($B,$c){connection()->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($B));}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=array();$ih=array();if($R!=""&&$R!=$B)$ih[]="ALTER TABLE ".table($R)." RENAME TO ".table($B);$Wh="";foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b[]="DROP $d";else{$Lj=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$b[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$b[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$ih[]="ALTER TABLE ".table($B)." RENAME $d TO $X[0]";$b[]="ALTER $d TYPE$X[1]";$Xh=$R."_".idf_unescape($X[0])."_seq";$b[]="ALTER $d ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($Xh).")":"DROP DEFAULT"));if(isset($X[6]))$Wh="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($Xh)." OWNED BY ".idf_escape($R).".$X[0]";$b[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($n[0]!=""||$Lj!="")$ih[]="COMMENT ON COLUMN ".table($B).".$X[0] IS ".($Lj!=""?substr($Lj,9):"''");}}$b=array_merge($b,$ld);if($R==""){$P="";if($E){$gb=(connection()->flavor=='cockroach');$P=" PARTITION BY $E[partition_by]($E[partition])";if($E["partition_by"]=='HASH'){$Gg=+$E["partitions"];for($t=0;$t<$Gg;$t++)$ih[]="CREATE TABLE ".idf_escape($B."_$t")." PARTITION OF ".idf_escape($B)." FOR VALUES WITH (MODULUS $Gg, REMAINDER $t)";}else{$Yg="MINVALUE";foreach($E["partition_names"]as$t=>$X){$Y=$E["partition_values"][$t];$Cg=" VALUES ".($E["partition_by"]=='LIST'?"IN ($Y)":"FROM ($Yg) TO ($Y)");if($gb)$P
.=($t?",":" (")."\n  PARTITION ".(preg_match('~^DEFAULT$~i',$X)?$X:idf_escape($X))."$Cg";else$ih[]="CREATE TABLE ".idf_escape($B."_$X")." PARTITION OF ".idf_escape($B)." FOR$Cg";$Yg=$Y;}$P
.=($gb?"\n)":"");}}array_unshift($ih,"CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");}elseif($b)array_unshift($ih,"ALTER TABLE ".table($R)."\n".implode(",\n",$b));if($Wh)array_unshift($ih,$Wh);if($qb!==null)$ih[]="COMMENT ON TABLE ".table($B)." IS ".q($qb);foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
alter_indexes($R,$b){$i=array();$kc=array();$ih=array();foreach($b
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$ih[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R).($X[3]?" USING $X[3]":"")." (".implode(", ",$X[2]).")".($X[4]?" WHERE $X[4]":"");}if($i)array_unshift($ih,"ALTER TABLE ".table($R).implode(",",$i));if($kc)array_unshift($ih,"DROP INDEX ".implode(", ",$kc));foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('Adminer\table',$T)));}function
drop_views($Rj){return
drop_tables($Rj);}function
drop_tables($T){foreach($T
as$R){$P=table_status1($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$Rj,$Mi){foreach(array_merge($T,$Rj)as$R){$P=table_status1($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($Mi)))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($B);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$e[]=$K["event_object_column"];$J=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement"
FROM information_schema.triggers'."
$Z
ORDER BY event_manipulation DESC")as$K){if($e&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$e);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$lj=trigger($K["trigger_name"],$R);$J[$lj["Trigger"]]=array($lj["Timing"],$lj["Event"]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($B,$U){$L=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($B));$J=idx($L,0,array());$J["returns"]=array("type"=>$J["type_udt_name"]);$J["fields"]=get_rows('SELECT COALESCE(parameter_name, ordinal_position::text) AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($B).'
ORDER BY ordinal_position');return$J;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($B,$K){$J=array();foreach($K["fields"]as$n){$Re=$n["length"];$J[]=$n["type"].($Re?"($Re)":"");}return
idf_escape($B)."(".implode(", ",$J).")";}function
last_id($I){$K=(is_object($I)?$I->fetch_row():array());return($K?$K[0]:0);}function
explain($g,$H){return$g->query("EXPLAIN $H");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",get_val("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$uh))return$uh[1];}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = ".driver()->nsOid."
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($u){$Dc=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $u ORDER BY enumsortorder");return($Dc?"'".implode("', '",array_map('addslashes',$Dc))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
get_val("SELECT current_schema()");}function
set_schema($Jh,$h=null){if(!$h)$h=connection();$J=$h->query("SET search_path TO ".idf_escape($Jh));driver()->setUserTypes(types());return$J;}function
foreign_keys_sql($R){$J="";$P=table_status1($R);$hd=foreign_keys($R);ksort($hd);foreach($hd
as$gd=>$fd)$J
.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($gd)." $fd[definition] ".($fd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Ba,$wi){$_h=array();$Yh=array();$P=table_status1($R);if(is_view($P)){$Qj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $Qj[select]",";");}$o=fields($R);if(count($P)<2||empty($o))return
false;$J="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($o
as$n){$Ag=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['null']?"":" NOT NULL");$_h[]=$Ag;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$df)){$Xh=$df[1];$li=first(get_rows((min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($Xh)):"SELECT * FROM $Xh"),null,"-- "));$Yh[]=($wi=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $Xh;\n":"")."CREATE SEQUENCE $Xh INCREMENT $li[increment_by] MINVALUE $li[min_value] MAXVALUE $li[max_value]".($Ba&&$li['last_value']?" START ".($li["last_value"]+1):"")." CACHE $li[cache_value];";}}if(!empty($Yh))$J=implode("\n\n",$Yh)."\n\n$J";$G="";foreach(indexes($R)as$ee=>$w){if($w['type']=='PRIMARY'){$G=$ee;$_h[]="CONSTRAINT ".idf_escape($ee)." PRIMARY KEY (".implode(', ',array_map('Adminer\idf_escape',$w['columns'])).")";}}foreach(driver()->checkConstraints($R)as$wb=>$yb)$_h[]="CONSTRAINT ".idf_escape($wb)." CHECK $yb";$J
.=implode(",\n    ",$_h)."\n)";$Cg=driver()->partitionsInfo($P['Name']);if($Cg)$J
.="\nPARTITION BY $Cg[partition_by]($Cg[partition])";$J
.="\nWITH (oids = ".($P['Oid']?'true':'false').");";if($P['Comment'])$J
.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($o
as$Yc=>$n){if($n['comment'])$J
.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Yc)." IS ".q($n['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($G?" AND indexname != ".q($G):""),null,"-- ")as$K)$J
.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status1($R);$J="";foreach(triggers($R)as$kj=>$jj){$lj=trigger($kj,$P['Name']);$J
.="\nCREATE TRIGGER ".idf_escape($lj['Trigger'])." $lj[Timing] $lj[Event] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $lj[Type] $lj[Statement];;\n";}return$J;}function
use_sql($Pb,$wi=""){$B=idf_escape($Pb);$J="";if(preg_match('~CREATE~',$wi)){if($wi=="DROP+CREATE")$J="DROP DATABASE IF EXISTS $B;\n";$J
.="CREATE DATABASE $B;\n";}return"$J\\connect $B";}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|columns|comment|database|drop_col|dump|descidx|indexes|kill|partial_indexes|routine|scheme|sequence|sql|table|trigger|type|variables|view'.(min_version(9.3)?'|materializedview':'').(min_version(11)?'|procedure':'').(connection()->flavor=='cockroach'?'':'|processlist').')$~',$Wc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
get_val("SHOW max_connections");}}add_driver("oracle","Oracle (beta)");if(isset($_GET["oracle"])){define('Adminer\DRIVER',"oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="oci8";var$_current_db;private$link;function
_error($Ec,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$this->link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->link){$this->server_info=oci_server_version($this->link);return'';}$m=oci_error();return$m["message"];}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($Pb){$this->_current_db=$Pb;return
true;}function
query($H,$sj=false){$I=oci_parse($this->link,$H);$this->error="";if(!$I){$m=oci_error($this->link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
Result($I);$this->affected_rows=oci_num_rows($I);oci_free_statement($I);}return$J;}function
timeout($yf){return
oci_set_call_timeout($this->link,$yf);}}class
Result{var$num_rows;private$result,$offset=1;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'OCILob')||is_a($X,'OCI-Lob'))$K[$y]=$X->load();}return$K;}function
fetch_assoc(){return$this->convert(oci_fetch_assoc($this->result));}function
fetch_row(){return$this->convert(oci_fetch_row($this->result));}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->name=oci_field_name($this->result,$d);$J->type=oci_field_type($this->result,$d);$J->charsetnr=(preg_match("~raw|blob|bfile~",$J->type)?63:0);return$J;}function
__destruct(){oci_free_statement($this->result);}}}elseif(extension_loaded("pdo_oci")){class
Db
extends
PdoDb{var$extension="PDO_OCI";var$_current_db;function
attach($N,$V,$F){return$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);}function
select_db($Pb){$this->_current_db=$Pb;return
true;}}}class
Driver
extends
SqlDriver{static$extensions=array("OCI8","PDO_OCI");static$jush="oracle";var$insertFunctions=array("date"=>"current_date","timestamp"=>"current_timestamp",);var$editFunctions=array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("length","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(29)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(30)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),);}function
begin(){return
true;}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$_j=array();$Z=array();foreach($O
as$y=>$X){$_j[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$_j)." WHERE ".implode(" AND ",$Z))&&$this->conn->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return($C?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $H$Z) t WHERE rownum <= ".($z+$C).") WHERE rnum > $C":($z?" * FROM (SELECT $H$Z) WHERE rownum <= ".($z+$C):" $H$Z"));}function
limit1($R,$H,$Z,$Vh="\n"){return" $H$Z";}function
db_collation($k,$lb){return
get_val("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
get_val("SELECT USER FROM DUAL");}function
get_current_db(){$k=connection()->_current_db?:DB;unset(connection()->_current_db);return$k;}function
where_owner($Wg,$vg="owner"){if(!$_GET["ns"])return'';return"$Wg$vg = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$vg=where_owner('');return"(SELECT $e FROM all_views WHERE ".($vg?:"rownum < 0").")";}function
tables_list(){$Qj=views_table("view_name");$vg=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$vg
UNION SELECT view_name, 'view' FROM $Qj
ORDER BY 1");}function
count_tables($j){$J=array();foreach($j
as$k)$J[$k]=get_val("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$J;}function
table_status($B=""){$J=array();$Oh=q($B);$k=get_current_db();$Qj=views_table("view_name");$vg=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$vg.($B!=""?" AND table_name = $Oh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $Qj".($B!=""?" WHERE view_name = $Oh":"")."
ORDER BY 1")as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=array();$vg=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$vg ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$Re="$K[DATA_PRECISION],$K[DATA_SCALE]";if($Re==",")$Re=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=array("field"=>$K["COLUMN_NAME"],"full_type"=>$U.($Re?"($Re)":""),"type"=>strtolower($U),"length"=>$Re,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),);}return$J;}function
indexes($R,$h=null){$J=array();$vg=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$vg
ORDER BY ac.constraint_type, aic.column_position",$h)as$K){$ee=$K["INDEX_NAME"];$nb=$K["DATA_DEFAULT"];$nb=($nb?trim($nb,'"'):$K["COLUMN_NAME"]);$J[$ee]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$ee]["columns"][]=$nb;$J[$ee]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$ee]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($B){$Qj=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$Qj.' WHERE view_name = '.q($B));return
reset($L);}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
h(connection()->error);}function
explain($g,$H){$g->query("EXPLAIN PLAN FOR $H");return$g->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=$kc=array();$og=($R?fields($R):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$ng=$og[$n[0]];if($X&&$ng){$Rf=process_field($ng,$ng);if($X[2]==$Rf[2])$X[2]="";}if($X)$b[]=($R!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$kc[]=idf_escape($n[0]);}if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)");return(!$b||queries("ALTER TABLE ".table($R)."\n".implode("\n",$b)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$kc).")"))&&($R==$B||queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)));}function
alter_indexes($R,$b){$kc=array();$ih=array();foreach($b
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($ih,"ALTER TABLE ".table($R).$i);}elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$ih[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($kc)array_unshift($ih,"DROP INDEX ".implode(", ",$kc));foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
foreign_keys($R){$J=array();$H="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($H)as$K)$J[$K['NAME']]=array("db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>array($K['SRC_COLUMN']),"target"=>array($K['DEST_COLUMN']),"on_delete"=>$K['ON_DELETE'],"on_update"=>null,);return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Rj){return
apply_queries("DROP VIEW",$Rj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){return
get_val("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($Lh,$h=null){if(!$h)$h=connection();return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($Lh));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=array();$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$y=>$X)$J[]=array($y,$X);return$J;}function
process_list(){return
get_rows('SELECT
	sess.process AS "process",
	sess.username AS "user",
	sess.schemaname AS "schema",
	sess.status AS "status",
	sess.wait_class AS "wait_class",
	sess.seconds_in_wait AS "seconds_in_wait",
	sql.sql_text AS "sql_text",
	sess.machine AS "machine",
	sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Wc);}}add_driver("mssql","MS SQL");if(isset($_GET["mssql"])){define('Adminer\DRIVER',"mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="sqlsrv";private$link,$result;private
function
get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error
.="$m[message]\n";}$this->error=rtrim($this->error);}function
attach($N,$V,$F){$xb=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");$ri=adminer()->connectSsl();if(isset($ri["Encrypt"]))$xb["Encrypt"]=$ri["Encrypt"];if(isset($ri["TrustServerCertificate"]))$xb["TrustServerCertificate"]=$ri["TrustServerCertificate"];$k=adminer()->database();if($k!="")$xb["Database"]=$k;list($Od,$Qg)=host_port($N);$this->link=@sqlsrv_connect($Od.($Qg?",$Qg":""),$xb);if($this->link){$je=sqlsrv_server_info($this->link);$this->server_info=$je['SQLServerVersion'];}else$this->get_error();return($this->link?'':$this->error);}function
quote($Q){$tj=strlen($Q)!=strlen(utf8_decode($Q));return($tj?"N":"")."'".str_replace("'","''",$Q)."'";}function
select_db($Pb){return$this->query(use_sql($Pb));}function
query($H,$sj=false){$I=sqlsrv_query($this->link,$H);$this->error="";if(!$I){$this->get_error();return
false;}return$this->store_result($I);}function
multi_query($H){$this->result=sqlsrv_query($this->link,$H);$this->error="";if(!$this->result){$this->get_error();return
false;}return
true;}function
store_result($I=null){if(!$I)$I=$this->result;if(!$I)return
false;if(sqlsrv_field_metadata($I))return
new
Result($I);$this->affected_rows=sqlsrv_rows_affected($I);return
true;}function
next_result(){return$this->result?!!sqlsrv_next_result($this->result):false;}}class
Result{var$num_rows;private$result,$offset=0,$fields;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'DateTime'))$K[$y]=$X->format("Y-m-d H:i:s");}return$K;}function
fetch_assoc(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->fields)$this->fields=sqlsrv_field_metadata($this->result);$n=$this->fields[$this->offset++];$J=new
\stdClass;$J->name=$n["Name"];$J->type=($n["Type"]==1?254:15);$J->charsetnr=0;return$J;}function
seek($C){for($t=0;$t<$C;$t++)sqlsrv_fetch($this->result);}function
__destruct(){sqlsrv_free_stmt($this->result);}}function
last_id($I){return
get_val("SELECT SCOPE_IDENTITY()");}function
explain($g,$H){$g->query("SET SHOWPLAN_ALL ON");$J=$g->query($H);$g->query("SET SHOWPLAN_ALL OFF");return$J;}}else{abstract
class
MssqlDb
extends
PdoDb{function
select_db($Pb){return$this->query(use_sql($Pb));}function
lastInsertId(){return$this->pdo->lastInsertId();}}function
last_id($I){return
connection()->lastInsertId();}function
explain($g,$H){}if(extension_loaded("pdo_sqlsrv")){class
Db
extends
MssqlDb{var$extension="PDO_SQLSRV";function
attach($N,$V,$F){list($Od,$Qg)=host_port($N);return$this->dsn("sqlsrv:Server=$Od".($Qg?",$Qg":""),$V,$F);}}}elseif(extension_loaded("pdo_dblib")){class
Db
extends
MssqlDb{var$extension="PDO_DBLIB";function
attach($N,$V,$F){list($Od,$Qg)=host_port($N);return$this->dsn("dblib:charset=utf8;host=$Od".($Qg?(is_numeric($Qg)?";port=":";unix_socket=").$Qg:""),$V,$F);}}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLSRV","PDO_SQLSRV","PDO_DBLIB");static$jush="mssql";var$insertFunctions=array("date|time"=>"getdate");var$editFunctions=array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("len","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$generated=array("PERSISTED","VIRTUAL");var$onActions="NO ACTION|CASCADE|SET NULL|SET DEFAULT";static
function
connect($N,$V,$F){if($N=="")$N="localhost:1433";return
parent::connect($N,$V,$F);}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(29)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(30)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),);}function
insertUpdate($R,array$L,array$G){$o=fields($R);$_j=array();$Z=array();$O=reset($L);$e="c".implode(", c",range(1,count($O)));$Ra=0;$pe=array();foreach($O
as$y=>$X){$Ra++;$B=idf_unescape($y);if(!$o[$B]["auto_increment"])$pe[$y]="c$Ra";if(isset($G[$B]))$Z[]="$y = c$Ra";else$_j[]="$y = c$Ra";}$Mj=array();foreach($L
as$O)$Mj[]="(".implode(", ",$O).")";if($Z){$Td=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$Mj)."\n) AS source ($e) ON ".implode(" AND ",$Z).($_j?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$_j):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($Td?$O:$pe)).") VALUES (".($Td?$e:implode(", ",$pe)).");");if($Td)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES\n".implode(",\n",$Mj));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($B,$_e=false){$Ve=array("sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",);$_=$Ve[get_schema()];if($_)return"relational-databases/system-$_".preg_replace('~_~','-',strtolower($B))."-transact-sql";}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return($z?" TOP (".($z+$C).")":"")." $H$Z";}function
limit1($R,$H,$Z,$Vh="\n"){return
limit($H,$Z,1,0,$Vh);}function
db_collation($k,$lb){return
get_val("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
logged_user(){return
get_val("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){$J=array();foreach($j
as$k){connection()->select_db($k);$J[$k]=get_val("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($B=""){$J=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$sb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=array();$Ci=get_val("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($Ci))as$K){$U=$K["type"];$Re=(preg_match("~char|binary~",$U)?intval($K["max_length"])/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=array("field"=>$K["name"],"full_type"=>$U.($Re?"($Re)":""),"type"=>$U,"length"=>$Re,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$A)?str_replace("''","'",$A[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["is_primary_key"],"comment"=>$sb[$K["name"]],);}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($Ci))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$h)as$K){$B=$K["name"];$J[$B]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$B]["lengths"]=array();$J[$B]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$B]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',get_val("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($B))));}function
collations(){$J=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$c)$J[preg_replace('~_.*~','',$c)][]=$c;return$J;}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',connection()->error)));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$c)?" COLLATE $c":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('Adminer\idf_escape',$j)));}function
rename_database($B,$c){if(preg_match('~^[a-z0-9_]+$~i',$c))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $c");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($B));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=array();$sb=array();$og=fields($R);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$sb[$n[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($n[0]=="")$b["ADD"][]="\n  ".implode("",$X).($R==""?substr($ld[$X[0]],16+strlen($X[0])):"");else{$l=$X[3];unset($X[3]);unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($R).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$b["ALTER COLUMN ".implode("",$X)][]="";$ng=$og[$n[0]];if(default_value($ng)!=$l){if($ng["default"]!==null)$b["DROP"][]=" ".idf_escape($ng["default_constraint"]);if($l)$b["ADD"][]="\n $l FOR $d";}}}}if($R=="")return
queries("CREATE TABLE ".table($B)." (".implode(",",(array)$b["ADD"])."\n)");if($R!=$B)queries("EXEC sp_rename ".q(table($R)).", ".q($B));if($ld)$b[""]=$ld;foreach($b
as$y=>$X){if(!queries("ALTER TABLE ".table($B)." $y".implode(",",$X)))return
false;}foreach($sb
as$y=>$X){$qb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($B).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty
@name = N'MS_Description',
@value = $qb,
@level0type = N'Schema',
@level0name = ".q(get_schema()).",
@level1type = N'Table',
@level1name = ".q($B).",
@level2type = N'Column',
@level2name = ".q($y));}return
true;}function
alter_indexes($R,$b){$w=array();$kc=array();foreach($b
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$kc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$kc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=array();$Yf=array("CASCADE","NO ACTION","SET NULL","SET DEFAULT");foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$q=&$J[$K["FK_NAME"]];$q["db"]=$K["PKTABLE_QUALIFIER"];$q["ns"]=$K["PKTABLE_OWNER"];$q["table"]=$K["PKTABLE_NAME"];$q["on_update"]=$Yf[$K["UPDATE_RULE"]];$q["on_delete"]=$Yf[$K["DELETE_RULE"]];$q["source"][]=$K["FKCOLUMN_NAME"];$q["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Rj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Rj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$Rj,$Mi){return
apply_queries("ALTER SCHEMA ".idf_escape($Mi)." TRANSFER",array_merge($T,$Rj));}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($B));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
get_val("SELECT SCHEMA_NAME()");}function
set_schema($Jh){$_GET["ns"]=$Jh;return
true;}function
create_sql($R,$Ba,$wi){if(is_view(table_status1($R))){$Qj=view($R);return"CREATE VIEW ".table($R)." AS $Qj[select]";}$o=array();$G=false;foreach(fields($R)as$B=>$n){$X=process_field($n,$n);if($X[6])$G=true;$o[]=implode("",$X);}foreach(indexes($R)as$B=>$w){if(!$G||$w["type"]!="PRIMARY"){$e=array();foreach($w["columns"]as$y=>$X)$e[]=idf_escape($X).($w["descs"][$y]?" DESC":"");$B=idf_escape($B);$o[]=($w["type"]=="INDEX"?"INDEX $B":"CONSTRAINT $B ".($w["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$e).")";}}foreach(driver()->checkConstraints($R)as$B=>$Ya)$o[]="CONSTRAINT ".idf_escape($B)." CHECK ($Ya)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$o)."\n)";}function
foreign_keys_sql($R){$o=array();foreach(foreign_keys($R)as$ld)$o[]=ltrim(format_foreign_key($ld));return($o?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$o).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($Pb,$wi=""){return"USE ".idf_escape($Pb);}function
trigger_sql($R){$J="";foreach(triggers($R)as$B=>$lj)$J
.=create_trigger(" ON ".table($R),trigger($B,$R)).";";return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Wc);}}class
Adminer{static$instance;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.1")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($jd=true){return
get_databases($jd);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
afterConnect(){}function
headers(){}function
csp(array$Ib){return$Ib;}function
head($Mb=null){return
true;}function
bodyClass(){echo" adminer";}function
css(){$J=array();foreach(array("","-dark")as$xf){$p="adminer$xf.css";if(file_exists($p)){$bd=file_get_contents($p);$J["$p?v=".crc32($bd)]=($xf?"dark":(preg_match('~prefers-color-scheme:\s*dark~',$bd)?'':'light'));}}return$J;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(33).'<td>',html_select("auth[driver]",SqlDriver::$drivers,DRIVER,"loginDriver(this);")),adminer()->loginFormField('server','<tr><th>'.lang(34).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(35).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("const authDriver = qs('#username').form['auth[driver]']; authDriver && authDriver.onchange();")),adminer()->loginFormField('password','<tr><th>'.lang(36).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(37).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(38)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(39))."\n";}function
loginFormField($B,$Jd,$Y){return$Jd.$Y."\n";}function
login($Xe,$F){if($F=="")return
lang(40,target_blank());return
true;}function
tableName(array$Bi){return
h($Bi["Name"]);}function
fieldName(array$n,$hg=0){$U=$n["full_type"];$qb=$n["comment"];return'<span title="'.h($U.($qb!=""?($U?": ":"").$qb:'')).'">'.h($n["field"]).'</span>';}function
selectLinks(array$Bi,$O=""){$B=$Bi["Name"];echo'<p class="links">';$Ve=array("select"=>lang(41));if(support("table")||support("indexes"))$Ve["table"]=lang(42);$_e=false;if(support("table")){$_e=is_view($Bi);if(!$_e)$Ve["create"]=lang(43);elseif(support("view"))$Ve["view"]=lang(44);}if($O!==null)$Ve["edit"]=lang(45);foreach($Ve
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($B).($y=="edit"?$O:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($B,$_e)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Ai){return
array();}function
backwardKeysPrint(array$Fa,array$K){}function
selectQuery($H,$si,$Uc=false){$J="</p>\n";if(!$Uc&&($Uj=driver()->warnings())){$u="warnings";$J=", <a href='#$u'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$J<div id='$u' class='hidden'>\n$Uj</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$H))."</code> <span class='time'>(".format_time($si).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($H)."'>".lang(12)."</a>":"").$J;}function
sqlCommandQuery($H){return
shorten_utf8(trim($H),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$L,array$md){return$L;}function
selectLink($X,array$n){}function
selectVal($X,$_,array$n,$rg){$J=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":(preg_match('~json~',$n["type"])?"<code class='jush-js'>$X</code>":$X)));if(is_blob($n)&&!is_utf8($X))$J="<i>".lang(47,strlen($rg))."</i>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$J</a>":$J);}function
editVal($X,array$n){return$X;}function
config(){return
array();}function
tableStructurePrint(array$o,$Bi=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(48)."<td>".lang(49).(support("comment")?"<td>".lang(50):"")."</thead>\n";$vi=driver()->structuredTypes();foreach($o
as$n){echo"<tr><th>".h($n["field"]);$U=h($n["full_type"]);$c=h($n["collation"]);echo"<td><span title='$c'>".(in_array($U,(array)$vi[lang(6)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($c&&isset($Bi["Collation"])&&$c!=$Bi["Collation"]?" $c":""))."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(51)."</i>":"");$l=h($n["default"]);echo(isset($n["default"])?" <span title='".lang(52)."'>[<b>".($n["generated"]?"<code class='jush-".JUSH."'>$l</code>":$l)."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x,array$Bi){$Bg=false;foreach($x
as$B=>$w)$Bg|=!!$w["partial"];echo"<table>\n";$Ub=first(driver()->indexAlgorithms($Bi));foreach($x
as$B=>$w){ksort($w["columns"]);$ah=array();foreach($w["columns"]as$y=>$X)$ah[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($B)."'>","<th>$w[type]".($Ub&&$w['algorithm']!=$Ub?" ($w[algorithm])":""),"<td>".implode(", ",$ah);if($Bg)echo"<td>".($w['partial']?"<code class='jush-".JUSH."'>WHERE ".h($w['partial']):"");echo"\n";}echo"</table>\n";}function
selectColumnsPrint(array$M,array$e){print_fieldset("select",lang(53),$M);$t=0;$M[""]=array();foreach($M
as$y=>$X){$X=idx($_GET["columns"],$y,array());$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(54)=>driver()->functions,lang(55)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$e,array$x){print_fieldset("search",lang(56),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h(idx($_GET["fulltext"],$t))."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Va="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(57).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Va),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Va }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$hg,array$e,array$x){print_fieldset("sort",lang(58),$hg);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(59))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(59))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Si){if($Si!==null)echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Si)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(62)."</legend><div>","<input type='submit' value='".lang(53)."'>"," <span id='noindex' title='".lang(63)."'></span>","<script".nonce().">\n","const indexColumns = ";$e=array();foreach($x
as$w){$Lb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Lb)$e[$Lb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$wc,array$e){}function
selectColumnsProcess(array$e,array$x){$M=array();$yd=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$M[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$yd[]=$M[$y];}}return
array($M,$yd);}function
selectSearchProcess(array$o,array$x){$J=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&idx($_GET["fulltext"],$t)!="")$J[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){$jb=$X["col"];if("$jb$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$ub=array();foreach(($jb!=""?array($jb=>$o[$jb]):$o)as$B=>$n){$Wg="";$tb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Yd=process_length($X["val"]);$tb
.=" ".($Yd!=""?$Yd:"(NULL)");}elseif($X["op"]=="SQL")$tb=" $X[val]";elseif(preg_match('~^(I?LIKE) %%$~',$X["op"],$A))$tb=" $A[1] ".adminer()->processInput($n,"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$Wg="$X[op](".q($X["val"]).", ";$tb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$tb
.=" ".adminer()->processInput($n,$X["val"]);if($jb!=""||(isset($n["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"]))))$ub[]=$Wg.driver()->convertSearch(idf_escape($B),$X,$n).$tb;}$J[]=(count($ub)==1?$ub[0]:($ub?"(".implode(" OR ",$ub).")":"1 = 0"));}}return$J;}function
selectOrderProcess(array$o,array$x){$J=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$J;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$md){return
false;}function
selectQueryBuild(array$M,array$Z,array$yd,array$hg,$z,$D){return"";}function
messageQuery($H,$Ti,$Uc=false){restart_session();$Ld=&get_session("queries");if(!idx($Ld,$_GET["db"]))$Ld[$_GET["db"]]=array();if(strlen($H)>1e6)$H=preg_replace('~[\x80-\xFF]+$~','',substr($H,0,1e6))."\n…";$Ld[$_GET["db"]][]=array($H,time(),$Ti);$oi="sql-".count($Ld[$_GET["db"]]);$J="<a href='#$oi' class='toggle'>".lang(64)."</a> <a href='' class='jsonly copy'>🗐</a>\n";if(!$Uc&&($Uj=driver()->warnings())){$u="warnings-".count($Ld[$_GET["db"]]);$J="<a href='#$u' class='toggle'>".lang(46)."</a>, $J<div id='$u' class='hidden'>\n$Uj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $J<div id='$oi' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($H,1000)."</code></pre>".($Ti?" <span class='time'>($Ti)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ld[$_GET["db"]])-1)).'">'.lang(12).'</a>':'').'</div>';}function
editRowPrint($R,array$o,$K,$_j){}function
editFunctions(array$n){$J=($n["null"]?"NULL/":"");$_j=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$td){if(!$y||(!isset($_GET["call"])&&$_j)){foreach($td
as$Kg=>$X){if(!$Kg||preg_match("~$Kg~",$n["type"]))$J
.="/$X";}}if($y&&$td&&!preg_match('~set|bool~',$n["type"])&&!is_blob($n))$J
.="/SQL";}if($n["auto_increment"]&&!$_j)$J=lang(51);return
explode("/",$J);}function
editInput($R,array$n,$_a,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$_a value='orig' checked><i>".lang(10)."</i></label> ":"").enum_input("radio",$_a,$n,$Y,"NULL");return"";}function
editHint($R,array$n,$Y){return"";}function
processInput(array$n,$Y,$s=""){if($s=="SQL")return$Y;$B=$n["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$J="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$J=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$J=idf_escape($B)." $s $J";elseif(preg_match('~^[+-] interval$~',$s))$J=idf_escape($B)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)&&JUSH!="pgsql"?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$J="$s(".idf_escape($B).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$J="$s($J)";return
unconvert_field($n,$J);}function
dumpOutput(){$J=array('text'=>lang(65),'file'=>lang(66));if(function_exists('gzencode'))$J['gz']='gzip';return$J;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($R,$wi,$_e=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($wi)dump_csv(array_keys(fields($R)));}else{if($_e==2){$o=array();foreach(fields($R)as$B=>$n)$o[]=idf_escape($B)." $n[full_type]";$i="CREATE TABLE ".table($R)." (".implode(", ",$o).")";}else$i=create_sql($R,$_POST["auto_increment"],$wi);set_utf8mb4($i);if($wi&&$i){if($wi=="DROP+CREATE"||$_e==1)echo"DROP ".($_e==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($_e==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($R,$wi,$H){if($wi){$hf=(JUSH=="sqlite"?0:1048576);$o=array();$Ud=false;if($_POST["format"]=="sql"){if($wi=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$o=fields($R);if(JUSH=="mssql"){foreach($o
as$n){if($n["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$Ud=true;break;}}}}$I=connection()->query($H,1);if($I){$pe="";$Pa="";$Ee=array();$ud=array();$yi="";$Xc=($R!=''?'fetch_assoc':'fetch_row');$Eb=0;while($K=$I->$Xc()){if(!$Ee){$Mj=array();foreach($K
as$X){$n=$I->fetch_field();if(idx($o[$n->name],'generated')){$ud[$n->name]=true;continue;}$Ee[]=$n->name;$y=idf_escape($n->name);$Mj[]="$y = VALUES($y)";}$yi=($wi=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Mj):"").";\n";}if($_POST["format"]!="sql"){if($wi=="table"){dump_csv($Ee);$wi="INSERT";}dump_csv($K);}else{if(!$pe)$pe="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$Ee)).") VALUES";foreach($K
as$y=>$X){if($ud[$y]){unset($K[$y]);continue;}$n=$o[$y];$K[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Hh=($hf?"\n":" ")."(".implode(",\t",$K).")";if(!$Pa)$Pa=$pe.$Hh;elseif(JUSH=='mssql'?$Eb%1000!=0:strlen($Pa)+4+strlen($Hh)+strlen($yi)<$hf)$Pa
.=",$Hh";else{echo$Pa.$yi;$Pa=$pe.$Hh;}}$Eb++;}if($Pa)echo$Pa.$yi;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($Ud)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($Sd){return
friendly_url($Sd!=""?$Sd:(SERVER?:"localhost"));}function
dumpHeaders($Sd,$_f=false){$ug=$_POST["output"];$Pc=(preg_match('~sql~',$_POST["format"])?"sql":($_f?"tar":"csv"));header("Content-Type: ".($ug=="gz"?"application/x-gzip":($Pc=="tar"?"application/x-tar":($Pc=="sql"||$ug!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($ug=="gz"){ob_start(function($Q){return
gzencode($Q);},1e6);}return$Pc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(67)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(68):lang(69))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(70)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(71)."</a>\n":"");if($_GET["ns"]!=="")echo(support("routine")?"<a href='#routines'>".lang(72)."</a>\n":""),(support("sequence")?"<a href='#sequences'>".lang(73)."</a>\n":""),(support("type")?"<a href='#user-types'>".lang(6)."</a>\n":""),(support("event")?"<a href='#events'>".lang(74)."</a>\n":"");return
true;}function
navigation($wf){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$Hf=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$Hf)<0?h($Hf):"")."</a>","</span></h1>\n";switch_lang();if($wf=="auth"){$ug="";foreach((array)$_SESSION["pwds"]as$Oj=>$ai){foreach($ai
as$N=>$Jj){$B=h(get_setting("vendor-$Oj-$N")?:get_driver($Oj));foreach($Jj
as$V=>$F){if($F!==null){$Sb=$_SESSION["db"][$Oj][$N][$V];foreach(($Sb?array_keys($Sb):array(""))as$k)$ug
.="<li><a href='".h(auth_url($Oj,$N,$V,$k))."'>($B) ".h("$V@".($N!=""?adminer()->serverName($N):"").($k!=""?" - $k":""))."</a>\n";}}}}if($ug)echo"<ul id='logins'>\n$ug</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$wf&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($wf);$ka=array();if(DB==""||!$wf){if(support("sql")){$ka[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(64)."</a>";$ka[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(75)."</a>";}$ka[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(76)."</a>";}$Zd=$_GET["ns"]!==""&&!$wf&&DB!="";if($Zd)$ka[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(77)."</a>";echo($ka?"<p class='links'>\n".implode("\n",$ka)."\n":"");if($Zd){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(11)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.4.1",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$Ve=array();foreach($T
as$R=>$U)$Ve[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.":";json_row(js_escape(ME).(support("table")?"table":"select").'=$&','/\b('.implode('|',$Ve).')\b/g',false);if(support('routine')){foreach(routines()as$K)json_row(js_escape(ME).'function='.urlencode($K["SPECIFIC_NAME"]).'&name=$&','/\b'.preg_quote($K["ROUTINE_NAME"],'/').'(?=["`]?\()/g',false);}json_row('');echo"};\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$Ii=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$o){foreach($o
as$n)$Ii[$R][]=$n["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($Ii)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($wf){$j=adminer()->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Qb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(37)."'>".lang(78).": ".($j?html_select("db",array(""=>"")+$j,DB).$Qb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(22)."'".($j?" class='hidden'":"").">\n";if(support("scheme")){if($wf!="db"&&DB!=""&&connection()->select_db(DB)){echo"<br><label>".lang(79).": ".html_select("ns",array(""=>"")+adminer()->schemas(),$_GET["ns"])."$Qb</label>";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$R="$R";$B=adminer()->tableName($P);if($B!=""&&!$P["partition"])echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(41)."'>".lang(80)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($P)?"view":"structure"))." title='".lang(42)."'>$B</a>":"<span>$B</span>")."\n";}echo"</ul>\n";}function
processList(){return
process_list();}function
killProcess($u){return
kill_process($u);}}class
Plugins{private
static$append=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($Pg){if($Pg===null){$Pg=array();$Ja="adminer-plugins";if(is_dir($Ja)){foreach(glob("$Ja/*.php")as$p)$ae=include_once"./$p";}$Kd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Ja.php")){$ae=include_once"./$Ja.php";if(is_array($ae)){foreach($ae
as$Og)$Pg[get_class($Og)]=$Og;}else$this->error
.=lang(81,"<b>$Ja.php</b>",$Kd)."<br>";}foreach(get_declared_classes()as$fb){if(!$Pg[$fb]&&preg_match('~^Adminer\w~i',$fb)){$sh=new
\ReflectionClass($fb);$zb=$sh->getConstructor();if($zb&&$zb->getNumberOfRequiredParameters())$this->error
.=lang(82,$Kd,"<b>$fb</b>","<b>$Ja.php</b>")."<br>";else$Pg[$fb]=new$fb;}}}$this->plugins=$Pg;$na=new
Adminer;$Pg[]=$na;$sh=new
\ReflectionObject($na);foreach($sh->getMethods()as$uf){foreach($Pg
as$Og){$B=$uf->getName();if(method_exists($Og,$B))$this->hooks[$B][]=$Og;}}}function
__call($B,array$zg){$wa=array();foreach($zg
as$y=>$X)$wa[]=&$zg[$y];$J=null;foreach($this->hooks[$B]as$Og){$Y=call_user_func_array(array($Og,$B),$wa);if($Y!==null){if(!self::$append[$B])return$Y;$J=$Y+(array)$J;}}return$J;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$Nf=null){$wa=func_get_args();$wa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}}Adminer::$instance=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$drivers=array("server"=>"MySQL / MariaDB")+SqlDriver::$drivers;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$instance;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($N,$V,$F){mysqli_report(MYSQLI_REPORT_OFF);list($Od,$Qg)=host_port($N);$ri=adminer()->connectSsl();if($ri)$this->ssl_set($ri['key'],$ri['cert'],$ri['ca'],'','');$J=@$this->real_connect(($N!=""?$Od:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),null,(is_numeric($Qg)?intval($Qg):ini_get("mysqli.default_port")),(is_numeric($Qg)?null:$Qg),($ri?($ri['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,0);return($J?'':$this->error);}function
set_charset($Xa){if(parent::set_charset($Xa))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Xa");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($N,$V,$F){if(ini_bool("mysql.allow_local_infile"))return
lang(83,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),($N.$V!=""?$V:ini_get("mysql.default_user")),($N.$V.$F!=""?$F:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Xa){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Xa,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Xa");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->link)."'";}function
select_db($Pb){return
mysql_select_db($Pb,$this->link);}function
query($H,$sj=false){$I=@($sj?mysql_unbuffered_query($H,$this->link):mysql_query($H,$this->link));$this->error="";if(!$I){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($I===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($I);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=mysql_num_rows($I);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$J=mysql_fetch_field($this->result,$this->offset++);$J->orgtable=$J->table;$J->charsetnr=($J->blob?63:0);return$J;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($N,$V,$F){$fg=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$ri=adminer()->connectSsl();if($ri){if($ri['key'])$fg[\PDO::MYSQL_ATTR_SSL_KEY]=$ri['key'];if($ri['cert'])$fg[\PDO::MYSQL_ATTR_SSL_CERT]=$ri['cert'];if($ri['ca'])$fg[\PDO::MYSQL_ATTR_SSL_CA]=$ri['ca'];if(isset($ri['verify']))$fg[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$ri['verify'];}list($Od,$Qg)=host_port($N);return$this->dsn("mysql:charset=utf8;host=$Od".($Qg?(is_numeric($Qg)?";port=":";unix_socket=").$Qg:""),$V,$F,$fg);}function
set_charset($Xa){return$this->query("SET NAMES $Xa");}function
select_db($Pb){return$this->query("USE ".idf_escape($Pb));}function
query($H,$sj=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$sj);return
parent::query($H,$sj);}}}class
Driver
extends
SqlDriver{static$extensions=array("MySQLi","MySQL","PDO_MySQL");static$jush="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g)){if(function_exists('iconv')&&!is_utf8($g)&&strlen($Hh=iconv("windows-1250","utf-8",$g))>strlen($g))$g=$Hh;return$g;}$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");$g->flavor=(preg_match('~MariaDB~',$g->server_info)?'maria':'mysql');add_driver(DRIVER,($g->flavor=='maria'?"MariaDB":"MySQL"));return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(29)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(84)=>array("enum"=>65535,"set"=>64),lang(30)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(32)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$g))$this->types[lang(29)]["json"]=4294967295;if(min_version('',10.7,$g)){$this->types[lang(29)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$g)){$this->types[lang(27)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.1,'',$g))$this->partitionBy=array("HASH","LINEAR HASH","KEY","LINEAR KEY","RANGE","LIST");if(min_version(5.7,10.2,$g))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$n){return(preg_match("~binary~",$n["type"])?"<code class='jush-sql'>UNHEX</code>":($n["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$n["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$L,array$G){$e=array_keys(reset($L));$Wg="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$Mj=array();foreach($e
as$y)$Mj[$y]="$y = VALUES($y)";$yi="\nON DUPLICATE KEY UPDATE ".implode(", ",$Mj);$Mj=array();$Re=0;foreach($L
as$O){$Y="(".implode(", ",$O).")";if($Mj&&(strlen($Wg)+$Re+strlen($Y)+strlen($yi)>1e6)){if(!queries($Wg.implode(",\n",$Mj).$yi))return
false;$Mj=array();$Re=0;}$Mj[]=$Y;$Re+=strlen($Y)+2;}return
queries($Wg.implode(",\n",$Mj).$yi);}function
slowQuery($H,$Ui){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$Ui FOR $H";elseif(preg_match('~^(SELECT\b)(.+)~is',$H,$A))return"$A[1] /*+ MAX_EXECUTION_TIME(".($Ui*1000).") */ $A[2]";}}function
convertSearch($v,array$X,array$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$I=$this->conn->query("SHOW WARNINGS");if($I&&$I->num_rows){ob_start();print_select_result($I);return
ob_get_clean();}}function
tableHelp($B,$_e=false){$Ze=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($Ze?"$B-table/":str_replace("_","-",$B)."-table.html"));if(DB=="mysql")return($Ze?"mysql$B-table/":"system-schema.html");}function
partitionsInfo($R){$rd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=$this->conn->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $rd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$J=array();list($J["partition_by"],$J["partition"],$J["partitions"])=$I->fetch_row();$Gg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $rd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$J["partition_names"]=array_keys($Gg);$J["partition_values"]=array_values($Gg);return$J;}function
hasCStyleEscapes(){static$Sa;if($Sa===null){$pi=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Sa=(strpos($pi,'NO_BACKSLASH_ESCAPES')===false);}return$Sa;}function
engines(){$J=array();foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$J[]=$K["Engine"];}return$J;}function
indexAlgorithms(array$Bi){return(preg_match('~^(MEMORY|NDB)$~',$Bi["Engine"])?array("HASH","BTREE"):array());}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($jd){$J=get_session("dbs");if($J===null){$H="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($jd?slow_query($H):get_vals($H));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return
limit($H,$Z,1,0,$Vh);}function
db_collation($k,array$lb){$J=null;$i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$A))$J=$A[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$A))$J=$lb[$A[1]][-1];return$J;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$j){$J=array();foreach($j
as$k)$J[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$J;}function
table_status($B="",$Vc=false){$J=array();foreach(get_rows($Vc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($B!=""?"AND TABLE_NAME = ".q($B):"ORDER BY Name"):"SHOW TABLE STATUS".($B!=""?" LIKE ".q(addcslashes($B,"%_\\")):""))as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($B!="")$K["Name"]=$B;$J[$K["Name"]]=$K;}return$J;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$Ze=(connection()->flavor=='maria');$J=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$n=$K["COLUMN_NAME"];$U=$K["COLUMN_TYPE"];$vd=$K["GENERATION_EXPRESSION"];$Sc=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Sc,$ud);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$cf);$l=$K["COLUMN_DEFAULT"];if($l!=""){$ze=preg_match('~text|json~',$cf[1]);if(!$Ze&&$ze)$l=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($l));if($Ze||$ze){$l=($l=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($A){return
stripslashes(str_replace("''","'",$A[1]));},$l));}if(!$Ze&&preg_match('~binary~',$cf[1])&&preg_match('~^0x(\w*)$~',$l,$A))$l=pack("H*",$A[1]);}$J[$n]=array("field"=>$n,"full_type"=>$U,"type"=>$cf[1],"length"=>$cf[2],"unsigned"=>ltrim($cf[3].$cf[4]),"default"=>($ud?($Ze?$vd:stripslashes($vd)):$l),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Sc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Sc,$A)?$A[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$K[PRIVILEGES],where,order")),"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($ud[1]=="PERSISTENT"?"STORED":$ud[1]),);}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$h)as$K){$B=$K["Key_name"];$J[$B]["type"]=($B=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$B]["columns"][]=$K["Column_name"];$J[$B]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$B]["descs"][]=null;$J[$B]["algorithm"]=$K["Index_type"];}return$J;}function
foreign_keys($R){static$Kg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=array();$Fb=get_val("SHOW CREATE TABLE ".table($R),1);if($Fb){preg_match_all("~CONSTRAINT ($Kg) FOREIGN KEY ?\\(((?:$Kg,? ?)+)\\) REFERENCES ($Kg)(?:\\.($Kg))? \\(((?:$Kg,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$Fb,$df,PREG_SET_ORDER);foreach($df
as$A){preg_match_all("~$Kg~",$A[2],$ji);preg_match_all("~$Kg~",$A[5],$Mi);$J[idf_unescape($A[1])]=array("db"=>idf_unescape($A[4]!=""?$A[3]:$A[4]),"table"=>idf_unescape($A[4]!=""?$A[4]:$A[3]),"source"=>array_map('Adminer\idf_unescape',$ji[0]),"target"=>array_map('Adminer\idf_unescape',$Mi[0]),"on_delete"=>($A[6]?:"RESTRICT"),"on_update"=>($A[7]?:"RESTRICT"),);}}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($B),1)));}function
collations(){$J=array();foreach(get_rows("SHOW COLLATION")as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$y=>$X)sort($J[$y]);return$J;}function
information_schema($k){return($k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" COLLATE ".q($c):""));}function
drop_databases(array$j){$J=apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($B,$c){$J=false;if(create_database($B,$c)){$T=array();$Rj=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$Rj[]=$R;else$T[]=$R;}$J=(!$T&&!$Rj)||move_tables($T,$Rj,$B);drop_databases($J?array(DB):array());}return$J;}function
auto_increment(){$Ca=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Ca="";break;}if($w["type"]=="PRIMARY")$Ca=" UNIQUE";}}return" AUTO_INCREMENT$Ca";}function
alter_table($R,$B,array$o,array$ld,$qb,$zc,$c,$Ba,$E){$b=array();foreach($o
as$n){if($n[1]){$l=$n[1][3];if(preg_match('~ GENERATED~',$l)){$n[1][3]=(connection()->flavor=='maria'?"":$n[1][2]);$n[1][2]=$l;}$b[]=($R!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($R!=""?$n[2]:"");}else$b[]="DROP ".idf_escape($n[0]);}$b=array_merge($b,$ld);$P=($qb!==null?" COMMENT=".q($qb):"").($zc?" ENGINE=".q($zc):"").($c?" COLLATE ".q($c):"").($Ba!=""?" AUTO_INCREMENT=$Ba":"");if($E){$Gg=array();if($E["partition_by"]=='RANGE'||$E["partition_by"]=='LIST'){foreach($E["partition_names"]as$y=>$X){$Y=$E["partition_values"][$y];$Gg[]="\n  PARTITION ".idf_escape($X)." VALUES ".($E["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$P
.="\nPARTITION BY $E[partition_by]($E[partition])";if($Gg)$P
.=" (".implode(",",$Gg)."\n)";elseif($E["partitions"])$P
.=" PARTITIONS ".(+$E["partitions"]);}elseif($E===null)$P
.="\nREMOVE PARTITIONING";if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");if($R!=$B)$b[]="RENAME TO ".table($B);if($P)$b[]=ltrim($P);return($b?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b)):true);}function
alter_indexes($R,$b){$Wa=array();foreach($b
as$X)$Wa[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Wa));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$Rj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Rj)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$Rj,$Mi){$wh=array();foreach($T
as$R)$wh[]=table($R)." TO ".idf_escape($Mi).".".table($R);if(!$wh||queries("RENAME TABLE ".implode(", ",$wh))){$Yb=array();foreach($Rj
as$R)$Yb[table($R)]=view($R);connection()->select_db($Mi);$k=idf_escape(DB);foreach($Yb
as$B=>$Qj){if(!queries("CREATE VIEW $B AS ".str_replace(" $k."," ",$Qj["select"]))||!queries("DROP VIEW $k.$B"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$Rj,$Mi){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$B=($Mi==DB?table("copy_$R"):idf_escape($Mi).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $B"))||!queries("CREATE TABLE $B LIKE ".table($R))||!queries("INSERT INTO $B SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$lj=$K["Trigger"];if(!queries("CREATE TRIGGER ".($Mi==DB?idf_escape("copy_$lj"):idf_escape($Mi).".".idf_escape($lj))." $K[Timing] $K[Event] ON $B FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($Rj
as$R){$B=($Mi==DB?table("copy_$R"):idf_escape($Mi).".".table($R));$Qj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $B"))||!queries("CREATE VIEW $B AS $Qj[select]"))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($B));return
reset($L);}function
triggers($R){$J=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($B,$U){$ta=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$ki="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Ac=driver()->enumLength;$qj="((".implode("|",array_merge(array_keys(driver()->types()),$ta)).")\\b(?:\\s*\\(((?:[^'\")]|$Ac)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?(?:\\s*COLLATE\\s*['\"]?[^'\"\\s,]+['\"]?)?";$Kg="$ki*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$qj";$i=get_val("SHOW CREATE $U ".idf_escape($B),2);preg_match("~\\(((?:$Kg\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$qj\\s+":"")."(.*)~is",$i,$A);$o=array();preg_match_all("~$Kg\\s*,?~is",$A[1],$df,PREG_SET_ORDER);foreach($df
as$yg)$o[]=array("field"=>str_replace("``","`",$yg[2]).$yg[3],"type"=>strtolower($yg[5]),"length"=>preg_replace_callback("~$Ac~s",'Adminer\normalize_enum',$yg[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$yg[8] $yg[7]"))),"null"=>true,"full_type"=>$yg[4],"inout"=>strtoupper($yg[1]),"collation"=>strtolower($yg[9]),);return
array("fields"=>$o,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($B)),)+($U!="FUNCTION"?array("definition"=>$A[11]):array("returns"=>array("type"=>$A[12],"length"=>$A[13],"unsigned"=>$A[15],"collation"=>$A[16]),"definition"=>$A[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($B,array$K){return
idf_escape($B);}function
last_id($I){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$g,$H){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$H);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Ba,$wi){$J=get_val("SHOW CREATE TABLE ".table($R),1);if(!$Ba)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Pb,$wi=""){$B=idf_escape($Pb);$J="";if(preg_match('~CREATE~',$wi)&&($i=get_val("SHOW CREATE DATABASE $B",1))){set_utf8mb4($i);if($wi=="DROP+CREATE")$J="DROP DATABASE IF EXISTS $B;\n";$J
.="$i;\n";}return$J."USE $B";}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J
.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field(array$n,$J){if(preg_match("~binary~",$n["type"]))$J="UNHEX($J)";if($n["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$Wg=(min_version(8)?"ST_":"");$J=$Wg."GeomFromText($J, $Wg"."SRID($n[field]))";}return$J;}function
support($Wc){return
preg_match('~^(comment|columns|copy|database|drop_col|dump|indexes|kill|privileges|move_col|procedure|processlist|routine|sql|status|table|trigger|variables|view'.(min_version(5.1)?'|event':'').(min_version(8)?'|descidx':'').(min_version('8.0.16','10.2.1')?'|check':'').')$~',$Wc);}function
kill_process($u){return
queries("KILL ".number($u));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Jh,$h=null){return
true;}}define('Adminer\JUSH',Driver::$jush);define('Adminer\SERVER',"".$_GET[DRIVER]);define('Adminer\DB',"$_GET[db]");define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($Wi,$m="",$Oa=array(),$Xi=""){page_headers();if(is_ajax()&&$m){page_messages($m);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$Yi=$Wi.($Xi!=""?": $Xi":"");$Zi=strip_tags($Yi.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(85),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$Zi,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.4.1"),'">
';$Jb=adminer()->css();if(is_int(key($Jb)))$Jb=array_fill_keys($Jb,'light');$Gd=in_array('light',$Jb)||in_array('',$Jb);$Ed=in_array('dark',$Jb)||in_array('',$Jb);$Mb=($Gd?($Ed?null:false):($Ed?:null));$nf=" media='(prefers-color-scheme: dark)'";if($Mb!==false)echo"<link rel='stylesheet'".($Mb?"":$nf)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.4.1")."'>\n";echo"<meta name='color-scheme' content='".($Mb===null?"light dark":($Mb?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.4.1");if(adminer()->head($Mb))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.1")."'>\n";foreach($Jb
as$Dj=>$xf){$_a=($xf=='dark'&&!$Mb?$nf:($xf=='light'&&$Ed?" media='(prefers-color-scheme: light)'":""));echo"<link rel='stylesheet'$_a href='".h($Dj)."'>\n";}echo"\n<body class='".lang(85)." nojs";adminer()->bodyClass();echo"'>\n";$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$Pj=unserialize(file_get_contents($p));$gh="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Pj["version"],base64_decode($Pj["signature"]),$gh)==1)$_COOKIE["adminer_version"]=$Pj["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(86))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Oa!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?:".").'">'.get_driver(DRIVER).'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=adminer()->serverName(SERVER);$N=($N!=""?$N:lang(34));if($Oa===false)echo"$N\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$N</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Oa)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Oa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Oa
as$y=>$X){$ac=(is_array($X)?$X[1]:h($X));if($ac!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$ac</a> » ";}}echo"$Wi\n";}}echo"<h2>$Yi</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$Ib){$Id=array();foreach($Ib
as$y=>$X)$Id[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Id));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$Jf;if(!$Jf)$Jf=base64_encode(rand_string());return$Jf;}function
page_messages($m){$Cj=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$tf=idx($_SESSION["messages"],$Cj);if($tf){echo"<div class='message'>".implode("</div>\n<div class='message'>",$tf)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Cj]);}if($m)echo"<div class='error'>$m</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($wf=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($wf);echo"</div>\n";if($wf!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(87),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($Bf){while($Bf>=2147483648)$Bf-=4294967296;while($Bf<=-2147483649)$Bf+=4294967296;return(int)$Bf;}function
long2str(array$W,$Tj){$Hh='';foreach($W
as$X)$Hh
.=pack('V',$X);if($Tj)return
substr($Hh,0,end($W));return$Hh;}function
str2long($Hh,$Tj){$W=array_values(unpack('V*',str_pad($Hh,4*ceil(strlen($Hh)/4),"\0")));if($Tj)$W[]=strlen($Hh);return$W;}function
xxtea_mx($ak,$Zj,$zi,$Ce){return
int32((($ak>>5&0x7FFFFFF)^$Zj<<2)+(($Zj>>3&0x1FFFFFFF)^$ak<<4))^int32(($zi^$Zj)+($Ce^$ak));}function
encrypt_string($ui,$y){if($ui=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($ui,true);$Bf=count($W)-1;$ak=$W[$Bf];$Zj=$W[0];$hh=floor(6+52/($Bf+1));$zi=0;while($hh-->0){$zi=int32($zi+0x9E3779B9);$qc=$zi>>2&3;for($wg=0;$wg<$Bf;$wg++){$Zj=$W[$wg+1];$Af=xxtea_mx($ak,$Zj,$zi,$y[$wg&3^$qc]);$ak=int32($W[$wg]+$Af);$W[$wg]=$ak;}$Zj=$W[0];$Af=xxtea_mx($ak,$Zj,$zi,$y[$wg&3^$qc]);$ak=int32($W[$Bf]+$Af);$W[$Bf]=$ak;}return
long2str($W,false);}function
decrypt_string($ui,$y){if($ui=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($ui,false);$Bf=count($W)-1;$ak=$W[$Bf];$Zj=$W[0];$hh=floor(6+52/($Bf+1));$zi=int32($hh*0x9E3779B9);while($zi){$qc=$zi>>2&3;for($wg=$Bf;$wg>0;$wg--){$ak=$W[$wg-1];$Af=xxtea_mx($ak,$Zj,$zi,$y[$wg&3^$qc]);$Zj=int32($W[$wg]-$Af);$W[$wg]=$Zj;}$ak=$W[$Bf];$Af=xxtea_mx($ak,$Zj,$zi,$y[$wg&3^$qc]);$Zj=int32($W[0]-$Af);$W[0]=$Zj;$zi=int32($zi-0x9E3779B9);}return
long2str($W,true);}$Mg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Mg[$y]=$X;}}function
add_invalid_login(){$Ha=get_temp_dir()."/adminer.invalid";foreach(glob("$Ha*")?:array($Ha)as$p){$r=file_open_lock($p);if($r)break;}if(!$r)$r=file_open_lock("$Ha-".rand_string());if(!$r)return;$ue=unserialize(stream_get_contents($r));$Ti=time();if($ue){foreach($ue
as$ve=>$X){if($X[0]<$Ti)unset($ue[$ve]);}}$te=&$ue[adminer()->bruteForceKey()];if(!$te)$te=array($Ti+30*60,0);$te[1]++;file_write_unlock($r,serialize($ue));}function
check_invalid_login(array&$Mg){$ue=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$p){$r=file_open_lock($p);if($r){$ue=unserialize(stream_get_contents($r));file_unlock($r);break;}}$te=idx($ue,adminer()->bruteForceKey(),array());$If=($te[1]>29?$te[0]-time():0);if($If>0)auth_error(lang(88,ceil($If/60)),$Mg);}$Aa=$_POST["auth"];if($Aa){session_regenerate_id();$Oj=$Aa["driver"];$N=$Aa["server"];$V=$Aa["username"];$F=(string)$Aa["password"];$k=$Aa["db"];set_password($Oj,$N,$V,$F);$_SESSION["db"][$Oj][$N][$V][$k]=true;if($Aa["permanent"]){$y=implode("-",array_map('base64_encode',array($Oj,$N,$V,$k)));$bh=adminer()->permanentLogin(true);$Mg[$y]="$y:".base64_encode($bh?encrypt_string($F,$bh):"");cookie("adminer_permanent",implode(" ",$Mg));}if(count($_POST)==1||DRIVER!=$Oj||SERVER!=$N||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($Oj,$N,$V,$k));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($Mg);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(89).' '.lang(90));}elseif($Mg&&!$_SESSION["pwds"]){session_regenerate_id();$bh=adminer()->permanentLogin();foreach($Mg
as$y=>$X){list(,$eb)=explode(":",$X);list($Oj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($Oj,$N,$V,decrypt_string(base64_decode($eb),$bh));$_SESSION["db"][$Oj][$N][$V][$k]=true;}}function
unset_permanent(array&$Mg){foreach($Mg
as$y=>$X){list($Oj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));if($Oj==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$k==DB)unset($Mg[$y]);}cookie("adminer_permanent",implode(" ",$Mg));}function
auth_error($m,array&$Mg){$bi=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$bi]||$_GET[$bi])&&!$_SESSION["token"])$m=lang(91);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m
.=($m?'<br>':'').lang(92,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($Mg);}}if(!$_COOKIE[$bi]&&$_GET[$bi]&&ini_bool("session.use_only_cookies"))$m=lang(93);$zg=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$zg["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(38),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(94)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($Mg);page_header(lang(95),lang(96,implode(", ",Driver::$extensions)),false);page_footer("auth");exit;}$g='';if(isset($_GET["username"])&&is_string(get_password())){list(,$Qg)=host_port(SERVER);if(preg_match('~^\s*([-+]?\d+)~',$Qg,$A)&&($A[1]<1024||$A[1]>65535))auth_error(lang(97),$Mg);check_invalid_login($Mg);$Hb=adminer()->credentials();$g=Driver::connect($Hb[0],$Hb[1],$Hb[2]);if(is_object($g)){Db::$instance=$g;Driver::$instance=new
Driver($g);if($g->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$Xe=null;if(!is_object($g)||($Xe=adminer()->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?nl_br(h($g)):(is_string($Xe)?$Xe:lang(98))).(preg_match('~^ | $~',get_password())?'<br>'.lang(99):'');auth_error($m,$Mg);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(87),lang(100));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($Aa&&$_POST["token"])$_POST["token"]=get_token();$m='';if($_POST){if(!verify_token()){$me="max_input_vars";$lf=ini_get($me);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$lf||$X<$lf)){$me=$y;$lf=$X;}}}$m=(!$_POST["token"]&&$lf?lang(101,"'$me'"):lang(100).' '.lang(102));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(103,"'post_max_size'");if(isset($_GET["sql"]))$m
.=' '.lang(104);}function
print_select_result($I,$h=null,array$lg=array(),$z=0){$Ve=array();$x=array();$e=array();$Ma=array();$rj=array();$J=array();for($t=0;(!$z||$t<$z)&&($K=$I->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($Ae=0;$Ae<count($K);$Ae++){$n=$I->fetch_field();$B=$n->name;$kg=(isset($n->orgtable)?$n->orgtable:"");$jg=(isset($n->orgname)?$n->orgname:$B);if($lg&&JUSH=="sql")$Ve[$Ae]=($B=="table"?"table=":($B=="possible_keys"?"indexes=":null));elseif($kg!=""){if(isset($n->table))$J[$n->table]=$kg;if(!isset($x[$kg])){$x[$kg]=array();foreach(indexes($kg,$h)as$w){if($w["type"]=="PRIMARY"){$x[$kg]=array_flip($w["columns"]);break;}}$e[$kg]=$x[$kg];}if(isset($e[$kg][$jg])){unset($e[$kg][$jg]);$x[$kg][$jg]=$Ae;$Ve[$Ae]=$kg;}}if($n->charsetnr==63)$Ma[$Ae]=true;$rj[$Ae]=$n->type;echo"<th".($kg!=""||$n->name!=$jg?" title='".h(($kg!=""?"$kg.":"").$jg)."'":"").">".h($B).($lg?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($B),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$y=>$X){$_="";if(isset($Ve[$y])&&!$e[$Ve[$y]]){if($lg&&JUSH=="sql"){$R=$K[array_search("table=",$Ve)];$_=ME.$Ve[$y].urlencode($lg[$R]!=""?$lg[$R]:$R);}else{$_=ME."edit=".urlencode($Ve[$y]);foreach($x[$Ve[$y]]as$jb=>$Ae){if($K[$Ae]===null){$_="";break;}$_
.="&where".urlencode("[".bracket_escape($jb)."]")."=".urlencode($K[$Ae]);}}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ma[$y]&&!is_utf8($X))$X="<i>".lang(47,strlen($X))."</i>";else{$X=h($X);if($rj[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td".($rj[$y]<=9||$rj[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(14))."\n";return$J;}function
referencable_primary($Th){$J=array();foreach(table_status('',true)as$Di=>$R){if($Di!=$Th&&fk_support($R)){foreach(fields($Di)as$n){if($n["primary"]){if($J[$Di]){unset($J[$Di]);break;}$J[$Di]=$n;}}}}return$J;}function
textarea($B,$Y,$L=10,$mb=80){echo"<textarea name='".h($B)."' rows='$L' cols='$mb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($_a,array$fg,$Y="",$Zf="",$Ng=""){$Li=($fg?"select":"input");return"<$Li$_a".($fg?"><option value=''>$Ng".optionlist($fg,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Ng'>").($Zf?script("qsl('$Li').onchange = $Zf;",""):"");}function
json_row($y,$X=null,$Hc=true){static$dd=true;if($dd)echo"{";if($y!=""){echo($dd?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?($Hc?'"'.addcslashes($X,"\r\n\"\\/").'"':$X):'null');$dd=false;}else{echo"\n}\n";$dd=true;}}function
edit_type($y,array$n,array$lb,array$nd=array(),array$Tc=array()){$U=$n["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($nd[$U])&&!in_array($U,$Tc))$Tc[]=$U;$vi=driver()->structuredTypes();if($nd)$vi[lang(105)]=$nd;echo
optionlist(array_merge($Tc,$vi),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($n["length"])."' size='3'".(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($lb?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($n["collation"])."' placeholder='(".lang(106).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(107).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($nd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(108).")".optionlist(explode("|",driver()->onActions),$n["on_delete"])."</select> ":" ");}function
process_length($Re){$Cc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$Cc(?:\\s*,\\s*$Cc)*+\\s*\\)?\\s*\$~",$Re)&&preg_match_all("~$Cc~",$Re,$df)?"(".implode(",",$df[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Re)));}function
process_type(array$n,$kb="COLLATE"){return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],driver()->unsigned)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $kb ".(JUSH=="mssql"?$n["collation"]:q($n["collation"])):"");}function
process_field(array$n,array$pj){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($pj),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value(array$n){$l=$n["default"];$ud=$n["generated"];return($l===null?"":(in_array($ud,driver()->generated)?(JUSH=="mssql"?" AS ($l)".($ud=="VIRTUAL"?"":" $ud")."":" GENERATED ALWAYS AS ($l) $ud"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$l)&&(preg_match('~char|binary|text|json|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$l))?(JUSH=="sql"&&preg_match('~text|json~',$n["type"])?"(".q($l).")":q($l)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($l)":$l)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$o,array$lb,$U="TABLE",array$nd=array()){$o=array_values($o);$Vb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$rb=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(109):lang(110)),"<td id='label-type'>".lang(49)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(111),"<td>".lang(112);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(51)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),"<td id='label-default'$Vb>".lang(52),(support("comment")?"<td id='label-comment'$rb>".lang(50):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($o))."]","+",lang(113)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$mg=$n[($_POST?"orig":"field")];$gc=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$mg=="");echo"<tr".($gc?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$n["inout"]):"")."<th>";if($gc)echo"<input name='fields[$t][field]' value='".h($n["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'".(isset($_POST["add"][$t-1])?" autofocus":"").">";echo
input_hidden("fields[$t][orig]",$mg);edit_type("fields[$t]",$n,$lb,$nd);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($n["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Vb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$n["generated"])." ":checkbox("fields[$t][generated]",1,$n["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($n["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$rb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(113))." ".icon("up","up[$t]","↑",lang(114))." ".icon("down","down[$t]","↓",lang(115))." ":""),($mg==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(116)):"");}}function
process_fields(array&$o){$C=0;if($_POST["up"]){$Le=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$Le,0,array($n));break;}if(isset($n["field"]))$Le=$C;$C++;}}elseif($_POST["down"]){$pd=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$pd){unset($o[key($_POST["down"])]);array_splice($o,$C,0,array($pd));break;}if(key($_POST["down"])==$y)$pd=$n;$C++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$A){$X=$A[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($wd,array$dh,$e,$Wf){if(!$dh)return
true;if($dh==array("ALL PRIVILEGES","GRANT OPTION"))return($wd=="GRANT"?queries("$wd ALL PRIVILEGES$Wf WITH GRANT OPTION"):queries("$wd ALL PRIVILEGES$Wf")&&queries("$wd GRANT OPTION$Wf"));return
queries("$wd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$dh).$e).$Wf);}function
drop_create($kc,$i,$mc,$Pi,$oc,$We,$sf,$qf,$rf,$Tf,$Ff){if($_POST["drop"])query_redirect($kc,$We,$sf);elseif($Tf=="")query_redirect($i,$We,$rf);elseif($Tf!=$Ff){$Gb=queries($i);queries_redirect($We,$qf,$Gb&&queries($kc));if($Gb)queries($mc);}else
queries_redirect($We,$qf,queries($Pi)&&queries($oc)&&queries($kc)&&queries($i));}function
create_trigger($Wf,array$K){$Vi=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(JUSH=="mssql"?$Wf.$Vi:$Vi.$Wf).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($Dh,array$K){$O=array();$o=(array)$K["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$O[]=(preg_match("~^(".driver()->inout.")\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Xb=rtrim($K["definition"],";");return"CREATE $Dh ".idf_escape(trim($K["name"]))." (".implode(", ",$O).")".($Dh=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(JUSH=="pgsql"?" AS ".q($Xb):"\n$Xb;");}function
remove_definer($H){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$H);}function
format_foreign_key(array$q){$k=$q["db"];$Kf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($Kf!=""&&$Kf!=$_GET["ns"]?idf_escape($Kf).".":"").idf_escape($q["table"])." (".implode(", ",array_map('Adminer\idf_escape',$q["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$aj){$J=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($aj->size),decoct(time()));$db=8*32;for($t=0;$t<strlen($J);$t++)$db+=ord($J[$t]);$J
.=sprintf("%06o",$db)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$aj->send();echo
str_repeat("\0",511-($aj->size+511)%512);}function
doc_link(array$Jg,$Qi="<sup>?</sup>"){$Zh=connection()->server_info;$Pj=preg_replace('~^(\d\.?\d).*~s','\1',$Zh);$Ej=array('sql'=>"https://dev.mysql.com/doc/refman/$Pj/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$Pj)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Zh)."&id=",);if(connection()->flavor=='maria'){$Ej['sql']="https://mariadb.com/kb/en/";$Jg['sql']=(isset($Jg['mariadb'])?$Jg['mariadb']:str_replace(".html","/",$Jg['sql']));}return($Jg[JUSH]?"<a href='".h($Ej[JUSH].$Jg[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$Pj":""))."'".target_blank().">$Qi</a>":"");}function
db_size($k){if(!connection()->select_db($k))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($i){static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$i)){$O=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(37).": ".h(DB),lang(117),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(118),drop_databases($_POST["db"]));page_header(lang(119),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(120),'privileges'=>lang(71),'processlist'=>lang(121),'variables'=>lang(122),'status'=>lang(123),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(124,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(125,"<b>".h(logged_user())."</b>")."\n";$j=adminer()->databases();if($j){$Lh=support("scheme");$lb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(37).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(126)."</a>":"")."<td>".lang(127)."<td>".lang(128)."<td>".lang(129)." - <a href='".h(ME)."dbsize=1'>".lang(130)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$T){$Ch=h(ME)."db=".urlencode($k);$u=h("Db-".$k);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$Ch' id='$u'>".h($k)."</a>";$c=h(db_collation($k,$lb));echo"<td>".(support("database")?"<a href='$Ch".($Lh?"&amp;ns=":"")."&amp;database=' title='".lang(67)."'>$c</a>":$c),"<td align='right'><a href='$Ch&amp;schema=' id='tables-".h($k)."' title='".lang(70)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(131)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(132)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(!empty(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(133)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$Og){$bc=(method_exists($Og,'description')?$Og->description():"");if(!$bc){$sh=new
\ReflectionObject($Og);if(preg_match('~^/[\s*]+(.+)~',$sh->getDocComment(),$A))$bc=$A[1];}$Mh=(method_exists($Og,'screenshot')?$Og->screenshot():"");echo"<li><b>".get_class($Og)."</b>".h($bc?": $bc":"").($Mh?" (<a href='".h($Mh)."'".target_blank().">".lang(134)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(79).": ".h($_GET["ns"]),lang(135),true);page_footer("ns");exit;}}}adminer()->afterConnect();class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Ab){$this->size+=strlen($Ab);fwrite($this->handler,$Ab);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=array(idf_escape($_GET["field"]));$I=driver()->select($a,$M,array(where($_GET,$o)),$M);$K=($I?$I->fetch_row():array());echo
driver()->value($K[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error()?:lang(11);$S=table_status1($a);$B=adminer()->tableName($S);page_header(($o&&is_view($S)?$S['Engine']=='materialized view'?lang(136):lang(137):lang(138)).": ".($B!=""?$B:h($a)),$m);$Bh=array();foreach($o
as$y=>$n)$Bh+=$n["privileges"];adminer()->selectLinks($S,(isset($Bh["insert"])||!support("table")?"":null));$qb=$S["Comment"];if($qb!="")echo"<p class='nowrap'>".lang(50).": ".h($qb)."\n";if($o)adminer()->tableStructurePrint($o,$S);function
tables_links(array$T){echo"<ul>\n";foreach($T
as$R)echo"<li><a href='".h(ME."table=".urlencode($R))."'>".h($R)."</a>";echo"</ul>\n";}$le=driver()->inheritsFrom($a);if($le){echo"<h3>".lang(139)."</h3>\n";tables_links($le);}if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(140)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x,$S);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(141)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(105)."</h3>\n";$nd=foreign_keys($a);if($nd){echo"<table>\n","<thead><tr><th>".lang(142)."<td>".lang(143)."<td>".lang(108)."<td>".lang(107)."<td></thead>\n";foreach($nd
as$B=>$q){echo"<tr title='".h($B)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$q["source"]))."</i>";$_=($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME));echo"<td><a href='".h($_."table=".urlencode($q["table"]))."'>".($q["db"]!=""&&$q["db"]!=DB?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""&&$q["ns"]!=$_GET["ns"]?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($B)).'">'.lang(144).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(145)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(146)."</h3>\n";$Za=driver()->checkConstraints($a);if($Za){echo"<table>\n";foreach($Za
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(144)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(147)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(148)."</h3>\n";$oj=triggers($a);if($oj){echo"<table>\n";foreach($oj
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(144)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(149)."</a>\n";}$ke=driver()->inheritedTables($a);if($ke){echo"<h3 id='partitions'>".lang(150)."</h3>\n";$Cg=driver()->partitionsInfo($a);if($Cg)echo"<p><code class='jush-".JUSH."'>BY ".h("$Cg[partition_by]($Cg[partition])")."</code>\n";tables_links($ke);}}elseif(isset($_GET["schema"])){page_header(lang(70),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Fi=array();$Gi=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$df,PREG_SET_ORDER);foreach($df
as$t=>$A){$Fi[$A[1]]=array($A[2],$A[3]);$Gi[]="\n\t'".js_escape($A[1])."': [ $A[2], $A[3] ]";}$dj=0;$Ia=-1;$Jh=array();$rh=array();$Pe=array();$ua=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$Rg=0;$Jh[$R]["fields"]=array();foreach($ua[$R]as$n){$Rg+=1.25;$n["pos"]=$Rg;$Jh[$R]["fields"][$n["field"]]=$n;}$Jh[$R]["pos"]=($Fi[$R]?:array($dj,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$Ne=$Ia;if(idx($Fi[$R],1)||idx($Fi[$X["table"]],1))$Ne=min(idx($Fi[$R],1,0),idx($Fi[$X["table"]],1,0))-1;else$Ia-=.1;while($Pe[(string)$Ne])$Ne-=.0001;$Jh[$R]["references"][$X["table"]][(string)$Ne]=array($X["source"],$X["target"]);$rh[$X["table"]][$R][(string)$Ne]=$X["target"];$Pe[(string)$Ne]=true;}}$dj=max($dj,$Jh[$R]["pos"][0]+2.5+$Rg);}echo'<div id="schema" style="height: ',$dj,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$Gi)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$dj,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Jh
as$B=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($B).'"><b>'.h($B)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["type"].($n["length"]?"($n[length])":"").($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$Ni=>$th){foreach($th
as$Ne=>$oh){$Oe=$Ne-idx($Fi[$B],1);$t=0;foreach($oh[0]as$ji)echo"\n<div class='references' title='".h($Ni)."' id='refs$Ne-".($t++)."' style='left: $Oe"."em; top: ".$R["fields"][$ji]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$Oe)."em;'></div></div>";}}foreach((array)$rh[$B]as$Ni=>$th){foreach($th
as$Ne=>$e){$Oe=$Ne-idx($Fi[$B],1);$t=0;foreach($e
as$Mi)echo"\n<div class='references arrow' title='".h($Ni)."' id='refd$Ne-".($t++)."' style='left: $Oe"."em; top: ".$R["fields"][$Mi]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$Oe)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($Jh
as$B=>$R){foreach((array)$R["references"]as$Ni=>$th){foreach($th
as$Ne=>$oh){$vf=$dj;$jf=-10;foreach($oh[0]as$y=>$ji){$Sg=$R["pos"][0]+$R["fields"][$ji]["pos"];$Tg=$Jh[$Ni]["pos"][0]+$Jh[$Ni]["fields"][$oh[1][$y]]["pos"];$vf=min($vf,$Sg,$Tg);$jf=max($jf,$Sg,$Tg);}echo"<div class='references' id='refl$Ne' style='left: $Ne"."em; top: $vf"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($jf-$vf)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(151),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Pc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$ye=preg_match('~sql~',$_POST["format"]);if($ye){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$wi=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){adminer()->dumpDatabase($k);if(connection()->select_db($k)){if($ye){if($wi)echo
use_sql($k,$wi).";\n\n";$tg="";if($_POST["types"]){foreach(types()as$u=>$U){$Dc=type_values($u);if($Dc)$tg
.=($wi!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($Dc);\n\n";else$tg
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$B=$K["ROUTINE_NAME"];$Dh=$K["ROUTINE_TYPE"];$i=create_routine($Dh,array("name"=>$B)+routine($K["SPECIFIC_NAME"],$Dh));set_utf8mb4($i);$tg
.=($wi!='DROP+CREATE'?"DROP $Dh IF EXISTS ".idf_escape($B).";;\n":"")."$i;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$i=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($i);$tg
.=($wi!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$i;;\n\n";}}echo($tg&&JUSH=='sql'?"DELIMITER ;;\n\n$tg"."DELIMITER ;\n\n":$tg);}if($_POST["table_style"]||$_POST["data_style"]){$Rj=array();foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));$Nb=(DB==""||in_array($B,(array)$_POST["data"]));if($R||$Nb){$aj=null;if($Pc=="tar"){$aj=new
TmpFile;ob_start(array($aj,'write'),1e5);}adminer()->dumpTable($B,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$Rj[]=$B;elseif($Nb){$o=fields($B);adminer()->dumpData($B,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($B));}if($ye&&$_POST["triggers"]&&$R&&($oj=trigger_sql($B)))echo"\nDELIMITER ;;\n$oj\nDELIMITER ;\n";if($Pc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$B.csv",$aj);}elseif($ye)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($B);}}foreach($Rj
as$Qj)adminer()->dumpTable($Qj,$_POST["table_style"],1);if($Pc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(76),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Rb=array('','USE','DROP+CREATE','CREATE');$Hi=array('','DROP+CREATE','CREATE');$Ob=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Ob[]='INSERT+UPDATE';$K=get_settings("adminer_export");if(!$K)$K=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($K["events"])){$K["routines"]=$K["events"]=($_GET["dump"]=="");$K["triggers"]=$K["table_style"];}echo"<tr><th>".lang(152)."<td>".html_radios("output",adminer()->dumpOutput(),$K["output"])."\n","<tr><th>".lang(153)."<td>".html_radios("format",adminer()->dumpFormat(),$K["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(37)."<td>".html_select('db_style',$Rb,$K["db_style"]).(support("type")?checkbox("types",1,$K["types"],lang(6)):"").(support("routine")?checkbox("routines",1,$K["routines"],lang(72)):"").(support("event")?checkbox("events",1,$K["events"],lang(74)):"")),"<tr><th>".lang(128)."<td>".html_select('table_style',$Hi,$K["table_style"]).checkbox("auto_increment",1,$K["auto_increment"],lang(51)).(support("trigger")?checkbox("triggers",1,$K["triggers"],lang(148)):""),"<tr><th>".lang(154)."<td>".html_select('data_style',$Ob,$K["data_style"]),'</table>
<p><input type="submit" value="',lang(76),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$Xg=array();if(DB!=""){$bb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$bb>".lang(128)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(154)."<input type='checkbox' id='check-data'$bb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Rj="";$Ji=tables_list();foreach($Ji
as$B=>$U){$Wg=preg_replace('~_.*~','',$B);$bb=($a==""||$a==(substr($a,-1)=="%"?"$Wg%":$B));$ah="<tr><td>".checkbox("tables[]",$B,$bb,$B,"","block");if($U!==null&&!preg_match('~table~i',$U))$Rj
.="$ah\n";else
echo"$ah<td align='right'><label class='block'><span id='Rows-".h($B)."'></span>".checkbox("data[]",$B,$bb)."</label>\n";$Xg[$Wg]++;}echo$Rj;if($Ji)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(37)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=adminer()->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$Wg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$Wg%",$k,"","block")."\n";$Xg[$Wg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$dd=true;foreach($Xg
as$y=>$X){if($y!=""&&$X>1){echo($dd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$dd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(71));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(155)."</a>";$I=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$wd=$I;if(!$I)$I=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($wd?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(35)."<th>".lang(34)."<th></thead>\n";while($K=$I->fetch_assoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(12)."</a>\n";if(!$wd||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(12)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");if($_POST["format"]=="sql")echo"$_POST[query]\n";else{adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();}exit;}restart_session();$Md=&get_session("queries");$Ld=&$Md[DB];if(!$m&&$_POST["clear"]){$Ld=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(75):lang(64)),$m);$Ue='--'.(JUSH=='sql'?' ':'');if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$H=$_POST["query"];elseif($_POST["webfile"]){$ni=adminer()->importServerPath();$r=@fopen((file_exists($ni)?$ni:"compress.zlib://$ni.gz"),"rb");$H=($r?fread($r,1e6):false);}else$H=get_file("sql_file",true,";");if(is_string($H)){if(function_exists('memory_get_usage')&&($of=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($of,strval(2*strlen($H)+memory_get_usage()+8e6)));if($H!=""&&strlen($H)<1e6){$hh=$H.(preg_match("~;[ \t\r\n]*\$~",$H)?"":";");if(!$Ld||first(end($Ld))!=$hh){restart_session();$Ld[]=array($hh,time());set_session("queries",$Md);stop_session();}}$ki="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|$Ue)[^\n]*\n?|--\r?\n)";$Zb=";";$C=0;$yc=true;$h=connect();if($h&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$pb=0;$Fc=array();$_g='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|'.$Ue.'|$'.(JUSH=="pgsql"?'|\$([a-zA-Z]\w*)?\$':'');$ej=microtime(true);$oa=get_settings("adminer_import");while($H!=""){if(!$C&&preg_match("~^$ki*+DELIMITER\\s+(\\S+)~i",$H,$A)){$Zb=preg_quote($A[1]);$H=substr($H,strlen($A[0]));}elseif(!$C&&JUSH=='pgsql'&&preg_match("~^($ki*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$H,$A)){$Zb="\n\\\\\\.\r?\n";$C=strlen($A[0]);}else{preg_match("($Zb\\s*|$_g)",$H,$A,PREG_OFFSET_CAPTURE,$C);list($pd,$Rg)=$A[0];if(!$pd&&$r&&!feof($r))$H
.=fread($r,1e5);else{if(!$pd&&rtrim($H)=="")break;$C=$Rg+strlen($pd);if($pd&&!preg_match("(^$Zb)",$pd)){$Ta=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($Rg>0&&strtolower($H[$Rg-1])=="e"));$Kg=($pd=='/*'?'\*/':($pd=='['?']':(preg_match("~^$Ue|^#~",$pd)?"\n":preg_quote($pd).($Ta?'|\\\\.':''))));while(preg_match("($Kg|\$)s",$H,$A,PREG_OFFSET_CAPTURE,$C)){$Hh=$A[0][0];if(!$Hh&&$r&&!feof($r))$H
.=fread($r,1e5);else{$C=$A[0][1]+strlen($Hh);if(!$Hh||$Hh[0]!="\\")break;}}}else{$yc=false;$hh=substr($H,0,$Rg+($Zb[0]=="\n"?3:0));$pb++;$ah="<pre id='sql-$pb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($hh)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$ki*+ATTACH\\b~i",$hh,$A)){echo$ah,"<p class='error'>".lang(156)."\n";$Fc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$ah;ob_flush();flush();}$si=microtime(true);if(connection()->multi_query($hh)&&$h&&preg_match("~^$ki*+USE\\b~i",$hh))$h->query($hh);do{$I=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$ah:""),"<p class='error'>".lang(157).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$Fc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break
2;}else{$Ti=" <span class='time'>(".format_time($si).")</span>".(strlen($hh)<1000?" <a href='".h(ME)."sql=".urlencode(trim($hh))."'>".lang(12)."</a>":"");$qa=connection()->affected_rows;$Uj=($_POST["only_errors"]?"":driver()->warnings());$Vj="warnings-$pb";if($Uj)$Ti
.=", <a href='#$Vj'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$Vj');","");$Nc=null;$lg=null;$Oc="explain-$pb";if(is_object($I)){$z=$_POST["limit"];$lg=print_select_result($I,$h,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$Mf=$I->num_rows;echo"<p class='sql-footer'>".($Mf?($z&&$Mf>$z?lang(158,$z):"").lang(159,$Mf):""),$Ti;if($h&&preg_match("~^($ki|\\()*+SELECT\\b~i",$hh)&&($Nc=explain($h,$hh)))echo", <a href='#$Oc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Oc');","");$u="export-$pb";echo", <a href='#$u'>".lang(76)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$oa["output"])." ".html_select("format",adminer()->dumpFormat(),$oa["format"]).input_hidden("query",$hh)."<input type='submit' name='export' value='".lang(76)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$ki*+(CREATE|DROP|ALTER)$ki++(DATABASE|SCHEMA)\\b~i",$hh)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(160,$qa)."$Ti\n";}echo($Uj?"<div id='$Vj' class='hidden'>\n$Uj</div>\n":"");if($Nc){echo"<div id='$Oc' class='hidden explain'>\n";print_select_result($Nc,$h,$lg);echo"</div>\n";}}$si=microtime(true);}while(connection()->next_result());}$H=substr($H,$C);$C=0;}}}}if($yc)echo"<p class='message'>".lang(161)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(162,$pb-count($Fc))," <span class='time'>(".format_time($ej).")</span>\n";elseif($Fc&&$pb>1)echo"<p class='error'>".lang(157).": ".implode("",$Fc)."\n";}else
echo"<p class='error'>".upload_error($H)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Lc="<input type='submit' value='".lang(163)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$hh=$_GET["sql"];if($_POST)$hh=$_POST["query"];elseif($_GET["history"]=="all")$hh=$Ld;elseif($_GET["history"]!="")$hh=idx($Ld[$_GET["history"]],0);echo"<p>";textarea("query",$hh,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$Lc\n",lang(164).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{$Bd=(extension_loaded("zlib")?"[.gz]":"");echo"<fieldset><legend>".lang(165)."</legend><div>",file_input("SQL$Bd: <input type='file' name='sql_file[]' multiple>\n$Lc"),"</div></fieldset>\n";$Xd=adminer()->importServerPath();if($Xd)echo"<fieldset><legend>".lang(166)."</legend><div>",lang(167,"<code>".h($Xd)."$Bd</code>"),' <input type="submit" name="webfile" value="'.lang(168).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(169))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(170))."\n",input_token();if(!isset($_GET["import"])&&$Ld){print_fieldset("history",lang(171),$_GET["history"]!="");for($X=end($Ld);$X;$X=prev($Ld)){$y=key($Ld);list($hh,$Ti,$tc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(12)."</a>"." <span class='time' title='".@date('Y-m-d',$Ti)."'>".@date("H:i:s",$Ti)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace("~^(#|$Ue).*~m",'',$hh)))),80,"</code>").($tc?" <span class='time'>($tc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(172)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(173)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$_j=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$B=>$n){if(!isset($n["privileges"][$_j?"update":"insert"])||adminer()->fieldName($n)==""||$n["generated"])unset($o[$B]);}if($_POST&&!$m&&!isset($_GET["select"])){$We=$_POST["referer"];if($_POST["insert"])$We=($_j?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$We))$We=ME."select=".urlencode($a);$x=indexes($a);$vj=unique_array($_GET["where"],$x);$kh="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($We,lang(174),driver()->delete($a,$kh,$vj?0:1));else{$O=array();foreach($o
as$B=>$n){$X=process_input($n);if($X!==false&&$X!==null)$O[idf_escape($B)]=$X;}if($_j){if(!$O)redirect($We);queries_redirect($We,lang(175),driver()->update($a,$O,$kh,$vj?0:1));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$I=driver()->insert($a,$O);$Me=($I?last_id($I):0);queries_redirect($We,lang(176,($Me?" $Me":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=array();foreach($o
as$B=>$n){if(isset($n["privileges"]["select"])){$ya=($_POST["clone"]&&$n["auto_increment"]?"''":convert_field($n));$M[]=($ya?"$ya AS ":"").idf_escape($B);}}$K=array();if(!support("table"))$M=array("*");if($M){$I=driver()->select($a,$M,array($Z),$M,array(),(isset($_GET["select"])?2:1));if(!$I)$m=error();else{$K=$I->fetch_assoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetch_assoc()))$K=null;}}if(!support("table")&&!$o){if(!$Z){$I=driver()->select($a,array("*"),array(),array("*"));$K=($I?$I->fetch_assoc():false);if(!$K)$K=array(driver()->primary=>"");}if($K){foreach($K
as$y=>$X){if(!$Z)$K[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$o,$K,$_j,$m);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Eg=driver()->partitionBy;$Hg=($Eg?driver()->partitionsInfo($a):array());$qh=referencable_primary($a);$nd=array();foreach($qh
as$Di=>$n)$nd[str_replace("`","``",$Di)."`".str_replace("`","``",$n["field"])]=$Di;$og=array();$S=array();if($a!=""){$og=fields($a);$S=table_status1($a);if(count($S)<2)$m=lang(11);}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($K["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(177),drop_tables(array($a)));else{$o=array();$ua=array();$Fj=false;$ld=array();$ng=reset($og);$sa=" FIRST";foreach($K["fields"]as$y=>$n){$q=$nd[$n["type"]];$pj=($q!==null?$qh[$q]:$n);if($n["field"]!=""){if(!$n["generated"])$n["default"]=null;$fh=process_field($n,$pj);$ua[]=array($n["orig"],$fh,$sa);if(!$ng||$fh!==process_field($ng,$ng)){$o[]=array($n["orig"],$fh,$sa);if($n["orig"]!=""||$sa)$Fj=true;}if($q!==null)$ld[idf_escape($n["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$nd[$n["type"]],'source'=>array($n["field"]),'target'=>array($pj["field"]),'on_delete'=>$n["on_delete"],));$sa=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$Fj=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$ng=next($og);if(!$ng)$sa="";}}$E=array();if(in_array($K["partition_by"],$Eg)){foreach($K
as$y=>$X){if(preg_match('~^partition~',$y))$E[$y]=$X;}foreach($E["partition_names"]as$y=>$B){if($B==""){unset($E["partition_names"][$y]);unset($E["partition_values"][$y]);}}$E["partition_names"]=array_values($E["partition_names"]);$E["partition_values"]=array_values($E["partition_values"]);if($E==$Hg)$E=array();}elseif(preg_match("~partitioned~",$S["Create_options"]))$E=null;$pf=lang(178);if($a==""){cookie("adminer_engine",$K["Engine"]);$pf=lang(179);}$B=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($B),$pf,alter_table($a,$B,(JUSH=="sqlite"&&($Fj||$ld)?$ua:$o),$ld,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$E));}}page_header(($a!=""?lang(43):lang(77)),$m,array("table"=>$a),h($a));if(!$_POST){$rj=driver()->types();$K=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($rj["int"])?"int":(isset($rj["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=array();if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($og
as$n){$n["generated"]=$n["generated"]?:(isset($n["default"])?"DEFAULT":"");$K["fields"][]=$n;}if($Eg){$K+=$Hg;$K["partition_names"][]="";$K["partition_values"][]="";}}}$lb=collations();if(is_array(reset($lb)))$lb=call_user_func_array('array_merge',array_values($lb));$_c=driver()->engines();foreach($_c
as$zc){if(!strcasecmp($zc,$K["Engine"])){$K["Engine"]=$zc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(180).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($K["name"])."' autocapitalize='off'>\n",($_c?html_select("Engine",array(""=>"(".lang(181).")")+$_c,$K["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($lb)echo"<datalist id='collations'>".optionlist($lb)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($K["Collation"])."' placeholder='(".lang(106).")'>\n");echo"<input type='submit' value='".lang(16)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$lb,"TABLE",$nd);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(51).": <input type='number' name='Auto_increment' class='size' value='".h($K["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(182),"columnShow(this.checked, 5)","jsonly");$sb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$sb,lang(50),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$K["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($sb?"":" class='hidden'").">".h($K["Comment"])."</textarea>":'<input name="Comment" value="'.h($K["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($sb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(16),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(132),'">',confirm(lang(183,$a));if($Eg&&(JUSH=='sql'||$a=="")){$Fg=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset("partition",lang(184),$K["partition_by"]);echo"<p>".html_select("partition_by",array_merge(array(""),$Eg),$K["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($K["partition"])."'>)\n",lang(185).": <input type='number' name='partitions' class='size".($Fg||!$K["partition_by"]?" hidden":"")."' value='".h($K["partitions"])."'>\n","<table id='partition-table'".($Fg?"":" class='hidden'").">\n","<thead><tr><th>".lang(186)."<th>".lang(187)."</thead>\n";foreach($K["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($K["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($K["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$fe=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);$ce=driver()->indexAlgorithms($S);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="SPATIAL";$x=indexes($a);$o=fields($a);$G=array();if(JUSH=="mongo"){$G=$x["_id_"];unset($fe[0]);unset($x["_id_"]);}$K=$_POST;if($K)save_settings(array("index_options"=>$K["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$b=array();foreach($K["indexes"]as$w){$B=$w["name"];if(in_array($w["type"],$fe)){$e=array();$Se=array();$cc=array();$de=(support("partial_indexes")?$w["partial"]:"");$be=(in_array($w["algorithm"],$ce)?$w["algorithm"]:"");$O=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$d){if($d!=""){$Re=idx($w["lengths"],$y);$ac=idx($w["descs"],$y);$O[]=($o[$d]?idf_escape($d):$d).($Re?"(".(+$Re).")":"").($ac?" DESC":"");$e[]=$d;$Se[]=($Re?:null);$cc[]=$ac;}}$Mc=$x[$B];if($Mc){ksort($Mc["columns"]);ksort($Mc["lengths"]);ksort($Mc["descs"]);if($w["type"]==$Mc["type"]&&array_values($Mc["columns"])===$e&&(!$Mc["lengths"]||array_values($Mc["lengths"])===$Se)&&array_values($Mc["descs"])===$cc&&$Mc["partial"]==$de&&(!$ce||$Mc["algorithm"]==$be)){unset($x[$B]);continue;}}if($e)$b[]=array($w["type"],$B,$O,$be,$de);}}foreach($x
as$B=>$Mc)$b[]=array($Mc["type"],$B,"DROP");if(!$b)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(188),alter_indexes($a,$b));}page_header(lang(140),$m,array("table"=>$a),h($a));$ad=array_keys($o);if($_POST["add"]){foreach($K["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$K["indexes"][$y]["columns"][]="";}$w=end($K["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$K["indexes"][]=array("columns"=>array(1=>""));}if(!$K){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$K["indexes"]=$x;}$Se=(JUSH=="sql"||JUSH=="mssql");$ei=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(189);$Vd=" class='idxopts".($ei?"":" hidden")."'";if($ce)echo"<th id='label-algorithm'$Vd>".lang(190).doc_link(array('sql'=>'create-index.html#create-index-storage-engine-index-types','mariadb'=>'storage-engine-index-types/','pgsql'=>'indexes-types.html',));echo'<th><input type="submit" class="wayoff">',lang(191).($Se?"<span$Vd> (".lang(192).")</span>":"");if($Se||support("descidx"))echo
checkbox("options",1,$ei,lang(112),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(193);if(support("partial_indexes"))echo"<th id='label-condition'$Vd>".lang(194);echo'<th><noscript>',icon("plus","add[0]","+",lang(113)),'</noscript>
</thead>
';if($G){echo"<tr><td>PRIMARY<td>";foreach($G["columns"]as$y=>$d)echo
select_input(" disabled",$ad,$d),"<label><input disabled type='checkbox'>".lang(59)."</label> ";echo"<td><td>\n";}$Ae=1;foreach($K["indexes"]as$w){if(!$_POST["drop_col"]||$Ae!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$Ae][type]",array(-1=>"")+$fe,$w["type"],($Ae==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type");if($ce)echo"<td$Vd>".html_select("indexes[$Ae][algorithm]",array_merge(array(""),$ce),$w['algorithm'],"label-algorithm");echo"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$Ae][columns][$t]' title='".lang(48)."'",($o&&($d==""||$o[$d])?array_combine($ad,$ad):array()),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span$Vd>",($Se?"<input type='number' name='indexes[$Ae][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(111)."'>":""),(support("descidx")?checkbox("indexes[$Ae][descs][$t]",1,idx($w["descs"],$y),lang(59)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$Ae][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n";if(support("partial_indexes"))echo"<td$Vd><input name='indexes[$Ae][partial]' value='".h($w["partial"])."' autocapitalize='off' aria-labelledby='label-condition'>\n";echo"<td>".icon("cross","drop_col[$Ae]","x",lang(116)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$Ae++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(16),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!$m&&!$_POST["add"]){$B=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(195),drop_databases(array(DB)));}elseif(DB!==$B){if(DB!=""){$_GET["db"]=$B;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($B),lang(196),rename_database($B,$K["collation"]));}else{$j=explode("\n",str_replace("\r","",$B));$xi=true;$Le="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$K["collation"]))$xi=false;$Le=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($Le),lang(197),$xi);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($B).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(198));}}page_header(DB!=""?lang(67):lang(120),$m,array(),h(DB));$lb=collations();$B=DB;if($_POST)$B=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,$lb);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$wd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$wd,$A)&&$A[1]){$B=stripcslashes(idf_unescape("`$A[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($B,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($B).'</textarea><br>':'<input name="name" autofocus value="'.h($B).'" data-maxlength="64" autocapitalize="off">')."\n".($lb?html_select("collation",array(""=>"(".lang(106).")")+$lb,$K["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(16),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(132)."'>".confirm(lang(183,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(113))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST&&!$m){$_=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$_,lang(199));else{$B=trim($K["name"]);$_
.=urlencode($B);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($B),$_,lang(200));elseif($_GET["ns"]!=$B)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($B),$_,lang(201));else
redirect($_);}}page_header($_GET["ns"]!=""?lang(68):lang(69),$m);if(!$K)$K["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(16),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(132)."'>".confirm(lang(183,$_GET["ns"]))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(202).": ".h($ca),$m);$Dh=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Yd=array();$tg=array();foreach($Dh["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT"&&JUSH=='sql')$tg[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Yd[]=$t;}if(!$m&&$_POST){$Ua=array();foreach($Dh["fields"]as$y=>$n){$X="";if(in_array($y,$Yd)){$X=process_input($n);if($X===false)$X="''";if(isset($tg[$y]))connection()->query("SET @".idf_escape($n["field"])." = $X");}if(isset($tg[$y]))$Ua[]="@".idf_escape($n["field"]);elseif(in_array($y,$Yd))$Ua[]=$X;}$H=(isset($_GET["callf"])?"SELECT ":"CALL ").($Dh["returns"]["type"]=="record"?"* FROM ":"").table($ca)."(".implode(", ",$Ua).")";$si=microtime(true);$I=connection()->multi_query($H);$qa=connection()->affected_rows;echo
adminer()->selectQuery($H,$si,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$h=connect();if($h)$h->select_db(DB);do{$I=connection()->store_result();if(is_object($I))print_select_result($I,$h);else
echo"<p class='message'>".lang(203,$qa)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($tg)print_select_result(connection()->query("SELECT ".implode(", ",$tg)));}}echo'
<form action="" method="post">
';if($Yd){echo"<table class='layout'>\n";foreach($Yd
as$y){$n=$Dh["fields"][$y];$B=$n["field"];echo"<tr><th>".adminer()->fieldName($n);$Y=idx($_POST["fields"],$B);if($Y!=""){if($n["type"]=="set")$Y=implode(",",$Y);}input($n,$Y,idx($_POST["function"],$B,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(202),'">
',input_token(),'</form>

<pre>
';function
pre_tr($Hh){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($Hh))));}$R='(\+--[-+]+\+\n)';$K='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$K$R?($K*)$R?~m",function($A){$ed=pre_tr($A[2]);return"<table>\n".($A[1]?"<thead>$ed</thead>\n":$ed).pre_tr($A[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($Dh['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$B=$_GET["name"];$K=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$Mi=array();foreach($K["source"]as$y=>$X)$Mi[$y]=$K["target"][$y];$K["target"]=$Mi;}if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(" $B"=>($K["drop"]?"":" ".format_foreign_key($K))));else{$b="ALTER TABLE ".table($a);$I=($B==""||queries("$b DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($B)));if(!$K["drop"])$I=queries("$b ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(204):($B!=""?lang(205):lang(206))),$I);if(!$K["drop"])$m=lang(207);}page_header(lang(208),$m,array("table"=>$a),h($a));if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=array();}elseif($B!=""){$nd=foreign_keys($a);$K=$nd[$B];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=array("");}echo'
<form action="" method="post">
';$ji=array_keys(fields($a));if($K["db"]!="")connection()->select_db($K["db"]);if($K["ns"]!=""){$pg=get_schema();set_schema($K["ns"]);}$ph=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$Mi=array_keys(fields(in_array($K["table"],$ph)?$K["table"]:reset($ph)));$Zf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(209).": ".html_select("table",$ph,$K["table"],$Zf)."</label>\n";if(support("scheme")){$Kh=array_filter(adminer()->schemas(),function($Jh){return!preg_match('~^information_schema$~i',$Jh);});echo"<label>".lang(79).": ".html_select("ns",$Kh,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$Zf)."</label>";if($K["ns"]!="")set_schema($pg);}elseif(JUSH!="sqlite"){$Sb=array();foreach(adminer()->databases()as$k){if(!information_schema($k))$Sb[]=$k;}echo"<label>".lang(78).": ".html_select("db",$Sb,$K["db"]!=""?$K["db"]:$_GET["db"],$Zf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(210),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(142),'<th id="label-target">',lang(143),'</thead>
';$Ae=0;foreach($K["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$ji,$X,($Ae==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$Mi,idx($K["target"],$y),"","label-target");$Ae++;}echo'</table>
<p>
<label>',lang(108),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$K["on_delete"]),'</label>
<label>',lang(107),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$K["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(16),'">
<noscript><p><input type="submit" name="add" value="',lang(211),'"></noscript>
';if($B!="")echo'<input type="submit" name="drop" value="',lang(132),'">',confirm(lang(183,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$qg="VIEW";if(JUSH=="pgsql"&&$a!=""){$P=table_status1($a);$qg=strtoupper($P["Engine"]);}if($_POST&&!$m){$B=trim($K["name"]);$ya=" AS\n$K[select]";$We=ME."table=".urlencode($B);$pf=lang(212);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$B&&JUSH!="sqlite"&&$U=="VIEW"&&$qg=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($B).$ya,$We,$pf);else{$Oi=$B."_adminer_".uniqid();drop_create("DROP $qg ".table($a),"CREATE $U ".table($B).$ya,"DROP $U ".table($B),"CREATE $U ".table($Oi).$ya,"DROP $U ".table($Oi),($_POST["drop"]?substr(ME,0,-1):$We),lang(213),$pf,lang(214),$a,$B);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($qg!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(44):lang(215)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(193),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$K["materialized"],lang(136)):""),'<p>';textarea("select",$K["select"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(132),'">',confirm(lang(183,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$se=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$ti=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$K=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(216));elseif(in_array($K["INTERVAL_FIELD"],$se)&&isset($ti[$K["STATUS"]])){$Ih="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(217):lang(218)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Ih.($aa!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$Ih)."\n".$ti[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(219).": ".h($aa):lang(220)),$m);if(!$K&&$aa!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$K=reset($L);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(193),'<td><input name="EVENT_NAME" value="',h($K["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(221),'<td><input name="STARTS" value="',h("$K[EXECUTE_AT]$K[STARTS]"),'">
<tr><th title="datetime">',lang(222),'<td><input name="ENDS" value="',h($K["ENDS"]),'">
<tr><th>',lang(223),'<td><input type="number" name="INTERVAL_VALUE" value="',h($K["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$se,$K["INTERVAL_FIELD"]),'<tr><th>',lang(123),'<td>',html_select("STATUS",$ti,$K["STATUS"]),'<tr><th>',lang(50),'<td><input name="EVENT_COMMENT" value="',h($K["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(224)),'</table>
<p>';textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(132),'">',confirm(lang(183,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$Dh=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])&&!$m){$mg=routine($_GET["procedure"],$Dh);$Oi="$K[name]_adminer_".uniqid();foreach($K["fields"]as$y=>$n){if($n["field"]=="")unset($K["fields"][$y]);}drop_create("DROP $Dh ".routine_id($ca,$mg),create_routine($Dh,$K),"DROP $Dh ".routine_id($K["name"],$K),create_routine($Dh,array("name"=>$Oi)+$K),"DROP $Dh ".routine_id($Oi,$K),substr(ME,0,-1),lang(225),lang(226),lang(227),$ca,$K["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(228):lang(229)).": ".h($ca):(isset($_GET["function"])?lang(230):lang(231))),$m);if(!$_POST){if($ca=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$Dh);$K["name"]=$ca;}}$lb=get_vals("SHOW CHARACTER SET");sort($lb);$Eh=routine_languages();echo($lb?"<datalist id='collations'>".optionlist($lb)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(193),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',($Eh?"<label>".lang(21).": ".html_select("language",$Eh,$K["language"])."</label>\n":""),'<input type="submit" value="',lang(16),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($K["fields"],$lb,$Dh);if(isset($_GET["function"])){echo"<tr><td>".lang(232);edit_type("returns",(array)$K["returns"],$lb,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$K["definition"],20);echo'<p>
<input type="submit" value="',lang(16),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(132),'">',confirm(lang(183,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["sequence"])){$ea=$_GET["sequence"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);$B=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($ea),$_,lang(233));elseif($ea=="")query_redirect("CREATE SEQUENCE ".idf_escape($B),$_,lang(234));elseif($ea!=$B)query_redirect("ALTER SEQUENCE ".idf_escape($ea)." RENAME TO ".idf_escape($B),$_,lang(235));else
redirect($_);}page_header($ea!=""?lang(236).": ".h($ea):lang(237),$m);if(!$K)$K["name"]=$ea;echo'
<form action="" method="post">
<p><input name="name" value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(16),'">
';if($ea!="")echo"<input type='submit' name='drop' value='".lang(132)."'>".confirm(lang(183,$ea))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["type"])){$fa=$_GET["type"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($fa),$_,lang(238));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$_,lang(239));}page_header($fa!=""?lang(240).": ".h($fa):lang(241),$m);if(!$K)$K["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($fa!=""){$rj=driver()->types();$Dc=type_values($rj[$fa]);if($Dc)echo"<code class='jush-".JUSH."'>ENUM (".h($Dc).")</code>\n<p>";echo"<input type='submit' name='drop' value='".lang(132)."'>".confirm(lang(183,$fa))."\n";}else{echo
lang(193).": <input name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(array('pgsql'=>"datatype-enum.html",),"?");textarea("as",$K["as"]);echo"<p><input type='submit' value='".lang(16)."'>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$B=$_GET["name"];$K=$_POST;if($K&&!$m){if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(),"",array(),"$B",($K["drop"]?"":$K["clause"]));else{$I=($B==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($B)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(242):($B!=""?lang(243):lang(244))),$I);}page_header(($B!=""?lang(245).": ".h($B):lang(147)),$m,array("table"=>$a));if(!$K){$cb=driver()->checkConstraints($a);$K=array("name"=>$B,"clause"=>$cb[$B]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(193).': <input name="name" value="'.h($K["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",),"?"),'<p>';textarea("clause",$K["clause"]);echo'<p><input type="submit" value="',lang(16),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(132),'">',confirm(lang(183,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$B="$_GET[name]";$nj=trigger_options();$K=(array)trigger($B,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$nj["Timing"])&&in_array($_POST["Event"],$nj["Event"])&&in_array($_POST["Type"],$nj["Type"])){$Wf=" ON ".table($a);$kc="DROP TRIGGER ".idf_escape($B).(JUSH=="pgsql"?$Wf:"");$We=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($kc,$We,lang(246));else{if($B!="")queries($kc);queries_redirect($We,($B!=""?lang(247):lang(248)),queries(create_trigger($Wf,$_POST)));if($B!="")queries(create_trigger($Wf,$K+array("Type"=>reset($nj["Type"]))));}}$K=$_POST;}page_header(($B!=""?lang(249).": ".h($B):lang(250)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(251),'<td>',html_select("Timing",$nj["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(252),'<td>',html_select("Event",$nj["Event"],$K["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$nj["Event"])?" <input name='Of' value='".h($K["Of"])."' class='hidden'>":""),'<tr><th>',lang(49),'<td>',html_select("Type",$nj["Type"],$K["Type"]),'</table>
<p>',lang(193),': <input name="Trigger" value="',h($K["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$K["Statement"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(132),'">',confirm(lang(183,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ga=$_GET["user"];$dh=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$Bb)$dh[$Bb][$K["Privilege"]]=$K["Comment"];}$dh["Server Admin"]+=$dh["File access on server"];$dh["Databases"]["Create routine"]=$dh["Procedures"]["Create routine"];unset($dh["Procedures"]["Create routine"]);$dh["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$dh["Columns"][$X]=$dh["Tables"][$X];unset($dh["Server Admin"]["Usage"]);foreach($dh["Tables"]as$y=>$X)unset($dh["Databases"][$y]);$Ef=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$Ef[$X]=(array)$Ef[$X]+idx($_POST["grants"],$y,array());}$xd=array();$Uf="";if(isset($_GET["host"])&&($I=connection()->query("SHOW GRANTS FOR ".q($ga)."@".q($_GET["host"])))){while($K=$I->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$A)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$A[1],$df,PREG_SET_ORDER)){foreach($df
as$X){if($X[1]!="USAGE")$xd["$A[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$xd["$A[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$A))$Uf=$A[1];}}if($_POST&&!$m){$Vf=(isset($_GET["host"])?q($ga)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $Vf",ME."privileges=",lang(253));else{$Gf=q($_POST["user"])."@".q($_POST["host"]);$Ig=$_POST["pass"];if($Ig!=''&&!$_POST["hashed"]&&!min_version(8)){$Ig=get_val("SELECT PASSWORD(".q($Ig).")");$m=!$Ig;}$Gb=false;if(!$m){if($Vf!=$Gf){$Gb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $Gf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Ig));$m=!$Gb;}elseif($Ig!=$Uf)queries("SET PASSWORD FOR $Gf = ".q($Ig));}if(!$m){$Ah=array();foreach($Ef
as$Of=>$wd){if(isset($_GET["grant"]))$wd=array_filter($wd);$wd=array_keys($wd);if(isset($_GET["grant"]))$Ah=array_diff(array_keys(array_filter($Ef[$Of],'strlen')),$wd);elseif($Vf==$Gf){$Sf=array_keys((array)$xd[$Of]);$Ah=array_diff($Sf,$wd);$wd=array_diff($wd,$Sf);unset($xd[$Of]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$Of,$A)&&(!grant("REVOKE",$Ah,$A[2]," ON $A[1] FROM $Gf")||!grant("GRANT",$wd,$A[2]," ON $A[1] TO $Gf"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($Vf!=$Gf)queries("DROP USER $Vf");elseif(!isset($_GET["grant"])){foreach($xd
as$Of=>$Ah){if(preg_match('~^(.+)(\(.*\))?$~U',$Of,$A))grant("REVOKE",array_keys($Ah),$A[2]," ON $A[1] FROM $Gf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(254):lang(255)),!$m);if($Gb)connection()->query("DROP USER $Gf");}}page_header((isset($_GET["host"])?lang(35).": ".h("$ga@$_GET[host]"):lang(155)),$m,array("privileges"=>array('',lang(71))));$K=$_POST;if($K)$xd=$Ef;else{$K=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$K["pass"]=$Uf;if($Uf!="")$K["hashed"]=true;$xd[(DB==""||$xd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(34),'<td><input name="host" data-maxlength="60" value="',h($K["host"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="user" data-maxlength="80" value="',h($K["user"]),'" autocapitalize="off">
<tr><th>',lang(36),'<td><input name="pass" id="pass" value="',h($K["pass"]),'" autocomplete="new-password">
',($K["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$K["hashed"],lang(256),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(71).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($xd
as$Of=>$wd){echo'<th>'.($Of!="*.*"?"<input name='objects[$t]' value='".h($Of)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(34),"Databases"=>lang(37),"Tables"=>lang(138),"Columns"=>lang(48),"Procedures"=>lang(257),)as$Bb=>$ac){foreach((array)$dh[$Bb]as$ch=>$qb){echo"<tr><td".($ac?">$ac<td":" colspan='2'").' lang="en" title="'.h($qb).'">'.h($ch);$t=0;foreach($xd
as$Of=>$wd){$B="'grants[$t][".h(strtoupper($ch))."]'";$Y=$wd[strtoupper($ch)];if($Bb=="Server Admin"&&$Of!=(isset($xd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$B><option><option value='1'".($Y?" selected":"").">".lang(258)."<option value='0'".($Y=="0"?" selected":"").">".lang(259)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$B value='1'".($Y?" checked":"").($ch=="All privileges"?" id='grants-$t-all'>":">".($ch=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(16),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(132),'">',confirm(lang(183,"$ga@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$Ge=0;foreach((array)$_POST["kill"]as$X){if(adminer()->killProcess($X))$Ge++;}queries_redirect(ME."processlist=",lang(260,$Ge),$Ge||!$_POST["kill"]);}}page_header(lang(121),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(adminer()->processList()as$t=>$K){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[JUSH=="sql"?"Id":"pid"],0):"");foreach($K
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.lang(261).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(262,max_connections()),"<p><input type='submit' value='".lang(263)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$o=fields($a);$nd=column_foreign_keys($a);$Qf=$S["Oid"];$pa=get_settings("adminer_import");$Bh=array();$e=array();$Ph=array();$ig=array();$Si="";foreach($o
as$y=>$n){$B=adminer()->fieldName($n);$Cf=html_entity_decode(strip_tags($B),ENT_QUOTES);if(isset($n["privileges"]["select"])&&$B!=""){$e[$y]=$Cf;if(is_shortable($n))$Si=adminer()->selectLengthProcess();}if(isset($n["privileges"]["where"])&&$B!="")$Ph[$y]=$Cf;if(isset($n["privileges"]["order"])&&$B!="")$ig[$y]=$Cf;$Bh+=$n["privileges"];}list($M,$yd)=adminer()->selectColumnsProcess($e,$x);$M=array_unique($M);$yd=array_unique($yd);$we=count($yd)<count($M);$Z=adminer()->selectSearchProcess($o,$x);$hg=adminer()->selectOrderProcess($o,$x);$z=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$wj=>$K){$ya=convert_field($o[key($K)]);$M=array($ya?:idf_escape(key($K)));$Z[]=where_check($wj,$o);$J=driver()->select($a,$M,$Z,$M);if($J)echo
first($J->fetch_row());}exit;}$G=$yj=array();foreach($x
as$w){if($w["type"]=="PRIMARY"){$G=array_flip($w["columns"]);$yj=($M?$G:array());foreach($yj
as$y=>$X){if(in_array(idf_escape($y),$M))unset($yj[$y]);}break;}}if($Qf&&!$G){$G=$yj=array($Qf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($Qf));}if($_POST&&!$m){$Xj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$cb=array();foreach($_POST["check"]as$Ya)$cb[]=where_check($Ya,$o);$Xj[]="((".implode(") OR (",$cb)."))";}$Xj=($Xj?"\nWHERE ".implode(" AND ",$Xj):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$rd=($M?implode(", ",$M):"*").convert_fields($e,$o,$M)."\nFROM ".table($a);$_d=($yd&&$we?"\nGROUP BY ".implode(", ",$yd):"").($hg?"\nORDER BY ".implode(", ",$hg):"");$H="SELECT $rd$Xj$_d";if(is_array($_POST["check"])&&!$G){$uj=array();foreach($_POST["check"]as$X)$uj[]="(SELECT".limit($rd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$_d,1).")";$H=implode(" UNION ALL ",$uj);}adminer()->dumpData($a,"table",$H);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$nd)){if($_POST["save"]||$_POST["delete"]){$I=true;$qa=0;$O=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$B=>$X){$X=process_input($o[$B]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($B)]=($X!==false?$X:idf_escape($B));}}if($_POST["delete"]||$O){$H=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a):"");if($_POST["all"]||($G&&is_array($_POST["check"]))||$we){$I=($_POST["delete"]?driver()->delete($a,$Xj):($_POST["clone"]?queries("INSERT $H$Xj".driver()->insertReturning($a)):driver()->update($a,$O,$Xj)));$qa=connection()->affected_rows;if(is_object($I))$qa+=$I->num_rows;}else{foreach((array)$_POST["check"]as$X){$Wj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$I=($_POST["delete"]?driver()->delete($a,$Wj,1):($_POST["clone"]?queries("INSERT".limit1($a,$H,$Wj)):driver()->update($a,$O,$Wj,1)));if(!$I)break;$qa+=connection()->affected_rows;}}}$pf=lang(264,$qa);if($_POST["clone"]&&$I&&$qa==1){$Me=last_id($I);if($Me)$pf=lang(176," $Me");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$pf,$I);if(!$_POST["delete"]){$Ug=(array)$_POST["fields"];edit_form($a,array_intersect_key($o,$Ug),$Ug,!$_POST["clone"],$m);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(265);else{$I=true;$qa=0;foreach($_POST["val"]as$wj=>$K){$O=array();foreach($K
as$y=>$X){$y=bracket_escape($y,true);$O[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?adminer()->processInput($o[$y],$X):"NULL");}$I=driver()->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($wj,$o),($we||$G?0:1)," ");if(!$I)break;$qa+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(264,$qa),$I);}}elseif(!is_string($bd=get_file("csv_file",true)))$m=upload_error($bd);elseif(!preg_match('~~u',$bd))$m=lang(266);else{save_settings(array("output"=>$pa["output"],"format"=>$_POST["separator"]),"adminer_import");$I=true;$mb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$bd,$df);$qa=count($df[0]);driver()->begin();$Vh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$L=array();foreach($df[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Vh]*)$Vh~",$X.$Vh,$ef);if(!$y&&!array_diff($ef[1],$mb)){$mb=$ef[1];$qa--;}else{$O=array();foreach($ef[1]as$t=>$jb)$O[idf_escape($mb[$t])]=($jb==""&&$o[$mb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$jb)?str_replace('""','"',substr($jb,1,-1)):$jb));$L[]=$O;}}$I=(!$L||driver()->insertUpdate($a,$L,$G));if($I)driver()->commit();queries_redirect(remove_from_uri("page"),lang(267,$qa),$I);driver()->rollback();}}}$Di=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(53).": $Di",$m);$O=null;if(isset($Bh["insert"])||!support("table")){$zg=array();foreach((array)$_GET["where"]as$X){if(isset($nd[$X["col"]])&&count($nd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$zg["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$O=$zg?"&".http_build_query($zg):"";}adminer()->selectLinks($S,$O);if(!$e&&support("table"))echo"<p class='error'>".lang(268).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($M,$e);adminer()->selectSearchPrint($Z,$Ph,$x);adminer()->selectOrderPrint($hg,$ig,$x);adminer()->selectLimitPrint($z);adminer()->selectLengthPrint($Si);adminer()->selectActionPrint($x);echo"</form>\n";$D=$_GET["page"];$qd=null;if($D=="last"){$qd=get_val(count_rows($a,$Z,$we,$yd));$D=floor(max(0,intval($qd)-1)/$z);}$Qh=$M;$zd=$yd;if(!$Qh){$Qh[]="*";$Cb=convert_fields($e,$o,$M);if($Cb)$Qh[]=substr($Cb,2);}foreach($M
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($ya=convert_field($n)))$Qh[$y]="$ya AS $X";}if(!$we&&$yj){foreach($yj
as$y=>$X){$Qh[]=idf_escape($y);if($zd)$zd[]=idf_escape($y);}}$I=driver()->select($a,$Qh,$Z,$zd,$hg,$z,$D,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$D)$I->seek($z*$D);$xc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$L=array();while($K=$I->fetch_assoc()){if($D&&JUSH=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$z&&$yd&&$we&&JUSH=="sql")$qd=get_val(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(14)."\n";else{$Ga=adminer()->backwardKeys($a,$Di);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$yd&&$M?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(269)."</a>");$Df=array();$td=array();reset($M);$mh=1;foreach($L[0]as$y=>$X){if(!isset($yj[$y])){$X=idx($_GET["columns"],key($M))?:array();$n=$o[$M?($X?$X["col"]:current($M)):$y];$B=($n?adminer()->fieldName($n,$mh):($X["fun"]?"*":h($y)));if($B!=""){$mh++;$Df[$y]=$B;$d=idf_escape($y);$Pd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$ac="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$sd=apply_sql_function($X["fun"],$B);$ii=isset($n["privileges"]["order"])||$sd;echo($ii?"<a href='".h($Pd.($hg[0]==$d||$hg[0]==$y?$ac:''))."'>$sd</a>":$sd),"<span class='column hidden'>";if($ii)echo"<a href='".h($Pd.$ac)."' title='".lang(59)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($n["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(56).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$td[$y]=$X["fun"];next($M);}}$Se=array();if($_GET["modify"]){foreach($L
as$K){foreach($K
as$y=>$X)$Se[$y]=max($Se[$y],min(40,strlen(utf8_decode($X))));}}echo($Ga?"<th>".lang(270):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($L,$nd)as$Bf=>$K){$vj=unique_array($L[$Bf],$x);if(!$vj){$vj=array();reset($M);foreach($L[$Bf]as$y=>$X){if(!preg_match('~^(COUNT|AVG|GROUP_CONCAT|MAX|MIN|SUM)\(~',current($M)))$vj[$y]=$X;next($M);}}$wj="";foreach($vj
as$y=>$X){$n=(array)$o[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$n["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$n["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$wj
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$yd&&$M?"":"<td>".checkbox("check[]",substr($wj,1),in_array(substr($wj,1),(array)$_POST["check"])).($we||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$wj)."' class='edit'>".lang(271)."</a>"));reset($M);foreach($K
as$y=>$X){if(isset($Df[$y])){$d=current($M);$n=(array)$o[$y];$X=driver()->value($X,$n);if($X!=""&&(!isset($xc[$y])||$xc[$y]!=""))$xc[$y]=(is_mail($X)?$Df[$y]:"");$_="";if(is_blob($n)&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$wj;if(!$_&&$X!==null){foreach((array)$nd[$y]as$q){if(count($nd[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$t=>$ji)$_
.=where_link($t,$q["target"][$t],$L[$Bf][$ji]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($d=="COUNT(*)"){$_=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$vj))$_
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($vj
as$Ce=>$W)$_
.=where_link($t++,$Ce,$W);}$Qd=select_value($X,$_,$n,$Si);$u=h("val[$wj][".bracket_escape($y)."]");$Vg=idx(idx($_POST["val"],$wj),bracket_escape($y));$sc=!is_array($K[$y])&&is_utf8($Qd)&&$L[$Bf][$y]==$K[$y]&&!$td[$y]&&!$n["generated"];$U=(preg_match('~^(AVG|MIN|MAX)\((.+)\)~',$d,$A)?$o[idf_unescape($A[2])]["type"]:$n["type"]);$Qi=preg_match('~text|json|lob~',$U);$xe=preg_match(number_type(),$U)||preg_match('~^(CHAR_LENGTH|ROUND|FLOOR|CEIL|TIME_TO_SEC|COUNT|SUM)\(~',$d);echo"<td id='$u'".($xe&&($X===null||is_numeric(strip_tags($Qd))||$U=="money")?" class='number'":"");if(($_GET["modify"]&&$sc&&$X!==null)||$Vg!==null){$Cd=h($Vg!==null?$Vg:$K[$y]);echo">".($Qi?"<textarea name='$u' cols='30' rows='".(substr_count($K[$y],"\n")+1)."'>$Cd</textarea>":"<input name='$u' value='$Cd' size='$Se[$y]'>");}else{$Ye=strpos($Qd,"<i>…</i>");echo" data-text='".($Ye?2:($Qi?1:0))."'".($sc?"":" data-warning='".h(lang(272))."'").">$Qd";}}next($M);}if($Ga)echo"<td>";adminer()->backwardKeysPrint($Ga,$L[$Bf]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($L||$D){$Kc=true;if($_GET["page"]!="last"){if(!$z||(count($L)<$z&&($L||!$D)))$qd=($D?$D*$z:0)+count($L);elseif(JUSH!="sql"||!$we){$qd=($we?false:found_rows($S,$Z));if(intval($qd)<max(1e4,2*($D+1)*$z))$qd=first(slow_query(count_rows($a,$Z,$we,$yd)));else$Kc=false;}}$xg=($z&&($qd===false||$qd>$z||$D));if($xg)echo(($qd===false?count($L)+1:$qd-$D*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($D+1)).'" class="loadmore">'.lang(273).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $z, '".lang(274)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($xg){$if=($qd===false?$D+(count($L)>=$z?2:1):floor(($qd-1)/$z));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(275)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(275)."', '".($D+1)."')); return false; };"),pagination(0,$D).($D>5?" …":"");for($t=max(1,$D-4);$t<min($if,$D+5);$t++)echo
pagination($t,$D);if($if>0)echo($D+5<$if?" …":""),($Kc&&$qd!==false?pagination($if,$D):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$if'>".lang(276)."</a>");}else
echo"<legend>".lang(275)."</legend>",pagination(0,$D).($D>1?" …":""),($D?pagination($D,$D):""),($if>$D?pagination($D+1,$D).($if>$D+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(277)."</legend>";$hc=($Kc?"":"~ ").$qd;$ag="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$hc' : checked); selectCount('selected2', this.checked || !checked ? '$hc' : checked);";echo
checkbox("all",1,0,($qd!==false?($Kc?"":"~ ").lang(159,$qd):""),$ag)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(269),'</legend><div>
<input type="submit" value="',lang(16),'"',($_GET["modify"]?'':' title="'.lang(265).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(131),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(12),'">
<input type="submit" name="clone" value="',lang(261),'">
<input type="submit" name="delete" value="',lang(20),'">',confirm(),'</div></fieldset>
';$od=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($od['sql']);break;}}if($od){print_fieldset("export",lang(76)." <span id='selected2'></span>");$ug=adminer()->dumpOutput();echo($ug?html_select("output",$ug,$pa["output"])." ":""),html_select("format",$od,$pa["format"])," <input type='submit' name='export' value='".lang(76)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($xc,'strlen'),$e);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<p>","<a href='#import'>".lang(75)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ",file_input("<input type='file' name='csv_file'> ".html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$pa["format"])." <input type='submit' name='import' value='".lang(75)."'>"),"</span>";echo
input_token(),"</form>\n",(!$yd&&$M?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(123):lang(122));$Nj=($P?show_status():show_variables());if(!$Nj)echo"<p class='message'>".lang(14)."\n";else{echo"<table>\n";foreach($Nj
as$K){echo"<tr>";$y=array_shift($K);echo"<th><code class='jush-".JUSH.($P?"status":"set")."'>".h($y)."</code>";foreach($K
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$_i=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$B=>$S){json_row("Comment-$B",h($S["Comment"]));if(!is_view($S)||preg_match('~materialized~i',$S["Engine"])){foreach(array("Engine","Collation")as$y)json_row("$y-$B",h($S[$y]));foreach($_i+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$B",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($_i[$y]))$_i[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$B","?");}}}foreach($_i
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$Ki=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Ki&&!$m&&!$_POST["search"]){$I=true;$pf="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$pf=lang(278);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$pf=lang(279);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$pf=lang(280);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$pf=lang(281);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$pf
.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$I=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$pf=lang(282);}elseif(!$_POST["tables"])$pf=lang(11);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($K=$I->fetch_assoc())$pf
.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$pf,$I);}page_header(($_GET["ns"]==""?lang(37).": ".h(DB):lang(79).": ".h($_GET["ns"])),$m,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(283)."</h3>\n";$Ji=tables_list();if(!$Ji)echo"<p class='message'>".lang(11)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(284)." <span id='selected2'></span></legend><div>",html_select("op",adminer()->operators(),idx($_POST,"op",JUSH=="elastic"?"should":"LIKE %%"))," <input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(56)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$_POST["op"];search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(138),'<td>'.lang(285).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(127).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(286).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(287).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(288).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(51).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(289).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(50).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($Ji
as$B=>$U){$Qj=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$B);echo'<tr><td>'.checkbox(($Qj?"views[]":"tables[]"),$B,in_array("$B",$Ki,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($B)."' title='".lang(42)."' id='$u'>".h($B).'</a>':h($B));if($Qj&&!preg_match('~materialized~i',$U)){$Wi=lang(137);echo'<td colspan="6">'.(support("view")?"<a href='".h(ME)."view=".urlencode($B)."' title='".lang(44)."'>$Wi</a>":$Wi),'<td align="right"><a href="'.h(ME)."select=".urlencode($B).'" title="'.lang(41).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(43)),"Index_length"=>array("indexes",lang(141)),"Data_free"=>array("edit",lang(45)),"Auto_increment"=>array("auto_increment=1&create",lang(43)),"Rows"=>array("select",lang(41)),)as$y=>$_){$u=" id='$y-".h($B)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($B)."'$u title='$_[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($B)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($B)."'>":""),"\n";}echo"<tr><td><th>".lang(262,count($Ji)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n",script("ajaxSetHtml('".js_escape(ME)."script=db');"),"</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Kj="<input type='submit' value='".lang(290)."'> ".on_help("'VACUUM'");$dg="<input type='submit' name='optimize' value='".lang(291)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(131)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$Kj."<input type='submit' name='check' value='".lang(292)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$Kj.$dg:(JUSH=="sql"?"<input type='submit' value='".lang(293)."'> ".on_help("'ANALYZE TABLE'").$dg."<input type='submit' name='check' value='".lang(292)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(294)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(295)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(132)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?adminer()->schemas():adminer()->databases());echo"</div></fieldset>\n";$Nh="";if(count($j)!=1&&JUSH!="sqlite"){echo"<fieldset><legend>".lang(296)." <span id='selected3'></span></legend><div>";$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(297)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(298)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(299)):""),"</div></fieldset>\n";$Nh=" selectCount('selected3', formChecked(this, /^(tables|views)\[/));";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")."$Nh }"),input_token(),"</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(77)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(215)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(72)."</h3>\n";$Fh=routines();if($Fh){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(193).'<td>'.lang(49).'<td>'.lang(232)."<td></thead>\n";foreach($Fh
as$K){$B=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.h($K["ROUTINE_NAME"]).'</a>','<td>'.h($K["ROUTINE_TYPE"]),'<td>'.h($K["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.lang(144)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(231).'</a>':'').'<a href="'.h(ME).'function=">'.lang(230)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(73)."</h3>\n";$Yh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($Yh){echo"<table class='odds'>\n","<thead><tr><th>".lang(193)."</thead>\n";foreach($Yh
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(237)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(6)."</h3>\n";$Ij=types();if($Ij){echo"<table class='odds'>\n","<thead><tr><th>".lang(193)."</thead>\n";foreach($Ij
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(241)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(74)."</h3>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(193)."<td>".lang(300)."<td>".lang(221)."<td>".lang(222)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(301)."<td>".$K["Execute at"]:lang(223)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(144).'</a>';echo"</table>\n";$Ic=get_val("SELECT @@event_scheduler");if($Ic&&$Ic!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Ic)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(220)."</a>\n";}}}}page_footer();