<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class AdminController extends Controller
{
    // Show login form
public function showLogin()
{
    return view('dashboard.Login');
}


    // Handle login form submission
    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $admin = DB::table('admin_subadmin')->where('gmail', $request->email)->first();

        if ($admin && Hash::check($request->password, $admin->password)) {
            // Login successful
            session([
                'admin_id' => $admin->id,
                'admin_name' => $admin->name,
                'admin_type' => $admin->type,
            ]);

            return redirect()->route('dashboard')->with('success', 'Login Successful');
        }

        return back()->withErrors(['email' => 'Invalid email or password']);
    }

    // Dashboard placeholder
    public function dashboard()
    {
        return "Welcome, Admin!";
    }

    // Logout
    public function logout()
    {
        session()->flush();
        return redirect()->route('admin.login');
    }
}
