<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;
use App\Models\State;

class CityController extends Controller
{
    // List cities
    public function index()
    {
        if (!session()->has('admin_id')) {
            return redirect()->route('admin.login');
        }

        $cities = State::fetchAllCities();

        $pageHead = View::make('template.page_head')->render();
        $sidebar  = View::make('template.sidebar')->render();
        $pageFoot = View::make('template.page_foot')->render();

        $table = View::make('cities.citieslisting', compact('cities'))->render();

        return response($pageHead . $sidebar . $table . $pageFoot);
    }

    // Show add city form
    public function create()
    {
        if (!session()->has('admin_id')) {
            return redirect()->route('admin.login');
        }

        $states = State::fetchAllStates();

        $pageHead = View::make('template.page_head')->render();
        $sidebar  = View::make('template.sidebar')->render();
        $pageFoot = View::make('template.page_foot')->render();
        $form = View::make('cities.citiesform', compact('states'))->render();

        return response($pageHead . $sidebar . $form . $pageFoot);
    }

    // Store new city
    public function store(Request $request)
    {
        $request->validate([
            'name'     => 'required|string|max:255',
            'state_id' => 'required|exists:states,id',
            'status'   => 'required|in:active,inactive',
        ]);

        State::createCity($request->only(['name','status','state_id']));

        return redirect()->route('cities.index')->with('success','City created successfully');
    }

    // Show edit city form
    public function edit($id)
    {
        if (!session()->has('admin_id')) {
            return redirect()->route('admin.login');
        }

        $city   = State::fetchCityById($id);
        $states = State::fetchAllStates();

        $pageHead = View::make('template.page_head')->render();
        $sidebar  = View::make('template.sidebar')->render();
        $pageFoot = View::make('template.page_foot')->render();
        $form = View::make('cities.citiesform', compact('city','states'))->render();

        return response($pageHead . $sidebar . $form . $pageFoot);
    }

    // Update city
    public function update(Request $request, $id)
    {
        $request->validate([
            'name'     => 'required|string|max:255',
            'state_id' => 'required|exists:states,id',
            'status'   => 'required|in:active,inactive',
        ]);

        State::updateCity($id, $request->only(['name','state_id','status']));

        return redirect()->route('cities.index')->with('success','City updated successfully');
    }

    // Delete city (soft deactivate)
    public function destroy($id)
    {
        \DB::table('cities')->where('id', $id)->update(['status' => 'inactive']);
        return redirect()->route('cities.index')->with('success','City deactivated successfully');
    }
}
