<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;
use App\Models\User;
    use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        // Check if admin is logged in
        if (!session()->has('admin_id')) {
            return redirect()->route('admin.login'); // redirect to login route
        }

        // fetch dashboard stats from User model
        $stats = User::dashboardStats();

        // Render each Blade file to a string, pass $stats to dashboard view
        $pageHead = View::make('template.page_head')->render();
        $sidebar  = View::make('template.sidebar')->render();
        $dashboard = View::make('dashboard.dashboard', compact('stats'))->render();
        $pageFoot = View::make('template.page_foot')->render();

        // Concatenate all parts
        $fullPage = $pageHead . $sidebar . $dashboard . $pageFoot;

        // Return as HTML response
        return response($fullPage);
    }



public function calendarBookings(Request $request)
{
    // Admin session check
    if (!session()->has('admin_id')) {
        return response()->json([]);
    }

    // Fetch ALL bookings (ADMIN VIEW)
    $bookings = DB::table('my_bookings')
        ->join('properties', 'properties.id', '=', 'my_bookings.property_id')
        ->select(
            'my_bookings.id',
            'my_bookings.booking_status',
            'my_bookings.check_in_time',
            'my_bookings.check_out_time',
            'properties.name as property_name'
        )
        ->get();

    $events = [];

    foreach ($bookings as $b) {

        // Color by status (optional but helpful)
        $colorMap = [
            'approved'  => '#198754',
            'pending'   => '#ffc107',
            'rejected'  => '#dc3545',
            'completed' => '#0d6efd',
        ];

        $events[] = [
            'id'    => $b->id,
            'title' => $b->property_name . ' (' . ucfirst($b->booking_status) . ')',
            'start' => $b->check_in_time,
            'end'   => $b->check_out_time,
            'color' => $colorMap[$b->booking_status] ?? '#6c757d',
        ];
    }

    return response()->json($events);
}

}
