<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;
use App\Models\State;

class LocalityController extends Controller
{
    public function index()
    {
        if (!session()->has('admin_id')) {
            return redirect()->route('admin.login');
        }

        $localities = State::fetchAllLocalities();

        $pageHead = View::make('template.page_head')->render();
        $sidebar  = View::make('template.sidebar')->render();
        $pageFoot = View::make('template.page_foot')->render();
        $table    = View::make('localities.localitylisting', compact('localities'))->render();

        return response($pageHead.$sidebar.$table.$pageFoot);
    }

    public function create()
    {
        if (!session()->has('admin_id')) {
            return redirect()->route('admin.login');
        }

        $cities = State::fetchAllCities();

        $pageHead = View::make('template.page_head')->render();
        $sidebar  = View::make('template.sidebar')->render();
        $pageFoot = View::make('template.page_foot')->render();
        $form     = View::make('localities.localityform', compact('cities'))->render();

        return response($pageHead.$sidebar.$form.$pageFoot);
    }

    public function store(Request $request)
    {
        $request->validate([
            'city_id' => 'required|integer',
            'name'    => 'required|string|max:255',
            'status'  => 'required|in:active,inactive',
        ]);

        State::createLocality($request->only(['city_id','name','status']));

        return redirect()->route('localities.index')->with('success','Locality created successfully');
    }

    public function edit($id)
    {
        if (!session()->has('admin_id')) {
            return redirect()->route('admin.login');
        }

        $locality = State::fetchLocalityById($id);
        $cities   = State::fetchAllCities();

        $pageHead = View::make('template.page_head')->render();
        $sidebar  = View::make('template.sidebar')->render();
        $pageFoot = View::make('template.page_foot')->render();
        $form     = View::make('localities.localityform', compact('locality','cities'))->render();

        return response($pageHead.$sidebar.$form.$pageFoot);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'city_id' => 'required|integer',
            'name'    => 'required|string|max:255',
            'status'  => 'required|in:active,inactive',
        ]);

        State::updateLocality($id, $request->only(['city_id','name','status']));

        return redirect()->route('localities.index')->with('success','Locality updated successfully');
    }

    public function destroy($id)
    {
        $locality = state::fetchLocalityById($id);
        if ($locality) {
            State::updateLocality($id, [
                'city_id' => $locality->city_id,
                'name'    => $locality->name,
                'status'  => 'inactive'
            ]);
        }

        return redirect()->route('localities.index')->with('success','Locality deactivated successfully');
    }
}
