namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Models\Locality;

class LocationController extends Controller
{
    public function getCities($state_id)
    {
        $cities = City::where('state_id', $state_id)->get(['id','name']);
        return response()->json(['data' => $cities]);
    }

    public function getLocalities($city_id)
    {
        $localities = Locality::where('city_id', $city_id)->get(['id','name']);
        return response()->json(['data' => $localities]);
    }
}
