<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class Merchant
{
    /**
     * Create new merchant
     */
    public static function createMerchant(array $data)
    {
        return DB::table('users')->insert([
            'name'       => $data['name'],
            'email'      => $data['email'],
            'password'   => Hash::make($data['password']), // HASHED
            'phone_no'   => $data['phone_no'] ?? null,
            'user_type'  => 'merchant',
            'status'     => 'active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Check if email already exists
     */
    public static function emailExists($email)
    {
        return DB::table('users')
            ->where('email', $email)
            ->exists();
    }
      public static function login($email, $password)
    {
        $merchant = DB::table('users')
            ->where('email', $email)
            ->where('user_type', 'merchant')
            ->first();

        if (!$merchant) {
            return false;
        }

        if (!Hash::check($password, $merchant->password)) {
            return false;
        }

        return $merchant;
    }
}
