<div class="content-wrapper">

  <!-- Page Header -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">Dashboard</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            <li class="breadcrumb-item active">Dashboard</li>
          </ol>
        </div>
      </div>
    </div>
  </div>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">

      <!-- MAIN ROW -->
      <div class="row">

        <!-- LEFT SIDE : 6 BOXES -->
        <div class="col-lg-6 col-12">
          <div class="row">

            <!-- Users -->
            <div class="col-lg-6 col-6">
              <div class="small-box bg-info">
                <div class="inner">
                  <h3>{{ $stats['total_users'] ?? 0 }}</h3>
                  <p>Total Users</p>
                  <small>User: {{ $stats['users_count'] ?? 0 }} | Merchant: {{ $stats['merchants_count'] ?? 0 }}</small>
                </div>
                <div class="icon"><i class="ion ion-person-stalker"></i></div>
                <a href="{{ route('users.index') }}" class="small-box-footer">
                  More info <i class="fas fa-arrow-circle-right"></i>
                </a>
              </div>
            </div>

            <!-- Properties -->
            <div class="col-lg-6 col-6">
              <div class="small-box bg-success">
                <div class="inner">
                  <h3>{{ $stats['properties_total'] ?? 0 }}</h3>
                  <p>Properties</p>
                  <small>
                    Active: {{ $stats['properties_active_count'] ?? 0 }} |
                    Inactive: {{ $stats['properties_inactive_count'] ?? 0 }}
                  </small>
                </div>
                <div class="icon"><i class="ion ion-home"></i></div>
                <a href="{{ route('properties.index') }}" class="small-box-footer">
                  More info <i class="fas fa-arrow-circle-right"></i>
                </a>
              </div>
            </div>

            <!-- Bookings -->
            <div class="col-lg-6 col-6">
              <div class="small-box bg-warning">
                <div class="inner">
                  <h3>{{ $stats['bookings_total'] ?? 0 }}</h3>
                  <p>Total Bookings</p>
                  <small>
                    Active: {{ $stats['bookings_active'] ?? 0 }} |
                    Pending: {{ $stats['bookings_pending'] ?? 0 }}
                  </small>
                </div>
                <div class="icon"><i class="ion ion-calendar"></i></div>
                <a href="{{ route('bookings.index') }}" class="small-box-footer">
                  More info <i class="fas fa-arrow-circle-right"></i>
                </a>
              </div>
            </div>

            <!-- Withdrawals -->
            <div class="col-lg-6 col-6">
              <div class="small-box bg-danger">
                <div class="inner">
                  <h3>{{ $stats['withdrawals_total'] ?? 0 }}</h3>
                  <p>Total Withdrawals</p>
                  <small>
                    Pending: {{ $stats['withdrawals_pending'] ?? 0 }} |
                    Approved: {{ $stats['withdrawals_approved'] ?? 0 }}
                  </small>
                </div>
                <div class="icon"><i class="ion ion-card"></i></div>
                <a href="{{ route('withdrawals.index') }}" class="small-box-footer">
                  More info <i class="fas fa-arrow-circle-right"></i>
                </a>
              </div>
            </div>

            <!-- Tickets -->
            <div class="col-lg-6 col-6">
              <div class="small-box bg-primary">
                <div class="inner">
                  <h3>{{ $stats['tickets_total'] ?? 0 }}</h3>
                  <p>Tickets</p>
                  <small>
                    Open: {{ $stats['tickets_active'] ?? 0 }} |
                    Closed: {{ $stats['tickets_closed'] ?? 0 }}
                  </small>
                </div>
                <div class="icon"><i class="ion ion-help-buoy"></i></div>
                <a href="{{ route('admin.tickets.index') }}" class="small-box-footer">
                  More info <i class="fas fa-arrow-circle-right"></i>
                </a>
              </div>
            </div>

            <!-- Coupons -->
            <div class="col-lg-6 col-6">
              <div class="small-box bg-secondary">
                <div class="inner">
                  <h3>{{ $stats['coupons_total'] ?? 0 }}</h3>
                  <p>Coupons</p>
                  <small>
                    Active: {{ $stats['coupons_active'] ?? 0 }} |
                    Used: {{ $stats['coupons_used'] ?? 0 }}
                  </small>
                </div>
                <div class="icon"><i class="ion ion-pricetag"></i></div>
                <a href="{{ route('coupons.index') }}" class="small-box-footer">
                  More info <i class="fas fa-arrow-circle-right"></i>
                </a>
              </div>
            </div>

          </div>
        </div>

        <!-- RIGHT SIDE : BIG CALENDAR -->
        <div class="col-lg-6 col-12">
          <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h3 class="card-title mb-0">Booking Calendar</h3>
              <i class="far fa-calendar-alt"></i>
            </div>

            <div class="card-body">
              <p class="text-muted mb-1">Select date to filter bookings</p>
              <small id="calendar-selected" class="text-muted">Pick a date</small>

              <div id="dashboardBigCalendar" style="margin-top:10px;"></div>
            </div>

            <div class="card-footer text-right">
              <a href="{{ route('bookings.index') }}">
                Show all <i class="fas fa-arrow-circle-right"></i>
              </a>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>
</div>

<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>

<style>
/* Disable drag / resize arrows */
.fc-event-resizer,
.fc-event-resizer-start,
.fc-event-resizer-end {
    display: none !important;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function () {

  const info = document.getElementById('calendar-selected');

  const calendar = new FullCalendar.Calendar(
    document.getElementById('dashboardBigCalendar'),
    {
      initialView: 'dayGridMonth',
      height: 350,

      headerToolbar: {
        left: 'prev,next',
        center: 'title',
        right: ''
      },

      // 🔥 LOAD ADMIN BOOKINGS
      events: "{{ route('admin.dashboard.calendar.bookings') }}",

      editable: false,

      eventTimeFormat: {
        hour: '2-digit',
        minute: '2-digit',
        hour12: false
      },

      // Click EMPTY DATE → bookings list
      dateClick: function(infoObj) {
        const url = new URL("{{ route('bookings.index') }}", window.location.origin);
        url.searchParams.set('filterKey', 'date');
        url.searchParams.set('filterValue', infoObj.dateStr);
        window.location.href = url.toString();
      },

      // Click BOOKING → bookings list (same date)
      eventClick: function(infoObj) {
        const date = infoObj.event.startStr.substring(0, 10);
        const url = new URL("{{ route('bookings.index') }}", window.location.origin);
        url.searchParams.set('filterKey', 'date');
        url.searchParams.set('filterValue', date);
        window.location.href = url.toString();
      }
    }
  );

  calendar.render();

});
</script>