<div class="content-wrapper">

<div class="card">
 <div class="card-header">
    <h3 class="card-title">Extra Services</h3>
    <a href="{{ route('extra-services.create') }}" class="btn btn-success float-right">Add Service</a>
</div>

    <div class="card-body">
        <!-- @if(session('success'))
          <div class="alert alert-success">{{ session('success') }}</div>
        @endif -->

        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Price</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
           <tbody>
    @foreach($services as $service)
    <tr>
        <td>{{ $loop->iteration }}</td> <!-- Serial number -->
        <td>{{ $service->name }}</td>
        <td>
          <div>{{ isset($service->formatted_price) ? $service->formatted_price : '₹'.number_format($service->price,2) }}</div>
          <small class="text-muted">{{ isset($service->price_type_label) ? $service->price_type_label : ( $service->price_type == 'per_day' ? 'Per Day' : 'One Time') }}</small>
        </td>
        <td>
          @if($service->status === 'active')
            <span class="badge badge-success">Active</span>
          @else
            <span class="badge badge-secondary">Inactive</span>
          @endif
        </td>
        <td>{{ $service->created_at }}</td>
        <td>
            <a href="{{ route('extra-services.edit', $service->id) }}" class="btn btn-primary btn-sm">Edit</a>

            <form action="{{ route('extra-services.destroy', $service->id) }}" method="POST" style="display:inline;">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger btn-sm"
                    onclick="return confirm('Are you sure you want to deactivate this service?')">Deactivate</button>
            </form>
        </td>
    </tr>
    @endforeach
</tbody>
        </table>
    </div>
</div>

<script>
$(function () {
    $("#example1").DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
</script>
</div>
