<div class="content-wrapper">
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12"><!-- full width -->
        <div class="card card-primary">

          <div class="card-header">
            <h3 class="card-title">Commission Settings</h3>
          </div>

          <form method="POST" action="{{ route('admin.settings.save') }}">
            @csrf

            <div class="card-body">

              @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
              @endif

              @if($errors->any())
                <div class="alert alert-danger">
                  <ul class="mb-0">
                    @foreach($errors->all() as $error)
                      <li>{{ $error }}</li>
                    @endforeach
                  </ul>
                </div>
              @endif

              {{-- Referral Income --}}
              <div class="form-group">
                <label>Referral Income</label>
                <div class="input-group">
                  <input type="number" step="0.01"
                         name="referral_income"
                         class="form-control"
                         placeholder="Enter referral income"
                         value="{{ old('referral_income', $settings['referral_income'] ?? 0) }}">
                  <div class="input-group-append">
                    <span class="input-group-text">%</span>
                  </div>
                </div>
              </div>

              {{-- First Booking Income --}}
              <div class="form-group">
                <label>First Booking Income</label>
                <div class="input-group">
                  <input type="number" step="0.01"
                         name="first_booking_income"
                         class="form-control"
                         placeholder="Enter first booking income"
                         value="{{ old('first_booking_income', $settings['first_booking_income'] ?? 0) }}">
                  <div class="input-group-append">
                    <span class="input-group-text">%</span>
                  </div>
                </div>
              </div>

              {{-- Admin Commission --}}
              <div class="form-group">
                <label>Admin Commission</label>
                <div class="input-group">
                  <input type="number" step="0.01"
                         name="admin_commission"
                         class="form-control"
                         placeholder="Enter admin commission"
                         value="{{ old('admin_commission', $settings['admin_commission'] ?? 0) }}">
                  <div class="input-group-append">
                    <span class="input-group-text">%</span>
                  </div>
                </div>
              </div>

            </div>

            <div class="card-footer">
              <button type="submit" class="btn btn-primary">
                Save Settings
              </button>
            </div>

          </form>

        </div>
      </div>
    </div>
  </div>
</section>
</div>
