{{-- resources/views/tickets/view.blade.php --}}
<div class="content-wrapper">
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12"><!-- full width -->
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title">Ticket #{{ $ticket->id }} - {{ $ticket->subject }}</h3>
          </div>

          <div class="card-body">
            @if(session('success')) <div class="alert alert-success">{{ session('success') }}</div> @endif

            <div class="mb-3">
              <strong>User ID:</strong> {{ $ticket->user_id ?? '-' }}<br>
              <strong>Email:</strong> {{ $ticket->email }}<br>
              <strong>Created:</strong> {{ \Carbon\Carbon::parse($ticket->created_at)->format('Y-m-d H:i') }}<br>
              <strong>Status:</strong>
              @if($ticket->status == 'active') <span class="badge badge-success">Active</span>
              @else <span class="badge badge-secondary">Closed</span> @endif
            </div>

            <div class="card card-outline card-default">
              <div class="card-header"><h5 class="card-title">Issue</h5></div>
              <div class="card-body">
                <pre style="white-space:pre-wrap">{{ $ticket->issue }}</pre>
              </div>
            </div>

            <hr>

            <form method="POST" action="{{ route('admin.tickets.update', $ticket->id) }}">
              @csrf
              <div class="form-group">
                <label for="status">Status</label>
                <select name="status" class="form-control" id="status">
                  <option value="active" {{ $ticket->status=='active'?'selected':'' }}>Active</option>
                  <option value="closed" {{ $ticket->status=='closed'?'selected':'' }}>Closed</option>
                </select>
                @error('status') <span class="text-danger">{{ $message }}</span> @enderror
              </div>

              <div class="form-group">
                <label for="admin_reply">Admin Note (optional)</label>
                <textarea name="admin_reply" id="admin_reply" class="form-control" rows="4" placeholder="Write internal note or reply (not saved in DB in this version)"></textarea>
              </div>

              <div class="card-footer">
                <a href="{{ route('admin.tickets.index') }}" class="btn btn-secondary">Back</a>
                <button type="submit" class="btn btn-primary">Update Ticket</button>
              </div>
            </form>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>
</div>
