{{-- resources/views/tickets/listing.blade.php --}}
<div class="content-wrapper">
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12"><!-- full width -->
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title">Support Tickets</h3>
          </div>

          <div class="card-body">
            @if(session('success')) <div class="alert alert-success">{{ session('success') }}</div> @endif
            @if(session('error'))   <div class="alert alert-danger">{{ session('error') }}</div>  @endif

            <table class="table table-bordered table-striped">
              <thead>
                <tr>
                  <th>#</th> {{-- serial number (1,2,3...) --}}
                  <th>Email</th>
                  <th>Subject</th>
                  <th>Status</th>
                  <th>Created</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
                @forelse($tickets as $t)
                <tr>
                  <td>{{ $loop->iteration }}</td> {{-- Blade's loop iteration gives serial index --}}
                  <td>{{ $t->email }}</td>
                  <td>{{ \Illuminate\Support\Str::limit($t->subject, 60) }}</td>
                  <td>
                    @if($t->status == 'active') <span class="badge badge-success">Active</span>
                    @else <span class="badge badge-secondary">Closed</span> @endif
                  </td>
                  <td>{{ $t->created_at ? \Carbon\Carbon::parse($t->created_at)->format('Y-m-d H:i') : '-' }}</td>
                  <td>
                    <a href="{{ route('admin.tickets.show', $t->id) }}" class="btn btn-sm btn-primary w-100">View</a>
                  </td>
                </tr>
                @empty
                <tr><td colspan="6" class="text-center">No tickets found</td></tr>
                @endforelse
              </tbody>
            </table>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>
</div>
