<div class="content-wrapper">
  <div class="card">
    <div class="card-header">
      <h3 class="card-title">{{ isset($locality) ? 'Edit Locality' : 'Add Locality' }}</h3>
    </div>
    <div class="card-body">
      <form method="POST" action="{{ isset($locality) ? route('localities.update', $locality->id) : route('localities.store') }}">
        @csrf
        @if(isset($locality)) @method('PUT') @endif

        <div class="form-group">
          <label for="city_id">Select City</label>
          <select name="city_id" class="form-control" required>
            <option value="">-- Select City --</option>
            @foreach($cities as $city)
              <option value="{{ $city->id }}" {{ isset($locality) && $locality->city_id == $city->id ? 'selected' : '' }}>
                {{ $city->name }} ({{ $city->state_name }})
              </option>
            @endforeach
          </select>
        </div>

        <div class="form-group">
          <label for="name">Locality Name</label>
          <input type="text" name="name" class="form-control" value="{{ $locality->name ?? '' }}" required>
        </div>

        <div class="form-group">
          <label for="status">Status</label>
          <select name="status" class="form-control" required>
            <option value="active" {{ isset($locality) && $locality->status == 'active' ? 'selected' : '' }}>Active</option>
            <option value="inactive" {{ isset($locality) && $locality->status == 'inactive' ? 'selected' : '' }}>Inactive</option>
          </select>
        </div>

        <button type="submit" class="btn btn-success">{{ isset($locality) ? 'Update' : 'Create' }}</button>
      </form>
    </div>
  </div>
</div>
