<div class="content-wrapper">
  <div class="card">
    <div class="card-header">
      <h3 class="card-title">Localities List</h3>
      <a href="{{ route('localities.create') }}" class="btn btn-success float-right">Add Locality</a>
    </div>
    <div class="card-body">
      <table id="example1" class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>#</th>
            <th>Locality Name</th>
            <th>City</th>
            <th>State</th>
            <th>Status</th>
            <th>Created At</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          @foreach($localities as $locality)
          <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{ $locality->name }}</td>
            <td>{{ $locality->city_name }}</td>
            <td>{{ $locality->state_name }}</td>
            <td>{{ $locality->status }}</td>
            <td>{{ $locality->created_at }}</td>
            <td>
              <a href="{{ route('localities.edit', $locality->id) }}" class="btn btn-primary btn-sm">Edit</a>
              <form action="{{ route('localities.destroy', $locality->id) }}" method="POST" style="display:inline;">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger btn-sm"
                  onclick="return confirm('Are you sure you want to deactivate this locality?')">Deactivate</button>
              </form>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>
