@php
    // ONLY pending is locked
    $isPending = $kyc && $kyc->status === 'pending';
@endphp

<div class="main-content">
  <div class="page-content">
    <div class="container-fluid">

      {{-- SUCCESS --}}
      @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
      @endif

      {{-- ERROR --}}
      @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
      @endif

      {{-- STATUS ALERTS --}}
      @if($kyc && $kyc->status === 'pending')
        <div class="alert alert-warning">
          Your KYC is under review. Editing is disabled until verification completes.
        </div>
      @elseif($kyc && $kyc->status === 'approved')
        <div class="alert alert-success">
          Your KYC is approved. You may update details if required.
        </div>
      @elseif($kyc && $kyc->status === 'rejected')
        <div class="alert alert-danger">
          Your KYC was rejected. Please correct details and re-submit.
        </div>
      @endif

      {{-- VALIDATION ERRORS --}}
      @if($errors->any())
        <div class="alert alert-danger">
          <ul class="mb-0">
            @foreach($errors->all() as $err)
              <li>{{ $err }}</li>
            @endforeach
          </ul>
        </div>
      @endif

      <div class="card">
        <div class="card-header">
          <h4 class="card-title mb-0">Merchant KYC</h4>
        </div>

        <div class="card-body">
          <form class="row g-3 needs-validation"
                method="POST"
                action="{{ route('merchant.kyc.store') }}"
                enctype="multipart/form-data"
                novalidate>
            @csrf

            {{-- DOCUMENT TYPE --}}
            <div class="col-md-4">
              <label class="form-label">Document Type</label>
              <select name="document_type"
                      id="document_type"
                      class="form-select"
                      {{ $isPending ? 'disabled' : '' }}
                      required>
                <option value="" disabled>Choose...</option>
                <option value="aadhaar"
                  {{ old('document_type', $kyc->document_type ?? '') === 'aadhaar' ? 'selected' : '' }}>
                  Aadhaar Card
                </option>
                <option value="other"
                  {{ old('document_type', $kyc->document_type ?? '') === 'other' ? 'selected' : '' }}>
                  Other Document
                </option>
              </select>
            </div>

            {{-- NAME --}}
            <div class="col-md-4">
              <label class="form-label">Name</label>
              <input type="text"
                     name="name"
                     class="form-control"
                     value="{{ old('name', $kyc->name ?? '') }}"
                     {{ $isPending ? 'readonly' : '' }}
                     required>
            </div>

            {{-- DOB --}}
            <div class="col-md-4">
              <label class="form-label">Date of Birth</label>
              <input type="date"
                     name="dob"
                     class="form-control"
                     value="{{ old('dob', $kyc->dob ?? '') }}"
                     {{ $isPending ? 'readonly' : '' }}
                     required>
            </div>

            {{-- ADDRESS --}}
            <div class="col-md-12">
              <label class="form-label">Address</label>
              <textarea name="address"
                        class="form-control"
                        rows="2"
                        {{ $isPending ? 'readonly' : '' }}
                        required>{{ old('address', $kyc->address ?? '') }}</textarea>
            </div>

            {{-- FRONT IMAGE --}}
            <div class="col-md-4">
              <label class="form-label">Document Front Image</label>

              @if($kyc && $kyc->front_image)
                <div class="mb-1">
                  <a href="{{ asset('storage/kyc/'.$kyc->front_image) }}" target="_blank">
                    View current
                  </a>
                </div>
              @endif

              @if(!$isPending)
                <input type="file"
                       name="front_image"
                       class="form-control"
                       accept="image/*"
                       {{ $kyc ? '' : 'required' }}>
              @endif
            </div>

            {{-- BACK IMAGE --}}
            <div class="col-md-4 {{ (old('document_type', $kyc->document_type ?? '') === 'aadhaar') ? '' : 'd-none' }}"
                 id="backImageBox">

              <label class="form-label">Document Back Image</label>

              @if($kyc && $kyc->back_image)
                <div class="mb-1">
                  <a href="{{ asset('storage/kyc/'.$kyc->back_image) }}" target="_blank">
                    View current
                  </a>
                </div>
              @endif

              @if(!$isPending)
                <input type="file"
                       name="back_image"
                       class="form-control"
                       accept="image/*">
              @endif
            </div>

            {{-- BUTTONS --}}
            <div class="col-12">
              @if(!$isPending)
                <button class="btn btn-primary">
                  {{ $kyc ? 'Update KYC' : 'Submit KYC' }}
                </button>
              @endif

              <a href="{{ route('merchant.index') }}" class="btn btn-secondary">
                Back
              </a>
            </div>

          </form>
        </div>
      </div>

    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const type = document.getElementById('document_type');
    const backBox = document.getElementById('backImageBox');

    if (!type) return;

    function toggleBack() {
        backBox.classList.add('d-none');
        if (type.value === 'aadhaar') {
            backBox.classList.remove('d-none');
        }
    }

    toggleBack();
    type.addEventListener('change', toggleBack);
});
</script>
