{{-- resources/views/merchant_panel/my_bookings.blade.php --}}
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">Property Bookings</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                <li class="breadcrumb-item active">Bookings</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="">
                        <div class="card-body">
                            <div class="row mb-3">
                                <div class="col-sm">
                                    <div class="d-flex gap-2">
                                        <button type="button" class="btn btn-success" onclick="location.reload();">
                                            <i class="ri-refresh-line align-bottom me-1"></i> Refresh
                                        </button>
                                        <a href="{{ route('merchant.properties.create') }}" class="btn btn-primary">
                                            <i class="ri-add-line align-bottom me-1"></i> Add Property
                                        </a>
                                    </div>
                                </div>
                                <div class="col-sm-auto">
                                    <div class="search-box ms-2">
                                        <input type="text" class="form-control" id="bookingSearch" placeholder="Search bookings by property/user...">
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive table-card mt-3 mb-1">
                                <table class="table align-middle table-nowrap" id="bookingsTable">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Booking</th>
                                            <th>Property</th>
                                            <th>User</th>
                                            <th>Location</th>
                                            <th>Booking Time</th>
                                            <th>Payment</th>
                                            <th>Status</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($bookings as $b)
                                            @php
                                                // humanize created_at safely
                                                try {
                                                    $created = \Carbon\Carbon::parse($b->created_at)->format('M d, Y h:i A');
                                                    $createdHuman = \Carbon\Carbon::parse($b->created_at)->diffForHumans();
                                                } catch (\Exception $e) {
                                                    $created = $b->created_at;
                                                    $createdHuman = $b->created_at;
                                                }

                                                $bookingRange = isset($b->check_in_time, $b->check_out_time)
                                                    ? \Carbon\Carbon::parse($b->check_in_time)->format('d M H:i') . ' → ' . \Carbon\Carbon::parse($b->check_out_time)->format('d M H:i')
                                                    : '';
                                            @endphp

                                            <tr>
<td>
    <strong>
        {{ ($bookings->currentPage() - 1) * $bookings->perPage() + $loop->iteration }}
    </strong>
    
    <!-- <small class="text-muted">{{ ucfirst($b->booking_status ?? '') }}</small> -->
</td>

                                                <td>
                                                    <strong>{{ $b->property_name ?? '—' }}</strong><br>
                                                    <small class="text-muted">{{ $b->address ?? '' }}</small>
                                                </td>

                                                <td>
                                                    <strong>{{ $b->user_name ?? 'Guest' }}</strong><br>
                                                    <small class="text-muted">{{ $b->user_email ?? '' }}</small>
                                                </td>

                                                <td>
                                                    {{ $b->locality_name ?? '' }}<br>
                                                    <small class="text-muted">{{ $b->city_name ?? '' }}, {{ $b->state_name ?? '' }}</small>
                                                </td>

                                                <td>
                                                    {{ $bookingRange }}<br>
<small class="text-muted">{{ $b->hours ?? 0 }} hrs</small>                                                </td>

                                                <td>
<strong>{{ number_format((float)($b->amount ?? 0), 2) }}</strong><br>
                                                    <small class="text-muted">{{ $b->payment_method ?? '' }} • {{ $b->payment_status ?? '' }}</small>
                                                </td>

                                                <td>
                                                    @php
                                                        $cfg = [
                                                            'pending' => ['class'=>'warning','text'=>'Pending'],
                                                            'approved'=> ['class'=>'info','text'=>'Approved'],
                                                            'rejected'=> ['class'=>'danger','text'=>'Rejected'],
                                                            'completed'=> ['class'=>'success','text'=>'Completed']
                                                        ];
                                                        $st = $cfg[$b->booking_status] ?? ['class'=>'secondary','text'=>ucfirst($b->booking_status ?? 'unknown')];
                                                    @endphp
                                                    <span class="badge bg-{{ $st['class'] }}-subtle text-{{ $st['class'] }}">{{ $st['text'] }}</span>
                                                </td>

                                                <td>
                                                    <small class="text-muted">{{ $created }}</small><br>
                                                    <small class="text-muted">{{ $createdHuman }}</small>
                                                </td>

                                                <td>
                                                    <div class="d-flex gap-2">
                                                        <button class="btn btn-sm btn-info view-booking" data-booking='@json($b)'>
                                                            <i class="ri-eye-line"></i> Details
                                                        </button>
                                                        @if(isset($b->booking_status) && $b->booking_status == 'pending')
                                                            <a href="javascript:void(0)" class="btn btn-sm btn-success approve-booking" data-id="{{ $b->id }}">Approve</a>
                                                            <a href="javascript:void(0)" class="btn btn-sm btn-danger reject-booking" data-id="{{ $b->id }}">Reject</a>
                                                        @endif
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="9" class="text-center py-4">
                                                    <h5 class="mt-2">No bookings found</h5>
                                                    <p class="text-muted mb-0">No one has booked your hideouts yet.</p>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            {{-- pagination (server side) --}}
                            <div class="d-flex justify-content-end">
                                {{ $bookings->links() }}
                            </div>

                        </div>
                        <!-- end card body -->
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- Booking Details Modal -->
<div class="modal fade" id="bookingDetailsModal" tabindex="-1" aria-labelledby="bookingDetailsLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="bookingDetailsLabel">Booking Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="bookingDetailsBody">
        <!-- filled by JS -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // View details
    document.querySelectorAll('.view-booking').forEach(btn => {
        btn.addEventListener('click', function() {
            const b = JSON.parse(this.getAttribute('data-booking'));
            const body = document.getElementById('bookingDetailsBody');

            const html = `
                <div class="row">
                    <div class="col-md-6">
                        <h6>Booking</h6>
                        <table class="table table-sm table-borderless">
                            <tr><td><strong>ID:</strong></td><td>#${String(b.id).padStart(6,'0')}</td></tr>
                            <tr><td><strong>Status:</strong></td><td>${b.booking_status ?? ''}</td></tr>
                            <tr><td><strong>Amount:</strong></td><td>${parseFloat(b.amount || 0).toFixed(2)} ${b.payment_method ?? ''}</td></tr>
                            <tr><td><strong>Payment Status:</strong></td><td>${b.payment_status ?? ''}</td></tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6>User</h6>
                        <table class="table table-sm table-borderless">
                            <tr><td><strong>Name:</strong></td><td>${b.user_name ?? ''}</td></tr>
                            <tr><td><strong>Email:</strong></td><td>${b.user_email ?? ''}</td></tr>
                        </table>
                    </div>
                </div>

                <div class="row mt-2">
                    <div class="col-12">
                        <h6>Property</h6>
                        <p><strong>${b.property_name ?? ''}</strong><br><small class="text-muted">${b.locality_name ?? ''}, ${b.city_name ?? ''}, ${b.state_name ?? ''}</small></p>
                        <p><strong>Address:</strong> ${b.address ?? ''}</p>
                    </div>
                </div>

                <div class="row mt-2">
                    <div class="col-12">
                        <h6>Timing</h6>
                        <p><strong>Check-in:</strong> ${b.check_in_time ?? ''} <br> <strong>Check-out:</strong> ${b.check_out_time ?? ''}</p>
                    </div>
                </div>
            `;

            body.innerHTML = html;
            new bootstrap.Modal(document.getElementById('bookingDetailsModal')).show();
        });
    });

    // (Optional) simple approve/reject stubs - wire to your endpoints if you add them
    document.querySelectorAll('.approve-booking').forEach(btn => {
        btn.addEventListener('click', function() {
            if (!confirm('Approve this booking?')) return;
            const id = this.dataset.id;
            // POST /merchant/properties/bookings/{id}/approve (implement on server)
            fetch(`/merchant/properties/bookings/${id}/approve`, {
                method: 'POST',
                headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Content-Type':'application/json'},
                body: JSON.stringify({})
            }).then(r=>r.json()).then(json=>{
                if (json.success) location.reload(); else alert(json.message || 'Failed');
            }).catch(e=>{ console.error(e); alert('Error'); });
        });
    });

    document.querySelectorAll('.reject-booking').forEach(btn => {
        btn.addEventListener('click', function() {
            if (!confirm('Reject this booking?')) return;
            const id = this.dataset.id;
            fetch(`/merchant/properties/bookings/${id}/reject`, {
                method: 'POST',
                headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Content-Type':'application/json'},
                body: JSON.stringify({})
            }).then(r=>r.json()).then(json=>{
                if (json.success) location.reload(); else alert(json.message || 'Failed');
            }).catch(e=>{ console.error(e); alert('Error'); });
        });
    });

    // quick search (client side; optional)
    const searchInput = document.getElementById('bookingSearch');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            const q = this.value.toLowerCase().trim();
            document.querySelectorAll('#bookingsTable tbody tr').forEach(tr => {
                const text = tr.textContent.toLowerCase();
                tr.style.display = text.indexOf(q) === -1 ? 'none' : '';
            });
        });
    }
});
</script>

<style>
/* small styling tweaks */
.table-card { background: #fff; padding: 12px; border-radius: 6px; }
</style>
