<div class="main-content">
  <div class="page-content">
    <div class="container-fluid">

      @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
      @endif
      @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
      @endif

      <div class="card">
        <div class="card-header">
          <h4 class="card-title mb-0">Withdrawal Request</h4>
        </div>

        <div class="card-body">
          <p>Your current wallet balance: <strong>₹{{ number_format($balance,2) }}</strong></p>

          {{-- Eligibility message --}}
          @if($canWithdraw)
            <div class="alert alert-success">
              Your balance meets the minimum withdrawal threshold of <strong>₹{{ number_format($minWithdrawalBalance,2) }}</strong>. You can request a withdrawal.
            </div>
          @else
            <div class="alert alert-warning">
              Minimum balance of <strong>₹{{ number_format($minWithdrawalBalance,2) }}</strong> is required to request a withdrawal.
              You need <strong>₹{{ number_format(max(0, $minWithdrawalBalance - $balance), 2) }}</strong> more to become eligible.
            </div>
          @endif

          <form id="withdrawalForm" method="POST" action="{{ route('merchant.withdraw.store') }}" class="row g-3 needs-validation" novalidate>
            @csrf

            <div class="col-md-6">
              <label class="form-label">Select Bank Account</label>
              <select name="bank_account_id" class="form-select" required>
                <option value="" selected disabled>Choose account...</option>

                @forelse($banks as $b)
                  <option value="{{ $b->id }}">
                    {{ $b->bank_name }} — {{ $b->branch_name ?? '-' }} • A/c ****{{ substr($b->account_number, -4) }}
                  </option>
                @empty
                  <option value="" disabled>No active bank accounts found. Add bank first.</option>
                @endforelse
              </select>
              <div class="invalid-feedback">Please select a bank account.</div>
            </div>

            <div class="col-md-6">
              <label class="form-label">Amount</label>
              <input type="number"
                     name="amount"
                     id="withdrawAmount"
                     class="form-control"
                     min="1"
                     step="0.01"
                     max="{{ number_format($balance, 2, '.', '') }}"
                     required
                     @if(!$canWithdraw) disabled @endif>
              <div class="form-text">You can withdraw up to <strong>₹{{ number_format($balance,2) }}</strong>.</div>
              <div class="invalid-feedback">Enter a valid amount (min ₹1, max your balance).</div>
            </div>

            <div class="col-12">
              @if($canWithdraw)
                <button id="withdrawBtn" type="submit" class="btn btn-primary">Request Withdrawal</button>
              @else
                <button id="withdrawBtn" type="button" class="btn btn-secondary" disabled>Request Withdrawal</button>
              @endif

              <a href="{{ route('merchant.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
          </form>

        </div>
      </div>

    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  // form validation bootstrap style
  const forms = document.querySelectorAll('.needs-validation');
  Array.prototype.slice.call(forms).forEach(function (form) {
    form.addEventListener('submit', function (event) {
      // if the submit button is disabled (client safety), block
      var withdrawBtn = document.getElementById('withdrawBtn');
      if (withdrawBtn && withdrawBtn.disabled) {
        event.preventDefault();
        event.stopPropagation();
        return;
      }

      if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
      } else {
        // Extra client-side check: amount must be <= balance
        var amtInput = document.getElementById('withdrawAmount');
        if (amtInput && parseFloat(amtInput.value) > parseFloat(amtInput.max || 0)) {
          event.preventDefault();
          event.stopPropagation();
          amtInput.classList.add('is-invalid');
          alert('Amount cannot be greater than your current balance.');
        }
      }
      form.classList.add('was-validated');
    }, false);
  });
});
</script>
