<div class="main-content">
  <div class="page-content">
    <div class="container-fluid">

      @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
      @endif
      @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
      @endif

      <div class="d-flex align-items-center justify-content-between mb-3">
        <h4 class="mb-0">Withdrawal History</h4>
        <a href="{{ route('merchant.withdraw.form') }}" class="btn btn-primary">New Withdrawal</a>
      </div>

      @if($withdrawals->count() === 0)
        <div class="alert alert-info">No withdrawal requests found.</div>
      @else
        <div class="card">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-striped table-sm">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Amount</th>
                    <th>Bank</th>
                    <th>Account (last4)</th>
                    <th>Status</th>
                    <th>Requested At</th>
                    <th>Admin Note</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($withdrawals as $w)
                    <tr>
                          <td>{{ $loop->iteration }}</td>
                      <td>{{ number_format($w->amount,2) }}</td>
                      <td>{{ $w->bank_name ?? '-' }}</td>
                      <td>****{{ $w->name_in_bank ? substr($w->name_in_bank, -4) : ( $w->bank_name ? 'xxxx' : '') }}</td>
                      <td>
                        @if($w->status === 'pending')
                          <span class="badge bg-warning">Pending</span>
                        @elseif($w->status === 'approved')
                          <span class="badge bg-success">Approved</span>
                        @else
                          <span class="badge bg-danger">Rejected</span>
                        @endif
                      </td>
                      <td>{{ $w->created_at }}</td>
                      <td>{{ $w->admin_note }}</td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      @endif

    </div>
  </div>
</div>


