{{-- resources/views/properties/listing.blade.php --}}
@php
    // Base image path from config/app.php or .env
    $propertiesBase = config('app.properties_image_path') ?: env('PROPERTIES_IMAGE_PATH', null);
    $propertiesBase = $propertiesBase ? rtrim($propertiesBase, '/') : null;
@endphp

<div class="content-wrapper">

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Properties</h3>
            <a href="{{ route('properties.create') }}" class="btn btn-success float-right">Add Property</a>
        </div>

        <div class="card-body">
            {{-- Flash messages --}}
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">&times;</button>
                </div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">&times;</button>
                </div>
            @endif

            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Place Name</th>
                        <th>Location</th>
                        <th>Price</th>
                        <th>Images</th>
                        <th>Status</th>
                        <th>Created At</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($properties as $property)
                    <tr>
                        <td>{{ $loop->iteration }}</td>

                        <td>{{ $property->name }}</td>

                        <td>
                            {{ $property->state_name ?? '' }} / {{ $property->city_name ?? '' }}
                            @if(!empty($property->locality_name))
                                <br><small>{{ $property->locality_name }}</small>
                            @endif
                            @if(!empty($property->address))
                                <div><small>{{ $property->address }}</small></div>
                            @endif
                        </td>

                        <td>
                            ₹{{ number_format($property->price ?? 0, 2) }}
                            <br>
                            <small>{{ ucfirst(str_replace('_',' ',$property->price_unit ?? '')) }}</small>
                        </td>

                     

                        <td>
                            @php
                                $imgs = \DB::table('property_images')
                                    ->where('property_id', $property->id)
                                    ->orderBy('id')
                                    ->limit(3)
                                    ->get();
                            @endphp

                            @if($imgs->count())
                                @foreach($imgs as $img)
                                    @php
                                        // If base provided, assume images stored at {BASE}/{property_id}/{filename}
                                        if ($propertiesBase) {
                                            $imgUrl = $propertiesBase . '/'  . ltrim($img->filename, '/');
                                        } else {
                                            // fallback to previous path you used
                                            $imgUrl = asset('storage/uploads/properties/' . $property->id . '/' . ltrim($img->filename, '/'));
                                        }
                                    @endphp

                                    <img src="{{ $imgUrl }}" alt="img" style="width:60px;height:40px;object-fit:cover;margin-right:4px;border:1px solid #ddd" />
                                @endforeach
                            @else
                                <small class="text-muted">No images</small>
                            @endif
                        </td>

                        <td>
                            @if($property->status === 'active')
                                <span class="badge badge-success">Active</span>
                            @elseif($property->status === 'pending')
                                <span class="badge badge-warning">Pending</span>
                            @elseif($property->status === 'reject' || $property->status === 'rejected')
                                <span class="badge badge-danger">Rejected</span>
                            @else
                                <span class="badge badge-secondary">{{ ucfirst($property->status) }}</span>
                            @endif
                        </td>

                        <td>{{ $property->created_at }}</td>

                       @php
    // build visible slug: slugified name + '-' + id
    $visibleSlug = \Illuminate\Support\Str::slug($property->name ?? 'property-'.$property->id) . '-' . $property->id;
@endphp

<td>
    <div class="d-flex flex-column gap-1">
        {{-- View button (always shown) --}}
        <a href="{{ route('properties.show', $visibleSlug) }}" class="btn btn-info btn-sm" title="View full ad">View</a>

        @if($property->status === 'pending')
            <form action="{{ route('admin.properties.approve', $visibleSlug) }}" method="POST">
                @csrf
                <button type="submit" class="btn btn-sm btn-primary mt-2 w-100"
                    onclick="return confirm('Approve this property?')">Approve</button>
            </form>

            <form action="{{ route('admin.properties.reject', $visibleSlug) }}" method="POST">
                @csrf
                <button type="submit" class="btn btn-sm btn-danger mt-2 w-100"
                    onclick="return confirm('Reject this property?')">Reject</button>
            </form>
        @else
            <a href="{{ route('properties.edit', $visibleSlug) }}" class="btn btn-primary btn-sm mt-2">Edit</a>

            <form action="{{ route('properties.destroy', $visibleSlug) }}" method="POST">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger btn-sm mt-2"
                    onclick="return confirm('Are you sure you want to deactivate this property?')">Deactivate</button>
            </form>
        @endif
    </div>
</td>


                    </tr>
                @endforeach
                </tbody>
            </table>

        </div>
    </div>

</div>

{{-- DataTables init --}}
<script>
    $(function () {
        $("#example1").DataTable({
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    });
</script>
