<div class="content-wrapper">

<div class="card">
<div class="card-header">
    <h3 class="card-title">Pending Bank Accounts</h3>
</div>

<div class="card-body">

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<table id="bankTable" class="table table-bordered table-striped">
<thead>
<tr>
    <th>#</th>
    <th>Merchant</th>
    <th>Bank</th>
    <th>Account</th>
    <th>IFSC</th>
    <th>Requested</th>
    <th>Action</th>
</tr>
</thead>

<tbody>
@forelse($banks as $b)
<tr>
    <td>{{ $loop->iteration }}</td>

    <td>
        <strong>{{ $b->merchant_name }}</strong><br>
        <small class="text-muted">{{ $b->merchant_email }}</small>
    </td>

    <td>{{ $b->bank_name }}</td>

    <td>
        {{ $b->name_in_bank }}<br>
        <small class="text-muted">
            ****{{ substr($b->account_number, -4) }}
        </small>
    </td>

    <td>{{ $b->ifsc }}</td>

    <td>{{ $b->created_at }}</td>

    <td>
        <form method="POST"
              action="{{ route('admin.bank.accounts.approve', $b->id) }}"
              style="display:inline">
            @csrf
            <button class="btn btn-success btn-sm"
                onclick="return confirm('Approve this bank account?')">
                Approve
            </button>
        </form>

        <form method="POST"
              action="{{ route('admin.bank.accounts.reject', $b->id) }}"
              style="display:inline">
            @csrf
            <button class="btn btn-danger btn-sm"
                onclick="return confirm('Reject this bank account?')">
                Reject
            </button>
        </form>
    </td>
</tr>
@empty
<tr>
    <td colspan="7" class="text-center text-muted">
        No pending bank accounts found.
    </td>
</tr>
@endforelse
</tbody>
</table>

</div>
</div>

</div>

<script>
$(function () {
    $("#bankTable").DataTable({
        responsive: true,
        lengthChange: false,
        autoWidth: false
    });
});
</script>
