<div class="content-wrapper">

<div class="card">
 <div class="card-header">
    <h3 class="card-title">Merchant KYC</h3>
</div>

<div class="card-body">

@if(session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif

<table id="example1" class="table table-bordered table-striped">
<thead>
<tr>
    <th>#</th>
    <th>Merchant</th>
    <th>Document</th>
    <th>Name</th>
    <th>DOB</th>
    <th>Status</th>
    <th>Submitted</th>
    <th>Action</th>
</tr>
</thead>

<tbody>
@foreach($kycs as $k)
<tr>
    <td>{{ $loop->iteration }}</td>

    <td>
        <strong>{{ $k->merchant_name }}</strong><br>
        <small>{{ $k->merchant_email }}</small>
    </td>

    <td>{{ ucfirst($k->document_type) }}</td>
    <td>{{ $k->name }}</td>
    <td>{{ $k->dob }}</td>

    <td>
        @if($k->status == 'pending')
            <span class="badge badge-warning">Pending</span>
        @elseif($k->status == 'approved')
            <span class="badge badge-success">Approved</span>
        @else
            <span class="badge badge-danger">Rejected</span>
        @endif
    </td>

    <td>{{ $k->created_at }}</td>

    <td>
       
<a href="{{ route('admin.kyc.view', $k->id) }}"
   class="btn btn-info btn-sm">
   View
</a>

        @if($k->status == 'pending')
            <form method="POST" action="{{ route('admin.kyc.approve', $k->id) }}" style="display:inline">
                @csrf
                <button class="btn btn-success btn-sm">Approve</button>
            </form>

            <form method="POST" action="{{ route('admin.kyc.reject', $k->id) }}" style="display:inline">
                @csrf
                <button class="btn btn-danger btn-sm">Reject</button>
            </form>
        @endif
    </td>
</tr>
@endforeach
</tbody>
</table>
</div>
</div>

<!-- VIEW MODAL -->
<div class="modal fade" id="kycModal">
<div class="modal-dialog modal-lg">
<div class="modal-content">
<div class="modal-header">
<h5>KYC Details</h5>
<button class="close" data-dismiss="modal">&times;</button>
</div>

<div class="modal-body">
<p><strong>Name:</strong> <span id="m_name"></span></p>
<p><strong>Document:</strong> <span id="m_doc"></span></p>
<p><strong>Address:</strong> <span id="m_address"></span></p>

<img id="m_front" style="width:100%;margin-bottom:10px">
<img id="m_back" style="width:100%">
</div>
</div>
</div>
</div>

<script>
$('.view-kyc').click(function(){
    $('#m_name').text($(this).data('name'));
    $('#m_doc').text($(this).data('doc'));
    $('#m_address').text($(this).data('address'));
    $('#m_front').attr('src', $(this).data('front'));
    $('#m_back').attr('src', $(this).data('back'));
    $('#kycModal').modal('show');
});
</script>

<script>
$(function () {
  $("#example1").DataTable({
    responsive:true
  });
});
</script>

</div>
