@php
    // Base KYC image path from .env / config
    $kycBase = config('app.kyc_image_path') ?: env('KYC_IMAGE_PATH');
@endphp

<div class="content-wrapper">

<div class="card">
<div class="card-header">
    <h3 class="card-title">Merchant KYC Details</h3>
    <a href="{{ route('admin.kyc.index') }}" class="btn btn-secondary float-right">
        Back
    </a>
</div>

<div class="card-body">

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<table class="table table-bordered">
    <tr>
        <th>Merchant Name</th>
        <td>{{ $kyc->merchant_name }}</td>
    </tr>
    <tr>
        <th>Email</th>
        <td>{{ $kyc->merchant_email }}</td>
    </tr>
    <tr>
        <th>Phone</th>
        <td>{{ $kyc->phone_no }}</td>
    </tr>
    <tr>
        <th>Document Type</th>
        <td>{{ ucfirst($kyc->document_type) }}</td>
    </tr>
    <tr>
        <th>Name on Document</th>
        <td>{{ $kyc->name }}</td>
    </tr>
    <tr>
        <th>Date of Birth</th>
        <td>{{ $kyc->dob }}</td>
    </tr>
    <tr>
        <th>Address</th>
        <td>{{ $kyc->address }}</td>
    </tr>
    <tr>
        <th>Status</th>
        <td>
            @if($kyc->status === 'pending')
                <span class="badge badge-warning">Pending</span>
            @elseif($kyc->status === 'approved')
                <span class="badge badge-success">Approved</span>
            @else
                <span class="badge badge-danger">Rejected</span>
            @endif
        </td>
    </tr>
</table>

<hr>

<h5>Uploaded Documents</h5>

<div class="row">
    <div class="col-md-6">
        <p><strong>Front Image</strong></p>
        <img
            src="{{ rtrim($kycBase, '/') . '/' . ltrim($kyc->front_image, '/') }}"
            class="img-fluid img-thumbnail"
            alt="KYC Front Image">
    </div>

    @if(!empty($kyc->back_image))
    <div class="col-md-6">
        <p><strong>Back Image</strong></p>
        <img
            src="{{ rtrim($kycBase, '/') . '/' . ltrim($kyc->back_image, '/') }}"
            class="img-fluid img-thumbnail"
            alt="KYC Back Image">
    </div>
    @endif
</div>

@if($kyc->status === 'pending')
<hr>
<div class="mt-3">
    <form method="POST" action="{{ route('admin.kyc.approve', $kyc->id) }}" style="display:inline">
        @csrf
        <button class="btn btn-success"
            onclick="return confirm('Approve this KYC?')">
            Approve
        </button>
    </form>

    <form method="POST" action="{{ route('admin.kyc.reject', $kyc->id) }}" style="display:inline">
        @csrf
        <button class="btn btn-danger"
            onclick="return confirm('Reject this KYC?')">
            Reject
        </button>
    </form>
</div>
@endif

</div>
</div>

</div>
