{{-- resources/views/properties/show.blade.php --}}
@php
    use Illuminate\Support\Str;
    // base path for images (S3 or local) — same logic as listing
    $propertiesBase = config('app.properties_image_path') ?: env('PROPERTIES_IMAGE_PATH', null);
    $propertiesBase = $propertiesBase ? rtrim($propertiesBase, '/') : null;

    // visible slug used in links/forms: slugified name + '-' + id
    $visibleSlug = Str::slug($property->name ?? 'property-' . $property->id) . '-' . $property->id;

    // prepare features array (trim, remove empty)
    $featuresArr = [];
    if (!empty($property->features)) {
        $featuresArr = array_filter(array_map('trim', explode(',', $property->features)));
    }
@endphp

<div class="content-wrapper">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">View Property: {{ $property->name }}</h3>
            <div class="btn-group" role="group" aria-label="actions">
                <a href="{{ url()->previous() }}" class="btn btn-light btn-sm">Back</a>

                @if($property->status === 'pending')
                    <form action="{{ route('admin.properties.approve', $visibleSlug) }}" method="POST" style="display:inline-block;">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-primary" onclick="return confirm('Approve this property?')">Approve</button>
                    </form>
                    <form action="{{ route('admin.properties.reject', $visibleSlug) }}" method="POST" style="display:inline-block;">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Reject this property?')">Reject</button>
                    </form>
                @else
                    <a href="{{ route('properties.edit', $visibleSlug) }}" class="btn btn-primary btn-sm">Edit</a>

                    <form action="{{ route('properties.destroy', $visibleSlug) }}" method="POST" style="display:inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to deactivate this property?')">
                            Deactivate
                        </button>
                    </form>
                @endif
            </div>
        </div>

        <div class="card-body">
            <div class="row">
                {{-- Left: images --}}
                <div class="col-md-6">
                    @if(isset($images) && $images->count())
                        <div id="propertyCarousel" class="carousel slide" data-ride="carousel">
                            <div class="carousel-inner">
                                @foreach($images as $idx => $img)
                                    @php
                                        if ($propertiesBase) {
                                            $imgUrl = $propertiesBase . '/' . ltrim($img->filename, '/');
                                        } else {
                                            $imgUrl = asset('storage/uploads/properties/' . $property->id . '/' . ltrim($img->filename, '/'));
                                        }
                                    @endphp

                                    <div class="carousel-item {{ $idx === 0 ? 'active' : '' }}">
                                        <img src="{{ $imgUrl }}" class="d-block w-100" style="height:380px; object-fit:cover;" alt="property-image-{{ $idx }}">
                                    </div>
                                @endforeach
                            </div>

                            @if($images->count() > 1)
                                <a class="carousel-control-prev" href="#propertyCarousel" role="button" data-slide="prev">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="sr-only">Previous</span>
                                </a>
                                <a class="carousel-control-next" href="#propertyCarousel" role="button" data-slide="next">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="sr-only">Next</span>
                                </a>
                            @endif
                        </div>

                        {{-- thumbnails --}}
                        <div class="mt-2 d-flex flex-wrap">
                            @foreach($images as $thumbIndex => $img)
                                @php
                                    if ($propertiesBase) {
                                        $thumb = $propertiesBase . '/' . ltrim($img->filename, '/');
                                    } else {
                                        $thumb = asset('storage/uploads/properties/' . $property->id . '/' . ltrim($img->filename, '/'));
                                    }
                                @endphp
                                <img src="{{ $thumb }}"
                                     class="property-thumb"
                                     data-index="{{ $thumbIndex }}"
                                     style="width:90px;height:66px;object-fit:cover;border:1px solid #ddd;margin-right:8px;margin-bottom:8px;cursor:pointer;" />
                            @endforeach
                        </div>
                    @else
                        <div class="text-center text-muted" style="height:380px;display:flex;align-items:center;justify-content:center;border:1px dashed #ddd;">No images available</div>
                    @endif
                </div>

                {{-- Right: details --}}
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <th style="width:140px">Place Name</th>
                            <td>{{ $property->name }}</td>
                        </tr>

                        <tr>
                            <th>Location</th>
                            <td>
                                {{ $property->state_name ?? '' }} / {{ $property->city_name ?? '' }}
                                @if(!empty($property->locality_id))<div><small>{{ $property->locality_id }}</small></div>@endif
                                @if(!empty($property->address))<div><small>{{ $property->address }}</small></div>@endif
                            </td>
                        </tr>

                        <tr>
                            <th>Price</th>
                            <td>₹{{ number_format($property->price ?? 0, 2) }}
                                <div><small>{{ ucfirst(str_replace('_',' ',$property->price_unit ?? '')) }}</small></div>
                            </td>
                        </tr>

                        {{-- Features row (replaces Bedrooms/Bathrooms/Area) --}}
                        <tr>
                            <th>Features</th>
                            <td>
                                @if(count($featuresArr))
                                    {{ implode(', ', $featuresArr) }}
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                        </tr>

                        <tr>
                            <th>Status</th>
                            <td>
                                @if($property->status === 'active')
                                    <span class="badge badge-success">Active</span>
                                @elseif($property->status === 'pending')
                                    <span class="badge badge-warning">Pending</span>
                                @elseif($property->status === 'reject' || $property->status === 'rejected')
                                    <span class="badge badge-danger">Rejected</span>
                                @else
                                    <span class="badge badge-secondary">{{ ucfirst($property->status) }}</span>
                                @endif
                            </td>
                        </tr>

                        <tr>
                            <th>Created At</th>
                            <td>{{ $property->created_at }}</td>
                        </tr>
                    </table>

                    @if(!empty($property->contact_name) || !empty($property->contact_phone) || !empty($property->contact_email))
                        <div class="mt-3">
                            <h5>Contact</h5>
                            <p class="mb-0"><strong>Name:</strong> {{ $property->contact_name ?? '-' }}</p>
                            <p class="mb-0"><strong>Phone:</strong> {{ $property->contact_phone ?? '-' }}</p>
                            <p class="mb-0"><strong>Email:</strong> {{ $property->contact_email ?? '-' }}</p>
                        </div>
                    @endif

                    {{-- Map iframe (if stored) --}}
                    @if(!empty($property->map_iframe))
                        <div class="mt-3">
                            {!! $property->map_iframe !!}
                        </div>
                    @endif
                </div>
            </div>

            {{-- Description --}}
            @if(!empty($property->description))
                <div class="mt-4">
                    <h5>Description</h5>
                    <p>{!! nl2br(e($property->description)) !!}</p>
                </div>
            @endif
        </div>
    </div>
</div>

{{-- Carousel init (Bootstrap) and thumbnail click handling --}}
<script>
    $(function () {
        $('#propertyCarousel').carousel({ interval: 5000 });

        // thumbnail -> slide
        $('.property-thumb').on('click', function () {
            var idx = parseInt($(this).data('index'), 10);
            $('#propertyCarousel').carousel(idx);
        });
    });
</script>
