<div class="content-wrapper">

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12">
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title">{{ isset($state) ? 'Edit State' : 'Add State' }}</h3>
          </div>
          <form id="quickForm" method="POST" action="{{ isset($state) ? route('states.update', $state->id) : route('states.store') }}">
            @csrf
            @if(isset($state))
                @method('PUT')
            @endif
            <div class="card-body">
              <div class="form-group">
                <label for="name">State Name</label>
                <input type="text" name="name" value="{{ old('name', $state->name ?? '') }}" class="form-control" id="name" placeholder="Enter State Name">
                @error('name') <span class="text-danger">{{ $message }}</span> @enderror
              </div>

              <div class="form-group">
                <label for="status">Status</label>
                <select name="status" class="form-control" id="status">
                  <option value="active" {{ (old('status', $state->status ?? '')=='active')?'selected':'' }}>Active</option>
                  <option value="inactive" {{ (old('status', $state->status ?? '')=='inactive')?'selected':'' }}>Inactive</option>
                </select>
                @error('status') <span class="text-danger">{{ $message }}</span> @enderror
              </div>
            </div>
            <div class="card-footer">
              <a href="{{ route('states.index') }}" class="btn btn-secondary">Back</a>
              <button type="submit" class="btn btn-primary">{{ isset($state) ? 'Update' : 'Submit' }}</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

  </div>

<script>
$(function () {
  $('#quickForm').validate({
    rules: {
      name: { required: true },
      status: { required: true }
    },
    messages: {
      name: "Please enter state name",
      status: "Please select status"
    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight: function (element) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script>
