

<div class="content-wrapper">

<div class="card">
 <div class="card-header">
    <h3 class="card-title">States List</h3>
    <a href="{{ route('states.create') }}" class="btn btn-success float-right">Add State</a>
</div>

    <div class="card-body">
        <!-- @if(session('success'))
          <div class="alert alert-success">{{ session('success') }}</div>
        @endif -->

        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
           <tbody>
    @foreach($states as $state)
    <tr>
        <td>{{ $loop->iteration }}</td> <!-- Serial number -->
        <td>{{ $state->name }}</td>
        <td>{{ $state->status }}</td>
        <td>{{ $state->created_at }}</td>
        <td>
            <a href="{{ route('states.edit', $state->id) }}" class="btn btn-primary btn-sm">Edit</a>

            <form action="{{ route('states.destroy', $state->id) }}" method="POST" style="display:inline;">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger btn-sm"
                    onclick="return confirm('Are you sure you want to deactivate this state?')">Deactivate</button>
            </form>
        </td>
    </tr>
    @endforeach
</tbody>
        </table>
    </div>
</div>

<script>
$(function () {
    $("#example1").DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
</script>
</div>
