<div class="content-wrapper">
<section class="content">

<div class="card card-primary">
<div class="card-header">
    <h3>Edit Booking #{{ $booking->id }}</h3>
</div>

<form method="POST" action="{{ route('bookings.update', $booking->id) }}">
@csrf
@method('POST')

<div class="card-body">

  {{-- USER INFO --}}
  <div class="form-group">
    <label>User</label>
    <input type="text" class="form-control"
           value="{{ $booking->user_name }} ({{ $booking->user_email }})"
           readonly>
  </div>

  {{-- PROPERTY --}}
  <div class="form-group">
    <label>Property</label>
    <input type="text" class="form-control"
           value="{{ $booking->property_name }}"
           readonly>
    <small class="text-muted">
      {{ $booking->locality_name }},
      {{ $booking->city_name }},
      {{ $booking->state_name }},
      {{ $booking->property_address }}
    </small>
  </div>

  {{-- CHECK IN --}}
  <div class="form-group">
    <label>Check In Time</label>
    <input type="datetime-local"
           name="check_in_time"
           class="form-control"
           value="{{ date('Y-m-d\TH:i', strtotime($booking->check_in_time)) }}"
           required>
  </div>

  {{-- CHECK OUT --}}
  <div class="form-group">
    <label>Check Out Time</label>
    <input type="datetime-local"
           name="check_out_time"
           class="form-control"
           value="{{ date('Y-m-d\TH:i', strtotime($booking->check_out_time)) }}"
           required>
  </div>

  {{-- PAYMENT STATUS (READ ONLY) --}}
  <div class="form-group">
    <label>Payment Status</label>
    <input type="text" class="form-control"
           value="{{ ucfirst($booking->payment_status) }}"
           readonly>
  </div>

  {{-- BOOKING STATUS --}}
  <div class="form-group">
    <label>Booking Status</label>
    <select name="booking_status" class="form-control" required>
      <option value="approved" {{ $booking->booking_status=='approved'?'selected':'' }}>Approved</option>
      <option value="completed" {{ $booking->booking_status=='completed'?'selected':'' }}>Completed</option>
      <option value="rejected" {{ $booking->booking_status=='rejected'?'selected':'' }}>Rejected</option>
    </select>
  </div>

  {{-- ADMIN NOTE --}}
  <div class="form-group">
    <label>Admin Note</label>
    <textarea name="admin_note"
              class="form-control"
              rows="4"
              placeholder="Enter admin note"
              required>{{ $booking->admin_note ?? '' }}</textarea>
  </div>

</div>

<div class="card-footer">
  <button class="btn btn-primary">Update Booking</button>
  <a href="{{ route('bookings.index') }}" class="btn btn-secondary">Back</a>
</div>

</form>
</div>

</section>
</div>
