<div class="content-wrapper">
  <div class="card">

    <div class="card-header">
      <h3 class="card-title">Bookings</h3>

      <div class="float-right">
        <a href="{{ route('bookings.index') }}" class="btn btn-sm btn-primary">All</a>

        <a href="{{ route('bookings.index', ['filterKey'=>'payment_status','filterValue'=>'pending']) }}"
           class="btn btn-sm btn-warning">Payment Pending</a>

        <a href="{{ route('bookings.index', ['filterKey'=>'booking_status','filterValue'=>'approved']) }}"
           class="btn btn-sm btn-success">Approved</a>

        <a href="{{ route('bookings.index', ['filterKey'=>'booking_status','filterValue'=>'completed']) }}"
           class="btn btn-sm btn-info">Completed</a>

        <a href="{{ route('bookings.index', ['filterKey'=>'booking_status','filterValue'=>'rejected']) }}"
           class="btn btn-sm btn-danger">Rejected</a>
      </div>
    </div>

    {{-- FILTER ALERT: show active filter and clear link --}}
    <div class="p-2">
      @if(!empty($filterKey) && !empty($filterValue))
        @php
          // helper: try to make user-friendly date text if possible
          $friendly = null;
          if ($filterKey === 'date' && strtotime($filterValue)) {
              $friendly = date('M d, Y', strtotime($filterValue));
          } elseif ($filterKey === 'date_range') {
              $parts = explode('|', $filterValue);
              $from = $parts[0] ?? null;
              $to   = $parts[1] ?? null;
              if ($from && strtotime($from)) $fromF = date('M d, Y', strtotime($from)); else $fromF = $from;
              if ($to   && strtotime($to))   $toF   = date('M d, Y', strtotime($to));   else $toF   = $to;
          }
        @endphp

        <div class="alert alert-info p-2" style="margin-bottom:8px;">
          @if($filterKey === 'date')
            Showing bookings for
            <strong>{{ e($filterValue) }}</strong>
            @if(!empty($friendly)) <small class="text-muted">({{ $friendly }})</small> @endif
          @elseif($filterKey === 'date_range')
            @php
              // ensure safe display even if explode failed
              $fromDisplay = $parts[0] ?? $filterValue;
              $toDisplay   = $parts[1] ?? null;
            @endphp
            Showing bookings from
            <strong>{{ e($fromDisplay) }}</strong>
            @if(!empty($fromF)) <small class="text-muted">({{ $fromF }})</small> @endif
            @if($toDisplay)
              to <strong>{{ e($toDisplay) }}</strong>
              @if(!empty($toF)) <small class="text-muted">({{ $toF }})</small> @endif
            @endif
          @else
            Filter: <strong>{{ ucfirst(e($filterKey)) }}</strong> = <strong>{{ e($filterValue) }}</strong>.
          @endif

          <a href="{{ route('bookings.index') }}" class="btn btn-sm btn-outline-dark float-right">Clear filter</a>
        </div>
      @endif
    </div>

    <div class="card-body">
      <table id="bookings_table" class="table table-bordered table-striped">
        <thead>
          <tr>
            <th >ID</th>
            <th >User</th>
            <th class="w-100">Property</th>
            <th class="w-100">Check In</th>
            <th class="w-100">Check Out</th>
            <th class="w-100">Payment</th>
            <th class="w-100">Booking Status</th>
            <th class="w-100">Admin Note</th>
            <th class="w-100">Admin Action Time</th>
            <th class="w-100">Action</th>
          </tr>
        </thead>

        <tbody>
          @foreach($bookings as $b)
            <tr>
  <td>{{ $loop->iteration }}</td>

              {{-- USER --}}
              <td>
                {{ $b->user_name ?? 'User #'.$b->user_id }}<br>
                <small class="text-muted">{{ $b->user_email ?? '' }}</small>
              </td>

              {{-- PROPERTY --}}
              <td>
                <strong>{{ $b->property_name ?? 'Property #'.$b->property_id }}</strong><br>
                <small class="text-muted">
                  {{ $b->locality_name ?? '' }}
                  {{ $b->city_name ? ', '.$b->city_name : '' }}
                  {{ $b->state_name ? ', '.$b->state_name : '' }}
                  {{ $b->property_address ? ', '.$b->property_address : '' }}
                </small>
              </td>

              <td>{{ $b->check_in_time }}</td>
              <td>{{ $b->check_out_time }}</td>

              <td>{{ ucfirst($b->payment_status) }}</td>
              <td>{{ ucfirst($b->booking_status) }}</td>

              <td>{{ $b->admin_note ?? '-' }}</td>
              <td>{{ $b->admin_action_time ?? '-' }}</td>

              {{-- ACTIONS --}}
              <td>
                {{-- APPROVE / REJECT (ONLY WHEN PAYMENT PENDING) --}}
                @if($b->payment_status === 'pending')
                  <form action="{{ route('bookings.approve_payment', $b->id) }}"
                        method="POST"
                        style="display:inline"
                        onsubmit="return attachAdminNote(this)">
                    @csrf
                    <input type="hidden" name="admin_note" value="">
                    <button class="btn btn-success btn-sm w-100 ">Approve</button>
                  </form>

                  <form action="{{ route('bookings.reject_payment', $b->id) }}"
                        method="POST"
                        style="display:inline"
                        onsubmit="return attachAdminNote(this)">
                    @csrf
                    <input type="hidden" name="admin_note" value="">
                    <button class="btn btn-danger btn-sm mt-1 w-100">Reject</button>
                  </form>

                  <br>
                @endif

                @if($b->booking_status !== 'completed')
                  <a href="{{ route('bookings.edit', $b->id) }}"
                     class="btn btn-primary btn-sm mt-1 w-100">
                    Update
                  </a>
                @endif
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
function attachAdminNote(form) {
    let note = prompt("Enter admin note (required):");
    if (!note || note.trim() === '') {
        alert('Admin note is required.');
        return false;
    }
    form.querySelector('input[name="admin_note"]').value = note;
    return true;
}

$(function () {
    $("#bookings_table").DataTable({
        responsive: true,
        lengthChange: false,
        autoWidth: false,
        buttons: ["copy", "csv", "excel", "pdf", "print"]
    }).buttons().container()
      .appendTo('#bookings_table_wrapper .col-md-6:eq(0)');
});
</script>
