<div class="content-wrapper">
<section class="content">
<div class="card card-primary">
<div class="card-header">
<h3>{{ isset($coupon) ? 'Edit Coupon' : 'Add Coupon' }}</h3>
</div>

<form method="POST" action="{{ isset($coupon) ? route('coupons.update',$coupon->id) : route('coupons.store') }}">
@csrf
@if(isset($coupon)) @method('PUT') @endif

<div class="card-body">

  <div class="form-group">
    <label>Coupon Name</label>
    <input type="text" name="name" class="form-control"
           value="{{ $coupon->name ?? '' }}"
           placeholder="Eg: New Year Offer">
  </div>

  @if(isset($coupon))
  <div class="form-group">
    <label>Coupon Code</label>
    <input type="text" class="form-control"
           value="{{ $coupon->coupon_code }}"
           readonly>
  </div>
  @endif

  <div class="form-group">
    <label>Expiry Date</label>
    <input type="date" name="expiry_date"
           class="form-control"
           value="{{ $coupon->expiry_date ?? '' }}">
  </div>

  <div class="form-group">
    <label>Value</label>
    <input type="number" name="value" class="form-control"
           value="{{ $coupon->value ?? '' }}">
  </div>

  <div class="form-group">
    <label>Type</label>
    <select name="type" class="form-control">
      <option value="flat" {{ (isset($coupon) && $coupon->type=='flat')?'selected':'' }}>Flat</option>
      <option value="percentage" {{ (isset($coupon) && $coupon->type=='percentage')?'selected':'' }}>Percentage</option>
    </select>
  </div>

  <div class="form-group">
    <label>Status</label>
    <select name="status" class="form-control">
      <option value="active" {{ (isset($coupon) && $coupon->status=='active')?'selected':'' }}>Active</option>
      <option value="inactive" {{ (isset($coupon) && $coupon->status=='inactive')?'selected':'' }}>Inactive</option>
      <option value="used" {{ (isset($coupon) && $coupon->status=='used')?'selected':'' }}>Used</option>
    </select>
  </div>

</div>


<div class="card-footer">
<button class="btn btn-primary">Submit</button>
</div>
</form>
</div>
</section>
</div>
