<div class="content-wrapper">
<div class="card">
<div class="card-header">
  <h3>Discount Coupons</h3>
  <a href="{{ route('coupons.create') }}" class="btn btn-success float-right">Add Coupon</a>
</div>

<div class="card-body">
<table class="table table-bordered table-striped">
<thead>
<tr>
  <th>ID</th>
  <th>Name</th>
<th>Code</th>
<th>Expiry</th>

  <th>Value</th>
  <th>Type</th>
  <th>Status</th>
  <th>Created By</th>
  <th>Used By</th>
  <th>Action</th>
</tr>
</thead>
<tbody>
@foreach($coupons as $c)
<tr>
  <td>{{ $loop->iteration }}</td>
  <td>{{ $c->name }}</td>
<td>{{ $c->coupon_code }}</td>
<td>{{ $c->expiry_date ?? '—' }}</td>

  <td>{{ $c->value }}</td>
  <td>{{ ucfirst($c->type) }}</td>
  <td>{{ ucfirst($c->status) }}</td>
  <td>
    {{ $c->admin_name ?? '—' }}<br>
    <small>{{ $c->admin_email ?? '' }}</small>
  </td>
  <td>
    @if($c->used_by_user_id)
      {{ $c->used_by_name }}<br>
      <small>{{ $c->used_by_email }}</small>
    @else —
    @endif
  </td>
  <td>
    <a href="{{ route('coupons.edit',$c->id) }}" class="btn btn-primary btn-sm w-100">Edit</a>
    <form action="{{ route('coupons.destroy',$c->id) }}" method="POST" style="display:inline;">
      @csrf @method('DELETE')
      <button class="btn btn-warning btn-sm w-100 mt-2" onclick="return confirm('Deactivate coupon?')">Deactivate</button>
    </form>
  </td>
</tr>
@endforeach
</tbody>
</table>
</div>
</div>
</div>
