<div class="content-wrapper">
<div class="card">
 <div class="card-header">
    <h3 class="card-title">Users List</h3>

    <div class="float-right">
      {{-- Filter buttons --}}
      <a href="{{ route('users.index') }}" class="btn {{ empty($user_type) ? 'btn-primary' : 'btn-outline-secondary' }} btn-sm">All</a>
      <a href="{{ route('users.index', ['user_type' => 'user']) }}" class="btn {{ (isset($user_type) && $user_type=='user') ? 'btn-primary' : 'btn-outline-secondary' }} btn-sm">User</a>
      <a href="{{ route('users.index', ['user_type' => 'merchant']) }}" class="btn {{ (isset($user_type) && $user_type=='merchant') ? 'btn-primary' : 'btn-outline-secondary' }} btn-sm">Merchant</a>

      <!-- <a href="{{ route('users.create') }}" class="btn btn-success btn-sm">Add User</a> -->
    </div>
</div>

    <div class="card-body">
        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>User Type</th> {{-- new column --}}
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($users as $user)
                <tr>
    <td>{{ $loop->iteration }}</td>
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->phone_no }}</td>
                    <td>{{ $user->user_type }}</td> {{-- show user_type --}}
                    <td>{{ $user->status }}</td>
                    <td>{{ $user->created_at }}</td>
                    <td>
                      <!-- <a href="{{ route('users.edit', $user->user_id) }}" class="btn btn-primary btn-sm">Edit</a> -->
                        <form action="{{ route('users.destroy', $user->user_id) }}" method="POST" style="display:inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm w-100"
                                onclick="return confirm('Are you sure?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<!-- datatables script remains the same -->
</div>


<script>
$(function () {
    $("#example1").DataTable({
        "responsive": true, 
        "lengthChange": false, 
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
</script>