{{-- resources/views/admin/withdrawals/index.blade.php --}}
<div class="content-wrapper">
  <div class="card">
    <div class="card-header">
      <h3 class="card-title">Withdrawals</h3>

      <div class="float-right">
        <a href="{{ route('withdrawals.index') }}" class="btn {{ empty($status) ? 'btn-primary' : 'btn-outline-secondary' }} btn-sm">All</a>
        <a href="{{ route('withdrawals.index',['status'=>'pending']) }}" class="btn {{ ($status=='pending')?'btn-primary':'btn-outline-secondary' }} btn-sm">Pending</a>
        <a href="{{ route('withdrawals.index',['status'=>'approved']) }}" class="btn {{ ($status=='approved')?'btn-primary':'btn-outline-secondary' }} btn-sm">Approved</a>
        <a href="{{ route('withdrawals.index',['status'=>'rejected']) }}" class="btn {{ ($status=='rejected')?'btn-primary':'btn-outline-secondary' }} btn-sm">Rejected</a>
      </div>
    </div>

    <div class="card-body">
      <table id="withdrawalsTable" class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>User</th>
            <th>Amount</th>
            <th>Bank (acct)</th>
            <th>Status</th>
            <th>Created</th>
            <th>Admin Note</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          @foreach($withdrawals as $w)
            <tr>
  <td>{{ $loop->iteration }}</td>
              <td>
                {{ $w->user_name ?? 'User #' . ($w->user_id ?? '') }}<br>
                <small class="text-muted">{{ $w->user_email ?? '' }}</small>
              </td>
              <td>{{ number_format((float)$w->amount, 2) }}</td>
              <td>
                @if($w->bank_name)
                  <strong>{{ $w->bank_name }}</strong><br>
                  <small>{{ $w->name_in_bank ?? '' }} • ****{{ $w->bank_account_number ? substr($w->bank_account_number, -4) : '----' }}</small><br>
                  <small class="text-muted">{{ $w->ifsc ?? '' }}</small>
                @else
                  <small class="text-muted">No bank</small>
                @endif
              </td>
              <td>
                @if($w->status === 'pending')
                  <span class="badge badge-warning">Pending</span>
                @elseif($w->status === 'approved')
                  <span class="badge badge-success">Approved</span>
                @else
                  <span class="badge badge-danger">Rejected</span>
                @endif
              </td>
              <td>{{ $w->created_at }}</td>
              <td>{{ $w->admin_note }}</td>
              <td>
                @if($w->status === 'pending')
                  <form action="{{ route('withdrawals.approve', $w->id) }}" method="POST" style="display:inline;" onsubmit="return adminNotePrompt(this)">
                    @csrf
                    <input type="hidden" name="admin_note" value="">
                    <button class="btn btn-success btn-sm">Approve</button>
                  </form>

                  <form action="{{ route('withdrawals.reject', $w->id) }}" method="POST" style="display:inline;" onsubmit="return adminNotePrompt(this)">
                    @csrf
                    <input type="hidden" name="admin_note" value="">
                    <button class="btn btn-danger btn-sm">Reject</button>
                  </form>
                @else
                  <span class="text-muted">No action</span>
                @endif
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>

{{-- DataTables init --}}
<script>
$(function () {
    $("#withdrawalsTable").DataTable({
        responsive: true,
        lengthChange: false,
        autoWidth: false,
        buttons: ["copy","csv","excel","pdf","print"]
    }).buttons().container().appendTo('#withdrawalsTable_wrapper .col-md-6:eq(0)');
});

function adminNotePrompt(form) {
    var note = prompt("Enter admin note (required):");
    if (!note || !note.trim()) {
        alert('Admin note is required.');
        return false;
    }
    form.querySelector('input[name="admin_note"]').value = note.trim();
    return true;
}
</script>
