<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\StateController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\LocalityController;
use App\Http\Controllers\ExtraServiceController;
use App\Http\Controllers\PropertyController; // <-- added
use App\Http\Controllers\MerchantController;

Route::get('/', function () {
    return view('welcome');
});

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::get('/admin/login', [AdminController::class, 'showLogin'])->name('admin.login');
    Route::post('/admin/login', [AdminController::class, 'login'])->name('admin.login.submit');

    Route::get('/admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');

    Route::get('/admin/logout', [AdminController::class, 'logout'])->name('admin.logout');
    Route::POST('/admin/logout', [AdminController::class, 'logout'])->name('admin.logout');


    // Users routes
    Route::prefix('admin')->group(function() {
    Route::get('users', [UserController::class, 'index'])->name('users.index');
    Route::get('/users/create', [UserController::class,'create'])->name('users.create');
    Route::post('/users', [UserController::class,'store'])->name('users.store');
    Route::get('/users/{id}/edit', [UserController::class,'edit'])->name('users.edit');
    Route::put('/users/{id}', [UserController::class,'update'])->name('users.update');
    Route::delete('users/{id}', [UserController::class, 'destroy'])->name('users.destroy');
   });
    /*
     |-----------------------------------------------------------------------
     | Properties (Admin)
     |-----------------------------------------------------------------------
     | Routes for managing properties. Controller: PropertyController
     | Keep these under the 'admin' prefix to match your other admin pages.
     */
Route::get('/admin/properties', [PropertyController::class, 'index'])->name('properties.index');
Route::get('/admin/properties/create', [PropertyController::class, 'create'])->name('properties.create');

// show/edit/update/destroy now use slug
Route::get('/admin/properties/{slug}', [PropertyController::class, 'show'])->name('properties.show');
Route::get('/admin/properties/{slug}/edit', [PropertyController::class, 'edit'])->name('properties.edit');
Route::put('/admin/properties/{slug}', [PropertyController::class, 'update'])->name('properties.update');
Route::delete('/admin/properties/{slug}', [PropertyController::class, 'destroy'])->name('properties.destroy');

// approve/reject endpoints
Route::post('/admin/properties/{slug}/approve', [PropertyController::class,'approve'])->name('admin.properties.approve');
Route::post('/admin/properties/{slug}/reject', [PropertyController::class,'reject'])->name('admin.properties.reject');
 

    Route::get('states', [StateController::class, 'index'])->name('states.index');
    Route::get('states/create', [StateController::class, 'create'])->name('states.create');
    Route::post('states', [StateController::class, 'store'])->name('states.store');
    Route::get('states/{id}/edit', [StateController::class, 'edit'])->name('states.edit');
    Route::put('states/{id}', [StateController::class, 'update'])->name('states.update');
    Route::delete('states/{id}', [StateController::class, 'destroy'])->name('states.destroy');

    Route::resource('cities', CityController::class);
    Route::resource('localities', LocalityController::class);

    Route::resource('extra-services', ExtraServiceController::class);
    Route::get('admin/tickets', [ExtraServiceController::class, 'ticketsIndex'])->name('admin.tickets.index');
    Route::get('admin/tickets/{id}', [ExtraServiceController::class, 'ticketShow'])->name('admin.tickets.show');
    Route::post('admin/tickets/{id}', [ExtraServiceController::class, 'ticketUpdate'])->name('admin.tickets.update');


    Route::get('admin/settings', [ExtraServiceController::class, 'settingsIndex'])
     ->name('admin.settings');

    Route::post('admin/settings', [ExtraServiceController::class, 'saveSettings'])
     ->name('admin.settings.save');


    Route::get('/withdrawals', [UserController::class, 'withdrawals'])->name('withdrawals.index');
    Route::post('/withdrawals/{id}/approve', [UserController::class, 'approveWithdrawal'])->name('withdrawals.approve');
    Route::post('/withdrawals/{id}/reject', [UserController::class, 'rejectWithdrawal'])->name('withdrawals.reject');
    Route::get('/transactions', [UserController::class, 'transactionsIndex'])->name('transactions.index');

    Route::get('/bookings', [UserController::class, 'bookingsIndex'])->name('bookings.index');


    Route::get('/coupons', [UserController::class,'couponsIndex'])->name('coupons.index');
    Route::get('/coupons/create', [UserController::class,'couponsCreate'])->name('coupons.create');
    Route::post('/coupons', [UserController::class,'couponsStore'])->name('coupons.store');
    Route::get('/coupons/{id}/edit', [UserController::class,'couponsEdit'])->name('coupons.edit');
    Route::put('/coupons/{id}', [UserController::class,'couponsUpdate'])->name('coupons.update');
    Route::delete('/coupons/{id}', [UserController::class,'couponsDestroy'])->name('coupons.destroy');
    Route::post('bookings/{id}/approve-payment', [UserController::class, 'approveBookingPayment'])->name('bookings.approve_payment');
    Route::post('bookings/{id}/reject-payment', [UserController::class, 'rejectBookingPayment'])->name('bookings.reject_payment');
    Route::post('bookings/{id}/admin-action',[UserController::class, 'bookingAdminAction'])->name('bookings.admin_action');
    Route::get('bookings/{id}/edit',[UserController::class, 'editBooking'])->name('bookings.edit');
    Route::post('bookings/{id}/update',[UserController::class, 'updateBooking'])->name('bookings.update');


    Route::get('/merchant', [MerchantController::class, 'index'])->name('merchant.index');
    Route::get('/merchant/login', [MerchantController::class, 'login'])->name('merchant.login');
    Route::get('/merchant/signup', [MerchantController::class, 'signup'])->name('merchant.signup');
    Route::post('/merchant/signup', [MerchantController::class, 'signupStore'])->name('merchant.signup.store');
    Route::post('/merchant/login', [MerchantController::class, 'loginStore'])->name('merchant.login.store');

    Route::get('/merchant/logout', [MerchantController::class, 'logout']) ->name('merchant.logout');

    Route::get('/merchant/profile', [MerchantController::class, 'merchant_profile'])->name('merchant.profile');

    Route::put('/merchant/profile/update', [MerchantController::class, 'profileUpdate'])->name('merchant.profile.update');

    // PROPERTY FORM (same blade)
    Route::get('merchant/properties/create', [MerchantController::class, 'propertyCreate'])
    ->name('merchant.properties.create');

Route::get('merchant/properties/{slug}/edit', [MerchantController::class, 'propertyEdit'])
    ->name('merchant.properties.edit');

// STORE (same)
Route::post('merchant/properties/store', [MerchantController::class, 'propertyStore'])
    ->name('merchant.properties.store');

// Update uses slug now
Route::post('merchant/properties/{slug}/update', [MerchantController::class, 'propertyUpdate'])
    ->name('merchant.properties.update');

     // AJAX (return all properly)
     // routes/web.php
     Route::get('merchant/ajax/cities', [MerchantController::class, 'ajaxCities'])
    ->name('merchant.ajax.cities');

     Route::get('merchant/ajax/localities', [MerchantController::class, 'ajaxLocalities'])
    ->name('merchant.ajax.localities');
     Route::get('merchant/my-properties', [MerchantController::class, 'myProperties'])
    ->name('merchant.my.properties');
     Route::get('merchant/properties/bookings', [MerchantController::class, 'propertyBookings'])
    ->name('merchant.properties.bookings');


    Route::get('/merchant/kyc', [MerchantController::class, 'kycForm'])
    ->name('merchant.kyc.form');

    Route::post('/merchant/kyc', [MerchantController::class, 'kycStore'])
    ->name('merchant.kyc.store');
    Route::get('/merchant/bank-details', [MerchantController::class, 'bankForm'])
    ->name('merchant.bank.form');

    Route::post('/merchant/bank-details/store', [MerchantController::class, 'bankStore'])
    ->name('merchant.bank.store');

    Route::post('/merchant/bank-details/update', [MerchantController::class, 'bankUpdate'])
    ->name('merchant.bank.update');
 
    // Merchant withdrawal
    Route::get('/merchant/withdraw', [MerchantController::class, 'withdrawalForm'])
    ->name('merchant.withdraw.form');

    Route::post('/merchant/withdraw', [MerchantController::class, 'withdrawalStore'])
    ->name('merchant.withdraw.store');

    Route::get('/merchant/withdraw/history', [MerchantController::class, 'withdrawalHistory'])
    ->name('merchant.withdraw.history');
    // web.php (inside admin/middleware group if any)
    // Route::post('admin/properties/{id}/approve', [PropertyController::class, 'approve'])->name('admin.properties.approve');
    // Route::post('admin/properties/{id}/reject',  [PropertyController::class, 'reject'])->name('admin.properties.reject');
    // admin KYC routes
    Route::prefix('admin')->middleware(['web'])->group(function () {
    Route::get('kyc', [PropertyController::class, 'kycIndex'])->name('admin.kyc.index');
    Route::get('kyc/{id}', [PropertyController::class, 'kycShow'])->name('admin.kyc.show'); // returns JSON for modal
    Route::post('kyc/{id}/approve', [PropertyController::class, 'kycApprove'])->name('admin.kyc.approve');
    Route::post('kyc/{id}/reject',  [PropertyController::class, 'kycReject'])->name('admin.kyc.reject');
    });
    Route::get('admin/merchant-kyc/{id}', [PropertyController::class, 'kycView'])
    ->name('admin.kyc.view');
    Route::get('/admin/bank-accounts', [PropertyController::class, 'bankAccounts'])
    ->name('admin.bank.accounts');

    Route::post('/admin/bank-accounts/{id}/approve', [PropertyController::class, 'approveBankAccount'])
    ->name('admin.bank.accounts.approve');

     Route::post('/admin/bank-accounts/{id}/reject', [PropertyController::class, 'rejectBankAccount'])
    ->name('admin.bank.accounts.reject');
    Route::get('/merchant/calendar/bookings',[MerchantController::class, 'calendarBookings']
     )->name('merchant.calendar.bookings');

     Route::get('/admin/dashboard/calendar/bookings',[DashboardController::class, 'calendarBookings'])->name('admin.dashboard.calendar.bookings');
Route::post(
    '/merchant/properties/delete/{slug}',
    [MerchantController::class, 'softDelete']
)->name('merchant.properties.softDelete');
