
<?php
function profile_image_url($path = null)
{
    if ($path) {
        return rtrim(config('app.url'), '/') . '/storage/app/public/profile_images/' . ltrim($path, '/');
    }

    return asset('dist/newdashboard/images/users/avatar-1.jpg');
}

?>

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">

            <div class="position-relative mx-n4 mt-n4">
                <div class="profile-wid-bg profile-setting-img">
                    <img src="<?php echo e(asset('dist/newdashboard/images/profile-bg.jpg')); ?>" class="profile-wid-img" alt="">
                    <div class="overlay-content">
                        <div class="text-end p-3">
                            <div class="p-0 ms-auto rounded-circle profile-photo-edit">
                                <label class="profile-photo-edit btn btn-light">
                                    <i class="ri-image-edit-line align-bottom me-1"></i> Change Cover
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                
                <div class="col-xxl-3">
                    <div class="card mt-n5">
                        <div class="card-body p-4 text-center">
                            <div class="profile-user position-relative d-inline-block mx-auto mb-4">
                                <?php
                                    $imgPreview = isset($user->profile_image) && $user->profile_image ? profile_image_url($user->profile_image) : asset('dist/newdashboard/images/users/avatar-1.jpg');
                                ?>
                                <img id="profilePreview" src="<?php echo e($imgPreview); ?>" class="rounded-circle avatar-xl img-thumbnail user-profile-image shadow" alt="user-profile-image">

                                <div class="avatar-xs p-0 rounded-circle profile-photo-edit">
                                    <label for="profile-img-file-input" class="profile-photo-edit avatar-xs btn btn-sm btn-light mt-2">
                                        <span class="avatar-title rounded-circle bg-light text-body shadow">
                                            <i class="ri-camera-fill"></i>
                                        </span>
                                        <input id="profile-img-file-input" type="file" accept="image/*" class="profile-img-file-input" style="display:none">
                                    </label>
                                </div>
                            </div>

                            <h5 class="fs-16 mb-1" id="displayName"><?php echo e($user->name); ?></h5>
                            <p class="text-muted mb-0" id="displayEmail"><?php echo e($user->email); ?></p>
                            <!-- <p class="text-muted mb-0"><small>Status: <strong><?php echo e($user->status ?? 'active'); ?></strong></small></p>
                            <p class="text-muted mb-0"><small>ID: <strong><?php echo e($user->user_id ?? ''); ?></strong></small></p> -->
                        </div>
                    </div>
                </div>

                
                <div class="col-xxl-9">
                    <div class="card mt-xxl-n5">
                        <div class="card-header">
                            <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#personalDetails" role="tab">
                                        <i class="fas fa-user"></i> Personal Details
                                    </a>
                                </li>
                            </ul>
                        </div>

                        <div class="card-body p-4">
                            <div class="tab-content">
                                <div class="tab-pane active" id="personalDetails" role="tabpanel">

                                    
                                    <form id="profileForm" action="<?php echo e(route('merchant.profile.update')); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>

                                        <?php if(session('success')): ?>
                                            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                                        <?php endif; ?>

                                        <?php if($errors->any()): ?>
                                            <div class="alert alert-danger">
                                                <ul class="mb-0">
                                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e($e); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>

                                        <div class="row">

                                            
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="nameInput" class="form-label">Full Name</label>
                                                    <input type="text" class="form-control" id="nameInput" name="name" placeholder="Enter your fullname" value="<?php echo e(old('name', $user->name)); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="emailInput" class="form-label">Email Address</label>
                                                    <input type="email" class="form-control" id="emailInput" name="email" placeholder="Enter your email" value="<?php echo e(old('email', $user->email)); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Account Type</label>
                                                    <div class="form-control" style="background:transparent; border:1px solid #e9ecef;">
                                                        <?php echo e($user->user_type); ?>

                                                    </div>
                                                    
                                                    
                                                </div>
                                            </div>

                                            
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="phoneInput" class="form-label">Phone</label>
                                                    <input type="text" class="form-control" id="phoneInput" name="phone_no" placeholder="Enter phone" value="<?php echo e(old('phone_no', $user->phone_no)); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="newpasswordInput" class="form-label">New Password</label>
                                                    <input type="password" class="form-control" id="newpasswordInput" name="password" placeholder="Leave blank to keep current password">
                                                    <small class="text-muted">Minimum 8 characters to change password.</small>
                                                </div>
                                            </div>

                                            
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="confirmpasswordInput" class="form-label">Confirm New Password</label>
                                                    <input type="password" class="form-control" id="confirmpasswordInput" name="password_confirmation" placeholder="Confirm new password">
                                                </div>
                                            </div>

                                            
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="profileImageInput" class="form-label">Profile Picture</label>
                                                    <input type="file" class="form-control" id="profileImageInput" name="profile_image" accept="image/*">
                                                    <small class="text-muted">Max 2MB. New upload replaces existing image.</small>
                                                </div>
                                            </div>

                                            
                                            <input type="hidden" name="current_password" id="currentPasswordHidden" value="">

                                            <div class="col-lg-12">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="button" id="updateBtn" class="btn btn-primary">Update</button>
                                                    <button type="button" class="btn btn-soft-success" onclick="window.history.back()">Cancel</button>
                                                </div>
                                            </div>

                                        </div>
                                    </form>

                                </div>
                                <!--end tab-pane-->
                            </div>
                        </div>
                    </div>
                </div>
                <!--end col-->
            </div>
            <!--end row-->

        </div>
        <!-- container-fluid -->
    </div><!-- End Page-content -->
</div>


<div class="modal fade" id="confirmPasswordModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <form id="confirmPasswordForm" class="modal-content" onsubmit="return false;">
      <div class="modal-header">
        <h5 class="modal-title">Confirm your password</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Please enter your current password to confirm changes.</p>
        <div class="mb-3">
          <input type="password" id="confirmPasswordInput" class="form-control" placeholder="Current password" required>
          <div class="invalid-feedback" id="confirmPasswordError"></div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" id="confirmCancel" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" id="confirmSubmit" class="btn btn-primary">Confirm & Save</button>
      </div>
    </form>
  </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', function () {
    const topInput = document.getElementById('profile-img-file-input');
    const formInput = document.getElementById('profileImageInput');
    const preview = document.getElementById('profilePreview');
    const displayName = document.getElementById('displayName');
    const displayEmail = document.getElementById('displayEmail');
    const updateBtn = document.getElementById('updateBtn');
    const confirmModalEl = document.getElementById('confirmPasswordModal');
    const confirmModal = new bootstrap.Modal(confirmModalEl);
    const confirmInput = document.getElementById('confirmPasswordInput');
    const confirmSubmit = document.getElementById('confirmSubmit');
    const confirmError = document.getElementById('confirmPasswordError');
    const hiddenCurrent = document.getElementById('currentPasswordHidden');
    const profileForm = document.getElementById('profileForm');

    // forward top avatar input to real file input and preview
    if (topInput && formInput) {
        topInput.addEventListener('change', function (ev) {
            if (ev.target.files && ev.target.files[0]) {
                const dt = new DataTransfer();
                dt.items.add(ev.target.files[0]);
                formInput.files = dt.files;
                const reader = new FileReader();
                reader.onload = function (e) { preview.src = e.target.result; };
                reader.readAsDataURL(ev.target.files[0]);
            }
        });

        formInput.addEventListener('change', function (ev) {
            if (ev.target.files && ev.target.files[0]) {
                const reader = new FileReader();
                reader.onload = function (e) { preview.src = e.target.result; };
                reader.readAsDataURL(ev.target.files[0]);
            }
        });
    }

    // live name/email update in left panel
    const nameField = document.getElementById('nameInput');
    const emailField = document.getElementById('emailInput');
    if (nameField) nameField.addEventListener('input', () => displayName.textContent = nameField.value || '<?php echo e($user->name); ?>');
    if (emailField) emailField.addEventListener('input', () => displayEmail.textContent = emailField.value || '<?php echo e($user->email); ?>');

    // show modal when Update clicked
    updateBtn.addEventListener('click', function () {
        confirmInput.value = '';
        confirmInput.classList.remove('is-invalid');
        confirmError.textContent = '';
        confirmModal.show();
    });

    // modal submit: validate non-empty current password then submit main form
    confirmSubmit.addEventListener('click', function () {
        const pwd = confirmInput.value.trim();
        if (!pwd) {
            confirmInput.classList.add('is-invalid');
            confirmError.textContent = 'Password is required';
            return;
        }
        // inject and submit
        hiddenCurrent.value = pwd;
        profileForm.submit();
    });

    // optional: clear modal state on hide
    confirmModalEl.addEventListener('hidden.bs.modal', function () {
        confirmInput.value = '';
        confirmInput.classList.remove('is-invalid');
        confirmError.textContent = '';
    });
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/merchant_panel/merchant_profile.blade.php ENDPATH**/ ?>