<div class="content-wrapper">
<div class="card">
 <div class="card-header">
    <h3 class="card-title">Users List</h3>

    <div class="float-right">
      
      <a href="<?php echo e(route('users.index')); ?>" class="btn <?php echo e(empty($user_type) ? 'btn-primary' : 'btn-outline-secondary'); ?> btn-sm">All</a>
      <a href="<?php echo e(route('users.index', ['user_type' => 'user'])); ?>" class="btn <?php echo e((isset($user_type) && $user_type=='user') ? 'btn-primary' : 'btn-outline-secondary'); ?> btn-sm">User</a>
      <a href="<?php echo e(route('users.index', ['user_type' => 'merchant'])); ?>" class="btn <?php echo e((isset($user_type) && $user_type=='merchant') ? 'btn-primary' : 'btn-outline-secondary'); ?> btn-sm">Merchant</a>

      <!-- <a href="<?php echo e(route('users.create')); ?>" class="btn btn-success btn-sm">Add User</a> -->
    </div>
</div>

    <div class="card-body">
        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>User Type</th> 
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($user->name); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->phone_no); ?></td>
                    <td><?php echo e($user->user_type); ?></td> 
                    <td><?php echo e($user->status); ?></td>
                    <td><?php echo e($user->created_at); ?></td>
                    <td>
                      <!-- <a href="<?php echo e(route('users.edit', $user->user_id)); ?>" class="btn btn-primary btn-sm">Edit</a> -->
                        <form action="<?php echo e(route('users.destroy', $user->user_id)); ?>" method="POST" style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm w-100"
                                onclick="return confirm('Are you sure?')">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<!-- datatables script remains the same -->
</div>


<script>
$(function () {
    $("#example1").DataTable({
        "responsive": true, 
        "lengthChange": false, 
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
</script><?php /**PATH /var/www/html/pc/hide/resources/views/users/index.blade.php ENDPATH**/ ?>