  <div class="content-wrapper">


<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12">
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title"><?php echo e(isset($user) ? 'Edit User' : 'Add User'); ?></h3>
          </div>
          <form id="quickForm" method="POST" action="<?php echo e(isset($user) ? route('users.update', $user->id) : route('users.store')); ?>">
            <?php echo csrf_field(); ?>
            <?php if(isset($user)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <div class="card-body">
              <div class="form-group">
                <label for="name">Name</label>
                <input type="text" name="name" value="<?php echo e($user->name ?? ''); ?>" class="form-control" id="name" placeholder="Enter Name">
              </div>
              <div class="form-group">
                <label for="email">Email address</label>
                <input type="email" name="email" value="<?php echo e($user->email ?? ''); ?>" class="form-control" id="email" placeholder="Enter email">
              </div>
              <div class="form-group">
                <label for="phone_no">Phone</label>
                <input type="text" name="phone_no" value="<?php echo e($user->phone_no ?? ''); ?>" class="form-control" id="phone_no" placeholder="Enter phone number">
              </div>

                <div class="form-group">
    <label for="user_type">User Type</label>
    <select name="user_type" class="form-control" id="user_type">
      <option value="user" <?php echo e((isset($user) && $user->user_type == 'user') ? 'selected' : ''); ?>>User</option>
      <option value="merchant" <?php echo e((isset($user) && $user->user_type == 'merchant') ? 'selected' : ''); ?>>Merchant</option>
    </select>
  </div>
              <div class="form-group">
                <label for="status">Status</label>
                <select name="status" class="form-control" id="status">
                  <option value="active" <?php echo e((isset($user) && $user->status=='active')?'selected':''); ?>>Active</option>
                  <option value="inactive" <?php echo e((isset($user) && $user->status=='inactive')?'selected':''); ?>>Inactive</option>
                </select>
              </div>
            </div>
            <div class="card-footer">
              <button type="submit" class="btn btn-primary"><?php echo e(isset($user) ? 'Update' : 'Submit'); ?></button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

  </div>
<script>
$(function () {
  $('#quickForm').validate({
    rules: {
      name: { required: true },
      email: { required: true, email: true },
      status: { required: true }
    },
    messages: {
      name: "Please enter name",
      email: "Please enter valid email",
      status: "Please select status"
    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight: function (element) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/users/form.blade.php ENDPATH**/ ?>