<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">

            
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
            <?php endif; ?>

            
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">Analytics</h4>
                    </div>
                </div>
            </div>

            
            <div class="row">

                
                <div class="col-md-6 col-xl-3">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <p class="fw-medium text-muted mb-0">Wallet Balance</p>
                                    <h2 class="mt-4 ff-secondary fw-semibold">
                                        ₹ <?php echo e(number_format($walletBalance, 2)); ?>

                                    </h2>
                                    <p class="mb-0 text-muted">Available balance</p>
                                </div>
                                <div class="avatar-sm">
                                    <span class="avatar-title bg-primary rounded-circle fs-2">
                                        <i data-feather="credit-card"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="col-md-6 col-xl-3">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <p class="fw-medium text-muted mb-0">Withdrawals</p>
                                    <h2 class="mt-4 ff-secondary fw-semibold">
                                        <?php echo e($withdrawalsPending + $withdrawalsApproved + $withdrawalsRejected); ?>

                                    </h2>
                                    <p class="mb-0 text-muted">
                                        P: <?php echo e($withdrawalsPending); ?> |
                                        A: <?php echo e($withdrawalsApproved); ?> |
                                        R: <?php echo e($withdrawalsRejected); ?>

                                    </p>
                                </div>
                                <div class="avatar-sm">
                                    <span class="avatar-title bg-warning rounded-circle fs-2">
                                        <i data-feather="arrow-down-circle"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="col-md-6 col-xl-3">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <p class="fw-medium text-muted mb-0">Active Bookings</p>
                                    <h2 class="mt-4 ff-secondary fw-semibold">
                                        <?php echo e($activeBookingsCount); ?>

                                    </h2>
                                    <p class="mb-0 text-muted">On active properties</p>
                                </div>
                                <div class="avatar-sm">
                                    <span class="avatar-title bg-success rounded-circle fs-2">
                                        <i data-feather="calendar"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="col-md-6 col-xl-3">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <p class="fw-medium text-muted mb-0">Active Properties</p>
                                    <h2 class="mt-4 ff-secondary fw-semibold">
                                        <?php echo e($activePropertiesCount); ?>

                                    </h2>
                                    <p class="mb-0 text-muted">Currently live</p>
                                </div>
                                <div class="avatar-sm">
                                    <span class="avatar-title bg-info rounded-circle fs-2">
                                        <i data-feather="home"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            
            <div class="row">

                
                <div class="col-xl-12">
                    <div class="card card-height-100">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Booking Calendar</h4>
                        </div>
                        <div class="card-body">
                            <p class="text-muted">
                                Click on a date to view bookings
                            </p>

                            
                            <div id="bookingCalendar"></div>
                        </div>
                    </div>
                </div>

             

            </div>

        </div>
    </div>
</div>
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>

<style>
/* REMOVE DRAG / RESIZE ARROW */
.fc-event-resizer,
.fc-event-resizer-start,
.fc-event-resizer-end {
    display: none !important;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function () {

    var calendarEl = document.getElementById('bookingCalendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {

        initialView: 'dayGridMonth',
        height: 650,

        // CLEAN HEADER
        headerToolbar: {
            left: 'title',
            center: '',
            right: 'prev today next'
        },

        // LOAD BOOKINGS
        events: "<?php echo e(route('merchant.calendar.bookings')); ?>",

        // DISABLE ALL EDITING (IMPORTANT)
        editable: false,
        eventStartEditable: false,
        eventDurationEditable: false,

        // SHOW TIME
        eventTimeFormat: {
            hour: '2-digit',
            minute: '2-digit',
            hour12: false
        },

        displayEventEnd: true,
        eventDisplay: 'block',

        // CLICK EMPTY DATE
        dateClick: function(info) {
            window.location.href =
                "<?php echo e(route('merchant.properties.bookings')); ?>?date=" + info.dateStr;
        },

        // CLICK BOOKING
        eventClick: function(info) {
            let date = info.event.startStr.substring(0, 10);
            window.location.href =
                "<?php echo e(route('merchant.properties.bookings')); ?>?date=" + date;
        }
    });

    calendar.render();
});
</script><?php /**PATH /var/www/html/pc/hide/resources/views/merchant_panel/merchant_dashboard.blade.php ENDPATH**/ ?>