<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark"
      data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">

<head>
    <meta charset="utf-8" />
    <title>Sign Up | THEHIDOUT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('dist/newdashboard/images/hidoutfavicon.png')); ?>">

    <!-- Layout config Js -->
    <script src="<?php echo e(asset('dist/newdashboard/js/layout.js')); ?>"></script>

    <!-- Bootstrap Css -->
    <link href="<?php echo e(asset('dist/newdashboard/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?php echo e(asset('dist/newdashboard/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- App Css -->
    <link href="<?php echo e(asset('dist/newdashboard/css/app.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- Custom Css -->
    <link href="<?php echo e(asset('dist/newdashboard/css/custom.min.css')); ?>" rel="stylesheet" type="text/css" />
</head>

<body>

<div class="auth-page-wrapper auth-bg-cover py-5 d-flex justify-content-center align-items-center min-vh-100">
  <div class="bg-overlay"></div>

  <div class="auth-page-content overflow-hidden pt-lg-5">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <div class="card overflow-hidden m-0">
            <div class="row justify-content-center g-0">

              <div class="col-lg-6 d-none d-lg-block">
                <!-- left side (logo / carousel) -->
                <div class="p-lg-5 p-4 auth-one-bg h-100">
                  <div class="bg-overlay"></div>
                  <div class="position-relative h-100 d-flex flex-column">
                    <div class="mb-4">
                      <a href="<?php echo e(route('merchant.signup')); ?>" class="d-block">
                        <img src="<?php echo e(asset('dist/newdashboard/images/hidoutlogo_light.png')); ?>" alt="Logo" height="35">
                      </a>
                    </div>
                    <div class="mt-auto">
                      <div class="mb-3">
                        <i class="ri-double-quotes-l display-4 text-success"></i>
                      </div>
                      <div id="qoutescarouselIndicators" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner text-center text-white-50 pb-5">
                          <div class="carousel-item active"><p class="fs-15 fst-italic">"Clean design, easy customization."</p></div>
                          <div class="carousel-item"><p class="fs-15 fst-italic">"Great support & docs."</p></div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-lg-6">
                <div class="p-lg-5 p-4">
                  <h2 class="text-primary">Register Account</h2>
                  <h5 class="text-muted">Get your Free Velzon account now.</h5>

                  
                  <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                      <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li><?php echo e($err); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </ul>
                    </div>
                  <?php endif; ?>

                  
                  <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                  <?php endif; ?>

                  <form method="POST" action="<?php echo e(route('merchant.signup.store')); ?>" class="needs-validation" novalidate>
                    <?php echo csrf_field(); ?>

                    <div class="mb-3">
                      <label for="name" class="form-label fs-5">Full Name <span class="text-danger">*</span></label>
                      <input id="name" name="name" type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                             value="<?php echo e(old('name')); ?>" required>
                      <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                      <label for="email" class="form-label fs-5">Email <span class="text-danger">*</span></label>
                      <input id="email" name="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                             value="<?php echo e(old('email')); ?>" required>
                      <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                      <label for="phone_no" class="form-label fs-5">Phone number</label>
                      <input id="phone_no" name="phone_no" type="text" class="form-control <?php $__errorArgs = ['phone_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                             value="<?php echo e(old('phone_no')); ?>">
                      <?php $__errorArgs = ['phone_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                      <label for="password" class="form-label fs-5">Password <span class="text-danger">*</span></label>
                      <div class="position-relative auth-pass-inputgroup">
                        <input id="password" name="password" type="password"
                               class="form-control fs-5 pe-5 password-input <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="Enter password" minlength="8" required>
                        <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none shadow-none text-muted"
                                type="button" onclick="togglePassword()">
                          <i class="ri-eye-fill align-middle"></i>
                        </button>
                      </div>
                      <small class="form-text text-muted  fs-5">Minimum 8 characters.</small>
                      <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                      <label for="password_confirmation" class="form-label fs-5">Confirm Password <span class="text-danger">*</span></label>
                      <input id="password_confirmation" name="password_confirmation" type="password"
                             class="form-control fs-5" placeholder="Confirm password" minlength="8" required>
                    </div>

                    <div class="mt-4">
                      <button class="btn btn-success w-100 fs-5" type="submit">Sign Up</button>
                    </div>
                  </form> 

                  <div class="mt-4 text-center">
                    <h4 class="mb-0">
                      Already have an account ?
                      <a href="<?php echo e(route('merchant.login')); ?>" class="fw-semibold text-primary text-decoration-underline"> Signin</a>
</h4>
                  </div>

                </div>
              </div>

            </div> 
          </div>
        </div>
      </div>
    </div>
  </div>

  <footer class="footer">
    <div class="container text-center">
      <p class="mb-0">&copy; <script>document.write(new Date().getFullYear())</script> THEHIDOUT</p>
    </div>
  </footer>
</div>

<script>
  function togglePassword(){
    var p = document.getElementById('password');
    p.type = p.type === 'password' ? 'text' : 'password';
  }
</script>

<!-- JAVASCRIPT -->
<script src="<?php echo e(asset('dist/newdashboard/libs/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('dist/newdashboard/libs/simplebar/simplebar.min.js')); ?>"></script>
<script src="<?php echo e(asset('dist/newdashboard/libs/node-waves/waves.min.js')); ?>"></script>
<script src="<?php echo e(asset('dist/newdashboard/libs/feather-icons/feather.min.js')); ?>"></script>
<script src="<?php echo e(asset('dist/newdashboard/js/pages/plugins/lord-icon-2.1.0.js')); ?>"></script>
<script src="<?php echo e(asset('dist/newdashboard/js/plugins.js')); ?>"></script>

<!-- validation init -->
<script src="<?php echo e(asset('dist/newdashboard/js/pages/form-validation.init.js')); ?>"></script>
<!-- password create init -->
<script src="<?php echo e(asset('dist/newdashboard/js/pages/passowrd-create.init.js')); ?>"></script>

</body>
</html>



<?php /**PATH /var/www/html/pc/hide/resources/views/merchant_panel/signup.blade.php ENDPATH**/ ?>