<?php
    // ONLY pending is locked
    $isPending = $kyc && $kyc->status === 'pending';
?>

<div class="main-content">
  <div class="page-content">
    <div class="container-fluid">

      
      <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
      <?php endif; ?>

      
      <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
      <?php endif; ?>

      
      <?php if($kyc && $kyc->status === 'pending'): ?>
        <div class="alert alert-warning">
          Your KYC is under review. Editing is disabled until verification completes.
        </div>
      <?php elseif($kyc && $kyc->status === 'approved'): ?>
        <div class="alert alert-success">
          Your KYC is approved. You may update details if required.
        </div>
      <?php elseif($kyc && $kyc->status === 'rejected'): ?>
        <div class="alert alert-danger">
          Your KYC was rejected. Please correct details and re-submit.
        </div>
      <?php endif; ?>

      
      <?php if($errors->any()): ?>
        <div class="alert alert-danger">
          <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><?php echo e($err); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      <?php endif; ?>

      <div class="card">
        <div class="card-header">
          <h4 class="card-title mb-0">Merchant KYC</h4>
        </div>

        <div class="card-body">
          <form class="row g-3 needs-validation"
                method="POST"
                action="<?php echo e(route('merchant.kyc.store')); ?>"
                enctype="multipart/form-data"
                novalidate>
            <?php echo csrf_field(); ?>

            
            <div class="col-md-4">
              <label class="form-label">Document Type</label>
              <select name="document_type"
                      id="document_type"
                      class="form-select"
                      <?php echo e($isPending ? 'disabled' : ''); ?>

                      required>
                <option value="" disabled>Choose...</option>
                <option value="aadhaar"
                  <?php echo e(old('document_type', $kyc->document_type ?? '') === 'aadhaar' ? 'selected' : ''); ?>>
                  Aadhaar Card
                </option>
                <option value="other"
                  <?php echo e(old('document_type', $kyc->document_type ?? '') === 'other' ? 'selected' : ''); ?>>
                  Other Document
                </option>
              </select>
            </div>

            
            <div class="col-md-4">
              <label class="form-label">Name</label>
              <input type="text"
                     name="name"
                     class="form-control"
                     value="<?php echo e(old('name', $kyc->name ?? '')); ?>"
                     <?php echo e($isPending ? 'readonly' : ''); ?>

                     required>
            </div>

            
            <div class="col-md-4">
              <label class="form-label">Date of Birth</label>
              <input type="date"
                     name="dob"
                     class="form-control"
                     value="<?php echo e(old('dob', $kyc->dob ?? '')); ?>"
                     <?php echo e($isPending ? 'readonly' : ''); ?>

                     required>
            </div>

            
            <div class="col-md-12">
              <label class="form-label">Address</label>
              <textarea name="address"
                        class="form-control"
                        rows="2"
                        <?php echo e($isPending ? 'readonly' : ''); ?>

                        required><?php echo e(old('address', $kyc->address ?? '')); ?></textarea>
            </div>

            
            <div class="col-md-4">
              <label class="form-label">Document Front Image</label>

              <?php if($kyc && $kyc->front_image): ?>
                <div class="mb-1">
                  <a href="<?php echo e(asset('storage/kyc/'.$kyc->front_image)); ?>" target="_blank">
                    View current
                  </a>
                </div>
              <?php endif; ?>

              <?php if(!$isPending): ?>
                <input type="file"
                       name="front_image"
                       class="form-control"
                       accept="image/*"
                       <?php echo e($kyc ? '' : 'required'); ?>>
              <?php endif; ?>
            </div>

            
            <div class="col-md-4 <?php echo e((old('document_type', $kyc->document_type ?? '') === 'aadhaar') ? '' : 'd-none'); ?>"
                 id="backImageBox">

              <label class="form-label">Document Back Image</label>

              <?php if($kyc && $kyc->back_image): ?>
                <div class="mb-1">
                  <a href="<?php echo e(asset('storage/kyc/'.$kyc->back_image)); ?>" target="_blank">
                    View current
                  </a>
                </div>
              <?php endif; ?>

              <?php if(!$isPending): ?>
                <input type="file"
                       name="back_image"
                       class="form-control"
                       accept="image/*">
              <?php endif; ?>
            </div>

            
            <div class="col-12">
              <?php if(!$isPending): ?>
                <button class="btn btn-primary">
                  <?php echo e($kyc ? 'Update KYC' : 'Submit KYC'); ?>

                </button>
              <?php endif; ?>

              <a href="<?php echo e(route('merchant.index')); ?>" class="btn btn-secondary">
                Back
              </a>
            </div>

          </form>
        </div>
      </div>

    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const type = document.getElementById('document_type');
    const backBox = document.getElementById('backImageBox');

    if (!type) return;

    function toggleBack() {
        backBox.classList.add('d-none');
        if (type.value === 'aadhaar') {
            backBox.classList.remove('d-none');
        }
    }

    toggleBack();
    type.addEventListener('change', toggleBack);
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/merchant_panel/kyc_form.blade.php ENDPATH**/ ?>