<div class="content-wrapper">

<div class="card">
 <div class="card-header">
    <h3 class="card-title">Cities List</h3>
    <a href="<?php echo e(route('cities.create')); ?>" class="btn btn-success float-right">Add City</a>
</div>

    <div class="card-body">
        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>City Name</th>
                    <th>State</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($city->name); ?></td>
                    <td><?php echo e($city->state_name); ?></td>
                    <td><?php echo e($city->status); ?></td>
                    <td><?php echo e($city->created_at); ?></td>
                    <td>
                        <a href="<?php echo e(route('cities.edit', $city->id)); ?>" class="btn btn-primary btn-sm">Edit</a>
                        <form action="<?php echo e(route('cities.destroy', $city->id)); ?>" method="POST" style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm"
                                onclick="return confirm('Are you sure to deactivate this city?')">Deactivate</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<script>
$(function () {
    $("#example1").DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
</script>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/cities/citieslisting.blade.php ENDPATH**/ ?>