<div class="content-wrapper">
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12"><!-- full width -->
        <div class="card card-primary">

          <div class="card-header">
            <h3 class="card-title">Commission Settings</h3>
          </div>

          <form method="POST" action="<?php echo e(route('admin.settings.save')); ?>">
            <?php echo csrf_field(); ?>

            <div class="card-body">

              <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
              <?php endif; ?>

              <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                  <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
                </div>
              <?php endif; ?>

              
              <div class="form-group">
                <label>Referral Income</label>
                <div class="input-group">
                  <input type="number" step="0.01"
                         name="referral_income"
                         class="form-control"
                         placeholder="Enter referral income"
                         value="<?php echo e(old('referral_income', $settings['referral_income'] ?? 0)); ?>">
                  <div class="input-group-append">
                    <span class="input-group-text">%</span>
                  </div>
                </div>
              </div>

              
              <div class="form-group">
                <label>First Booking Income</label>
                <div class="input-group">
                  <input type="number" step="0.01"
                         name="first_booking_income"
                         class="form-control"
                         placeholder="Enter first booking income"
                         value="<?php echo e(old('first_booking_income', $settings['first_booking_income'] ?? 0)); ?>">
                  <div class="input-group-append">
                    <span class="input-group-text">%</span>
                  </div>
                </div>
              </div>

              
              <div class="form-group">
                <label>Admin Commission</label>
                <div class="input-group">
                  <input type="number" step="0.01"
                         name="admin_commission"
                         class="form-control"
                         placeholder="Enter admin commission"
                         value="<?php echo e(old('admin_commission', $settings['admin_commission'] ?? 0)); ?>">
                  <div class="input-group-append">
                    <span class="input-group-text">%</span>
                  </div>
                </div>
              </div>

            </div>

            <div class="card-footer">
              <button type="submit" class="btn btn-primary">
                Save Settings
              </button>
            </div>

          </form>

        </div>
      </div>
    </div>
  </div>
</section>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/extra_services/settings.blade.php ENDPATH**/ ?>