<div class="content-wrapper">
  <div class="card">
    <div class="card-header">
      <h3 class="card-title">Localities List</h3>
      <a href="<?php echo e(route('localities.create')); ?>" class="btn btn-success float-right">Add Locality</a>
    </div>
    <div class="card-body">
      <table id="example1" class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>#</th>
            <th>Locality Name</th>
            <th>City</th>
            <th>State</th>
            <th>Status</th>
            <th>Created At</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $localities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td><?php echo e($locality->name); ?></td>
            <td><?php echo e($locality->city_name); ?></td>
            <td><?php echo e($locality->state_name); ?></td>
            <td><?php echo e($locality->status); ?></td>
            <td><?php echo e($locality->created_at); ?></td>
            <td>
              <a href="<?php echo e(route('localities.edit', $locality->id)); ?>" class="btn btn-primary btn-sm">Edit</a>
              <form action="<?php echo e(route('localities.destroy', $locality->id)); ?>" method="POST" style="display:inline;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger btn-sm"
                  onclick="return confirm('Are you sure you want to deactivate this locality?')">Deactivate</button>
              </form>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/localities/localitylisting.blade.php ENDPATH**/ ?>