<div class="content-wrapper">

<div class="card">
<div class="card-header">
    <h3 class="card-title">Pending Bank Accounts</h3>
</div>

<div class="card-body">

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<table id="bankTable" class="table table-bordered table-striped">
<thead>
<tr>
    <th>#</th>
    <th>Merchant</th>
    <th>Bank</th>
    <th>Account</th>
    <th>IFSC</th>
    <th>Requested</th>
    <th>Action</th>
</tr>
</thead>

<tbody>
<?php $__empty_1 = true; $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<tr>
    <td><?php echo e($loop->iteration); ?></td>

    <td>
        <strong><?php echo e($b->merchant_name); ?></strong><br>
        <small class="text-muted"><?php echo e($b->merchant_email); ?></small>
    </td>

    <td><?php echo e($b->bank_name); ?></td>

    <td>
        <?php echo e($b->name_in_bank); ?><br>
        <small class="text-muted">
            ****<?php echo e(substr($b->account_number, -4)); ?>

        </small>
    </td>

    <td><?php echo e($b->ifsc); ?></td>

    <td><?php echo e($b->created_at); ?></td>

    <td>
        <form method="POST"
              action="<?php echo e(route('admin.bank.accounts.approve', $b->id)); ?>"
              style="display:inline">
            <?php echo csrf_field(); ?>
            <button class="btn btn-success btn-sm"
                onclick="return confirm('Approve this bank account?')">
                Approve
            </button>
        </form>

        <form method="POST"
              action="<?php echo e(route('admin.bank.accounts.reject', $b->id)); ?>"
              style="display:inline">
            <?php echo csrf_field(); ?>
            <button class="btn btn-danger btn-sm"
                onclick="return confirm('Reject this bank account?')">
                Reject
            </button>
        </form>
    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<tr>
    <td colspan="7" class="text-center text-muted">
        No pending bank accounts found.
    </td>
</tr>
<?php endif; ?>
</tbody>
</table>

</div>
</div>

</div>

<script>
$(function () {
    $("#bankTable").DataTable({
        responsive: true,
        lengthChange: false,
        autoWidth: false
    });
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/properties/merchant_bank_accounts_listing.blade.php ENDPATH**/ ?>