
<div class="content-wrapper">
  <div class="card">
    <div class="card-header">
      <h3 class="card-title">Withdrawals</h3>

      <div class="float-right">
        <a href="<?php echo e(route('withdrawals.index')); ?>" class="btn <?php echo e(empty($status) ? 'btn-primary' : 'btn-outline-secondary'); ?> btn-sm">All</a>
        <a href="<?php echo e(route('withdrawals.index',['status'=>'pending'])); ?>" class="btn <?php echo e(($status=='pending')?'btn-primary':'btn-outline-secondary'); ?> btn-sm">Pending</a>
        <a href="<?php echo e(route('withdrawals.index',['status'=>'approved'])); ?>" class="btn <?php echo e(($status=='approved')?'btn-primary':'btn-outline-secondary'); ?> btn-sm">Approved</a>
        <a href="<?php echo e(route('withdrawals.index',['status'=>'rejected'])); ?>" class="btn <?php echo e(($status=='rejected')?'btn-primary':'btn-outline-secondary'); ?> btn-sm">Rejected</a>
      </div>
    </div>

    <div class="card-body">
      <table id="withdrawalsTable" class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>User</th>
            <th>Amount</th>
            <th>Bank (acct)</th>
            <th>Status</th>
            <th>Created</th>
            <th>Admin Note</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
  <td><?php echo e($loop->iteration); ?></td>
              <td>
                <?php echo e($w->user_name ?? 'User #' . ($w->user_id ?? '')); ?><br>
                <small class="text-muted"><?php echo e($w->user_email ?? ''); ?></small>
              </td>
              <td><?php echo e(number_format((float)$w->amount, 2)); ?></td>
              <td>
                <?php if($w->bank_name): ?>
                  <strong><?php echo e($w->bank_name); ?></strong><br>
                  <small><?php echo e($w->name_in_bank ?? ''); ?> • ****<?php echo e($w->bank_account_number ? substr($w->bank_account_number, -4) : '----'); ?></small><br>
                  <small class="text-muted"><?php echo e($w->ifsc ?? ''); ?></small>
                <?php else: ?>
                  <small class="text-muted">No bank</small>
                <?php endif; ?>
              </td>
              <td>
                <?php if($w->status === 'pending'): ?>
                  <span class="badge badge-warning">Pending</span>
                <?php elseif($w->status === 'approved'): ?>
                  <span class="badge badge-success">Approved</span>
                <?php else: ?>
                  <span class="badge badge-danger">Rejected</span>
                <?php endif; ?>
              </td>
              <td><?php echo e($w->created_at); ?></td>
              <td><?php echo e($w->admin_note); ?></td>
              <td>
                <?php if($w->status === 'pending'): ?>
                  <form action="<?php echo e(route('withdrawals.approve', $w->id)); ?>" method="POST" style="display:inline;" onsubmit="return adminNotePrompt(this)">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="admin_note" value="">
                    <button class="btn btn-success btn-sm">Approve</button>
                  </form>

                  <form action="<?php echo e(route('withdrawals.reject', $w->id)); ?>" method="POST" style="display:inline;" onsubmit="return adminNotePrompt(this)">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="admin_note" value="">
                    <button class="btn btn-danger btn-sm">Reject</button>
                  </form>
                <?php else: ?>
                  <span class="text-muted">No action</span>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
</div>


<script>
$(function () {
    $("#withdrawalsTable").DataTable({
        responsive: true,
        lengthChange: false,
        autoWidth: false,
        buttons: ["copy","csv","excel","pdf","print"]
    }).buttons().container().appendTo('#withdrawalsTable_wrapper .col-md-6:eq(0)');
});

function adminNotePrompt(form) {
    var note = prompt("Enter admin note (required):");
    if (!note || !note.trim()) {
        alert('Admin note is required.');
        return false;
    }
    form.querySelector('input[name="admin_note"]').value = note.trim();
    return true;
}
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/users/withdrawals.blade.php ENDPATH**/ ?>