
<?php
    use Illuminate\Support\Str;
?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">My Properties</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                <li class="breadcrumb-item active">My Properties</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-12">
                    <div class="">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="row gallery-wrapper">
                                        <?php $__empty_1 = true; $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php
                                                // first image filename stored as 'first_image' by controller (filename or absolute URL)
                                                $imagePath = $ad->first_image ?? null;

                                                // prefer env-defined base path (CDN/public URL)
                                                $imageBase = rtrim(env('PROPERTIES_IMAGE_PATH', ''), '/');

                                                if (!empty($imagePath)) {
                                                    // if DB already contains an absolute URL, use it
                                                    if (preg_match('/^https?:\/\//i', $imagePath)) {
                                                        $imageUrl = $imagePath;
                                                    }
                                                    // if we have an env base, use it (best for CDN / external host)
                                                    elseif (!empty($imageBase)) {
                                                        $imageUrl = $imageBase . '/' . ltrim($imagePath, '/');
                                                    }
                                                    // fallback to storage path (legacy / local)
                                                    else {
                                                        $imageUrl = asset('storage/property_images/' . ltrim($imagePath, '/'));
                                                    }
                                                } else {
                                                    // no image: fallback placeholder
                                                    $imageUrl = asset('assets/images/small/img-1.jpg');
                                                }

                                                // created_at humanized
                                                try {
                                                    if (isset($ad->created_at) && $ad->created_at instanceof \Carbon\Carbon) {
                                                        $humanCreatedAt = $ad->created_at->diffForHumans();
                                                    } else {
                                                        $humanCreatedAt = \Carbon\Carbon::parse($ad->created_at ?? now())->diffForHumans();
                                                    }
                                                } catch (\Exception $e) {
                                                    $humanCreatedAt = $ad->created_at ?? '';
                                                }

                                                $priceFormatted = is_numeric($ad->price) ? number_format((float)$ad->price, 2) : number_format(0, 2);
                                                $isSold = !empty($ad->is_sold);

                                                // visible slug: slugified name + '-' + id
                                                $visibleSlug = Str::slug($ad->name ?? 'property-' . $ad->id) . '-' . $ad->id;
                                            ?>

                                            <div class="element-item col-xxl-3 col-xl-4 col-sm-6" data-category="user-ad">
                                                <div class="gallery-box card position-relative <?php echo e($isSold ? 'card-sold' : ''); ?>">

                                                    <!-- Three Dots Menu -->
                                                   <?php if(isset($ad->status) && $ad->status === 'active'): ?>
<div class="position-absolute top-0 end-0 p-2 dropdown-container" style="z-index: 50;">
    <div class="dropdown">
        <button class="btn btn-sm btn-light rounded-circle shadow-sm"
                type="button"
                data-bs-toggle="dropdown"
                aria-expanded="false"
                style="width: 32px; height: 32px; padding: 0;">
            <i class="ri-more-2-fill"></i>
        </button>

        <ul class="dropdown-menu dropdown-menu-end">

            <!-- EDIT -->
            <li>
                <a class="dropdown-item" href="<?php echo e(route('merchant.properties.edit', $visibleSlug)); ?>">
                    <i class="ri-edit-line me-2"></i>Edit
                </a>
            </li>

            <!-- SOFT DELETE -->
            <!-- <li>
                <a class="dropdown-item text-danger soft-delete-ad"
                   href="javascript:void(0);"
                   data-slug="<?php echo e($visibleSlug); ?>">
                    <i class="ri-delete-bin-line me-2"></i>Delete
                </a>
            </li> -->

        </ul>
    </div>
</div>
<?php endif; ?>


                                                    <!-- Status Badge -->
                                                    <div class="position-absolute top-0 start-0 p-2" style="z-index: 40;">
                                                        <?php if($isSold): ?>
                                                            <span class="badge bg-danger">Sold</span>
                                                        <?php elseif(isset($ad->status) && $ad->status == 'pending'): ?>
                                                            <span class="badge bg-warning">Pending</span>
                                                        <?php elseif(isset($ad->status) && $ad->status == 'active'): ?>
                                                            <span class="badge bg-success">Active</span>
                                                        <?php elseif(isset($ad->status) && $ad->status == 'inactive'): ?>
                                                            <span class="badge bg-secondary">Inactive</span>
                                                        <?php else: ?>
                                                            <span class="badge bg-dark"><?php echo e(isset($ad->status) ? ucfirst($ad->status) : 'Unknown'); ?></span>
                                                        <?php endif; ?>
                                                    </div>

                                                    <div class="gallery-container">
                                                        
                                                        <?php if($isSold): ?>
                                                            <a class="image-popup disabled" href="javascript:void(0);" title="<?php echo e($ad->name); ?>" aria-disabled="true" onclick="return false;">
                                                        <?php else: ?>
                                                            <a class="image-popup" href="<?php echo e($imageUrl); ?>" title="<?php echo e($ad->name); ?>">
                                                        <?php endif; ?>
                                                            <img class="gallery-img img-fluid mx-auto"
                                                                 src="<?php echo e($imageUrl); ?>"
                                                                 alt="<?php echo e($ad->name); ?>"
                                                                 style="height: 250px; object-fit: cover;" />
                                                            <div class="gallery-overlay">
                                                                <h5 class="overlay-caption"><?php echo e($ad->name); ?></h5>
                                                            </div>
                                                        </a>

                                                        <?php if($isSold): ?>
                                                            
                                                            <span class="sold-ribbon">Sold Out</span>
                                                            <div class="sold-overlay" aria-hidden="true"></div>
                                                        <?php endif; ?>
                                                    </div>

                                                    <div class="box-content">
                                                        <div class="mt-2">
                                                            <h6 class="mb-1"><?php echo e($ad->name); ?></h6>
                                                            <p class="text-muted mb-1 small">
                                                                <?php echo e($ad->address ?? ''); ?>

                                                            </p>
                                                            <p class="text-muted mb-2 small" style="height: 40px; overflow: hidden;">
                                                                <?php echo e(\Illuminate\Support\Str::limit($ad->summary ?? $ad->description ?? '', 80)); ?>

                                                            </p>
                                                        </div>
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div class="text-primary fw-bold">
                                                                
                                                                <?php echo e($ad->currency_name ?? '₹'); ?> <?php echo e($priceFormatted); ?>

                                                                <span class="text-muted small">/ <?php echo e(str_replace('_', ' ', $ad->price_unit ?? '')); ?></span>
                                                            </div>
                                                            <div class="text-muted small"><?php echo e($humanCreatedAt); ?></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="col-12">
                                                <div class="text-center py-5">
                                                    <i class="ri-home-4-line" style="font-size: 4rem; color: #ccc;"></i>
                                                    <h5 class="mt-3">No properties found</h5>
                                                    <p class="text-muted">You haven't listed any properties yet.</p>
                                                    <a href="<?php echo e(route('merchant.properties.create')); ?>" class="btn btn-primary">Create Your First Property</a>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <!-- end row -->
                                </div>
                            </div>
                            <!-- end row -->
                        </div>
                        <!-- end card body -->
                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->
</div>

<style>
/* Ensure the 3-dots dropdown sits above overlays and is clickable */
.gallery-box { position: relative; overflow: visible; }
.gallery-box .dropdown-container { pointer-events: auto; }
.gallery-box .dropdown-menu { z-index: 1080; } /* higher than overlays/modals if needed */

/* If your overlay captures clicks, prevent it from blocking the menu */
.gallery-container .gallery-overlay { pointer-events: none; }

/* Sold styling */
.card-sold { filter: grayscale(60%); opacity: .85; pointer-events: none; }
.card-sold .dropdown-container { pointer-events: auto; } /* keep menu clickable if you want, but we disabled actions */
.sold-ribbon {
    position: absolute;
    left: 12px;
    top: 12px;
    background: #c62828;
    color: #fff;
    padding: 6px 10px;
    font-weight: 700;
    font-size: 12px;
    border-radius: 4px;
    z-index: 30;
    text-transform: uppercase;
    letter-spacing: .5px;
}
.sold-overlay {
    position: absolute;
    inset: 0;
    background: rgba(0,0,0,0.35);
    z-index: 20;
}

/* Optionally ensure disabled image links look disabled */
.image-popup.disabled { cursor: default; opacity: .95; }

/* Prevent the disabled dropdown text from looking like a link */
.dropdown-item.disabled { cursor: not-allowed; }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // CSRF token helper: try to read meta tag, fallback to blade-inserted token
    const csrfMeta = document.querySelector('meta[name="csrf-token"]');
    const csrfToken = csrfMeta ? csrfMeta.content : '<?php echo e(csrf_token()); ?>';

    // Stop clicks inside dropdown from bubbling to wrappers (avoids accidental image-popup open)
    document.querySelectorAll('.dropdown-menu').forEach(menu => {
        menu.addEventListener('click', e => e.stopPropagation());
    });

    // Deactivate Property (example using slug)
    document.querySelectorAll('.deactivate-ad').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            const slug = this.dataset.slug;
            if (!slug) return;
            if (confirm('Are you sure you want to deactivate this property?')) {
                fetch(`/merchant/properties/deactivate/${slug}`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': csrfToken,
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({})
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert(data.message || 'Failed to deactivate property');
                    }
                })
                .catch(err => {
                    console.error(err);
                    alert('An error occurred');
                });
            }
        });
    });

    // Delete Property (example using slug)
  




});
</script>
<!-- Remove the existing script blocks and add this single script block -->
<script>
document.addEventListener('click', function (e) {

    const deleteBtn = e.target.closest('.soft-delete-ad');
    if (!deleteBtn) return;

    e.preventDefault();
    e.stopPropagation(); // stop Bootstrap dropdown

    const slug = deleteBtn.dataset.slug;
    const csrfToken = document.querySelector('meta[name="csrf-token"]').content;

    console.log('Delete clicked:', slug);

    const confirmDelete = confirm('Are you sure you want to delete this property?');

    if (!confirmDelete) return;

    fetch(`/merchant/properties/delete/${slug}`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': csrfToken,
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            alert('Property deleted successfully');
            location.reload();
        } else {
            alert(data.message || 'Delete failed');
        }
    })
    .catch(err => {
        console.error(err);
        alert('Network error');
    });

});
</script>

<?php /**PATH /var/www/html/pc/hide/resources/views/merchant_panel/my_properties.blade.php ENDPATH**/ ?>