<div class="content-wrapper">
<section class="content">
<div class="card card-primary">
<div class="card-header">
<h3><?php echo e(isset($coupon) ? 'Edit Coupon' : 'Add Coupon'); ?></h3>
</div>

<form method="POST" action="<?php echo e(isset($coupon) ? route('coupons.update',$coupon->id) : route('coupons.store')); ?>">
<?php echo csrf_field(); ?>
<?php if(isset($coupon)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

<div class="card-body">

  <div class="form-group">
    <label>Coupon Name</label>
    <input type="text" name="name" class="form-control"
           value="<?php echo e($coupon->name ?? ''); ?>"
           placeholder="Eg: New Year Offer">
  </div>

  <?php if(isset($coupon)): ?>
  <div class="form-group">
    <label>Coupon Code</label>
    <input type="text" class="form-control"
           value="<?php echo e($coupon->coupon_code); ?>"
           readonly>
  </div>
  <?php endif; ?>

  <div class="form-group">
    <label>Expiry Date</label>
    <input type="date" name="expiry_date"
           class="form-control"
           value="<?php echo e($coupon->expiry_date ?? ''); ?>">
  </div>

  <div class="form-group">
    <label>Value</label>
    <input type="number" name="value" class="form-control"
           value="<?php echo e($coupon->value ?? ''); ?>">
  </div>

  <div class="form-group">
    <label>Type</label>
    <select name="type" class="form-control">
      <option value="flat" <?php echo e((isset($coupon) && $coupon->type=='flat')?'selected':''); ?>>Flat</option>
      <option value="percentage" <?php echo e((isset($coupon) && $coupon->type=='percentage')?'selected':''); ?>>Percentage</option>
    </select>
  </div>

  <div class="form-group">
    <label>Status</label>
    <select name="status" class="form-control">
      <option value="active" <?php echo e((isset($coupon) && $coupon->status=='active')?'selected':''); ?>>Active</option>
      <option value="inactive" <?php echo e((isset($coupon) && $coupon->status=='inactive')?'selected':''); ?>>Inactive</option>
      <option value="used" <?php echo e((isset($coupon) && $coupon->status=='used')?'selected':''); ?>>Used</option>
    </select>
  </div>

</div>


<div class="card-footer">
<button class="btn btn-primary">Submit</button>
</div>
</form>
</div>
</section>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/users/coupons_form.blade.php ENDPATH**/ ?>