<div class="content-wrapper">
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-12"><!-- full width -->
          <div class="card card-primary">
            <div class="card-header">
              <h3 class="card-title"><?php echo e(isset($property) ? 'Edit Property' : 'Add Property'); ?></h3>
            </div>

            <form id="quickForm" method="POST" 
                  action="<?php echo e(isset($property) ? route('properties.update', $property->id) : route('properties.store')); ?>" 
                  enctype="multipart/form-data">
              <?php echo csrf_field(); ?>
              <?php if(isset($property)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

              <div class="card-body">

                <!-- Place name -->
                <div class="form-group">
                  <label for="name">Place Name</label>
                  <input type="text" name="name" value="<?php echo e(old('name', $property->name ?? '')); ?>" 
                         class="form-control" id="name" placeholder="Enter Place Name">
                  <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- State / City / Locality -->
                <div class="row">
                  <div class="col-md-4 form-group">
                    <label for="state_id">State</label>
                    <select name="state_id" id="state_id" class="form-control">
                      <option value="">Select State</option>
                      <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($st->id); ?>" 
                          <?php echo e(old('state_id', $property->state_id ?? '') == $st->id ? 'selected' : ''); ?>>
                          <?php echo e($st->name); ?>

                        </option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>

                  <div class="col-md-4 form-group">
                    <label for="city_id">City</label>
                    <select name="city_id" id="city_id" class="form-control">
                      <option value="">Select City</option>
                      <?php if(isset($cities)): ?>
                        <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($ct->id); ?>" 
                            <?php echo e(old('city_id', $property->city_id ?? '') == $ct->id ? 'selected' : ''); ?>>
                            <?php echo e($ct->name); ?>

                          </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      <?php endif; ?>
                    </select>
                    <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>

                  <div class="col-md-4 form-group">
                    <label for="locality_id">Locality</label>
                    <select name="locality_id" id="locality_id" class="form-control">
                      <option value="">Select Locality</option>
                      <?php if(isset($localities)): ?>
                        <?php $__currentLoopData = $localities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($loc->id); ?>" 
                            <?php echo e(old('locality_id', $property->locality_id ?? '') == $loc->id ? 'selected' : ''); ?>>
                            <?php echo e($loc->name); ?>

                          </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      <?php endif; ?>
                    </select>
                    <?php $__errorArgs = ['locality_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                </div>

                <!-- Address -->
                <div class="form-group">
                  <label for="address">Accurate Location / Address</label>
                  <input type="text" name="address" value="<?php echo e(old('address', $property->address ?? '')); ?>" 
                         class="form-control" id="address" placeholder="House no, building etc.">
                  <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Price -->
                <div class="row">
                  <div class="col-md-6 form-group">
                    <label for="price">Price (₹)</label>
                    <input type="number" step="0.01" name="price" 
                           value="<?php echo e(old('price', $property->price ?? 0)); ?>" 
                           class="form-control" id="price" placeholder="0.00">
                    <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                  <div class="col-md-6 form-group">
                    <label for="price_unit">Price Unit</label>
                    <select name="price_unit" id="price_unit" class="form-control">
                      <option value="per_hour" <?php echo e(old('price_unit', $property->price_unit ?? '') == 'per_hour' ? 'selected':''); ?>>Per Hour</option>
                      <option value="per_day" <?php echo e(old('price_unit', $property->price_unit ?? '') == 'per_day' ? 'selected':''); ?>>Per Day</option>
                      <option value="one_time" <?php echo e(old('price_unit', $property->price_unit ?? '') == 'one_time' ? 'selected':''); ?>>One Time</option>
                    </select>
                  </div>
                </div>

                <!-- Extra Services -->
                <div class="form-group">
                  <label>Extra Services</label>
                  <div class="row">
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="col-md-3">
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" name="extra_services[]" 
                                 value="<?php echo e($s->id); ?>" id="service_<?php echo e($s->id); ?>"
                                 <?php echo e(in_array($s->id, old('extra_services', $selectedServices ?? [])) ? 'checked' : ''); ?>>
                          <label class="form-check-label" for="service_<?php echo e($s->id); ?>">
                            <?php echo e($s->name); ?> (₹<?php echo e(number_format($s->price,2)); ?>)
                          </label>
                        </div>
                      </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>

                <!-- Google Map -->
                <div class="form-group">
                  <label>Pick Location on Map (optional)</label>
                  <div id="map" style="height:300px;border:1px solid #ddd;"></div>
                  <small class="form-text text-muted">Drag marker or click map to set location. Enter address above too.</small>
                  <input type="hidden" name="latitude" id="latitude" value="<?php echo e(old('latitude', $property->latitude ?? '')); ?>">
                  <input type="hidden" name="longitude" id="longitude" value="<?php echo e(old('longitude', $property->longitude ?? '')); ?>">
                </div>

                <!-- Images -->
                <div class="form-group">
                  <label for="images">Images (up to 6)</label>
                  <input type="file" name="images[]" id="images" class="form-control" multiple accept="image/*">
                  <small class="text-muted">Upload up to 6 images (jpg, png, gif, max 5MB each).</small>
                  <?php $__errorArgs = ['images'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                  <div id="imagePreview" style="margin-top:8px;"></div>

                  <?php if(isset($property) && isset($property->images)): ?>
                    <div style="margin-top:8px;">
                      <label>Existing Images</label><br>
                      <?php $__currentLoopData = $property->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div style="display:inline-block;margin-right:6px;position:relative">
                          <img src="<?php echo e(asset('storage/uploads/properties/'.$property->id.'/'.$img->filename)); ?>" 
                               style="width:120px;height:80px;object-fit:cover;border:1px solid #ddd" />
                        </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                  <?php endif; ?>
                </div>

              </div>

              <div class="card-footer">
                <a href="<?php echo e(route('properties.index')); ?>" class="btn btn-secondary">Back</a>
                <button type="submit" class="btn btn-primary"><?php echo e(isset($property) ? 'Update' : 'Submit'); ?></button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>




<!-- Ensure jQuery is loaded first -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
// Check if jQuery is loaded
if (typeof jQuery === 'undefined') {
  console.error('jQuery is not loaded!');
  alert('jQuery is required for this form to work properly.');
} else {
  console.log('jQuery loaded successfully');
}

$(document).ready(function () {
  console.log('Document ready - starting initialization');
  
  // FIXED: Use the correct route URLs that match your web.php routes
  var getCitiesBase = "<?php echo e(url('admin/get-cities')); ?>";
  var getLocalitiesBase = "<?php echo e(url('admin/get-localities')); ?>";
  
  console.log('Base URLs:', {cities: getCitiesBase, localities: getLocalitiesBase});

  // Function to load cities based on state selection
  function loadCities(stateId, selectedCityId = null) {
    if (!stateId) {
      $('#city_id').html('<option value="">Select City</option>');
      $('#locality_id').html('<option value="">Select Locality</option>');
      return;
    }
    
    $('#city_id').html('<option value="">Loading cities...</option>');
    $('#locality_id').html('<option value="">Select Locality</option>'); // Reset localities
    
    $.ajax({
      url: getCitiesBase + '/' + stateId,
      method: 'GET',
      dataType: 'json', // ADDED: Explicitly expect JSON response
      success: function(response) {
        console.log('Cities response:', response); // DEBUG: Add logging
        
        if (response.success && response.data && response.data.length > 0) {
          var options = '<option value="">Select City</option>';
          $.each(response.data, function(index, city) {
            var selected = (selectedCityId && selectedCityId == city.id) ? 'selected' : '';
            options += '<option value="' + city.id + '" ' + selected + '>' + city.name + '</option>';
          });
          $('#city_id').html(options);
          
          // If we set a selected city, trigger change to load localities
          if (selectedCityId) {
            $('#city_id').trigger('change');
          }
        } else {
          $('#city_id').html('<option value="">No cities found</option>');
        }
      },
      error: function(xhr, status, error) {
        console.error('Error loading cities:', xhr.responseText); // DEBUG: Better error logging
        $('#city_id').html('<option value="">Error loading cities</option>');
      }
    });
  }

  // Function to load localities based on city selection
  function loadLocalities(cityId, selectedLocalityId = null) {
    if (!cityId) {
      $('#locality_id').html('<option value="">Select Locality</option>');
      return;
    }
    
    $('#locality_id').html('<option value="">Loading localities...</option>');
    
    $.ajax({
      url: getLocalitiesBase + '/' + cityId,
      method: 'GET',
      dataType: 'json', // ADDED: Explicitly expect JSON response
      success: function(response) {
        console.log('Localities response:', response); // DEBUG: Add logging
        
        if (response.success && response.data && response.data.length > 0) {
          var options = '<option value="">Select Locality</option>';
          $.each(response.data, function(index, locality) {
            var selected = (selectedLocalityId && selectedLocalityId == locality.id) ? 'selected' : '';
            options += '<option value="' + locality.id + '" ' + selected + '>' + locality.name + '</option>';
          });
          $('#locality_id').html(options);
        } else {
          $('#locality_id').html('<option value="">No localities found</option>');
        }
      },
      error: function(xhr, status, error) {
        console.error('Error loading localities:', xhr.responseText); // DEBUG: Better error logging
        $('#locality_id').html('<option value="">Error loading localities</option>');
      }
    });
  }

  // Event handlers for dropdown changes - with more robust error checking
  $('#state_id').on('change', function() {
    var stateId = $(this).val();
    console.log('State changed to:', stateId);
    
    if (stateId) {
      console.log('About to call loadCities with state ID:', stateId);
      loadCities(stateId);
    } else {
      console.log('No state selected, clearing dropdowns');
      $('#city_id').html('<option value="">Select City</option>');
      $('#locality_id').html('<option value="">Select Locality</option>');
    }
  });

  $('#city_id').on('change', function() {
    var cityId = $(this).val();
    console.log('City changed to:', cityId);
    
    if (cityId) {
      console.log('About to call loadLocalities with city ID:', cityId);
      loadLocalities(cityId);
    } else {
      console.log('No city selected, clearing localities');
      $('#locality_id').html('<option value="">Select Locality</option>');
    }
  });

  // FIXED: Auto-load in Edit mode with proper timing
  var initialStateId = $('#state_id').val();
  var initialCityId = "<?php echo e(old('city_id', isset($property) ? $property->city_id : '')); ?>";
  var initialLocalityId = "<?php echo e(old('locality_id', isset($property) ? $property->locality_id : '')); ?>";

  console.log('Initial values:', {state: initialStateId, city: initialCityId, locality: initialLocalityId}); // DEBUG

  if (initialStateId) {
    // Load cities first
    loadCities(initialStateId, initialCityId);
    
    // If we have an initial city, load localities after cities are loaded
    if (initialCityId) {
      // Use a longer timeout to ensure cities are loaded first
      setTimeout(function() {
        loadLocalities(initialCityId, initialLocalityId);
      }, 1000);
    }
  }
});
</script>

<!-- Google Maps (replace YOUR_API_KEY) -->
<script async defer src="https://maps.googleapis.com/maps/api/js?key=YOUR_GOOGLE_MAPS_API_KEY&callback=initMap"></script>
<?php /**PATH C:\xampp\htdocs\laravel_project\resources\views/properties/form.blade.php ENDPATH**/ ?>