<div class="content-wrapper">

<div class="card">
 <div class="card-header">
    <h3 class="card-title">Properties</h3>
    <a href="<?php echo e(route('properties.create')); ?>" class="btn btn-success float-right">Add Property</a>
</div>

    <div class="card-body">
        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Place Name</th>
                    <th>Location</th>
                    <th>Price</th>
                    <th>Services</th>
                    <th>Images</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
           <tbody>
    <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td><?php echo e($property->name); ?></td>
        <td>
          <?php echo e($property->state_name ?? ''); ?> / <?php echo e($property->city_name ?? ''); ?>

          <?php if($property->locality_name): ?> <br><small><?php echo e($property->locality_name); ?></small> <?php endif; ?>
          <?php if($property->address): ?> <div><small><?php echo e($property->address); ?></small></div> <?php endif; ?>
        </td>
        <td>₹<?php echo e(number_format($property->price,2)); ?> <br><small><?php echo e(ucfirst(str_replace('_',' ',$property->price_unit))); ?></small></td>
        <td>
            <?php
                $serviceNames = \DB::table('property_extra_service as pes')
                    ->join('extra_services as es','pes.service_id','es.id')
                    ->where('pes.property_id', $property->id)
                    ->pluck('es.name')->toArray();
            ?>
            <?php if(count($serviceNames)): ?>
                <?php echo e(implode(', ', $serviceNames)); ?>

            <?php else: ?>
                <small class="text-muted">-</small>
            <?php endif; ?>
        </td>
        <td>
            <?php
              $imgs = \DB::table('property_images')->where('property_id',$property->id)->limit(3)->get();
            ?>
            <?php $__currentLoopData = $imgs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <img src="<?php echo e(asset('storage/uploads/properties/'.$property->id.'/'.$img->filename)); ?>" style="width:60px;height:40px;object-fit:cover;margin-right:4px;border:1px solid #ddd" />
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </td>
        <td>
          <?php if($property->status === 'active'): ?>
            <span class="badge badge-success">Active</span>
          <?php else: ?>
            <span class="badge badge-secondary">Inactive</span>
          <?php endif; ?>
        </td>
        <td><?php echo e($property->created_at); ?></td>
        <td>
            <a href="<?php echo e(route('properties.edit', $property->id)); ?>" class="btn btn-primary btn-sm">Edit</a>

            <form action="<?php echo e(route('properties.destroy', $property->id)); ?>" method="POST" style="display:inline;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger btn-sm"
                    onclick="return confirm('Are you sure you want to deactivate this property?')">Deactivate</button>
            </form>
        </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
        </table>
    </div>
</div>

<script>
$(function () {
    $("#example1").DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
</script>
</div>
<?php /**PATH C:\xampp\htdocs\laravel_project\resources\views/properties/listing.blade.php ENDPATH**/ ?>