
<?php
    // Base image path from config/app.php or .env
    $propertiesBase = config('app.properties_image_path') ?: env('PROPERTIES_IMAGE_PATH', null);
    $propertiesBase = $propertiesBase ? rtrim($propertiesBase, '/') : null;
?>

<div class="content-wrapper">

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Properties</h3>
            <a href="<?php echo e(route('properties.create')); ?>" class="btn btn-success float-right">Add Property</a>
        </div>

        <div class="card-body">
            
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">&times;</button>
                </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">&times;</button>
                </div>
            <?php endif; ?>

            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Place Name</th>
                        <th>Location</th>
                        <th>Price</th>
                        <th>Images</th>
                        <th>Status</th>
                        <th>Created At</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>

                        <td><?php echo e($property->name); ?></td>

                        <td>
                            <?php echo e($property->state_name ?? ''); ?> / <?php echo e($property->city_name ?? ''); ?>

                            <?php if(!empty($property->locality_name)): ?>
                                <br><small><?php echo e($property->locality_name); ?></small>
                            <?php endif; ?>
                            <?php if(!empty($property->address)): ?>
                                <div><small><?php echo e($property->address); ?></small></div>
                            <?php endif; ?>
                        </td>

                        <td>
                            ₹<?php echo e(number_format($property->price ?? 0, 2)); ?>

                            <br>
                            <small><?php echo e(ucfirst(str_replace('_',' ',$property->price_unit ?? ''))); ?></small>
                        </td>

                     

                        <td>
                            <?php
                                $imgs = \DB::table('property_images')
                                    ->where('property_id', $property->id)
                                    ->orderBy('id')
                                    ->limit(3)
                                    ->get();
                            ?>

                            <?php if($imgs->count()): ?>
                                <?php $__currentLoopData = $imgs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        // If base provided, assume images stored at {BASE}/{property_id}/{filename}
                                        if ($propertiesBase) {
                                            $imgUrl = $propertiesBase . '/'  . ltrim($img->filename, '/');
                                        } else {
                                            // fallback to previous path you used
                                            $imgUrl = asset('storage/uploads/properties/' . $property->id . '/' . ltrim($img->filename, '/'));
                                        }
                                    ?>

                                    <img src="<?php echo e($imgUrl); ?>" alt="img" style="width:60px;height:40px;object-fit:cover;margin-right:4px;border:1px solid #ddd" />
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <small class="text-muted">No images</small>
                            <?php endif; ?>
                        </td>

                        <td>
                            <?php if($property->status === 'active'): ?>
                                <span class="badge badge-success">Active</span>
                            <?php elseif($property->status === 'pending'): ?>
                                <span class="badge badge-warning">Pending</span>
                            <?php elseif($property->status === 'reject' || $property->status === 'rejected'): ?>
                                <span class="badge badge-danger">Rejected</span>
                            <?php else: ?>
                                <span class="badge badge-secondary"><?php echo e(ucfirst($property->status)); ?></span>
                            <?php endif; ?>
                        </td>

                        <td><?php echo e($property->created_at); ?></td>

                       <?php
    // build visible slug: slugified name + '-' + id
    $visibleSlug = \Illuminate\Support\Str::slug($property->name ?? 'property-'.$property->id) . '-' . $property->id;
?>

<td>
    <div class="d-flex flex-column gap-1">
        
        <a href="<?php echo e(route('properties.show', $visibleSlug)); ?>" class="btn btn-info btn-sm" title="View full ad">View</a>

        <?php if($property->status === 'pending'): ?>
            <form action="<?php echo e(route('admin.properties.approve', $visibleSlug)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-sm btn-primary mt-2 w-100"
                    onclick="return confirm('Approve this property?')">Approve</button>
            </form>

            <form action="<?php echo e(route('admin.properties.reject', $visibleSlug)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-sm btn-danger mt-2 w-100"
                    onclick="return confirm('Reject this property?')">Reject</button>
            </form>
        <?php else: ?>
            <a href="<?php echo e(route('properties.edit', $visibleSlug)); ?>" class="btn btn-primary btn-sm mt-2">Edit</a>

            <form action="<?php echo e(route('properties.destroy', $visibleSlug)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger btn-sm mt-2"
                    onclick="return confirm('Are you sure you want to deactivate this property?')">Deactivate</button>
            </form>
        <?php endif; ?>
    </div>
</td>


                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

        </div>
    </div>

</div>


<script>
    $(function () {
        $("#example1").DataTable({
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    });
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/properties/listing.blade.php ENDPATH**/ ?>