<div class="content-wrapper">

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12"><!-- use full width like your original -->
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title"><?php echo e(isset($service) ? 'Edit Service' : 'Add Service'); ?></h3>
          </div>
          <form id="quickForm" method="POST" action="<?php echo e(isset($service) ? route('extra-services.update', $service->id) : route('extra-services.store')); ?>">
            <?php echo csrf_field(); ?>
            <?php if(isset($service)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <div class="card-body">
              <div class="form-group">
                <label for="name">Service Name</label>
                <input type="text" name="name" value="<?php echo e(old('name', $service->name ?? '')); ?>" class="form-control" id="name" placeholder="Enter Service Name">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="form-group">
                <label for="price">Price (₹)</label>
                <input type="number" step="0.01" name="price" value="<?php echo e(old('price', $service->price ?? 0)); ?>" class="form-control" id="price" placeholder="0.00">
                <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="form-group">
                <label for="price_type">Price Type</label>
                <select name="price_type" class="form-control" id="price_type">
                  <option value="per_day" <?php echo e((old('price_type', $service->price_type ?? '')=='per_day')?'selected':''); ?>>Per Day</option>
                  <option value="one_time" <?php echo e((old('price_type', $service->price_type ?? '')=='one_time')?'selected':''); ?>>One Time</option>
                </select>
                <?php $__errorArgs = ['price_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="form-group">
                <label for="status">Status</label>
                <select name="status" class="form-control" id="status">
                  <option value="active" <?php echo e((old('status', $service->status ?? '')=='active')?'selected':''); ?>>Active</option>
                  <option value="inactive" <?php echo e((old('status', $service->status ?? '')=='inactive')?'selected':''); ?>>Inactive</option>
                </select>
                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="form-group">
                <label for="description">Description (optional)</label>
                <textarea name="description" id="description" class="form-control" rows="3"><?php echo e(old('description', $service->description ?? '')); ?></textarea>
              </div>

            </div>
            <div class="card-footer">
              <a href="<?php echo e(route('extra-services.index')); ?>" class="btn btn-secondary">Back</a>
              <button type="submit" class="btn btn-primary"><?php echo e(isset($service) ? 'Update' : 'Submit'); ?></button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

  </div>

<script>
$(function () {
  $('#quickForm').validate({
    rules: {
      name: { required: true },
      price: { required: true, number: true, min: 0 },
      price_type: { required: true },
      status: { required: true }
    },
    messages: {
      name: "Please enter service name",
      price: "Please enter a valid price",
      price_type: "Please select price type",
      status: "Please select status"
    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight: function (element) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/extra_services/form.blade.php ENDPATH**/ ?>