<?php
    // Base KYC image path from .env / config
    $kycBase = config('app.kyc_image_path') ?: env('KYC_IMAGE_PATH');
?>

<div class="content-wrapper">

<div class="card">
<div class="card-header">
    <h3 class="card-title">Merchant KYC Details</h3>
    <a href="<?php echo e(route('admin.kyc.index')); ?>" class="btn btn-secondary float-right">
        Back
    </a>
</div>

<div class="card-body">

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<table class="table table-bordered">
    <tr>
        <th>Merchant Name</th>
        <td><?php echo e($kyc->merchant_name); ?></td>
    </tr>
    <tr>
        <th>Email</th>
        <td><?php echo e($kyc->merchant_email); ?></td>
    </tr>
    <tr>
        <th>Phone</th>
        <td><?php echo e($kyc->phone_no); ?></td>
    </tr>
    <tr>
        <th>Document Type</th>
        <td><?php echo e(ucfirst($kyc->document_type)); ?></td>
    </tr>
    <tr>
        <th>Name on Document</th>
        <td><?php echo e($kyc->name); ?></td>
    </tr>
    <tr>
        <th>Date of Birth</th>
        <td><?php echo e($kyc->dob); ?></td>
    </tr>
    <tr>
        <th>Address</th>
        <td><?php echo e($kyc->address); ?></td>
    </tr>
    <tr>
        <th>Status</th>
        <td>
            <?php if($kyc->status === 'pending'): ?>
                <span class="badge badge-warning">Pending</span>
            <?php elseif($kyc->status === 'approved'): ?>
                <span class="badge badge-success">Approved</span>
            <?php else: ?>
                <span class="badge badge-danger">Rejected</span>
            <?php endif; ?>
        </td>
    </tr>
</table>

<hr>

<h5>Uploaded Documents</h5>

<div class="row">
    <div class="col-md-6">
        <p><strong>Front Image</strong></p>
        <img
            src="<?php echo e(rtrim($kycBase, '/') . '/' . ltrim($kyc->front_image, '/')); ?>"
            class="img-fluid img-thumbnail"
            alt="KYC Front Image">
    </div>

    <?php if(!empty($kyc->back_image)): ?>
    <div class="col-md-6">
        <p><strong>Back Image</strong></p>
        <img
            src="<?php echo e(rtrim($kycBase, '/') . '/' . ltrim($kyc->back_image, '/')); ?>"
            class="img-fluid img-thumbnail"
            alt="KYC Back Image">
    </div>
    <?php endif; ?>
</div>

<?php if($kyc->status === 'pending'): ?>
<hr>
<div class="mt-3">
    <form method="POST" action="<?php echo e(route('admin.kyc.approve', $kyc->id)); ?>" style="display:inline">
        <?php echo csrf_field(); ?>
        <button class="btn btn-success"
            onclick="return confirm('Approve this KYC?')">
            Approve
        </button>
    </form>

    <form method="POST" action="<?php echo e(route('admin.kyc.reject', $kyc->id)); ?>" style="display:inline">
        <?php echo csrf_field(); ?>
        <button class="btn btn-danger"
            onclick="return confirm('Reject this KYC?')">
            Reject
        </button>
    </form>
</div>
<?php endif; ?>

</div>
</div>

</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/properties/merchant_kyc_view.blade.php ENDPATH**/ ?>